/*
 * Decompiled with CFR 0.152.
 */
package gravestone.tileentity;

import gravestone.block.enums.EnumGraves;
import gravestone.tileentity.GSGraveStoneItems;
import gravestone.tileentity.GSGraveStoneSpawn;
import gravestone.tileentity.TileEntityGSGrave;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityGSGraveStone
extends TileEntityGSGrave {
    protected GSGraveStoneSpawn gsSpawn;
    protected byte swordType = 0;
    protected int swordDamage = 0;
    protected String swordName = "";
    protected ArrayList<NBTBase> swordEnchantment = new ArrayList();
    protected NBTTagCompound swordNBT = new NBTTagCompound();

    public TileEntityGSGraveStone() {
        this.gsSpawn = new GSGraveStoneSpawn(this);
        this.gSItems = new GSGraveStoneItems(this);
    }

    public TileEntityGSGraveStone(World world) {
        this.field_145850_b = world;
        this.gsSpawn = new GSGraveStoneSpawn(this);
        this.gSItems = new GSGraveStoneItems(this);
    }

    public void func_145845_h() {
        this.gsSpawn.updateEntity();
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1 && this.field_145850_b.field_72995_K) {
            this.gsSpawn.setMinDelay();
        }
        return true;
    }

    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        this.readType(nbtTag);
        this.gSItems.readItems(nbtTag);
        this.gSDeathText.readText(nbtTag);
        if (nbtTag.func_74764_b("Age")) {
            this.age = nbtTag.func_74762_e("Age");
        }
        if (this.graveType > 4 && this.graveType < 10) {
            this.readSwordInfo(nbtTag);
        }
    }

    public void func_145841_b(NBTTagCompound nbtTag) {
        super.func_145841_b(nbtTag);
        this.saveType(nbtTag);
        this.gSItems.saveItems(nbtTag);
        this.gSDeathText.saveText(nbtTag);
        nbtTag.func_74768_a("Age", this.age);
        if (this.swordType != 0) {
            this.writeSwordInfo(nbtTag);
        }
    }

    private void readSwordInfo(NBTTagCompound nbtTag) {
        this.swordType = nbtTag.func_74771_c("SwordType");
        this.swordDamage = nbtTag.func_74762_e("SwordDamage");
        this.swordName = nbtTag.func_74779_i("SwordName");
        this.swordNBT = nbtTag.func_74775_l("SwordNBT");
    }

    private void writeSwordInfo(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("SwordType", this.swordType);
        nbtTag.func_74768_a("SwordDamage", this.swordDamage);
        nbtTag.func_74778_a("SwordName", this.swordName);
        nbtTag.func_74782_a("SwordNBT", (NBTBase)this.swordNBT);
    }

    public byte getSword() {
        return this.swordType;
    }

    public int getDamage() {
        return this.swordDamage;
    }

    public String getSwordName() {
        return this.swordName;
    }

    public NBTTagCompound getEnchantment() {
        return this.swordNBT;
    }

    public void setSword(byte swordType) {
        this.swordType = swordType;
    }

    public void setDamage(int swordDamage) {
        this.swordDamage = swordDamage;
    }

    public void setSwordName(String swordName) {
        this.swordName = swordName;
    }

    public void setEnchantment(NBTTagCompound swordNBT) {
        this.swordNBT = swordNBT;
    }

    public boolean isEnchanted() {
        return this.swordNBT != null && this.swordNBT.func_74764_b("ench");
    }

    public void dropSword() {
        ItemStack sword = this.getSwordItem();
        GSGraveStoneItems.dropItem(sword, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack getSwordItem() {
        Item item;
        switch (this.swordType) {
            case 5: {
                item = Items.field_151048_u;
                break;
            }
            case 3: {
                item = Items.field_151040_l;
                break;
            }
            case 2: {
                item = Items.field_151052_q;
                break;
            }
            case 4: {
                item = Items.field_151010_B;
                break;
            }
            default: {
                item = Items.field_151041_m;
            }
        }
        ItemStack sword = new ItemStack(item, 1, this.swordDamage);
        sword.func_151001_c(this.swordName);
        sword.func_77982_d(this.swordNBT);
        return sword;
    }

    public EnumGraves getGraveType() {
        return EnumGraves.getByID(this.graveType);
    }

    public boolean isEmpty() {
        return this.gSItems.graveContents.isEmpty();
    }
}

