/*
 * Decompiled with CFR 0.152.
 */
package gravestone.tileentity;

import gravestone.block.enums.EnumGraves;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSMobSpawn;
import gravestone.tileentity.GSSpawner;
import gravestone.tileentity.TileEntityGSGraveStone;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class GSGraveStoneSpawn
extends GSSpawner {
    private static final int BASE_DELAY = 600;
    private static final int PLAYER_RANGE = 35;
    private static final int MIN_DELAY = 500;
    private static final int START_TIME = 13500;
    private static final int END_TIME = 22500;
    private boolean getNewMob = true;
    private static final int MAX_NEARBY_ENTITIES = 3;
    private static final int SPAWN_RANGE = 1;

    public GSGraveStoneSpawn(TileEntity tileEntity) {
        super(tileEntity, 600);
    }

    @Override
    protected void clientUpdateLogic() {
    }

    @Override
    protected void serverUpdateLogic() {
        int nearbyEntitiesCount;
        if (this.delay == -1) {
            this.updateDelay();
        }
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        if (this.getNewMob) {
            this.spawnedMob = GSMobSpawn.getMobEntity(this.tileEntity.func_145831_w(), EnumGraves.getByID(((TileEntityGSGraveStone)this.tileEntity).graveType), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
            if (this.spawnedMob == null) {
                return;
            }
            this.getNewMob = false;
        }
        if ((nearbyEntitiesCount = this.tileEntity.func_145831_w().func_72872_a(this.spawnedMob.getClass(), AxisAlignedBB.func_72332_a().func_72299_a((double)this.tileEntity.field_145851_c, (double)this.tileEntity.field_145848_d, (double)this.tileEntity.field_145849_e, (double)(this.tileEntity.field_145851_c + 1), (double)(this.tileEntity.field_145848_d + 1), (double)(this.tileEntity.field_145849_e + 1)).func_72314_b(1.0, 4.0, 2.0)).size()) >= 3) {
            this.updateDelay();
            return;
        }
        if (GSMobSpawn.checkChance(this.tileEntity.func_145831_w().field_73012_v) && GSMobSpawn.spawnMob(this.tileEntity.func_145831_w(), this.spawnedMob, this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e, true)) {
            this.getNewMob = true;
        }
        this.updateDelay();
    }

    @Override
    protected boolean canSpawnMobs(World world) {
        long time = world.func_72820_D() % 24000L;
        return time > 13500L && time < 22500L || world.func_72911_I();
    }

    @Override
    protected int getPlayerRange() {
        return 35;
    }

    @Override
    protected int getSpawnRange() {
        return 1;
    }

    @Override
    protected int getMinDelay() {
        return 500;
    }

    @Override
    protected int getMaxDelay() {
        return GraveStoneConfig.graveSpawnRate;
    }

    @Override
    protected Entity getMob() {
        return GSMobSpawn.getMobEntity(this.tileEntity.func_145831_w(), EnumGraves.getByID(((TileEntityGSGraveStone)this.tileEntity).graveType), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
    }
}

