/*
 * Decompiled with CFR 0.152.
 */
package gravestone.core;

import gravestone.GraveStoneLogger;
import gravestone.block.enums.EnumGraves;
import gravestone.block.enums.EnumSpawner;
import gravestone.config.GraveStoneConfig;
import gravestone.entity.monster.EntitySkullCrawler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GSMobSpawn {
    public static final String WITHER_ID = "WitherBoss";
    private static final int HELL_HEIGHT = 51;
    public static Map<String, Constructor<EntityLiving>> mobNameToClassMapping = new HashMap<String, Constructor<EntityLiving>>();
    public static List<String> MOB_ID = new ArrayList<String>(Arrays.asList("Zombie", "Skeleton"));
    public static List<String> DOG_ID = new ArrayList<String>(Arrays.asList("GSZombieDog", "GSSkeletonDog"));
    public static List<String> CAT_ID = new ArrayList<String>(Arrays.asList("GSZombieCat", "GSSkeletonCat"));
    public static List<String> HELL_MOB_ID = new ArrayList<String>(Arrays.asList("PigZombie", "Skeleton"));
    public static List<String> skeletonSpawnerMobs = new ArrayList<String>(Arrays.asList("Skeleton", "Skeleton", "Skeleton", "Skeleton", "GSSkeletonDog", "GSSkeletonCat"));
    public static List<String> zombieSpawnerMobs = new ArrayList<String>(Arrays.asList("Zombie", "Zombie", "Zombie", "Zombie", "GSZombieDog", "GSZombieCat"));
    public static List<String> catacombsStatuesMobs = new ArrayList<String>(Arrays.asList("Skeleton", "Zombie"));

    private GSMobSpawn() {
    }

    private static boolean canSpawnHellCreatures(World world, int x, int y, int z) {
        if (world != null) {
            return y < 51 && world.func_147439_a(x, y - 1, z).equals(Blocks.field_150385_bj);
        }
        return false;
    }

    public static Entity getMobEntity(World world, EnumGraves graveType, int x, int y, int z) {
        String id;
        switch (graveType) {
            case DOG_STATUE: {
                id = GSMobSpawn.getMobID(world.field_73012_v, EnumMobType.UNDEAD_DOGS);
                break;
            }
            case CAT_STATUE: {
                id = GSMobSpawn.getMobID(world.field_73012_v, EnumMobType.UNDEAD_CATS);
                break;
            }
            case HORSE_STATUE: {
                return null;
            }
            default: {
                if (GSMobSpawn.canSpawnHellCreatures(world, x, y, z) && world.field_73012_v.nextInt(10) == 0) {
                    id = GSMobSpawn.getMobID(world.field_73012_v, EnumMobType.HELL_MOBS);
                    if (!id.equals("Skeleton")) break;
                    EntitySkeleton skeleton = GSMobSpawn.getSkeleton(world);
                    skeleton.func_82201_a(1);
                    return skeleton;
                }
                id = GSMobSpawn.getMobID(world.field_73012_v, EnumMobType.DEFAULT_MOBS);
                if (!id.equals("Skeleton")) break;
                return GSMobSpawn.getSkeleton(world);
            }
        }
        EntityLiving entity = (EntityLiving)EntityList.func_75620_a((String)id, (World)world);
        if (entity == null) {
            entity = GSMobSpawn.getForeinMob(world, id);
        }
        try {
            entity.func_110161_a((IEntityLivingData)null);
        }
        catch (Exception e) {
            GraveStoneLogger.logError("getMobEntity exception with onSpawnWithEgg");
            e.printStackTrace();
        }
        return entity;
    }

    public static Entity getMobEntityForSpawner(World world, EnumSpawner spawnerType, int x, int y, int z) {
        String mobId;
        switch (spawnerType) {
            case WITHER_SPAWNER: {
                mobId = WITHER_ID;
                break;
            }
            case SKELETON_SPAWNER: {
                mobId = skeletonSpawnerMobs.get(world.field_73012_v.nextInt(skeletonSpawnerMobs.size()));
                if (!mobId.equals("Skeleton") || world.field_73012_v.nextInt(10) != 0) break;
                EntitySkeleton skeleton = GSMobSpawn.getSkeleton(world);
                skeleton.func_82201_a(1);
                return skeleton;
            }
            default: {
                mobId = zombieSpawnerMobs.get(world.field_73012_v.nextInt(zombieSpawnerMobs.size()));
            }
        }
        EntityLiving entity = (EntityLiving)EntityList.func_75620_a((String)mobId, (World)world);
        if (entity == null) {
            entity = GSMobSpawn.getForeinMob(world, mobId);
        }
        try {
            entity.func_110161_a((IEntityLivingData)null);
        }
        catch (Exception e) {
            GraveStoneLogger.logError("getMobEntity exception with onSpawnWithEgg");
            e.printStackTrace();
        }
        return entity;
    }

    private static EntitySkeleton getSkeleton(World world) {
        EntitySkeleton skeleton = (EntitySkeleton)EntityList.func_75620_a((String)"Skeleton", (World)world);
        if (world.field_73012_v.nextInt(2) == 0) {
            skeleton.func_70062_b(0, new ItemStack(Items.field_151052_q, 1, 0));
        } else {
            skeleton.func_70062_b(0, new ItemStack((Item)Items.field_151031_f, 1, 0));
        }
        return skeleton;
    }

    public static EntitySkeleton getSkeleton(World world, byte skeletonType) {
        EntitySkeleton skeleton = (EntitySkeleton)EntityList.func_75620_a((String)"Skeleton", (World)world);
        if (skeletonType == 0) {
            skeleton.func_70062_b(0, new ItemStack((Item)Items.field_151031_f, 1, 0));
        } else {
            skeleton.func_70062_b(0, new ItemStack(Items.field_151052_q, 1, 0));
        }
        return skeleton;
    }

    public static boolean isWitherSkeleton(EntitySkeleton skeleton) {
        return skeleton.func_82202_m() == 1;
    }

    private static EntityLiving getForeinMob(World world, String mobName) {
        EntityLiving mob = null;
        try {
            mob = mobNameToClassMapping.get(mobName).newInstance(world);
        }
        catch (InstantiationException e) {
            GraveStoneLogger.logError("getForeinMob InstantiationException. mob name " + mobName);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            GraveStoneLogger.logError("getForeinMob IllegalAccessException. mob name " + mobName);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            GraveStoneLogger.logError("getForeinMob InvocationTargetException. mob name " + mobName);
            e.getCause().printStackTrace();
        }
        return mob;
    }

    public static String getMobID(Random random, EnumMobType mobType) {
        switch (mobType) {
            case HELL_MOBS: {
                return HELL_MOB_ID.get(random.nextInt(HELL_MOB_ID.size()));
            }
            case UNDEAD_DOGS: {
                return DOG_ID.get(random.nextInt(DOG_ID.size()));
            }
            case UNDEAD_CATS: {
                return CAT_ID.get(random.nextInt(CAT_ID.size()));
            }
        }
        return MOB_ID.get(random.nextInt(MOB_ID.size()));
    }

    public static boolean spawnMob(World world, Entity mob, double x, double y, double z, boolean checkSpawn) {
        float rotation = world.field_73012_v.nextFloat() * 360.0f;
        return GSMobSpawn.spawnMob(world, mob, x, y, z, rotation, checkSpawn);
    }

    public static boolean spawnMob(World world, Entity mob, double x, double y, double z, float rotation, boolean checkSpawn) {
        EntityLiving livingEntity = (EntityLiving)mob;
        boolean canSpawn = false;
        double xPosition = x + 0.5;
        double yPosition = y;
        double zPosition = z + 0.5;
        mob.func_70012_b(xPosition, yPosition, zPosition, rotation, 0.0f);
        if (!checkSpawn || livingEntity.func_70601_bi()) {
            canSpawn = true;
        } else if (!(mob instanceof EntityZombie)) {
            mob.func_70012_b(xPosition += 1.0, yPosition, zPosition, rotation, 0.0f);
            if (livingEntity.func_70601_bi()) {
                canSpawn = true;
            } else {
                mob.func_70012_b(xPosition -= 1.0, yPosition, zPosition += 1.0, rotation, 0.0f);
                if (livingEntity.func_70601_bi()) {
                    canSpawn = true;
                } else {
                    mob.func_70012_b(xPosition, yPosition, zPosition -= 2.0, rotation, 0.0f);
                    if (livingEntity.func_70601_bi()) {
                        canSpawn = true;
                    } else {
                        mob.func_70012_b(xPosition -= 1.0, yPosition, zPosition += 1.0, rotation, 0.0f);
                        if (livingEntity.func_70601_bi()) {
                            canSpawn = true;
                        }
                    }
                }
            }
        }
        if (canSpawn) {
            xPosition = x + (double)world.field_73012_v.nextFloat();
            yPosition = y + (double)world.field_73012_v.nextFloat();
            zPosition = z + (double)world.field_73012_v.nextFloat();
            world.func_72869_a("largesmoke", xPosition, yPosition + 2.0, zPosition, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", xPosition, yPosition + 1.0, zPosition, 0.0, 0.0, 0.0);
            world.func_72838_d(mob);
            world.func_72926_e(2004, (int)x, (int)y, (int)z, 0);
            return true;
        }
        return false;
    }

    public static boolean checkChance(Random random) {
        return random.nextInt(100) < GraveStoneConfig.spawnChance;
    }

    public static String getMobForSkeletonSpawner(Random random) {
        return skeletonSpawnerMobs.get(random.nextInt(skeletonSpawnerMobs.size()));
    }

    public static String getMobForZombieSpawner(Random random) {
        return zombieSpawnerMobs.get(random.nextInt(zombieSpawnerMobs.size()));
    }

    public static String getMobForStatueSpawner(Random random) {
        return catacombsStatuesMobs.get(random.nextInt(catacombsStatuesMobs.size()));
    }

    public static void spawnCrawler(Entity entity, EntitySkullCrawler crawler) {
        if (entity.field_70170_p.field_73012_v.nextInt(10) == 0) {
            GSMobSpawn.spawnMob(entity.field_70170_p, (Entity)crawler, (int)Math.floor(entity.field_70165_t), entity.field_70163_u + 1.5, (int)Math.floor(entity.field_70161_v), entity.field_70177_z, false);
        }
    }

    public static enum EnumMobType {
        DEFAULT_MOBS,
        HELL_MOBS,
        UNDEAD_DOGS,
        UNDEAD_CATS;

    }
}

