/*
 * Decompiled with CFR 0.152.
 */
package gravestone.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.ModGraveStone;
import gravestone.block.enums.EnumMemorials;
import gravestone.config.GraveStoneConfig;
import gravestone.tileentity.TileEntityGSMemorial;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGSMemorial
extends BlockContainer {
    public static final byte[] GENERATED_MEMORIALS = new byte[]{(byte)EnumMemorials.STONE_CROSS.ordinal(), (byte)EnumMemorials.OBELISK.ordinal(), (byte)EnumMemorials.STEVE_STATUE.ordinal(), (byte)EnumMemorials.VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.ANGEL_STATUE.ordinal(), (byte)EnumMemorials.DOG_STATUE.ordinal(), (byte)EnumMemorials.CAT_STATUE.ordinal()};
    public static final byte[] PETS_MEMORIALS = new byte[]{(byte)EnumMemorials.DOG_STATUE.ordinal(), (byte)EnumMemorials.CAT_STATUE.ordinal()};
    public static final byte[] DOG_MEMORIALS = new byte[]{(byte)EnumMemorials.DOG_STATUE.ordinal()};
    public static final byte[] CAT_MEMORIALS = new byte[]{(byte)EnumMemorials.CAT_STATUE.ordinal()};
    public static final byte[] CREEPER_MEMORIALS = new byte[]{(byte)EnumMemorials.CREEPER_STATUE.ordinal()};
    public static final byte[] STATUES_MEMORIALS = new byte[]{(byte)EnumMemorials.STEVE_STATUE.ordinal(), (byte)EnumMemorials.VILLAGER_STATUE.ordinal(), (byte)EnumMemorials.ANGEL_STATUE.ordinal()};

    public BlockGSMemorial() {
        super(Material.field_151576_e);
        this.field_149758_A = true;
        this.func_149672_a(Block.field_149769_e);
        this.func_149663_c("Memorial");
        this.func_149711_c(4.5f);
        this.func_149752_b(5.0f);
        this.func_149647_a(ModGraveStone.creativeTab);
        this.func_149658_d("stone");
        this.setHarvestLevel("pickaxe", 2);
    }

    public static int getMetaDirection(int direction) {
        switch (direction) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public static byte getMemorialType(Random random, int memorialType) {
        switch (memorialType) {
            default: {
                return GENERATED_MEMORIALS[random.nextInt(GENERATED_MEMORIALS.length)];
            }
            case 1: {
                return PETS_MEMORIALS[random.nextInt(PETS_MEMORIALS.length)];
            }
            case 2: {
                return DOG_MEMORIALS[random.nextInt(DOG_MEMORIALS.length)];
            }
            case 3: {
                return CAT_MEMORIALS[random.nextInt(CAT_MEMORIALS.length)];
            }
            case 4: {
                return CREEPER_MEMORIALS[random.nextInt(CREEPER_MEMORIALS.length)];
            }
            case 5: 
        }
        return STATUES_MEMORIALS[random.nextInt(STATUES_MEMORIALS.length)];
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int direction = MathHelper.func_76141_d((float)player.field_70177_z);
        if (direction < 0) {
            direction = 360 + direction;
        }
        int metadata = this.getMetadataBasedOnRotation(direction);
        world.func_72921_c(x, y, z, metadata, 2);
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)world.func_147438_o(x, y, z);
        if (tileEntity != null && itemStack.field_77990_d != null) {
            if (itemStack.field_77990_d.func_74764_b("isLocalized") && itemStack.field_77990_d.func_74767_n("isLocalized")) {
                tileEntity.getDeathTextComponent().setLocalized();
                if (itemStack.field_77990_d.func_74764_b("name") && itemStack.field_77990_d.func_74764_b("KillerName")) {
                    tileEntity.getDeathTextComponent().setName(itemStack.field_77990_d.func_74779_i("name"));
                    tileEntity.getDeathTextComponent().setKillerName(itemStack.field_77990_d.func_74779_i("KillerName"));
                }
            }
            if (itemStack.field_77990_d.func_74764_b("DeathText")) {
                tileEntity.getDeathTextComponent().setDeathText(itemStack.field_77990_d.func_74779_i("DeathText"));
            }
            if (itemStack.field_77990_d.func_74764_b("GraveType")) {
                tileEntity.setGraveType(itemStack.field_77990_d.func_74771_c("GraveType"));
            } else {
                tileEntity.setGraveType((byte)0);
            }
        }
    }

    private int getMetadataBasedOnRotation(int rotation) {
        if (rotation >= 315 || rotation < 45) {
            return 1;
        }
        if (rotation >= 45 && rotation < 135) {
            return 2;
        }
        if (rotation >= 135 && rotation < 225) {
            return 0;
        }
        return 3;
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)access.func_147438_o(x, y, z);
        EnumMemorials memorialType = tileEntity != null ? tileEntity.getMemorialType() : EnumMemorials.STONE_CROSS;
        switch (memorialType) {
            case STONE_CROSS: 
            case OBELISK: {
                this.func_149676_a(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f);
                break;
            }
            case STEVE_STATUE: 
            case VILLAGER_STATUE: 
            case ANGEL_STATUE: {
                this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 3.0f, 0.875f);
                break;
            }
            case DOG_STATUE: 
            case CAT_STATUE: {
                this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 2.0f, 0.875f);
                break;
            }
            case CREEPER_STATUE: {
                this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 2.5f, 0.875f);
            }
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 2.0f);
    }

    public boolean func_149700_E() {
        return true;
    }

    public Item func_149650_a(int par1, Random random, int par3) {
        return null;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return GraveStoneConfig.memorialRenderID;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        String deathText;
        TileEntityGSMemorial entity;
        if (world.field_72995_K && (entity = (TileEntityGSMemorial)world.func_147438_o(x, y, z)) != null && (deathText = entity.getDeathTextComponent().getDeathText()).length() != 0) {
            String name;
            if (entity.getDeathTextComponent().isLocalized() && (name = entity.getDeathTextComponent().getName()).length() != 0) {
                String killerName = ModGraveStone.proxy.getLocalizedEntityName(entity.getDeathTextComponent().getKillerName());
                if (killerName.length() == 0) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[]{name}));
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[]{name, killerName}));
                }
                return false;
            }
            player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[0]));
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityGSMemorial(world);
    }

    public int func_149692_a(int metadata) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (byte j = 0; j < EnumMemorials.values().length; j = (byte)(j + 1)) {
            ItemStack stack = new ItemStack(item, 1, 0);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", j);
            stack.func_77982_d(nbt);
            list.add(stack);
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        ItemStack itemStack;
        player.func_71020_j(0.025f);
        if (EnchantmentHelper.func_77502_d((EntityLivingBase)player) && (itemStack = this.getBlockItemStack(world, x, y, z)) != null) {
            this.func_149642_a(world, x, y, z, itemStack);
        }
    }

    private ItemStack getBlockItemStack(World world, int x, int y, int z) {
        ItemStack itemStack = this.func_149644_j(0);
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (tileEntity.getDeathTextComponent().isLocalized()) {
                nbt.func_74757_a("isLocalized", true);
                nbt.func_74778_a("name", tileEntity.getDeathTextComponent().getName());
                nbt.func_74778_a("KillerName", tileEntity.getDeathTextComponent().getKillerName());
            }
            nbt.func_74778_a("DeathText", tileEntity.getDeathTextComponent().getDeathText());
            nbt.func_74774_a("GraveType", tileEntity.getGraveTypeNum());
            itemStack.func_77982_d(nbt);
        }
        return itemStack;
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int metadata) {
    }

    public void dropCreeperMemorial(World world, int x, int y, int z) {
        byte memorialType = BlockGSMemorial.getMemorialType(new Random(), 4);
        ItemStack itemStack = new ItemStack((Block)this);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("GraveType", memorialType);
        itemStack.func_77982_d(nbt);
        this.func_149642_a(world, x, y, z, itemStack);
    }
}

