/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures.catacombs.components;

import gravestone.core.GSStructures;
import gravestone.structures.ComponentGraveStone;
import gravestone.structures.catacombs.CatacombsLevel;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public abstract class CatacombsBaseComponent
extends ComponentGraveStone {
    public boolean goTop = true;
    protected int leftXEnd = 0;
    protected int rightXEnd = 0;
    protected int topXEnd = 0;
    protected int leftZEnd = 0;
    protected int rightZEnd = 0;
    protected int topZEnd = 0;
    protected int yEnd = 0;
    protected int xShift = 0;
    protected int zShift = 0;
    protected int level = 0;
    protected CatacombsBaseComponent prevComponent;
    protected CatacombsBaseComponent[] nextComponents;

    protected CatacombsBaseComponent(int direction) {
        this(direction, 0);
    }

    protected CatacombsBaseComponent(int direction, int level) {
        super(direction);
        this.field_74885_f = direction;
        this.level = level;
    }

    public static int getLeftDirection(int direction) {
        if (--direction < 0) {
            direction = 3;
        }
        return direction;
    }

    public static int getRightDirection(int direction) {
        if (++direction > 3) {
            direction = 0;
        }
        return direction;
    }

    public static int getInvertDirection(int direction) {
        if ((direction += 2) > 3) {
            direction -= 4;
        }
        return direction;
    }

    public static int getLeftItemDirection(int direction) {
        if (direction == 0 || direction == 1) {
            if (++direction > 3) {
                direction = 0;
            }
        } else if (--direction < 0) {
            direction = 3;
        }
        return direction;
    }

    public static int getRightItemDirection(int direction) {
        if (direction == 0 || direction == 1) {
            if (--direction < 0) {
                direction = 3;
            }
        } else if (++direction > 3) {
            direction = 0;
        }
        return direction;
    }

    public static Block getValuableBlock(Random random) {
        return GSStructures.VALUEBLE_BLOCKS[random.nextInt(GSStructures.VALUEBLE_BLOCKS.length)];
    }

    protected int getGroundLevel(World world, int x, int z) {
        return world.func_72825_h(x, z);
    }

    protected int invertDirection(int direction) {
        return 0;
    }

    public int getLeftXEnd() {
        return this.func_74865_a(this.leftXEnd, this.leftZEnd);
    }

    public int getLeftZEnd() {
        return this.func_74873_b(this.leftXEnd, this.leftZEnd);
    }

    public int getRightXEnd() {
        return this.func_74865_a(this.rightXEnd, this.rightZEnd);
    }

    public int getRightZEnd() {
        return this.func_74873_b(this.rightXEnd, this.rightZEnd);
    }

    public int getTopZEnd() {
        return this.func_74873_b(this.topXEnd, this.topZEnd);
    }

    public int getTopXEnd() {
        return this.func_74865_a(this.topXEnd, this.topZEnd);
    }

    public int getYEnd() {
        return this.field_74887_e.field_78895_b + this.yEnd;
    }

    public StructureComponent.BlockSelector getCemeteryCatacombsStones() {
        return CatacombsLevel.getCatacombsStones(this.level);
    }

    public boolean canBePlacedHere(StructureBoundingBox boundingBox) {
        if (this.field_74885_f == 0 || this.field_74885_f == 2) {
            return this.field_74887_e.field_78893_d > boundingBox.field_78897_a && this.field_74887_e.field_78897_a < boundingBox.field_78893_d && this.field_74887_e.field_78892_f - 1 > boundingBox.field_78896_c && this.field_74887_e.field_78896_c + 1 < boundingBox.field_78892_f;
        }
        return this.field_74887_e.field_78893_d - 1 > boundingBox.field_78897_a && this.field_74887_e.field_78897_a + 1 < boundingBox.field_78893_d && this.field_74887_e.field_78892_f > boundingBox.field_78896_c && this.field_74887_e.field_78896_c < boundingBox.field_78892_f;
    }

    public boolean canGoOnlyTop() {
        return true;
    }

    protected void func_151554_b(World world, Block block, int metadata, int xCoord, int yCoord, int zCoord, StructureBoundingBox boundingBox) {
        int x = this.func_74865_a(xCoord, zCoord);
        int z = this.func_74873_b(xCoord, zCoord);
        for (int y = this.func_74862_a(yCoord); (world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z).func_149688_o().func_76224_d() || world.func_147439_a(x, y, z).func_149688_o().func_76222_j()) && y > 1; --y) {
            world.func_147465_d(x, y, z, block, metadata, 2);
        }
    }

    public int getDirection() {
        return this.field_74885_f;
    }
}

