/*
 * Decompiled with CFR 0.152.
 */
package gravestone.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class GSSpawner {
    protected TileEntity tileEntity;
    protected int delay;
    protected Entity spawnedMob;

    public GSSpawner(TileEntity tileEntity, int delay) {
        this.tileEntity = tileEntity;
        this.delay = delay;
    }

    public void updateEntity() {
        if (this.canSpawnMobs(this.tileEntity.func_145831_w()) && !this.tileEntity.func_145831_w().field_73013_u.equals((Object)EnumDifficulty.PEACEFUL) && this.anyPlayerInRange()) {
            if (this.tileEntity.func_145831_w().field_72995_K) {
                this.clientUpdateLogic();
            } else {
                this.serverUpdateLogic();
            }
        }
    }

    protected void updateDelay() {
        this.delay = this.getMinDelay() + this.tileEntity.func_145831_w().field_73012_v.nextInt(this.getMaxDelay() - this.getMinDelay());
    }

    protected void setMinDelay() {
        this.delay = this.getMinDelay();
    }

    protected int getNearbyMobsCount() {
        return this.tileEntity.func_145831_w().func_72872_a(this.spawnedMob.getClass(), AxisAlignedBB.func_72332_a().func_72299_a((double)this.tileEntity.field_145851_c, (double)this.tileEntity.field_145848_d, (double)this.tileEntity.field_145849_e, (double)(this.tileEntity.field_145851_c + 1), (double)(this.tileEntity.field_145848_d + 1), (double)(this.tileEntity.field_145849_e + 1)).func_72314_b(1.0, 4.0, (double)(this.getSpawnRange() * 2))).size();
    }

    protected boolean anyPlayerInRange() {
        return this.tileEntity.func_145831_w().func_72977_a((double)this.tileEntity.field_145851_c + 0.5, (double)this.tileEntity.field_145848_d + 0.5, (double)this.tileEntity.field_145849_e + 0.5, (double)this.getPlayerRange()) != null;
    }

    protected abstract boolean canSpawnMobs(World var1);

    protected abstract int getPlayerRange();

    protected abstract int getSpawnRange();

    protected abstract int getMinDelay();

    protected abstract int getMaxDelay();

    protected abstract Entity getMob();

    protected abstract void clientUpdateLogic();

    protected abstract void serverUpdateLogic();
}

