/*
 * Decompiled with CFR 0.152.
 */
package gravestone.tileentity;

import gravestone.GraveStoneLogger;
import gravestone.block.BlockGSSpawner;
import gravestone.block.enums.EnumSpawner;
import gravestone.core.GSMobSpawn;
import gravestone.tileentity.GSSpawner;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GSMobSpawner
extends GSSpawner {
    private static final int BASE_DELAY = 60;
    private static final int MIN_DELAY = 600;
    private static final int MAX_DELAY = 800;
    private static final int BOSS_PLAYER_RANGE = 8;
    private static final int MOB_PLAYER_RANGE = 16;
    private static final int SPAWN_EFFECTS_DELAY = 20;
    private static final float MAX_LIGHT_VALUE = 0.46f;
    private EnumSpawner spawnerType = null;

    public GSMobSpawner(TileEntity tileEntity) {
        super(tileEntity, 60);
    }

    @Override
    protected void clientUpdateLogic() {
    }

    @Override
    protected void serverUpdateLogic() {
        --this.delay;
        if (this.delay <= 0) {
            EntityLiving entity = (EntityLiving)this.getMob();
            if (entity == null) {
                GraveStoneLogger.logError("Spanwer mob get 'null' as mob!!!");
            } else {
                double x = (double)this.tileEntity.field_145851_c + 0.5;
                double y = this.tileEntity.field_145848_d;
                double z = (double)this.tileEntity.field_145849_e + 0.5;
                entity.func_70012_b(x, y, z, this.tileEntity.func_145831_w().field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (this.isBossSpawner()) {
                    this.tileEntity.func_145831_w().func_147475_p(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
                    this.tileEntity.func_145831_w().func_147449_b(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e, Blocks.field_150350_a);
                    this.tileEntity.func_145831_w().func_72838_d((Entity)entity);
                } else if (this.tileEntity.func_145831_w().func_72801_o(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e) <= 0.46f) {
                    this.tileEntity.func_145831_w().func_72838_d((Entity)entity);
                }
            }
            this.updateDelay();
        }
    }

    private boolean isBossSpawner() {
        return BlockGSSpawner.BOSS_SPAWNERS.contains((byte)this.getSpawnerType().ordinal());
    }

    private EnumSpawner getSpawnerType() {
        if (this.spawnerType == null) {
            if (this.tileEntity.func_145831_w() == null) {
                GraveStoneLogger.logError("Spawner te worldobj is null !!!!!");
                return EnumSpawner.ZOMBIE_SPAWNER;
            }
            byte meta = (byte)this.tileEntity.func_145831_w().func_72805_g(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
            this.spawnerType = EnumSpawner.getById(meta);
            return this.spawnerType;
        }
        return this.spawnerType;
    }

    @Override
    protected boolean canSpawnMobs(World world) {
        return true;
    }

    @Override
    protected int getPlayerRange() {
        return this.isBossSpawner() ? 8 : 16;
    }

    @Override
    protected Entity getMob() {
        return GSMobSpawn.getMobEntityForSpawner(this.tileEntity.func_145831_w(), this.getSpawnerType(), this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
    }

    @Override
    protected int getSpawnRange() {
        return 0;
    }

    @Override
    protected int getMinDelay() {
        return 600;
    }

    @Override
    protected int getMaxDelay() {
        return 800;
    }
}

