/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures.catacombs;

import gravestone.GraveStoneLogger;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSBiomes;
import gravestone.structures.GSStructureGenerator;
import gravestone.structures.catacombs.CatacombsSurface;
import gravestone.structures.catacombs.CatacombsUnderground;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.village.Village;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class CatacombsGenerator
implements GSStructureGenerator {
    private static CatacombsGenerator instance;
    private static final int VILLAGE_RANGE = 200;
    public static final byte CATACOMBS_RANGE = 100;
    private static final double CHANCE = 5.0E-4;
    protected static LinkedList<ChunkCoordIntPair> structuresList;

    private CatacombsGenerator() {
        instance = this;
    }

    public static CatacombsGenerator getInstance() {
        if (instance == null) {
            return new CatacombsGenerator();
        }
        return instance;
    }

    @Override
    public boolean generate(World world, Random rand, int x, int z, double chance, boolean isCommand) {
        if (isCommand || GraveStoneConfig.generateCatacombs && CatacombsGenerator.canSpawnStructureAtCoords(world, x, z, chance) && CatacombsGenerator.isHeightAcceptable(world, x, z)) {
            int direction = rand.nextInt(4);
            CatacombsSurface surface = new CatacombsSurface(world, rand, x, z, direction);
            GraveStoneLogger.logInfo("Generate catacombs at " + x + "x" + z);
            if (surface.getMausoleumY() > 55) {
                new CatacombsUnderground(world, rand, direction, surface.getMausoleumX(), surface.getMausoleumY(), surface.getMausoleumZ());
            }
            structuresList.add(new ChunkCoordIntPair(x, z));
            return true;
        }
        return false;
    }

    protected static boolean canSpawnStructureAtCoords(World world, int x, int z, double chance) {
        return chance < 5.0E-4 && GSBiomes.getCatacombsBiomes().contains(world.func_72807_a((int)x, (int)z).field_76756_M) && CatacombsGenerator.noAnyInRange(x, z, 700, world);
    }

    protected static boolean noAnyInRange(int x, int z, int range, World world) {
        GraveStoneLogger.logInfo("Catacombs generation - Begin Checking area for another catacombs or villages");
        for (ChunkCoordIntPair position : structuresList) {
            if (position.field_77276_a <= x - range || position.field_77276_a >= x + range || position.field_77275_b <= z - range || position.field_77275_b >= z + range) continue;
            return false;
        }
        if (world.field_72982_D != null && world.field_72982_D.func_75540_b() != null) {
            for (Object villageObj : world.field_72982_D.func_75540_b()) {
                ChunkCoordinates villageCenter = ((Village)villageObj).func_75577_a();
                if (villageCenter.field_71574_a <= x - 200 || villageCenter.field_71574_a >= x + 200 || villageCenter.field_71573_c <= z - 200 || villageCenter.field_71573_c >= z + 200) continue;
                return false;
            }
        }
        GraveStoneLogger.logInfo("Catacombs generation - End Checking area for another catacombs or villages");
        return true;
    }

    public static LinkedList<ChunkCoordIntPair> getStructuresList() {
        return structuresList;
    }

    private static boolean isHeightAcceptable(World world, int x, int z) {
        GraveStoneLogger.logInfo("Catacombs generation - Begin Checking area height");
        int height = 0;
        int count = 0;
        for (int xPos = x; xPos < x + 16; ++xPos) {
            for (int zPos = z; zPos < z + 16; ++zPos) {
                height += world.func_72825_h(xPos, zPos);
                ++count;
            }
        }
        GraveStoneLogger.logInfo("Catacombs generation - End Checking area height");
        return height / count < GraveStoneConfig.maxCatacombsHeight;
    }

    static {
        structuresList = new LinkedList();
    }
}

