/*
 * Decompiled with CFR 0.152.
 */
package gravestone.renderer.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.core.Resources;
import gravestone.models.block.ModelGraveStone;
import gravestone.models.block.memorials.ModelAngelStatueMemorial;
import gravestone.models.block.memorials.ModelCatStatueMemorial;
import gravestone.models.block.memorials.ModelCreeperStatueMemorial;
import gravestone.models.block.memorials.ModelDogStatueMemorial;
import gravestone.models.block.memorials.ModelMemorialCross;
import gravestone.models.block.memorials.ModelMemorialObelisk;
import gravestone.models.block.memorials.ModelSteveStatueMemorial;
import gravestone.models.block.memorials.ModelVillagerMemorial;
import gravestone.renderer.tileentity.TileEntityGSRenderer;
import gravestone.tileentity.TileEntityGSMemorial;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityGSMemorialRenderer
extends TileEntityGSRenderer {
    protected static ModelGraveStone cross = new ModelMemorialCross();
    protected static ModelGraveStone obelisk = new ModelMemorialObelisk();
    protected static ModelGraveStone steveStatue = new ModelSteveStatueMemorial();
    protected static ModelGraveStone villagerStatue = new ModelVillagerMemorial();
    protected static ModelGraveStone angelStatue = new ModelAngelStatueMemorial();
    protected static ModelGraveStone dogStatue = new ModelDogStatueMemorial();
    protected static ModelGraveStone catStatue = new ModelCatStatueMemorial();
    protected static ModelCreeperStatueMemorial creeperStatue = new ModelCreeperStatueMemorial();
    private static IModelCustom celticCross;
    public static TileEntityGSMemorialRenderer instance;

    public TileEntityGSMemorialRenderer() {
        instance = this;
    }

    @Override
    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        TileEntityGSMemorial tileEntity = (TileEntityGSMemorial)te;
        byte memorialType = tileEntity.getGraveTypeNum();
        int meta = tileEntity.func_145831_w() != null ? tileEntity.func_145832_p() : 0;
        this.getMemorialTexture(memorialType);
        GL11.glPushMatrix();
        if (tileEntity.func_145831_w() != null) {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        } else if (memorialType == 0 || memorialType == 1) {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            GL11.glScalef((float)0.4f, (float)-0.4f, (float)-0.4f);
        } else {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.8f), (float)((float)z + 0.5f));
            GL11.glScalef((float)0.7f, (float)-0.7f, (float)-0.7f);
        }
        switch (TileEntityGSMemorialRenderer.getMemorialDirection(meta)) {
            case 0: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 1: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        if (memorialType == 9) {
            celticCross.renderAll();
        } else if (memorialType == 7 || memorialType == 2) {
            this.getMemorialModel(memorialType).customRender();
        } else {
            this.getMemorialModel(memorialType).renderAll();
        }
        GL11.glPopMatrix();
    }

    private ModelGraveStone getMemorialModel(int memorialType) {
        switch (memorialType) {
            case 1: {
                return obelisk;
            }
            case 2: {
                return steveStatue;
            }
            case 3: {
                return villagerStatue;
            }
            case 4: {
                return angelStatue;
            }
            case 5: {
                return dogStatue;
            }
            case 6: {
                return catStatue;
            }
            case 7: {
                return creeperStatue;
            }
        }
        return cross;
    }

    private void getMemorialTexture(int memorialType) {
        switch (memorialType) {
            case 0: {
                this.bindTextureByName(Resources.MEMORIAL_CROSS);
                break;
            }
            case 1: {
                this.bindTextureByName(Resources.MEMORIAL_OBELISK);
                break;
            }
            case 2: {
                this.bindTextureByName(Resources.STEVE_STATUE_MEMORIAL);
                break;
            }
            case 3: {
                this.bindTextureByName(Resources.VILLAGER_STATUE_MEMORIAL);
                break;
            }
            case 4: {
                this.bindTextureByName(Resources.ANGEL_STAUTE_MEMORIAL);
                break;
            }
            case 5: {
                this.bindTextureByName(Resources.DOG_STATUE_MEMORIAL);
                break;
            }
            case 6: {
                this.bindTextureByName(Resources.CAT_STAUTE_MEMORIAL);
                break;
            }
            case 7: {
                this.bindTextureByName(Resources.CREEPER_STATUE_MEMORIAL);
            }
        }
    }

    private static int getMemorialDirection(int meta) {
        switch (meta) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 1;
            }
        }
        return 2;
    }
}

