/*
 * Decompiled with CFR 0.152.
 */
package gravestone.renderer.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.block.GraveStoneHelper;
import gravestone.block.enums.EnumGraves;
import gravestone.core.Resources;
import gravestone.models.block.ModelGraveStone;
import gravestone.models.block.graves.ModelCatStatueGraveStone;
import gravestone.models.block.graves.ModelCrossGraveStone;
import gravestone.models.block.graves.ModelDogStatueGraveStone;
import gravestone.models.block.graves.ModelHorisontalPlateGraveStone;
import gravestone.models.block.graves.ModelHorseGraveStone;
import gravestone.models.block.graves.ModelSwordGrave;
import gravestone.models.block.graves.ModelVerticalPlateGraveStone;
import gravestone.renderer.tileentity.TileEntityGSRenderer;
import gravestone.tileentity.TileEntityGSGraveStone;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityGSGraveStoneRenderer
extends TileEntityGSRenderer {
    private static ModelGraveStone verticalPlate = new ModelVerticalPlateGraveStone();
    private static ModelGraveStone cross = new ModelCrossGraveStone();
    private static ModelGraveStone horisontalPlate = new ModelHorisontalPlateGraveStone();
    private static ModelGraveStone dogStatue = new ModelDogStatueGraveStone();
    private static ModelGraveStone catStatue = new ModelCatStatueGraveStone();
    private static ModelGraveStone horseStatue = new ModelHorseGraveStone();
    private static ModelGraveStone swordGrave = new ModelSwordGrave();
    public static TileEntityGSGraveStoneRenderer instance;

    public TileEntityGSGraveStoneRenderer() {
        instance = this;
    }

    @Override
    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)te;
        EnumGraves graveType = tileEntity.getGraveType();
        int meta = 0;
        if (tileEntity.func_145831_w() != null) {
            meta = tileEntity.func_145832_p();
        }
        this.getGraveTexture(graveType);
        GL11.glPushMatrix();
        if (tileEntity.func_145831_w() == null && GraveStoneHelper.isSwordGrave(tileEntity)) {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 2.0f), (float)((float)z + 0.5f));
            GL11.glScalef((float)1.5f, (float)-1.5f, (float)-1.5f);
        } else {
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        }
        switch (TileEntityGSGraveStoneRenderer.getGraveDirection(meta)) {
            case 0: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 1: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        if (GraveStoneHelper.isSwordGrave(tileEntity) && tileEntity.isEnchanted()) {
            this.getGraveModel(graveType).customRender();
        } else {
            this.getGraveModel(graveType).renderAll();
        }
        GL11.glPopMatrix();
    }

    private ModelGraveStone getGraveModel(EnumGraves graveType) {
        switch (graveType) {
            case CROSS: {
                return cross;
            }
            case HORISONTAL_PLATE: {
                return horisontalPlate;
            }
            case DOG_STATUE: {
                return dogStatue;
            }
            case CAT_STATUE: {
                return catStatue;
            }
            case HORSE_STATUE: {
                return horseStatue;
            }
            case WOODEN_SWORD: 
            case STONE_SWORD: 
            case IRON_SWORD: 
            case GOLDEN_SWORD: 
            case DIAMOND_SWORD: {
                return swordGrave;
            }
        }
        return verticalPlate;
    }

    private void getGraveTexture(EnumGraves graveType) {
        switch (graveType) {
            case VERTICAL_PLATE: {
                this.bindTextureByName(Resources.GRAVE_VERTICAL_PLATE);
                break;
            }
            case CROSS: {
                this.bindTextureByName(Resources.GRAVE_CROSS);
                break;
            }
            case HORISONTAL_PLATE: {
                this.bindTextureByName(Resources.GRAVE_HORISONTAL_PLATE);
                break;
            }
            case DOG_STATUE: {
                this.bindTextureByName(Resources.DOG_STATUE_GRAVE);
                break;
            }
            case CAT_STATUE: {
                this.bindTextureByName(Resources.CAT_STATUE_GRAVE);
                break;
            }
            case HORSE_STATUE: {
                this.bindTextureByName(Resources.HORSE_STATUE_GRAVE);
                break;
            }
            case WOODEN_SWORD: {
                this.bindTextureByName(Resources.WOODEN_SWORD_GRAVE);
                break;
            }
            case STONE_SWORD: {
                this.bindTextureByName(Resources.STONE_SWORD_GRAVE);
                break;
            }
            case IRON_SWORD: {
                this.bindTextureByName(Resources.IRON_SWORD_GRAVE);
                break;
            }
            case GOLDEN_SWORD: {
                this.bindTextureByName(Resources.GOLDEN_SWORD_GRAVE);
                break;
            }
            case DIAMOND_SWORD: {
                this.bindTextureByName(Resources.DIAMOND_SWORD_GRAVE);
            }
        }
    }

    private static int getGraveDirection(int meta) {
        switch (meta) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 1;
            }
        }
        return 2;
    }
}

