/*
 * Decompiled with CFR 0.152.
 */
package gravestone.block;

import gravestone.GraveStoneLogger;
import gravestone.block.BlockGSGraveStone;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSBlock;
import gravestone.core.GSMobSpawn;
import gravestone.core.compatibility.GSCompatibilityBattlegear;
import gravestone.core.compatibility.GSCompatibilityTheCampingMod;
import gravestone.core.compatibility.GSCompatibilityisArsMagica;
import gravestone.item.CorpseHelper;
import gravestone.item.enums.EnumCorpse;
import gravestone.tileentity.DeathMessageInfo;
import gravestone.tileentity.TileEntityGSGraveStone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class GraveStoneHelper {
    private static final List<Integer> swordsList = Arrays.asList(Item.func_150891_b((Item)Items.field_151048_u), Item.func_150891_b((Item)Items.field_151010_B), Item.func_150891_b((Item)Items.field_151040_l), Item.func_150891_b((Item)Items.field_151052_q), Item.func_150891_b((Item)Items.field_151041_m));
    private static final List<Integer> gravestoneGround = Arrays.asList(Block.func_149682_b((Block)Blocks.field_150349_c), Block.func_149682_b((Block)Blocks.field_150346_d), Block.func_149682_b((Block)Blocks.field_150354_m), Block.func_149682_b((Block)Blocks.field_150351_n), Block.func_149682_b((Block)Blocks.field_150425_aM), Block.func_149682_b((Block)Blocks.field_150391_bh), Block.func_149682_b((Block)Blocks.field_150433_aE));

    private GraveStoneHelper() {
    }

    public static ItemStack checkSword(List<ItemStack> items) {
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                if (items.get(i) == null || !swordsList.contains(Item.func_150891_b((Item)items.get(i).func_77973_b()))) continue;
                ItemStack sword = items.get(i).func_77946_l();
                items.remove(i);
                return sword;
            }
        }
        return null;
    }

    public static boolean isSwordGrave(TileEntityGSGraveStone tileEntity) {
        return tileEntity.getSword() != 0;
    }

    public static boolean isSwordGrave(byte graveType) {
        return Arrays.binarySearch(BlockGSGraveStone.SWORD_GRAVES, graveType) != -1;
    }

    public static byte getGraveType(Random random, BlockGSGraveStone.EnumGraveType graveType) {
        switch (graveType) {
            case PLAYER_GRAVES: {
                if ((double)random.nextFloat() > 0.1) {
                    return BlockGSGraveStone.GENERATED_GRAVES[random.nextInt(BlockGSGraveStone.GENERATED_GRAVES.length)];
                }
                return BlockGSGraveStone.GENERATED_SWORD_GRAVES[random.nextInt(BlockGSGraveStone.GENERATED_SWORD_GRAVES.length)];
            }
            case PETS_GRAVES: {
                return BlockGSGraveStone.PETS_GRAVES[random.nextInt(BlockGSGraveStone.PETS_GRAVES.length)];
            }
            case DOGS_GRAVES: {
                return BlockGSGraveStone.DOG_GRAVES[random.nextInt(BlockGSGraveStone.DOG_GRAVES.length)];
            }
            case CATS_GRAVES: {
                return BlockGSGraveStone.CAT_GRAVES[random.nextInt(BlockGSGraveStone.CAT_GRAVES.length)];
            }
        }
        if ((double)random.nextFloat() > 0.2) {
            if ((double)random.nextFloat() > 0.1) {
                return BlockGSGraveStone.GENERATED_GRAVES[random.nextInt(BlockGSGraveStone.GENERATED_GRAVES.length)];
            }
            return BlockGSGraveStone.GENERATED_SWORD_GRAVES[random.nextInt(BlockGSGraveStone.GENERATED_SWORD_GRAVES.length)];
        }
        return BlockGSGraveStone.PETS_GRAVES[random.nextInt(BlockGSGraveStone.PETS_GRAVES.length)];
    }

    public static int getMetaDirection(int direction) {
        switch (direction) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public static boolean isPetGrave(byte graveType) {
        return Arrays.binarySearch(BlockGSGraveStone.PETS_GRAVES, graveType) >= 0;
    }

    public static byte graveTypeToSwordType(byte graveType) {
        return (byte)(graveType - 4);
    }

    public static byte swordGraveTypeToGraveType(byte swordGraveType) {
        return (byte)(swordGraveType + 4);
    }

    public static byte getSwordType(Item item) {
        if (Item.func_150891_b((Item)item) == Item.func_150891_b((Item)Items.field_151048_u)) {
            return 5;
        }
        if (Item.func_150891_b((Item)item) == Item.func_150891_b((Item)Items.field_151040_l)) {
            return 3;
        }
        if (Item.func_150891_b((Item)item) == Item.func_150891_b((Item)Items.field_151052_q)) {
            return 2;
        }
        if (Item.func_150891_b((Item)item) == Item.func_150891_b((Item)Items.field_151010_B)) {
            return 4;
        }
        return 1;
    }

    public static void replaceGround(World world, int x, int y, int z) {
        Block botBlock = world.func_147439_a(x, y, z);
        if (botBlock.equals(Blocks.field_150349_c) || botBlock.equals(Blocks.field_150391_bh)) {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
        }
    }

    public static void spawnMob(World world, int x, int y, int z) {
        Entity mob;
        TileEntityGSGraveStone tileEntity;
        if (world.field_73012_v.nextInt(10) == 0 && (tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z)) != null && (mob = GSMobSpawn.getMobEntity(world, tileEntity.getGraveType(), x, y, z)) != null) {
            GSMobSpawn.spawnMob(world, mob, x, y, z, false);
        }
    }

    public static boolean canPlaceBlockAt(Block block) {
        return GraveStoneConfig.canPlaceGravesEveryWhere || gravestoneGround.contains(Block.func_149682_b((Block)block));
    }

    public static int getMetadataBasedOnRotation(int rotation) {
        if (rotation >= 315 || rotation < 45) {
            return 1;
        }
        if (rotation >= 45 && rotation < 135) {
            return 2;
        }
        if (rotation >= 135 && rotation < 225) {
            return 0;
        }
        return 3;
    }

    public static void createPlayerGrave(EntityPlayer player, LivingDeathEvent event) {
        if (player.field_70170_p != null && !player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && GraveStoneConfig.graveItemsCount > 0) {
            LinkedList<ItemStack> items = new LinkedList<ItemStack>();
            items.addAll(Arrays.asList(player.field_71071_by.field_70462_a));
            items.addAll(Arrays.asList(player.field_71071_by.field_70460_b));
            GSCompatibilityBattlegear.addItems(items, player);
            GSCompatibilityTheCampingMod.addItems(items, player);
            player.field_71071_by.func_146027_a(null, -1);
            GSCompatibilityisArsMagica.getSoulboundItemsBack(items, player);
            GraveStoneHelper.createGrave((Entity)player, event, items, player.func_70654_ax(), BlockGSGraveStone.EnumGraveType.PLAYER_GRAVES, false);
        } else {
            GraveStoneHelper.createGrave((Entity)player, event, null, player.func_70654_ax(), BlockGSGraveStone.EnumGraveType.PLAYER_GRAVES, false);
        }
    }

    public static void createGrave(Entity entity, LivingDeathEvent event, List<ItemStack> items, int age, BlockGSGraveStone.EnumGraveType entityType, boolean isVillager) {
        GSBlock.graveStone.createOnDeath(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v - 1, GraveStoneHelper.getDeathMessage((EntityLivingBase)entity, event.source.field_76373_n, isVillager), MathHelper.func_76141_d((float)entity.field_70177_z), items, age, entityType);
    }

    public static void createPetGrave(Entity entity, LivingDeathEvent event) {
        EntityTameable pet = (EntityTameable)entity;
        if (pet.func_70909_n()) {
            if (pet instanceof EntityWolf) {
                GraveStoneHelper.createGrave(entity, event, CorpseHelper.getCorpse(entity, EnumCorpse.DOG), pet.func_70654_ax(), BlockGSGraveStone.EnumGraveType.DOGS_GRAVES, false);
            } else if (pet instanceof EntityOcelot) {
                GraveStoneHelper.createGrave(entity, event, CorpseHelper.getCorpse(entity, EnumCorpse.CAT), pet.func_70654_ax(), BlockGSGraveStone.EnumGraveType.CATS_GRAVES, false);
            }
        }
    }

    public static void createHorseGrave(EntityHorse horse, LivingDeathEvent event) {
        if (horse.func_110248_bS()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.addAll(CorpseHelper.getCorpse((Entity)horse, EnumCorpse.HORSE));
            GraveStoneHelper.createGrave((Entity)horse, event, items, horse.func_70654_ax(), BlockGSGraveStone.EnumGraveType.HORSE_GRAVES, false);
        }
    }

    private static DeathMessageInfo getDeathMessage(EntityLivingBase entity, String damageType, boolean isVillager) {
        EntityLivingBase killer = entity.func_94060_bK();
        String shortString = "death.attack." + damageType;
        String fullString = shortString + ".player";
        if (killer != null) {
            String killerName;
            if (killer instanceof EntityPlayer) {
                killerName = ((EntityPlayer)killer).getDisplayName();
                if (isVillager) {
                    GraveStoneLogger.logInfo("Villager was killed by " + killerName);
                }
            } else {
                killerName = EntityList.func_75621_b((Entity)killer);
                killerName = killerName == null ? "entity.generic.name" : "entity." + killerName + ".name";
            }
            if (StatCollector.func_94522_b((String)fullString)) {
                return new DeathMessageInfo(entity.func_70005_c_(), fullString, killerName);
            }
            return new DeathMessageInfo(entity.func_70005_c_(), shortString, killerName);
        }
        return new DeathMessageInfo(entity.func_70005_c_(), shortString, null);
    }
}

