/*
 * Decompiled with CFR 0.152.
 */
package gravestone.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.GraveStoneLogger;
import gravestone.ModGraveStone;
import gravestone.block.GraveStoneHelper;
import gravestone.block.enums.EnumGraves;
import gravestone.config.GraveStoneConfig;
import gravestone.tileentity.DeathMessageInfo;
import gravestone.tileentity.GSGraveStoneItems;
import gravestone.tileentity.TileEntityGSGraveStone;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGSGraveStone
extends BlockContainer {
    public static final byte[] GENERATED_GRAVES = new byte[]{(byte)EnumGraves.VERTICAL_PLATE.ordinal(), (byte)EnumGraves.CROSS.ordinal(), (byte)EnumGraves.HORISONTAL_PLATE.ordinal()};
    public static final byte[] PETS_GRAVES = new byte[]{(byte)EnumGraves.DOG_STATUE.ordinal(), (byte)EnumGraves.CAT_STATUE.ordinal()};
    public static final byte[] DOG_GRAVES = new byte[]{(byte)EnumGraves.DOG_STATUE.ordinal()};
    public static final byte[] CAT_GRAVES = new byte[]{(byte)EnumGraves.CAT_STATUE.ordinal()};
    public static final byte[] HORSE_GRAVES = new byte[]{(byte)EnumGraves.HORSE_STATUE.ordinal()};
    public static final byte[] SWORD_GRAVES = new byte[]{(byte)EnumGraves.WOODEN_SWORD.ordinal(), (byte)EnumGraves.STONE_SWORD.ordinal(), (byte)EnumGraves.IRON_SWORD.ordinal(), (byte)EnumGraves.GOLDEN_SWORD.ordinal(), (byte)EnumGraves.DIAMOND_SWORD.ordinal()};
    public static final byte[] GENERATED_SWORD_GRAVES = new byte[]{(byte)EnumGraves.WOODEN_SWORD.ordinal(), (byte)EnumGraves.STONE_SWORD.ordinal()};
    private static final Random rand = new Random();

    public BlockGSGraveStone() {
        super(Material.field_151576_e);
        this.field_149758_A = true;
        this.func_149672_a(Block.field_149769_e);
        this.func_149663_c("GraveStone");
        this.func_149711_c(4.5f);
        this.func_149752_b(5.0f);
        this.func_149647_a(ModGraveStone.creativeTab);
        this.func_149675_a(GraveStoneConfig.removeEmptyGraves);
        this.func_149658_d("stone");
        this.setHarvestLevel("pickaxe", 1);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        GraveStoneHelper.replaceGround(world, x, y - 1, z);
        int direction = MathHelper.func_76141_d((float)player.field_70177_z);
        if (direction < 0) {
            direction = 360 + direction;
        }
        int metadata = GraveStoneHelper.getMetadataBasedOnRotation(direction);
        world.func_72921_c(x, y, z, metadata, 2);
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
        if (tileEntity != null && itemStack.field_77990_d != null) {
            if (itemStack.field_77990_d.func_74764_b("GraveType")) {
                tileEntity.setGraveType(itemStack.field_77990_d.func_74771_c("GraveType"));
            } else {
                tileEntity.setGraveType((byte)0);
            }
            if (itemStack.field_77990_d.func_74764_b("isLocalized") && itemStack.field_77990_d.func_74767_n("isLocalized")) {
                tileEntity.getDeathTextComponent().setLocalized();
                if (itemStack.field_77990_d.func_74764_b("name") && itemStack.field_77990_d.func_74764_b("KillerName")) {
                    tileEntity.getDeathTextComponent().setName(itemStack.field_77990_d.func_74779_i("name"));
                    tileEntity.getDeathTextComponent().setKillerName(itemStack.field_77990_d.func_74779_i("KillerName"));
                }
            }
            if (itemStack.field_77990_d.func_74764_b("DeathText")) {
                tileEntity.getDeathTextComponent().setDeathText(itemStack.field_77990_d.func_74779_i("DeathText"));
            }
            if (itemStack.field_77990_d.func_74764_b("Age")) {
                tileEntity.setAge(itemStack.field_77990_d.func_74762_e("Age"));
            }
            if (itemStack.field_77990_d.func_74764_b("SwordType")) {
                byte swordType = itemStack.field_77990_d.func_74771_c("SwordType");
                tileEntity.setSword(swordType);
                if (swordType != 0) {
                    if (itemStack.field_77990_d.func_74764_b("SwordDamage")) {
                        tileEntity.setDamage(itemStack.field_77990_d.func_74762_e("SwordDamage"));
                    }
                    if (itemStack.field_77990_d.func_74764_b("SwordName")) {
                        tileEntity.setSwordName(itemStack.field_77990_d.func_74779_i("SwordName"));
                    }
                    if (itemStack.field_77990_d.func_74764_b("SwordNBT")) {
                        tileEntity.setEnchantment(itemStack.field_77990_d.func_74775_l("SwordNBT"));
                    }
                }
            }
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return GraveStoneHelper.canPlaceBlockAt(world.func_147439_a(x, y - 1, z));
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        int meta = access.func_72805_g(x, y, z);
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)access.func_147438_o(x, y, z);
        EnumGraves graveType = tileEntity != null ? tileEntity.getGraveType() : EnumGraves.VERTICAL_PLATE;
        block0 : switch (graveType) {
            case VERTICAL_PLATE: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.125f, 0.0f, 0.0625f, 0.875f, 0.9375f, 0.1875f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.125f, 0.0f, 0.8125f, 0.875f, 0.9375f, 0.9375f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.0625f, 0.0f, 0.125f, 0.1875f, 0.9375f, 0.875f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.8125f, 0.0f, 0.125f, 0.9375f, 0.9375f, 0.875f);
                    }
                }
                break;
            }
            case CROSS: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.125f, 0.0f, 0.0625f, 0.875f, 1.0f, 0.1875f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.125f, 0.0f, 0.8125f, 0.875f, 1.0f, 0.9375f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.0625f, 0.0f, 0.125f, 0.1875f, 1.0f, 0.875f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.8125f, 0.0f, 0.125f, 0.9375f, 1.0f, 0.875f);
                    }
                }
                break;
            }
            case HORISONTAL_PLATE: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.09375f, 0.0f, 0.0625f, 0.90625f, 0.0625f, 0.9375f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.09375f, 0.0f, 0.0625f, 0.90625f, 0.0625f, 0.9375f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.0625f, 0.0f, 0.09375f, 0.9375f, 0.0625f, 0.90625f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.0625f, 0.0f, 0.09375f, 0.9375f, 0.0625f, 0.90625f);
                    }
                }
                break;
            }
            case DOG_STATUE: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.35f, 0.0f, 0.3f, 0.6f, 0.5f, 0.9f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.35f, 0.0f, 0.7f, 0.6f, 0.5f, 0.1f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.3f, 0.0f, 0.35f, 0.9f, 0.5f, 0.6f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.7f, 0.0f, 0.35f, 0.1f, 0.5f, 0.6f);
                    }
                }
                break;
            }
            case CAT_STATUE: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.43f, 0.0f, 0.3f, 0.57f, 0.5f, 0.75f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.43f, 0.0f, 0.7f, 0.57f, 0.5f, 0.25f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.3f, 0.0f, 0.43f, 0.75f, 0.5f, 0.57f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.7f, 0.0f, 0.43f, 0.25f, 0.5f, 0.57f);
                    }
                }
                break;
            }
            case WOODEN_SWORD: 
            case STONE_SWORD: 
            case IRON_SWORD: 
            case GOLDEN_SWORD: 
            case DIAMOND_SWORD: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.375f, 0.0f, 0.4375f, 0.625f, 0.9f, 0.5625f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.375f, 0.0f, 0.4375f, 0.625f, 0.9f, 0.5625f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.4375f, 0.0f, 0.375f, 0.5625f, 0.9f, 0.625f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.4375f, 0.0f, 0.375f, 0.5625f, 0.9f, 0.625f);
                    }
                }
                break;
            }
            case HORSE_STATUE: {
                switch (meta) {
                    case 0: {
                        this.func_149676_a(0.375f, 0.0f, 0.275f, 0.625f, 0.85f, 0.725f);
                        break block0;
                    }
                    case 1: {
                        this.func_149676_a(0.375f, 0.0f, 0.275f, 0.625f, 0.85f, 0.725f);
                        break block0;
                    }
                    case 2: {
                        this.func_149676_a(0.275f, 0.0f, 0.375f, 0.725f, 0.85f, 0.625f);
                        break block0;
                    }
                    case 3: {
                        this.func_149676_a(0.275f, 0.0f, 0.375f, 0.725f, 0.85f, 0.625f);
                    }
                }
            }
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int metadata, EntityPlayer player) {
        player.func_71020_j(0.025f);
        GraveStoneHelper.spawnMob(world, x, y, z);
        if (GraveStoneConfig.silkTouchForGraves) {
            if (EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
                this.dropBlock(world, x, y, z);
            } else {
                TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
                if (tileEntity != null && GraveStoneHelper.isSwordGrave(tileEntity)) {
                    tileEntity.dropSword();
                }
            }
        } else {
            this.dropBlock(world, x, y, z);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!GraveStoneConfig.silkTouchForGraves) {
            ret.add(this.getBlockItemStack(world, x, y, z));
        } else {
            TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
            if (tileEntity != null && GraveStoneHelper.isSwordGrave(tileEntity)) {
                ret.add(tileEntity.getSwordItem());
            }
        }
        return ret;
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int metadata) {
    }

    public boolean func_149700_E() {
        return GraveStoneConfig.silkTouchForGraves;
    }

    public Item func_149650_a(int par1, Random random, int par3) {
        return GraveStoneConfig.silkTouchForGraves ? null : super.func_149650_a(par1, random, par3);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return GraveStoneConfig.graveRenderID;
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        GraveStoneHelper.spawnMob(world, x, y, z);
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.func_149638_a(par1Entity);
    }

    public float func_149638_a(Entity par1Entity) {
        return 1.8E7f;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntityGSGraveStone te = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
        if (te == null) return false;
        if (world.field_72995_K) {
            String deathText;
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemSpade || (deathText = te.getDeathTextComponent().getDeathText()).length() == 0) return false;
            if (te.getDeathTextComponent().isLocalized()) {
                String name = te.getDeathTextComponent().getName();
                String killerName = ModGraveStone.proxy.getLocalizedEntityName(te.getDeathTextComponent().getKillerName());
                if (killerName.length() == 0) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[]{name}));
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[]{name, killerName}));
                }
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[0]));
            }
            if (te.getAge() == -1) return false;
        }
        if (player.field_71071_by.func_70448_g() == null || !(player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemSpade)) return false;
        GraveStoneLogger.logInfo(player.func_70005_c_() + " loot grave at " + x + "/" + y + "/" + z);
        te.dropAllItems();
        return false;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityGSGraveStone(world);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        GraveStoneHelper.replaceGround(world, x, y - 1, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            tileEntity.dropAllItems();
        }
        super.func_149749_a(world, x, y, z, block, par6);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.isSideSolid(x, y - 1, z, ForgeDirection.DOWN, true)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147465_d(x, y, z, (Block)this, 0, 2);
        }
    }

    public int func_149692_a(int metadata) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        ItemStack graveStoneStack;
        byte i;
        NBTTagCompound nbt;
        for (byte i2 = 0; i2 < EnumGraves.WOODEN_SWORD.ordinal(); i2 = (byte)(i2 + 1)) {
            ItemStack stack = new ItemStack(item, 1, 0);
            nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", i2);
            stack.func_77982_d(nbt);
            list.add(stack);
        }
        ItemStack stack = new ItemStack(item, 1, 0);
        NBTTagCompound nbt2 = new NBTTagCompound();
        nbt2.func_74774_a("GraveType", (byte)EnumGraves.HORSE_STATUE.ordinal());
        stack.func_77982_d(nbt2);
        list.add(stack);
        for (i = (byte)EnumGraves.WOODEN_SWORD.ordinal(); i <= EnumGraves.DIAMOND_SWORD.ordinal(); i = (byte)(i + 1)) {
            graveStoneStack = new ItemStack(item, 1, 0);
            nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", i);
            if (GraveStoneHelper.isSwordGrave(i)) {
                nbt.func_74774_a("SwordType", GraveStoneHelper.graveTypeToSwordType(i));
            }
            graveStoneStack.func_77982_d(nbt);
            list.add(graveStoneStack);
        }
        for (i = (byte)EnumGraves.WOODEN_SWORD.ordinal(); i <= EnumGraves.DIAMOND_SWORD.ordinal(); i = (byte)(i + 1)) {
            graveStoneStack = new ItemStack(item, 1, 0);
            nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", i);
            if (GraveStoneHelper.isSwordGrave(i)) {
                nbt.func_74774_a("SwordType", GraveStoneHelper.graveTypeToSwordType(i));
                NBTTagCompound enchantmentTags = new NBTTagCompound();
                enchantmentTags.func_74782_a("ench", (NBTBase)new NBTTagList());
                nbt.func_74782_a("SwordNBT", (NBTBase)enchantmentTags);
            }
            graveStoneStack.func_77982_d(nbt);
            list.add(graveStoneStack);
        }
    }

    private void dropBlock(World world, int x, int y, int z) {
        ItemStack itemStack = this.getBlockItemStack(world, x, y, z);
        if (itemStack != null) {
            this.func_149642_a(world, x, y, z, itemStack);
        }
    }

    private ItemStack getBlockItemStack(World world, int x, int y, int z) {
        ItemStack itemStack = this.func_149644_j(0);
        TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", tileEntity.getGraveTypeNum());
            if (tileEntity.getDeathTextComponent().isLocalized()) {
                nbt.func_74757_a("isLocalized", true);
                nbt.func_74778_a("name", tileEntity.getDeathTextComponent().getName());
                nbt.func_74778_a("KillerName", tileEntity.getDeathTextComponent().getKillerName());
            }
            nbt.func_74778_a("DeathText", tileEntity.getDeathTextComponent().getDeathText());
            nbt.func_74768_a("Age", tileEntity.getAge());
            if (tileEntity.getSword() != 0) {
                nbt.func_74774_a("SwordType", tileEntity.getSword());
                nbt.func_74768_a("SwordDamage", tileEntity.getDamage());
                nbt.func_74778_a("SwordName", tileEntity.getSwordName());
                nbt.func_74782_a("SwordNBT", (NBTBase)tileEntity.getEnchantment());
            }
            itemStack.func_77982_d(nbt);
        }
        return itemStack;
    }

    public void createOnDeath(World world, int x, int y, int z, DeathMessageInfo deathInfo, int direction, List<ItemStack> items, int age, EnumGraveType entityType) {
        if (direction < 0) {
            direction = 360 + direction;
        }
        byte graveType = 0;
        byte swordType = 0;
        ItemStack sword = null;
        if (GraveStoneConfig.generateSwordGraves && world.field_73012_v.nextInt(1) == 0 && entityType.equals((Object)EnumGraveType.PLAYER_GRAVES) && (sword = GraveStoneHelper.checkSword(items)) != null) {
            swordType = GraveStoneHelper.getSwordType(sword.func_77973_b());
        }
        switch (entityType) {
            case PLAYER_GRAVES: {
                if (swordType == 0) {
                    graveType = GENERATED_GRAVES[rand.nextInt(GENERATED_GRAVES.length)];
                    break;
                }
                graveType = (byte)(4 + swordType);
                break;
            }
            case DOGS_GRAVES: {
                graveType = DOG_GRAVES[rand.nextInt(DOG_GRAVES.length)];
                break;
            }
            case CATS_GRAVES: {
                graveType = CAT_GRAVES[rand.nextInt(CAT_GRAVES.length)];
                break;
            }
            case HORSE_GRAVES: {
                graveType = HORSE_GRAVES[rand.nextInt(HORSE_GRAVES.length)];
            }
        }
        boolean canGenerateGrave = false;
        while ((world.func_147437_c(x, y - 1, z) || world.func_147439_a(x, y - 1, z).func_149688_o().func_76224_d() || world.func_147439_a(x, y - 1, z).func_149688_o().func_76222_j()) && y > 1) {
            --y;
        }
        if (this.canGenerateGraveAtCoordinates(world, x, y, z)) {
            canGenerateGrave = true;
        } else {
            for (int xShift = -5; xShift < 6; xShift = (int)((byte)(xShift + 1))) {
                for (int zShift = -5; zShift < 6; zShift = (int)((byte)(zShift + 1))) {
                    if (!this.canGenerateGraveAtCoordinates(world, x + xShift, y, z + zShift)) continue;
                    x += xShift;
                    z += zShift;
                    canGenerateGrave = true;
                    break;
                }
                if (canGenerateGrave) break;
            }
        }
        if (canGenerateGrave) {
            world.func_147465_d(x, y, z, (Block)this, GraveStoneHelper.getMetadataBasedOnRotation(direction), 2);
            TileEntityGSGraveStone tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z);
            if (tileEntity != null) {
                if (sword != null) {
                    tileEntity.setSword(swordType);
                    tileEntity.setDamage(sword.func_77960_j());
                    tileEntity.setSwordName(sword.func_82833_r());
                    if (sword.func_77986_q() != null && sword.func_77986_q().func_74745_c() > 0) {
                        tileEntity.setEnchantment(sword.func_77978_p());
                    }
                }
                tileEntity.getDeathTextComponent().setLocalized();
                tileEntity.getDeathTextComponent().setName(deathInfo.getName());
                tileEntity.getDeathTextComponent().setDeathText(deathInfo.getDeathMessage());
                tileEntity.getDeathTextComponent().setKillerName(deathInfo.getKillerName());
                tileEntity.setItems(items);
                tileEntity.setGraveType(graveType);
                tileEntity.setAge(age);
            }
            GraveStoneLogger.logInfo("Create " + deathInfo.getName() + "'s grave at " + x + "x" + y + "x" + z);
        } else {
            ItemStack itemStack = this.func_149644_j(0);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", graveType);
            nbt.func_74757_a("isLocalized", true);
            nbt.func_74778_a("name", deathInfo.getName());
            nbt.func_74778_a("DeathText", deathInfo.getDeathMessage());
            nbt.func_74778_a("KillerName", deathInfo.getKillerNameForTE());
            if (swordType != 0) {
                nbt.func_74774_a("SwordType", swordType);
                nbt.func_74768_a("SwordDamage", sword.func_77960_j());
                nbt.func_74778_a("SwordName", sword.func_82833_r());
                if (sword.func_77986_q() != null && sword.func_77986_q().func_74745_c() > 0) {
                    nbt.func_74782_a("SwordNBT", (NBTBase)sword.func_77978_p());
                }
            }
            itemStack.func_77982_d(nbt);
            this.func_149642_a(world, x, y, z, itemStack);
            if (items != null) {
                for (int i = 0; i < items.size(); ++i) {
                    if (items.get(i) == null) continue;
                    GSGraveStoneItems.dropItem(items.get(i), world, x, y, z);
                }
            }
            GraveStoneLogger.logInfo("Can not create " + deathInfo.getName() + "'s grave at " + x + "x" + y + "x" + z);
        }
    }

    private boolean canGenerateGraveAtCoordinates(World world, int x, int y, int z) {
        return world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z).func_149688_o().func_76224_d() || world.func_147439_a(x, y, z).func_149688_o().func_76222_j();
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TileEntityGSGraveStone tileEntity;
        if (GraveStoneConfig.removeEmptyGraves && !world.field_72995_K && (tileEntity = (TileEntityGSGraveStone)world.func_147438_o(x, y, z)) != null && tileEntity.getSword() == 0 && tileEntity.isEmpty()) {
            GraveStoneLogger.logInfo("Remove empty grave at " + x + "/" + y + "/" + z);
            world.func_147475_p(x, y, z);
            world.func_147465_d(x, y, z, (Block)this, 0, 2);
        }
    }

    public static enum EnumGraveType {
        ALL_GRAVES,
        PLAYER_GRAVES,
        PETS_GRAVES,
        DOGS_GRAVES,
        CATS_GRAVES,
        HORSE_GRAVES;

    }
}

