/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;
import shadersmodcore.client.DefaultTexture;
import shadersmodcore.client.HFNoiseTexture;
import shadersmodcore.client.IShaderPack;
import shadersmodcore.client.ShaderPackDefault;
import shadersmodcore.client.ShaderPackFolder;
import shadersmodcore.client.ShaderPackNone;
import shadersmodcore.client.ShaderPackZip;
import shadersmodcore.client.ShadersTex;

public class Shaders {
    public static final String versionString = "2.0.1 beta 9";
    public static final int versionNumber = 131073;
    public static final int buildNumber = 18;
    public static boolean isInitialized = false;
    private static int renderDisplayWidth = 0;
    private static int renderDisplayHeight = 0;
    public static int renderWidth = 0;
    public static int renderHeight = 0;
    private static ats mc;
    public static boolean isRenderingWorld;
    public static boolean isRenderingSky;
    public static boolean isCompositeRendered;
    public static boolean isRenderingDfb;
    public static boolean isShadowPass;
    private static float[] sunPosition;
    private static float[] moonPosition;
    private static float[] upPosition;
    private static float[] upPosModelView;
    private static float[] sunPosModelView;
    private static float[] moonPosModelView;
    private static float[] tempMat;
    private static float[] clearColor;
    private static long worldTime;
    private static long lastWorldTime;
    private static long diffWorldTime;
    private static float sunAngle;
    private static float shadowAngle;
    private static long systemTime;
    private static long lastSystemTime;
    private static long diffSystemTime;
    private static int frameCounter;
    private static float frameTimeCounter;
    private static int systemTimeInt32;
    private static float rainStrength;
    private static float wetness;
    public static float wetnessHalfLife;
    public static float drynessHalfLife;
    public static float eyeBrightnessHalflife;
    private static boolean usewetness;
    private static int isEyeInWater;
    private static int eyeBrightness;
    private static float eyeBrightnessFadeX;
    private static float eyeBrightnessFadeY;
    private static float eyePosY;
    private static float centerDepth;
    private static float centerDepthSmooth;
    private static float centerDepthSmoothHalflife;
    private static boolean centerDepthSmoothEnabled;
    private static int superSamplingLevel;
    private static boolean lightmapEnabled;
    private static boolean fogEnabled;
    public static int entityAttrib;
    public static int midTexCoordAttrib;
    public static boolean useEntityAttrib;
    public static boolean useMidTexCoordAttrib;
    public static boolean useMultiTexCoord3Attrib;
    public static boolean progUseEntityAttrib;
    public static boolean progUseMidTexCoordAttrib;
    public static int atlasSizeX;
    public static int atlasSizeY;
    public static int uniformEntityHurt;
    public static int uniformEntityFlash;
    public static boolean useEntityHurtFlash;
    private static FloatBuffer previousProjection;
    private static FloatBuffer projection;
    private static FloatBuffer projectionInverse;
    private static FloatBuffer previousModelView;
    private static FloatBuffer modelView;
    private static FloatBuffer modelViewInverse;
    private static double[] previousCameraPosition;
    private static double[] cameraPosition;
    private static int shadowPassInterval;
    public static boolean needResizeShadow;
    private static int shadowMapWidth;
    private static int shadowMapHeight;
    private static int spShadowMapWidth;
    private static int spShadowMapHeight;
    private static float shadowMapFOV;
    private static float shadowMapHalfPlane;
    private static boolean shadowMapIsOrtho;
    private static int gbufferFormat_gcolor;
    private static int gbufferFormat_gaux1;
    private static int gbufferFormat_gdepth;
    private static int gbufferFormat_gaux4;
    private static int gbufferFormat_gnormal;
    private static int gbufferFormat_composite;
    private static int shadowPassCounter;
    private static int preShadowPassThirdPersonView;
    public static boolean shouldSkipDefaultShadow;
    private static int sfb;
    private static IntBuffer sfbDepthTextures;
    private static IntBuffer sfbColorTextures;
    private static boolean waterShadowEnabled;
    private static boolean colorShadowEnabled;
    private static FloatBuffer shadowProjection;
    private static FloatBuffer shadowProjectionInverse;
    private static FloatBuffer shadowModelView;
    private static FloatBuffer shadowModelViewInverse;
    private static final int MaxColorBuffers = 8;
    private static final int MaxDrawBuffers = 8;
    private static int usedColorBuffers;
    private static int usedColorAttachs;
    private static int usedDrawBuffers;
    private static IntBuffer dfbDrawBuffers;
    private static IntBuffer drawBuffersNone;
    private static IntBuffer drawBuffersLast;
    private static IntBuffer drawBuffersAll;
    private static IntBuffer drawBuffersClear0;
    private static IntBuffer drawBuffersClear1;
    private static IntBuffer drawBuffersClearColor;
    private static IntBuffer drawBuffersColorAtt0;
    private static int dfb;
    private static IntBuffer dfbDepthTextures;
    private static IntBuffer dfbTextures;
    public static int activeProgram;
    public static final int ProgramNone = 0;
    public static final int ProgramBasic = 1;
    public static final int ProgramTextured = 2;
    public static final int ProgramTexturedLit = 3;
    public static final int ProgramSkyBasic = 4;
    public static final int ProgramSkyTextured = 5;
    public static final int ProgramTerrain = 6;
    public static final int ProgramEntities = 7;
    public static final int ProgramHand = 8;
    public static final int ProgramWater = 9;
    public static final int ProgramWeather = 10;
    public static final int ProgramComposite = 11;
    public static final int ProgramComposite1 = 12;
    public static final int ProgramComposite2 = 13;
    public static final int ProgramComposite3 = 14;
    public static final int ProgramComposite4 = 15;
    public static final int ProgramComposite5 = 16;
    public static final int ProgramComposite6 = 17;
    public static final int ProgramComposite7 = 18;
    public static final int ProgramFinal = 19;
    public static final int ProgramShadow = 20;
    public static final int ProgramCount = 21;
    public static final int MaxCompositePasses = 8;
    private static final String[] programNames;
    private static final int[] programBackups;
    private static int[] programsID;
    private static int[] programsRef;
    private static int programIDCopyDepth;
    private static String[] programsDrawBufSettings;
    private static String newDrawBufSetting;
    private static IntBuffer[] programsDrawBuffers;
    private static IntBuffer activeDrawBuffers;
    private static String[] programsColorAtmSettings;
    private static String newColorAtmSetting;
    private static String activeColorAtmSettings;
    private static int[] programsCompositeMipmapSetting;
    private static int newCompositeMipmapSetting;
    private static int activeCompositeMipmapSetting;
    public static Properties loadedShaders;
    public static Properties shadersConfig;
    public static DefaultTexture defaultTexture;
    public static boolean normalMapEnabled;
    public static boolean shadowMipmapEnabled;
    public static boolean shadowHardwareFilteringEnabled;
    private static ByteBuffer tempDirectByteBuffer;
    private static IntBuffer tempDirectIntBuffer;
    private static FloatBuffer tempDirectFloatBuffer;
    public static boolean dtweak;
    public static boolean configCloudShadow;
    public static float configHandDepthMul;
    public static float configRenderResMul;
    public static float configShadowResMul;
    public static int configTexMinFilB;
    public static int configTexMinFilN;
    public static int configTexMinFilS;
    public static int configTexMagFilB;
    public static int configTexMagFilN;
    public static int configTexMagFilS;
    public static boolean configShadowClipFrustum;
    public static final int texMinFilRange = 3;
    public static final int texMagFilRange = 2;
    public static final String[] texMinFilDesc;
    public static final String[] texMagFilDesc;
    public static final int[] texMinFilValue;
    public static final int[] texMagFilValue;
    static IShaderPack shaderPack;
    static File currentshader;
    static String currentshadername;
    static String packNameNone;
    static String packNameDefault;
    static String shaderpacksdirname;
    static String optionsfilename;
    static File shadersdir;
    static File shaderpacksdir;
    static File configFile;
    public static final boolean enableShadersOption = true;
    private static final boolean enableShadersDebug = true;
    public static final boolean blockLightingFixEnabled = true;
    public static float blockLightLevel05;
    public static float blockLightLevel06;
    public static float blockLightLevel08;
    public static float aoLevel;
    public static float blockAoLight;
    public static float sunPathRotation;
    public static float shadowAngleInterval;
    public static float[] fogColor;
    public static float shadowIntervalSize;
    public static int terrainIconSize;
    public static int[] terrainTextureSize;
    private static HFNoiseTexture noiseTexture;
    private static boolean noiseTextureEnabled;
    private static int noiseTextureResolution;
    static float[] invertMat4x_m;
    static float[] invertMat4x_inv;
    public static int[] entityData;
    public static int entityDataIndex;
    private static final String shaderCodeCopyDepthV = "#version 120\nvarying vec4 texcoord;\nvoid main()\n{\n    texcoord = gl_MultiTexCoord0;\n    gl_Position = ftransform();\n}\n";
    private static final String shaderCodeCopyDepthF = "#version 120\nvarying vec4 texcoord;\nuniform sampler2D depthtex0;\nvoid main()\n{\n    gl_FragDepth = texture2D(depthtex0,texcoord.st).r;\n    gl_FragColor = texture2D(depthtex0,texcoord.st);\n}\n";

    private Shaders() {
    }

    public static void loadConfig() {
        System.out.println("[Shaders] Loading configuration.");
        try {
            if (!shaderpacksdir.exists()) {
                shaderpacksdir.mkdir();
            }
        }
        catch (Exception e) {
            System.err.println("[Shaders] Failed openning shaderpacks directory.");
        }
        shadersConfig = new Properties();
        shadersConfig.setProperty("shaderPack", "");
        if (configFile.exists()) {
            try {
                FileReader reader = new FileReader(configFile);
                shadersConfig.load(reader);
                reader.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!configFile.exists()) {
            try {
                Shaders.storeConfig();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Object value = null;
        dtweak = Boolean.parseBoolean(shadersConfig.getProperty("dtweak", "false"));
        configCloudShadow = Boolean.parseBoolean(shadersConfig.getProperty("cloudShadow", "true"));
        configHandDepthMul = Float.parseFloat(shadersConfig.getProperty("handDepthMul", "0.125"));
        configRenderResMul = Float.parseFloat(shadersConfig.getProperty("renderResMul", "1.0"));
        configShadowResMul = Float.parseFloat(shadersConfig.getProperty("shadowResMul", "1.0"));
        configShadowClipFrustum = Boolean.parseBoolean(shadersConfig.getProperty("shadowClipFrustum", "0"));
        configTexMinFilB = Integer.parseInt(shadersConfig.getProperty("TexMinFilB", "0")) % 3;
        configTexMinFilN = Integer.parseInt(shadersConfig.getProperty("TexMinFilN", Integer.toString(configTexMinFilB))) % 3;
        configTexMinFilS = Integer.parseInt(shadersConfig.getProperty("TexMinFilS", Integer.toString(configTexMinFilB))) % 3;
        configTexMagFilB = Integer.parseInt(shadersConfig.getProperty("TexMagFilB", "0")) % 2;
        configTexMagFilN = Integer.parseInt(shadersConfig.getProperty("TexMagFilN", "0")) % 2;
        configTexMagFilS = Integer.parseInt(shadersConfig.getProperty("TexMagFilS", "0")) % 2;
        currentshadername = shadersConfig.getProperty("shaderPack", packNameDefault);
        Shaders.loadShaderPack();
    }

    public static void storeConfig() {
        System.out.println("[Shaders] Save configuration.");
        shadersConfig.setProperty("dtweak", Boolean.toString(dtweak));
        shadersConfig.setProperty("cloudShadow", Boolean.toString(configCloudShadow));
        shadersConfig.setProperty("handDepthMul", Float.toString(configHandDepthMul));
        shadersConfig.setProperty("renderResMul", Float.toString(configRenderResMul));
        shadersConfig.setProperty("shadowResMul", Float.toString(configShadowResMul));
        shadersConfig.setProperty("shadowClipFrustum", Boolean.toString(configShadowClipFrustum));
        shadersConfig.setProperty("TexMinFilB", Integer.toString(configTexMinFilB));
        shadersConfig.setProperty("TexMinFilN", Integer.toString(configTexMinFilN));
        shadersConfig.setProperty("TexMinFilS", Integer.toString(configTexMinFilS));
        shadersConfig.setProperty("TexMagFilB", Integer.toString(configTexMagFilB));
        shadersConfig.setProperty("TexMagFilN", Integer.toString(configTexMagFilN));
        shadersConfig.setProperty("TexMagFilS", Integer.toString(configTexMagFilS));
        try {
            FileWriter writer = new FileWriter(configFile);
            shadersConfig.store(writer, null);
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setShaderPack(String par1name) {
        currentshadername = par1name;
        shadersConfig.setProperty("shaderPack", par1name);
    }

    public static void loadShaderPack() {
        String packName;
        if (shaderPack != null) {
            shaderPack.close();
            shaderPack = null;
        }
        if (!(packName = shadersConfig.getProperty("shaderPack", packNameDefault)).isEmpty() && !packName.equals(packNameNone)) {
            if (packName.equals(packNameDefault)) {
                shaderPack = new ShaderPackDefault();
            } else {
                try {
                    File packFile = new File(shaderpacksdir, packName);
                    if (packFile.isDirectory()) {
                        shaderPack = new ShaderPackFolder(packName, packFile);
                    } else if (packFile.isFile() && packName.toLowerCase().endsWith(".zip")) {
                        shaderPack = new ShaderPackZip(packName, packFile);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (shaderPack != null) {
            System.out.println("[Shaders] Loaded shaderpack.");
        } else {
            System.out.println("[Shaders] Did not load shaderpack.");
            shaderPack = new ShaderPackNone();
        }
    }

    static ArrayList listofShaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(packNameNone);
        list.add(packNameDefault);
        try {
            if (!shaderpacksdir.exists()) {
                shaderpacksdir.mkdir();
            }
            File[] listOfFiles = shaderpacksdir.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                File file = listOfFiles[i];
                String name = file.getName();
                if (!file.isDirectory() && (!file.isFile() || !name.toLowerCase().endsWith(".zip"))) continue;
                list.add(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    static String versiontostring(int vv) {
        String vs = Integer.toString(vv);
        return Integer.toString(Integer.parseInt(vs.substring(1, 3))) + "." + Integer.toString(Integer.parseInt(vs.substring(3, 5))) + "." + Integer.toString(Integer.parseInt(vs.substring(5)));
    }

    static void checkOptifine() {
    }

    public static int checkGLError(String location) {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            String str = "GL Error " + errorCode + ": " + GLU.gluErrorString((int)errorCode) + " @" + location;
            System.err.println(str);
        }
        return errorCode;
    }

    public static int checkGLError(String location, String info) {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            String str = "GL Error " + errorCode + ": " + GLU.gluErrorString((int)errorCode) + " @" + location + " " + info;
            System.err.println(str);
        }
        return errorCode;
    }

    public static void init() {
        if (!isInitialized) {
            int i;
            mc = ats.w();
            Shaders.checkGLError("Shaders.init pre");
            ContextCapabilities capabilities = GLContext.getCapabilities();
            System.out.println("[Shaders] OpenGL 2.0 = " + capabilities.OpenGL20 + "    OpenGL 2.1 = " + capabilities.OpenGL21 + "    OpenGL 3.0 = " + capabilities.OpenGL30 + "    OpenGL 3.2 = " + capabilities.OpenGL32);
            if (!capabilities.OpenGL20) {
                Shaders.printChatAndLogError("[Shaders] No OpenGL 2.0.");
            }
            if (!capabilities.OpenGL21) {
                Shaders.printChatAndLogError("[Shaders] No OpenGL 2.1.");
            }
            if (!capabilities.GL_EXT_framebuffer_object) {
                Shaders.printChatAndLogError("[Shaders] No EXT_framebuffer_object.");
            }
            if (!capabilities.OpenGL20 || !capabilities.GL_EXT_framebuffer_object) {
                System.out.println("[Shaders] Your GPU is not compatible with the Shaders mod.");
                System.exit(-1);
            }
            if (dfbDrawBuffers == null) {
                dfbDrawBuffers = BufferUtils.createIntBuffer((int)8);
            }
            if (dfbTextures == null) {
                dfbTextures = BufferUtils.createIntBuffer((int)8);
            }
            if (dfbDepthTextures == null) {
                dfbDepthTextures = BufferUtils.createIntBuffer((int)3);
            }
            if (sfbDepthTextures == null) {
                sfbDepthTextures = BufferUtils.createIntBuffer((int)2);
            }
            if (sfbColorTextures == null) {
                sfbColorTextures = BufferUtils.createIntBuffer((int)1);
            }
            int maxDrawBuffers = GL11.glGetInteger((int)34852);
            int maxColorAttach = GL11.glGetInteger((int)36063);
            System.out.println("[Shaders] GL_MAX_DRAW_BUFFERS = " + maxDrawBuffers);
            System.out.println("[Shaders] GL_MAX_COLOR_ATTACHMENTS_EXT = " + maxColorAttach);
            System.out.println("[Shaders] GL_MAX_TEXTURE_IMAGE_UNITS = " + GL11.glGetInteger((int)34930));
            usedColorBuffers = 4;
            usedColorAttachs = 1;
            usedDrawBuffers = 1;
            gbufferFormat_gcolor = 6408;
            gbufferFormat_gdepth = 6408;
            gbufferFormat_composite = 6408;
            gbufferFormat_gnormal = 6408;
            gbufferFormat_gaux1 = 6408;
            gbufferFormat_gaux4 = 6408;
            shadowMipmapEnabled = false;
            shadowHardwareFilteringEnabled = false;
            centerDepthSmoothEnabled = false;
            noiseTextureEnabled = false;
            sunPathRotation = 0.0f;
            shadowIntervalSize = 2.0f;
            aoLevel = 0.8f;
            blockAoLight = 1.0f - aoLevel;
            useEntityAttrib = false;
            useMidTexCoordAttrib = false;
            useMultiTexCoord3Attrib = false;
            waterShadowEnabled = false;
            colorShadowEnabled = false;
            for (i = 0; i < 21; ++i) {
                int pr;
                if (programNames[i] == "") {
                    Shaders.programsRef[i] = 0;
                    Shaders.programsID[i] = 0;
                    Shaders.programsDrawBufSettings[i] = null;
                    Shaders.programsColorAtmSettings[i] = null;
                    Shaders.programsCompositeMipmapSetting[i] = 0;
                    continue;
                }
                newDrawBufSetting = null;
                newColorAtmSetting = null;
                newCompositeMipmapSetting = 0;
                Shaders.programsID[i] = Shaders.programsRef[i] = (pr = Shaders.setupProgram(i, "/shaders/" + programNames[i] + ".vsh", "/shaders/" + programNames[i] + ".fsh"));
                Shaders.programsDrawBufSettings[i] = pr != 0 ? newDrawBufSetting : null;
                Shaders.programsColorAtmSettings[i] = pr != 0 ? newColorAtmSetting : null;
                Shaders.programsCompositeMipmapSetting[i] = pr != 0 ? newCompositeMipmapSetting : 0;
            }
            for (int p = 0; p < 21; ++p) {
                if (p == 19) {
                    Shaders.programsDrawBuffers[p] = null;
                    continue;
                }
                if (programsID[p] == 0) {
                    Shaders.programsDrawBuffers[p] = dfbDrawBuffers;
                    continue;
                }
                String str = programsDrawBufSettings[p];
                if (str != null) {
                    IntBuffer intbuf = BufferUtils.createIntBuffer((int)8);
                    int numDB = str.length();
                    if (numDB > usedDrawBuffers) {
                        usedDrawBuffers = numDB;
                    }
                    if (numDB > maxDrawBuffers) {
                        numDB = maxDrawBuffers;
                    }
                    Shaders.programsDrawBuffers[p] = intbuf;
                    intbuf.limit(numDB);
                    for (int i2 = 0; i2 < numDB; ++i2) {
                        char c;
                        int d = 0;
                        if (str.length() > i2 && (c = str.charAt(i2)) >= '0' && c <= '7') {
                            int ca = c - 48;
                            d = ca + 36064;
                            if (ca > usedColorAttachs) {
                                usedColorAttachs = ca;
                            }
                            if (ca > usedColorBuffers) {
                                usedColorBuffers = ca;
                            }
                        }
                        intbuf.put(i2, d);
                    }
                    continue;
                }
                Shaders.programsDrawBuffers[p] = dfbDrawBuffers;
                usedDrawBuffers = usedColorBuffers;
            }
            usedColorAttachs = usedColorBuffers;
            dfbDrawBuffers.limit(usedColorBuffers);
            dfbTextures.limit(usedColorBuffers);
            for (i = 0; i < usedColorBuffers; ++i) {
                dfbDrawBuffers.put(i, 36064 + i);
            }
            if (usedDrawBuffers > maxDrawBuffers) {
                Shaders.printChatAndLogError("[Shaders] Not enough draw buffers! Requires " + usedDrawBuffers + ".  Has " + maxDrawBuffers + ".");
            }
            for (i = 0; i < 21; ++i) {
                int n = i;
                while (programsID[n] == 0 && programBackups[n] != n) {
                    n = programBackups[n];
                }
                if (n == i) continue;
                Shaders.programsID[i] = programsID[n];
                Shaders.programsDrawBufSettings[i] = programsDrawBufSettings[n];
                Shaders.programsDrawBuffers[i] = programsDrawBuffers[n];
            }
            Shaders.resize();
            Shaders.resizeShadow();
            if (noiseTextureEnabled) {
                Shaders.setupNoiseTexture();
            }
            if (defaultTexture == null) {
                defaultTexture = new DefaultTexture();
            }
            isInitialized = true;
            Shaders.checkGLError("Shaders.init");
        }
    }

    private static void setupNoiseTexture() {
        if (noiseTexture == null) {
            noiseTexture = new HFNoiseTexture(noiseTextureResolution, noiseTextureResolution);
        }
    }

    private static IntBuffer fillIntBufferZero(IntBuffer buf) {
        int limit = buf.limit();
        for (int i = buf.position(); i < limit; ++i) {
            buf.put(i, 0);
        }
        return buf;
    }

    public static void uninit() {
        if (isInitialized) {
            Shaders.checkGLError("Shaders.uninit pre");
            for (int i = 0; i < 21; ++i) {
                if (programsRef[i] != 0) {
                    ARBShaderObjects.glDeleteObjectARB((int)programsRef[i]);
                    Shaders.checkGLError("del programRef[" + i + "] " + programsRef[i]);
                }
                Shaders.programsRef[i] = 0;
                Shaders.programsID[i] = 0;
                Shaders.programsDrawBufSettings[i] = null;
                Shaders.programsDrawBuffers[i] = null;
                Shaders.programsCompositeMipmapSetting[i] = 0;
            }
            if (dfb != 0) {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)dfb);
                dfb = 0;
                Shaders.checkGLError("del dfb");
            }
            if (sfb != 0) {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)sfb);
                sfb = 0;
                Shaders.checkGLError("del sfb");
            }
            if (dfbDepthTextures != null) {
                GL11.glDeleteTextures((IntBuffer)dfbDepthTextures);
                Shaders.fillIntBufferZero(dfbDepthTextures);
                Shaders.checkGLError("del dfbDepthTextures");
            }
            if (dfbTextures != null) {
                GL11.glDeleteTextures((IntBuffer)dfbTextures);
                Shaders.fillIntBufferZero(dfbTextures);
                Shaders.checkGLError("del dfbTextures");
            }
            if (sfbDepthTextures != null) {
                GL11.glDeleteTextures((IntBuffer)sfbDepthTextures);
                Shaders.fillIntBufferZero(sfbDepthTextures);
                Shaders.checkGLError("del shadow depth");
            }
            if (sfbColorTextures != null) {
                GL11.glDeleteTextures((IntBuffer)sfbColorTextures);
                Shaders.fillIntBufferZero(sfbColorTextures);
                Shaders.checkGLError("del shadow color");
            }
            if (dfbDrawBuffers != null) {
                Shaders.fillIntBufferZero(dfbDrawBuffers);
            }
            if (noiseTexture != null) {
                noiseTexture.destroy();
                noiseTexture = null;
            }
            System.out.println("UNINIT");
            shadowPassInterval = 0;
            shouldSkipDefaultShadow = false;
            isInitialized = false;
            Shaders.checkGLError("Shaders.uninit");
        }
    }

    public static void scheduleResize() {
        renderDisplayHeight = 0;
    }

    public static void scheduleResizeShadow() {
        needResizeShadow = true;
    }

    private static void resize() {
        renderDisplayWidth = Shaders.mc.d;
        renderDisplayHeight = Shaders.mc.e;
        renderWidth = Math.round((float)renderDisplayWidth * configRenderResMul);
        renderHeight = Math.round((float)renderDisplayHeight * configRenderResMul);
        Shaders.setupFrameBuffer();
    }

    private static void resizeShadow() {
        needResizeShadow = false;
        shadowMapWidth = Math.round((float)spShadowMapWidth * configShadowResMul);
        shadowMapHeight = Math.round((float)spShadowMapHeight * configShadowResMul);
        Shaders.setupShadowFrameBuffer();
    }

    private static void setupFrameBuffer() {
        int i;
        if (dfb != 0) {
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)dfb);
            GL11.glDeleteTextures((IntBuffer)dfbDepthTextures);
            GL11.glDeleteTextures((IntBuffer)dfbTextures);
        }
        dfb = EXTFramebufferObject.glGenFramebuffersEXT();
        int[] depthTex = new int[]{GL11.glGenTextures(), GL11.glGenTextures(), GL11.glGenTextures()};
        ((IntBuffer)dfbDepthTextures.clear()).put(depthTex).flip();
        GL11.glGenTextures((IntBuffer)dfbTextures);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        for (i = 0; i < depthTex.length; ++i) {
            GL11.glBindTexture((int)3553, (int)depthTex[i]);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)34891, (int)6409);
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)renderWidth, (int)renderHeight, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
        }
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)depthTex[0], (int)0);
        Shaders.checkGLError("FT d");
        for (i = 0; i < usedColorBuffers; ++i) {
            GL11.glBindTexture((int)3553, (int)dfbTextures.get(i));
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            if (i == 0 && gbufferFormat_gcolor != 6408) {
                GL11.glTexImage2D((int)3553, (int)0, (int)gbufferFormat_gcolor, (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            } else if (i == 1 && gbufferFormat_gdepth != 6408) {
                GL11.glTexImage2D((int)3553, (int)0, (int)gbufferFormat_gdepth, (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            } else if (i == 2 && gbufferFormat_gnormal != 6408) {
                GL11.glTexImage2D((int)3553, (int)0, (int)gbufferFormat_gnormal, (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            } else if (i == 3 && gbufferFormat_composite != 6408) {
                GL11.glTexImage2D((int)3553, (int)0, (int)gbufferFormat_composite, (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            } else if (i == 7 && gbufferFormat_gaux4 != 6408) {
                GL11.glTexImage2D((int)3553, (int)0, (int)gbufferFormat_gaux4, (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            } else {
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            }
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)dfbDrawBuffers.get(i), (int)3553, (int)dfbTextures.get(i), (int)0);
            Shaders.checkGLError("FT c");
        }
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status == 36058) {
            Shaders.printChatAndLogError("Failed using multiple internal formats in frame buffer.");
            for (int i2 = 0; i2 < usedColorBuffers; ++i2) {
                GL11.glBindTexture((int)3553, (int)dfbTextures.get(i2));
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)dfbDrawBuffers.get(i2), (int)3553, (int)dfbTextures.get(i2), (int)0);
                Shaders.checkGLError("FT c");
            }
            status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
            if (status == 36053) {
                Shaders.printChatAndLogError("Please update graphics driver.");
            }
        }
        if (status != 36053) {
            Shaders.printChatAndLogError("Failed creating framebuffer! (Status " + status + ")");
        }
    }

    private static void setupShadowFrameBuffer() {
        if (shadowPassInterval <= 0) {
            return;
        }
        Shaders.setupShadowRenderTexture();
        EXTFramebufferObject.glDeleteFramebuffersEXT((int)sfb);
        sfb = EXTFramebufferObject.glGenFramebuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
        GL11.glDrawBuffer((int)0);
        GL11.glReadBuffer((int)0);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbDepthTextures.get(0), (int)0);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)sfbColorTextures.get(0), (int)0);
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status != 36053) {
            Shaders.printChatAndLogError("Failed creating shadow framebuffer! (Status " + status + ")");
        }
    }

    private static void setupShadowRenderTexture() {
        if (shadowPassInterval <= 0) {
            return;
        }
        GL11.glDeleteTextures((IntBuffer)sfbDepthTextures);
        GL11.glDeleteTextures((IntBuffer)sfbColorTextures);
        GL11.glGenTextures((IntBuffer)((IntBuffer)sfbDepthTextures.clear()));
        GL11.glGenTextures((IntBuffer)((IntBuffer)sfbColorTextures.clear()));
        for (int i = 0; i < 2; ++i) {
            GL11.glBindTexture((int)3553, (int)sfbDepthTextures.get(i));
            GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
            GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            if (shadowHardwareFilteringEnabled) {
                GL11.glTexParameteri((int)3553, (int)34892, (int)34894);
            }
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)shadowMapWidth, (int)shadowMapHeight, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
        }
        GL11.glBindTexture((int)3553, (int)sfbColorTextures.get(0));
        GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)shadowMapWidth, (int)shadowMapHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
        GL11.glBindTexture((int)3553, (int)0);
    }

    private static String printChatAndLogError(String str) {
        Shaders.mc.r.b().a(str);
        System.err.println(str);
        return str;
    }

    public static void startup(ats mc) {
        Shaders.mc = mc;
        System.out.println("ShadersMod version 2.0.1 beta 9");
        Shaders.loadConfig();
    }

    public static void beginRender(ats minecraft, float f, long l) {
        if (isShadowPass) {
            return;
        }
        Shaders.checkGLError("pre beginRender");
        mc = minecraft;
        Shaders.mc.C.a("init");
        if (!isInitialized) {
            Shaders.init();
        }
        if (Shaders.mc.d != renderDisplayWidth || Shaders.mc.e != renderDisplayHeight) {
            Shaders.resize();
        }
        if (needResizeShadow) {
            Shaders.resizeShadow();
        }
        if ((diffWorldTime = ((worldTime = Shaders.mc.f.J()) - lastWorldTime) % 24000L) < 0L) {
            diffWorldTime += 24000L;
        }
        lastWorldTime = worldTime;
        systemTime = System.currentTimeMillis();
        if (lastSystemTime == 0L) {
            lastSystemTime = systemTime;
        }
        diffSystemTime = systemTime - lastSystemTime;
        lastSystemTime = systemTime;
        frameTimeCounter += (float)diffSystemTime * 0.001f;
        frameTimeCounter %= 100000.0f;
        rainStrength = minecraft.f.i(f);
        float fadeScalar = (float)diffSystemTime * 0.01f;
        float temp1 = (float)Math.exp(Math.log(0.5) * (double)fadeScalar / (double)(wetness < rainStrength ? drynessHalfLife : wetnessHalfLife));
        wetness = wetness * temp1 + rainStrength * (1.0f - temp1);
        oe eye = Shaders.mc.i;
        eyePosY = (float)eye.v * f + (float)eye.V * (1.0f - f);
        eyeBrightness = eye.c(f);
        float fadeScalar2 = (float)diffSystemTime * 0.01f;
        float temp2 = (float)Math.exp(Math.log(0.5) * (double)fadeScalar2 / (double)eyeBrightnessHalflife);
        eyeBrightnessFadeX = eyeBrightnessFadeX * temp2 + (float)(eyeBrightness & 0xFFFF) * (1.0f - temp2);
        eyeBrightnessFadeY = eyeBrightnessFadeY * temp2 + (float)(eyeBrightness >> 16) * (1.0f - temp2);
        isEyeInWater = Shaders.mc.u.aa == 0 && !Shaders.mc.i.bg() && Shaders.mc.h.a(ajz.h) ? 1 : 0;
        isRenderingWorld = true;
        isCompositeRendered = false;
        if (shadowPassInterval > 0) {
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)sfbDepthTextures.get(0));
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)sfbDepthTextures.get(1));
        }
        for (int i = 0; i < 4 && 4 + i < usedColorBuffers; ++i) {
            GL13.glActiveTexture((int)(33991 + i));
            GL11.glBindTexture((int)3553, (int)dfbTextures.get(4 + i));
        }
        GL13.glActiveTexture((int)33990);
        GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(0));
        GL13.glActiveTexture((int)33995);
        GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(1));
        GL13.glActiveTexture((int)33996);
        GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(2));
        GL13.glActiveTexture((int)33997);
        GL11.glBindTexture((int)3553, (int)sfbColorTextures.get(0));
        if (noiseTextureEnabled) {
            GL13.glActiveTexture((int)(33984 + Shaders.noiseTexture.textureUnit));
            GL11.glBindTexture((int)3553, (int)noiseTexture.getID());
        }
        GL13.glActiveTexture((int)33984);
        if (shadowPassInterval > 0 && --shadowPassCounter <= 0) {
            Shaders.mc.C.c("shadow pass");
            preShadowPassThirdPersonView = Shaders.mc.u.aa;
            Shaders.mc.u.aa = 1;
            isShadowPass = true;
            shadowPassCounter = shadowPassInterval;
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
            GL20.glDrawBuffers((int)(colorShadowEnabled ? 36064 : 0));
            Shaders.useProgram(20);
            Shaders.mc.p.a(f, l);
            GL11.glFlush();
            isShadowPass = false;
            Shaders.mc.u.aa = preShadowPassThirdPersonView;
            if (shadowMipmapEnabled) {
                GL13.glActiveTexture((int)33988);
                GL30.glGenerateMipmap((int)3553);
                GL13.glActiveTexture((int)33989);
                GL30.glGenerateMipmap((int)3553);
                GL13.glActiveTexture((int)33984);
            }
        }
        Shaders.mc.C.b();
        GL11.glViewport((int)0, (int)0, (int)renderWidth, (int)renderHeight);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
        Shaders.checkGLError("end beginRender");
    }

    public static void beginRenderPass(ats minecraft, float f, long l) {
        if (isShadowPass) {
            return;
        }
        GL11.glViewport((int)0, (int)0, (int)renderWidth, (int)renderHeight);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        isRenderingDfb = true;
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
        GL20.glDrawBuffers((int)0);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void setClearColor(float red, float green, float blue) {
        Shaders.clearColor[0] = red;
        Shaders.clearColor[1] = green;
        Shaders.clearColor[2] = blue;
        if (isShadowPass) {
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbDepthTextures.get(0), (int)0);
            GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glClear((int)(colorShadowEnabled ? 16640 : 256));
            return;
        }
        GL20.glDrawBuffers((int)36064);
        GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)1.0f);
        GL11.glClear((int)16384);
        GL20.glDrawBuffers((int)36065);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16384);
        for (int i = 2; i < usedColorBuffers; ++i) {
            GL20.glDrawBuffers((int)(36064 + i));
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16384);
        }
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
    }

    public static void setCamera(float f) {
        oe viewEntity = Shaders.mc.i;
        double x2 = viewEntity.U + (viewEntity.u - viewEntity.U) * (double)f;
        double y = viewEntity.V + (viewEntity.v - viewEntity.V) * (double)f;
        double z = viewEntity.W + (viewEntity.w - viewEntity.W) * (double)f;
        if (isShadowPass) {
            float angleInterval;
            GL11.glViewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            if (shadowMapIsOrtho) {
                GL11.glOrtho((double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)0.05f, (double)256.0);
            } else {
                GLU.gluPerspective((float)shadowMapFOV, (float)((float)shadowMapWidth / (float)shadowMapHeight), (float)0.05f, (float)256.0f);
            }
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float celestialAngle = Shaders.mc.f.c(f);
            sunAngle = celestialAngle < 0.75f ? celestialAngle + 0.25f : celestialAngle - 0.75f;
            float angle = celestialAngle * -360.0f;
            float f2 = angleInterval = shadowAngleInterval > 0.0f ? angle % shadowAngleInterval - shadowAngleInterval * 0.5f : 0.0f;
            if ((double)sunAngle <= 0.5) {
                GL11.glRotatef((float)(angle - angleInterval), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)sunPathRotation, (float)1.0f, (float)0.0f, (float)0.0f);
                shadowAngle = sunAngle;
            } else {
                GL11.glRotatef((float)(angle + 180.0f - angleInterval), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)sunPathRotation, (float)1.0f, (float)0.0f, (float)0.0f);
                shadowAngle = sunAngle - 0.5f;
            }
            if (shadowMapIsOrtho) {
                float trans = shadowIntervalSize;
                float trans2 = trans / 2.0f;
                GL11.glTranslatef((float)((float)x2 % trans - trans2), (float)((float)y % trans - trans2), (float)((float)z % trans - trans2));
            }
            GL11.glGetFloat((int)2983, (FloatBuffer)((FloatBuffer)shadowProjection.position(0)));
            Shaders.invertMat4x((FloatBuffer)shadowProjection.position(0), (FloatBuffer)shadowProjectionInverse.position(0));
            shadowProjection.position(0);
            shadowProjectionInverse.position(0);
            GL11.glGetFloat((int)2982, (FloatBuffer)((FloatBuffer)shadowModelView.position(0)));
            Shaders.invertMat4x((FloatBuffer)shadowModelView.position(0), (FloatBuffer)shadowModelViewInverse.position(0));
            shadowModelView.position(0);
            shadowModelViewInverse.position(0);
            return;
        }
        FloatBuffer tempRefFB = previousProjection;
        previousProjection = projection;
        projection = tempRefFB;
        tempRefFB = previousModelView;
        previousModelView = modelView;
        modelView = tempRefFB;
        tempRefFB = null;
        GL11.glGetFloat((int)2983, (FloatBuffer)((FloatBuffer)projection.position(0)));
        Shaders.invertMat4x((FloatBuffer)projection.position(0), (FloatBuffer)projectionInverse.position(0));
        projection.position(0);
        projectionInverse.position(0);
        GL11.glGetFloat((int)2982, (FloatBuffer)((FloatBuffer)modelView.position(0)));
        Shaders.invertMat4x((FloatBuffer)modelView.position(0), (FloatBuffer)modelViewInverse.position(0));
        modelView.position(0);
        modelViewInverse.position(0);
        Shaders.previousCameraPosition[0] = cameraPosition[0];
        Shaders.previousCameraPosition[1] = cameraPosition[1];
        Shaders.previousCameraPosition[2] = cameraPosition[2];
        Shaders.cameraPosition[0] = x2;
        Shaders.cameraPosition[1] = y;
        Shaders.cameraPosition[2] = z;
    }

    public static void preCelestialRotate() {
        Shaders.setUpPosition();
        GL11.glRotatef((float)(sunPathRotation * 1.0f), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static void postCelestialRotate() {
        tempDirectFloatBuffer.clear();
        FloatBuffer modelView = tempDirectFloatBuffer;
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        modelView.get(tempMat, 0, 16);
        Shaders.multiplyMat4xVec4(tempMat, sunPosModelView, sunPosition);
        Shaders.multiplyMat4xVec4(tempMat, moonPosModelView, moonPosition);
    }

    public static void setUpPosition() {
        tempDirectFloatBuffer.clear();
        FloatBuffer modelView = tempDirectFloatBuffer;
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        modelView.get(tempMat, 0, 16);
        Shaders.multiplyMat4xVec4(tempMat, upPosModelView, upPosition);
    }

    private static float[] multiplyMat4xVec4(float[] matA, float[] vecB, float[] vecOut) {
        vecOut[0] = matA[0] * vecB[0] + matA[4] * vecB[1] + matA[8] * vecB[2] + matA[12] * vecB[3];
        vecOut[1] = matA[1] * vecB[0] + matA[5] * vecB[1] + matA[9] * vecB[2] + matA[13] * vecB[3];
        vecOut[2] = matA[2] * vecB[0] + matA[6] * vecB[1] + matA[10] * vecB[2] + matA[14] * vecB[3];
        vecOut[3] = matA[3] * vecB[0] + matA[7] * vecB[1] + matA[11] * vecB[2] + matA[15] * vecB[3];
        return vecOut;
    }

    private static FloatBuffer invertMat4x(FloatBuffer matIn, FloatBuffer invMatOut) {
        float[] m = invertMat4x_m;
        float[] inv = invertMat4x_inv;
        matIn.get(m);
        inv[0] = m[5] * m[10] * m[15] - m[5] * m[11] * m[14] - m[9] * m[6] * m[15] + m[9] * m[7] * m[14] + m[13] * m[6] * m[11] - m[13] * m[7] * m[10];
        inv[4] = -m[4] * m[10] * m[15] + m[4] * m[11] * m[14] + m[8] * m[6] * m[15] - m[8] * m[7] * m[14] - m[12] * m[6] * m[11] + m[12] * m[7] * m[10];
        inv[8] = m[4] * m[9] * m[15] - m[4] * m[11] * m[13] - m[8] * m[5] * m[15] + m[8] * m[7] * m[13] + m[12] * m[5] * m[11] - m[12] * m[7] * m[9];
        inv[12] = -m[4] * m[9] * m[14] + m[4] * m[10] * m[13] + m[8] * m[5] * m[14] - m[8] * m[6] * m[13] - m[12] * m[5] * m[10] + m[12] * m[6] * m[9];
        inv[1] = -m[1] * m[10] * m[15] + m[1] * m[11] * m[14] + m[9] * m[2] * m[15] - m[9] * m[3] * m[14] - m[13] * m[2] * m[11] + m[13] * m[3] * m[10];
        inv[5] = m[0] * m[10] * m[15] - m[0] * m[11] * m[14] - m[8] * m[2] * m[15] + m[8] * m[3] * m[14] + m[12] * m[2] * m[11] - m[12] * m[3] * m[10];
        inv[9] = -m[0] * m[9] * m[15] + m[0] * m[11] * m[13] + m[8] * m[1] * m[15] - m[8] * m[3] * m[13] - m[12] * m[1] * m[11] + m[12] * m[3] * m[9];
        inv[13] = m[0] * m[9] * m[14] - m[0] * m[10] * m[13] - m[8] * m[1] * m[14] + m[8] * m[2] * m[13] + m[12] * m[1] * m[10] - m[12] * m[2] * m[9];
        inv[2] = m[1] * m[6] * m[15] - m[1] * m[7] * m[14] - m[5] * m[2] * m[15] + m[5] * m[3] * m[14] + m[13] * m[2] * m[7] - m[13] * m[3] * m[6];
        inv[6] = -m[0] * m[6] * m[15] + m[0] * m[7] * m[14] + m[4] * m[2] * m[15] - m[4] * m[3] * m[14] - m[12] * m[2] * m[7] + m[12] * m[3] * m[6];
        inv[10] = m[0] * m[5] * m[15] - m[0] * m[7] * m[13] - m[4] * m[1] * m[15] + m[4] * m[3] * m[13] + m[12] * m[1] * m[7] - m[12] * m[3] * m[5];
        inv[14] = -m[0] * m[5] * m[14] + m[0] * m[6] * m[13] + m[4] * m[1] * m[14] - m[4] * m[2] * m[13] - m[12] * m[1] * m[6] + m[12] * m[2] * m[5];
        inv[3] = -m[1] * m[6] * m[11] + m[1] * m[7] * m[10] + m[5] * m[2] * m[11] - m[5] * m[3] * m[10] - m[9] * m[2] * m[7] + m[9] * m[3] * m[6];
        inv[7] = m[0] * m[6] * m[11] - m[0] * m[7] * m[10] - m[4] * m[2] * m[11] + m[4] * m[3] * m[10] + m[8] * m[2] * m[7] - m[8] * m[3] * m[6];
        inv[11] = -m[0] * m[5] * m[11] + m[0] * m[7] * m[9] + m[4] * m[1] * m[11] - m[4] * m[3] * m[9] - m[8] * m[1] * m[7] + m[8] * m[3] * m[5];
        inv[15] = m[0] * m[5] * m[10] - m[0] * m[6] * m[9] - m[4] * m[1] * m[10] + m[4] * m[2] * m[9] + m[8] * m[1] * m[6] - m[8] * m[2] * m[5];
        float det = m[0] * inv[0] + m[1] * inv[4] + m[2] * inv[8] + m[3] * inv[12];
        if ((double)det != 0.0) {
            int i = 0;
            while (i < 16) {
                int n = i++;
                inv[n] = inv[n] / det;
            }
        } else {
            Arrays.fill(inv, 0.0f);
        }
        invMatOut.put(inv);
        return invMatOut;
    }

    public static void genCompositeMipmap() {
        if ((activeCompositeMipmapSetting & 1) != 0) {
            GL13.glActiveTexture((int)33984);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL30.glGenerateMipmap((int)3553);
        }
        if ((activeCompositeMipmapSetting & 2) != 0) {
            GL13.glActiveTexture((int)33985);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
            GL30.glGenerateMipmap((int)3553);
        }
        if ((activeCompositeMipmapSetting & 4) != 0) {
            GL13.glActiveTexture((int)33986);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
            GL30.glGenerateMipmap((int)3553);
        }
        if ((activeCompositeMipmapSetting & 8) != 0) {
            GL13.glActiveTexture((int)33987);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL30.glGenerateMipmap((int)3553);
        }
        for (int i = 0; i < 4 && 4 + i < usedColorBuffers; ++i) {
            if ((activeCompositeMipmapSetting & 16 << i) == 0) continue;
            GL13.glActiveTexture((int)(33991 + i));
            GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL30.glGenerateMipmap((int)3553);
        }
        GL13.glActiveTexture((int)33984);
    }

    public static void drawComposite() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
    }

    public static void renderCompositeFinal() {
        int i;
        if (isShadowPass) {
            Shaders.useProgram(0);
            return;
        }
        Shaders.checkGLError("pre-renderCompositeFinal");
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)519);
        GL11.glDepthMask((boolean)false);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(0));
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(1));
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(2));
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(3));
        if (shadowPassInterval > 0) {
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)sfbDepthTextures.get(0));
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)sfbDepthTextures.get(1));
        }
        for (i = 0; i < 4 && 4 + i < usedColorBuffers; ++i) {
            GL13.glActiveTexture((int)(33991 + i));
            GL11.glBindTexture((int)3553, (int)dfbTextures.get(4 + i));
        }
        GL13.glActiveTexture((int)33990);
        GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(0));
        GL13.glActiveTexture((int)33995);
        GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(1));
        GL13.glActiveTexture((int)33996);
        GL11.glBindTexture((int)3553, (int)dfbDepthTextures.get(2));
        GL13.glActiveTexture((int)33997);
        GL11.glBindTexture((int)3553, (int)sfbColorTextures.get(0));
        GL13.glActiveTexture((int)33984);
        if (centerDepthSmoothEnabled) {
            tempDirectFloatBuffer.clear();
            GL11.glReadPixels((int)(renderWidth / 2), (int)(renderHeight / 2), (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)tempDirectFloatBuffer);
            centerDepth = tempDirectFloatBuffer.get(0);
            float fadeScalar = (float)diffSystemTime * 0.01f;
            float fadeFactor = (float)Math.exp(Math.log(0.5) * (double)fadeScalar / (double)centerDepthSmoothHalflife);
            centerDepthSmooth = centerDepthSmooth * fadeFactor + centerDepth * (1.0f - fadeFactor);
        }
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)dfbDepthTextures.get(0), (int)0);
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
        Shaders.checkGLError("pre-composite");
        for (i = 0; i < 8; ++i) {
            if (programsID[11 + i] == 0) continue;
            Shaders.useProgram(11 + i);
            Shaders.checkGLError(programNames[11 + i]);
            if (activeCompositeMipmapSetting != 0) {
                Shaders.genCompositeMipmap();
            }
            Shaders.drawComposite();
        }
        isRenderingDfb = false;
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        GL11.glViewport((int)0, (int)0, (int)Shaders.mc.d, (int)Shaders.mc.e);
        if (bfb.a) {
            boolean maskR = bfb.b != 0;
            GL11.glColorMask((boolean)maskR, (!maskR ? 1 : 0) != 0, (!maskR ? 1 : 0) != 0, (boolean)true);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)519);
        GL11.glDepthMask((boolean)false);
        Shaders.checkGLError("pre-final");
        Shaders.useProgram(19);
        Shaders.checkGLError("final");
        Shaders.drawComposite();
        Shaders.checkGLError("renderCompositeFinal");
        isCompositeRendered = true;
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glDepthFunc((int)515);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        Shaders.useProgram(0);
    }

    public static void endRender() {
        if (isShadowPass) {
            Shaders.useProgram(0);
            return;
        }
        if (!isCompositeRendered) {
            Shaders.renderCompositeFinal();
        }
        isRenderingWorld = false;
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glEnable((int)3042);
        Shaders.useProgram(0);
        Shaders.checkGLError("endRender end");
        defaultTexture.bind();
    }

    public static void beginSky() {
        isRenderingSky = true;
        Shaders.useProgram(5);
        Shaders.pushEntity(-2, 0);
    }

    public static void endSky() {
        isRenderingSky = false;
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
        Shaders.popEntity();
    }

    public static void beginTerrain() {
        if (isRenderingWorld) {
            Shaders.useProgram(6);
        }
    }

    public static void endTerrain() {
        if (isRenderingWorld) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
            ShadersTex.bindNSTextures(defaultTexture.getMultiTexID());
        }
    }

    public static void beginTileEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram(6);
        }
    }

    public static void endTileEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
            ShadersTex.bindNSTextures(defaultTexture.getMultiTexID());
        }
    }

    public static void beginBlockDestroyProgress() {
        if (isRenderingWorld) {
            Shaders.useProgram(6);
            if (dtweak) {
                GL11.glBlendFunc((int)770, (int)771);
            }
        }
    }

    public static void endBlockDestroyProgress() {
        if (isRenderingWorld) {
            Shaders.useProgram(3);
        }
    }

    public static void beginEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram(7);
            if (programsID[activeProgram] != 0) {
                boolean bl = useEntityHurtFlash = uniformEntityHurt != -1 || uniformEntityFlash != -1;
                if (uniformEntityHurt != -1) {
                    ARBShaderObjects.glUniform1iARB((int)uniformEntityHurt, (int)0);
                }
                if (uniformEntityHurt != -1) {
                    ARBShaderObjects.glUniform1iARB((int)uniformEntityFlash, (int)0);
                }
            } else {
                useEntityHurtFlash = false;
            }
        }
    }

    public static void endEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void setEntityHurtFlash(int hurt, int flash) {
        if (useEntityHurtFlash && isRenderingWorld && !isShadowPass) {
            if (uniformEntityHurt != -1) {
                ARBShaderObjects.glUniform1iARB((int)uniformEntityHurt, (int)hurt);
            }
            if (uniformEntityFlash != -1) {
                ARBShaderObjects.glUniform1iARB((int)uniformEntityFlash, (int)(flash >> 24));
            }
            Shaders.checkGLError("setEntityHurtFlash");
        }
    }

    public static void resetEntityHurtFlash() {
        Shaders.setEntityHurtFlash(0, 0);
    }

    public static void beginLivingDamage() {
        if (isRenderingWorld) {
            defaultTexture.bind();
            if (!isShadowPass) {
                Shaders.setDrawBuffers(drawBuffersColorAtt0);
            }
        }
    }

    public static void endLivingDamage() {
        if (isRenderingWorld && !isShadowPass) {
            Shaders.setDrawBuffers(programsDrawBuffers[7]);
        }
    }

    public static void beginLitParticles() {
        bfn.a.b(0.0f, 0.0f, 0.0f);
        Shaders.useProgram(3);
    }

    public static void beginParticles() {
        bfn.a.b(0.0f, 0.0f, 0.0f);
        Shaders.useProgram(2);
    }

    public static void endParticles() {
        bfn.a.b(0.0f, 0.0f, 0.0f);
        Shaders.useProgram(3);
    }

    public static void copyDepthTexture() {
        Shaders.setDrawBuffers(drawBuffersNone);
        GL11.glClear((int)256);
        GL11.glDepthFunc((int)519);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        ARBShaderObjects.glUseProgramObjectARB((int)programIDCopyDepth);
        Shaders.setProgramUniform1i("depthtex0", 6);
        Shaders.setProgramUniform1i("depthtex1", 12);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glDepthFunc((int)515);
    }

    public static void beginWaterFancy() {
        if (isRenderingWorld) {
            if (isShadowPass) {
                GL13.glActiveTexture((int)33989);
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)shadowMapWidth, (int)shadowMapWidth);
                GL13.glActiveTexture((int)33984);
            } else {
                GL13.glActiveTexture((int)33995);
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
                GL13.glActiveTexture((int)33984);
                Shaders.useProgram(9);
                GL11.glEnable((int)3042);
                Shaders.setDrawBuffers(drawBuffersNone);
            }
        }
    }

    public static void midWaterFancy() {
        if (isRenderingWorld && !isShadowPass) {
            Shaders.setDrawBuffers(programsDrawBuffers[9]);
        }
    }

    public static void beginWater() {
        if (isRenderingWorld) {
            if (isShadowPass) {
                GL13.glActiveTexture((int)33989);
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)shadowMapWidth, (int)shadowMapWidth);
                GL13.glActiveTexture((int)33984);
                GL11.glDisable((int)3042);
            } else {
                GL13.glActiveTexture((int)33995);
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
                GL13.glActiveTexture((int)33984);
                Shaders.useProgram(9);
                GL11.glEnable((int)3042);
            }
        }
    }

    public static void endWater() {
        if (isRenderingWorld) {
            if (isShadowPass) {
                // empty if block
            }
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void beginWeather() {
        if (!isShadowPass) {
            GL13.glActiveTexture((int)33996);
            GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
            GL13.glActiveTexture((int)33984);
        }
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        Shaders.useProgram(10);
    }

    public static void endWeather() {
        GL11.glDisable((int)3042);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void beginHand() {
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5888);
        Shaders.useProgram(8);
    }

    public static void endHand() {
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void beginFPOverlay() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static void endFPOverlay() {
        GL11.glDisable((int)3042);
    }

    public static void glEnableWrapper(int cap) {
        GL11.glEnable((int)cap);
        if (cap == 3553) {
            Shaders.enableTexture2D();
        } else if (cap == 2912) {
            Shaders.enableFog();
        }
    }

    public static void glDisableWrapper(int cap) {
        GL11.glDisable((int)cap);
        if (cap == 3553) {
            Shaders.disableTexture2D();
        } else if (cap == 2912) {
            Shaders.disableFog();
        }
    }

    public static void sglEnableT2D(int cap) {
        GL11.glEnable((int)cap);
        Shaders.enableTexture2D();
    }

    public static void sglDisableT2D(int cap) {
        GL11.glDisable((int)cap);
        Shaders.disableTexture2D();
    }

    public static void sglEnableFog(int cap) {
        GL11.glEnable((int)cap);
        Shaders.enableFog();
    }

    public static void sglDisableFog(int cap) {
        GL11.glDisable((int)cap);
        Shaders.disableFog();
    }

    public static void enableTexture2D() {
        if (isRenderingSky) {
            Shaders.useProgram(5);
        } else if (activeProgram == 1) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void disableTexture2D() {
        if (isRenderingSky) {
            Shaders.useProgram(4);
        } else if (activeProgram == 2 || activeProgram == 3) {
            Shaders.useProgram(1);
        }
    }

    public static void enableFog() {
        fogEnabled = true;
        if (programsID[activeProgram] != 0) {
            Shaders.setProgramUniform1i("fogMode", GL11.glGetInteger((int)2917));
        }
    }

    public static void disableFog() {
        fogEnabled = false;
        if (programsID[activeProgram] != 0) {
            Shaders.setProgramUniform1i("fogMode", 0);
        }
    }

    public static void enableLightmap() {
        lightmapEnabled = true;
        if (activeProgram == 2) {
            Shaders.useProgram(3);
        }
    }

    public static void disableLightmap() {
        lightmapEnabled = false;
        if (activeProgram == 3) {
            Shaders.useProgram(2);
        }
    }

    public static void preDrawArray(bfn tess) {
        if (useMultiTexCoord3Attrib && tess.o) {
            GL13.glClientActiveTexture((int)33987);
            if (!bfn.A) {
                GL11.glTexCoordPointer((int)2, (int)(13 * 4), (FloatBuffer)((FloatBuffer)bfn.f.position(11)));
            } else {
                GL11.glTexCoordPointer((int)2, (int)5126, (int)(13 * 4), (long)44L);
            }
            GL11.glEnableClientState((int)32888);
            GL13.glClientActiveTexture((int)33984);
        }
        if (useMidTexCoordAttrib) {
            if (!bfn.A) {
                ARBVertexShader.glVertexAttribPointerARB((int)midTexCoordAttrib, (int)2, (boolean)false, (int)(13 * 4), (FloatBuffer)((FloatBuffer)bfn.f.position(11)));
            } else {
                ARBVertexShader.glVertexAttribPointerARB((int)midTexCoordAttrib, (int)2, (int)5126, (boolean)false, (int)(13 * 4), (long)44L);
            }
            ARBVertexShader.glEnableVertexAttribArrayARB((int)midTexCoordAttrib);
        }
        if (useEntityAttrib) {
            if (!bfn.A) {
                ARBVertexShader.glVertexAttribPointerARB((int)entityAttrib, (int)2, (boolean)false, (boolean)false, (int)(13 * 4), (ShortBuffer)((ShortBuffer)bfn.g.position(12)));
            } else {
                ARBVertexShader.glVertexAttribPointerARB((int)entityAttrib, (int)2, (int)5122, (boolean)false, (int)(13 * 4), (long)24L);
            }
            ARBVertexShader.glEnableVertexAttribArrayARB((int)entityAttrib);
        }
    }

    public static void postDrawArray(bfn tess) {
        if (useEntityAttrib) {
            ARBVertexShader.glDisableVertexAttribArrayARB((int)entityAttrib);
        }
        if (useMidTexCoordAttrib) {
            ARBVertexShader.glDisableVertexAttribArrayARB((int)midTexCoordAttrib);
        }
        if (useMultiTexCoord3Attrib && tess.o) {
            GL13.glClientActiveTexture((int)33987);
            GL11.glDisableClientState((int)32888);
            GL13.glClientActiveTexture((int)33984);
        }
    }

    public static void pushEntity(int par1, int par2) {
        Shaders.entityData[++Shaders.entityDataIndex] = par1 & 0xFFFF | par2 << 16;
    }

    public static void pushEntity(int par1) {
        Shaders.entityData[++Shaders.entityDataIndex] = par1 & 0xFFFF;
    }

    public static void pushEntity(aqw block) {
        Shaders.entityData[++Shaders.entityDataIndex] = block.cF & 0xFFFF;
    }

    public static void popEntity() {
        Shaders.entityData[--Shaders.entityDataIndex] = 0;
    }

    public static int getEntityData() {
        return entityData[entityDataIndex];
    }

    private static int setupProgramCopyDepth() {
        int program = ARBShaderObjects.glCreateProgramObjectARB();
        if (program != 0) {
            int vShader = Shaders.createVertShaderFromCode(shaderCodeCopyDepthV);
            int fShader = Shaders.createFragShaderFromCode(shaderCodeCopyDepthF);
            if (vShader != 0 || fShader != 0) {
                int valid;
                if (vShader != 0) {
                    ARBShaderObjects.glAttachObjectARB((int)program, (int)vShader);
                }
                if (fShader != 0) {
                    ARBShaderObjects.glAttachObjectARB((int)program, (int)fShader);
                }
                ARBShaderObjects.glLinkProgramARB((int)program);
                if (vShader != 0) {
                    ARBShaderObjects.glDetachObjectARB((int)program, (int)vShader);
                    ARBShaderObjects.glDeleteObjectARB((int)vShader);
                }
                if (fShader != 0) {
                    ARBShaderObjects.glDetachObjectARB((int)program, (int)fShader);
                    ARBShaderObjects.glDeleteObjectARB((int)fShader);
                }
                if ((valid = GL20.glGetProgrami((int)program, (int)35715)) == 1) {
                    System.out.println("Program copydepth created");
                } else {
                    Shaders.printChatAndLogError("[Shaders] Error : Invalid program copydepth");
                    ARBShaderObjects.glDeleteObjectARB((int)program);
                    program = 0;
                }
            } else {
                ARBShaderObjects.glDeleteObjectARB((int)program);
                program = 0;
            }
        }
        return program;
    }

    private static int createVertShaderFromCode(String code) {
        int vertShader = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
        if (vertShader == 0) {
            return 0;
        }
        ARBShaderObjects.glShaderSourceARB((int)vertShader, (CharSequence)code);
        ARBShaderObjects.glCompileShaderARB((int)vertShader);
        Shaders.printLogInfo(vertShader, "copydepth vert");
        return vertShader;
    }

    private static int createFragShaderFromCode(String code) {
        int fragShader = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
        if (fragShader == 0) {
            return 0;
        }
        ARBShaderObjects.glShaderSourceARB((int)fragShader, (CharSequence)code);
        ARBShaderObjects.glCompileShaderARB((int)fragShader);
        Shaders.printLogInfo(fragShader, "copydepth frag");
        return fragShader;
    }

    private static int setupProgram(int iprogram, String vShaderPath, String fShaderPath) {
        int program = ARBShaderObjects.glCreateProgramObjectARB();
        if (program != 0) {
            progUseEntityAttrib = false;
            progUseMidTexCoordAttrib = false;
            int vShader = Shaders.createVertShader(vShaderPath);
            int fShader = Shaders.createFragShader(fShaderPath);
            if (vShader != 0 || fShader != 0) {
                if (vShader != 0) {
                    ARBShaderObjects.glAttachObjectARB((int)program, (int)vShader);
                }
                if (fShader != 0) {
                    ARBShaderObjects.glAttachObjectARB((int)program, (int)fShader);
                }
                if (progUseEntityAttrib) {
                    ARBVertexShader.glBindAttribLocationARB((int)program, (int)entityAttrib, (CharSequence)"mc_Entity");
                }
                if (progUseMidTexCoordAttrib) {
                    ARBVertexShader.glBindAttribLocationARB((int)program, (int)midTexCoordAttrib, (CharSequence)"mc_midTexCoord");
                }
                ARBShaderObjects.glLinkProgramARB((int)program);
                if (vShader != 0) {
                    ARBShaderObjects.glDetachObjectARB((int)program, (int)vShader);
                    ARBShaderObjects.glDeleteObjectARB((int)vShader);
                }
                if (fShader != 0) {
                    ARBShaderObjects.glDetachObjectARB((int)program, (int)fShader);
                    ARBShaderObjects.glDeleteObjectARB((int)fShader);
                }
                ARBShaderObjects.glValidateProgramARB((int)program);
                Shaders.printLogInfo(program, vShaderPath + "," + fShaderPath);
                int valid = GL20.glGetProgrami((int)program, (int)35715);
                if (valid == 1) {
                    System.out.println("Program " + programNames[iprogram] + " loaded");
                } else {
                    Shaders.printChatAndLogError("[Shaders] Error : Invalid program " + programNames[iprogram]);
                    ARBShaderObjects.glDeleteObjectARB((int)program);
                    program = 0;
                }
            } else {
                ARBShaderObjects.glDeleteObjectARB((int)program);
                program = 0;
            }
        }
        return program;
    }

    private static int createVertShader(String filename) {
        BufferedReader reader;
        int vertShader = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
        if (vertShader == 0) {
            return 0;
        }
        String vertexCode = "";
        try {
            reader = new BufferedReader(new InputStreamReader(shaderPack.getResourceAsStream(filename)));
        }
        catch (Exception e) {
            try {
                reader = new BufferedReader(new FileReader(new File(filename)));
            }
            catch (Exception e2) {
                System.out.println("Couldn't open " + filename);
                ARBShaderObjects.glDeleteObjectARB((int)vertShader);
                return 0;
            }
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                vertexCode = vertexCode + line + "\n";
                if (line.matches("attribute [_a-zA-Z0-9]+ mc_Entity.*")) {
                    useEntityAttrib = true;
                    progUseEntityAttrib = true;
                    continue;
                }
                if (line.matches("attribute [_a-zA-Z0-9]+ mc_midTexCoord.*")) {
                    useMidTexCoordAttrib = true;
                    progUseMidTexCoordAttrib = true;
                    continue;
                }
                if (!line.matches(".*gl_MultiTexCoord3.*")) continue;
                useMultiTexCoord3Attrib = true;
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't read " + filename + "!");
            ARBShaderObjects.glDeleteObjectARB((int)vertShader);
            return 0;
        }
        try {
            reader.close();
        }
        catch (Exception e) {
            System.out.println("Couldn't close " + filename + "!");
        }
        ARBShaderObjects.glShaderSourceARB((int)vertShader, (CharSequence)vertexCode);
        ARBShaderObjects.glCompileShaderARB((int)vertShader);
        Shaders.printLogInfo(vertShader, filename);
        return vertShader;
    }

    private static int createFragShader(String filename) {
        BufferedReader reader;
        int fragShader = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
        if (fragShader == 0) {
            return 0;
        }
        StringBuilder fragCode = new StringBuilder(0x100000);
        try {
            reader = new BufferedReader(new InputStreamReader(shaderPack.getResourceAsStream(filename)));
        }
        catch (Exception e) {
            try {
                reader = new BufferedReader(new FileReader(new File(filename)));
            }
            catch (Exception e2) {
                System.out.println("Couldn't open " + filename);
                ARBShaderObjects.glDeleteObjectARB((int)fragShader);
                return 0;
            }
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int format;
                String[] parts;
                fragCode.append(line).append('\n');
                if (line.matches("#version .*")) continue;
                if (line.matches("uniform [ _a-zA-Z0-9]+ shadow;.*")) {
                    shadowPassInterval = 1;
                    shouldSkipDefaultShadow = true;
                    continue;
                }
                if (line.matches("uniform [ _a-zA-Z0-9]+ watershadow;.*")) {
                    waterShadowEnabled = true;
                    continue;
                }
                if (line.matches("uniform [ _a-zA-Z0-9]+ shadowcolor;.*")) {
                    colorShadowEnabled = true;
                    continue;
                }
                if (line.matches("uniform [ _a-zA-Z0-9]+ gdepth;.*")) {
                    gbufferFormat_gdepth = 34837;
                    continue;
                }
                if (usedColorBuffers < 5 && line.matches("uniform [ _a-zA-Z0-9]+ gaux1;.*")) {
                    usedColorBuffers = 5;
                    continue;
                }
                if (usedColorBuffers < 6 && line.matches("uniform [ _a-zA-Z0-9]+ gaux2;.*")) {
                    usedColorBuffers = 6;
                    continue;
                }
                if (usedColorBuffers < 7 && line.matches("uniform [ _a-zA-Z0-9]+ gaux3;.*")) {
                    usedColorBuffers = 7;
                    continue;
                }
                if (usedColorBuffers < 8 && line.matches("uniform [ _a-zA-Z0-9]+ gaux4;.*")) {
                    usedColorBuffers = 8;
                    continue;
                }
                if (usedColorBuffers < 5 && line.matches("uniform [ _a-zA-Z0-9]+ colortex4;.*")) {
                    usedColorBuffers = 5;
                    continue;
                }
                if (usedColorBuffers < 6 && line.matches("uniform [ _a-zA-Z0-9]+ colortex5;.*")) {
                    usedColorBuffers = 6;
                    continue;
                }
                if (usedColorBuffers < 7 && line.matches("uniform [ _a-zA-Z0-9]+ colortex6;.*")) {
                    usedColorBuffers = 7;
                    continue;
                }
                if (usedColorBuffers < 8 && line.matches("uniform [ _a-zA-Z0-9]+ colortex7;.*")) {
                    usedColorBuffers = 8;
                    continue;
                }
                if (usedColorBuffers < 8 && line.matches("uniform [ _a-zA-Z0-9]+ centerDepthSmooth;.*")) {
                    centerDepthSmoothEnabled = true;
                    continue;
                }
                if (line.matches("/\\* SHADOWRES:[0-9]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Shadow map resolution: " + parts[2]);
                    spShadowMapWidth = spShadowMapHeight = Integer.parseInt(parts[2]);
                    shadowMapWidth = shadowMapHeight = Math.round((float)spShadowMapWidth * configShadowResMul);
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*int[ \t]*shadowMapResolution[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    System.out.println("Shadow map resolution: " + parts[1]);
                    spShadowMapWidth = spShadowMapHeight = Integer.parseInt(parts[1]);
                    shadowMapWidth = shadowMapHeight = Math.round((float)spShadowMapWidth * configShadowResMul);
                    continue;
                }
                if (line.matches("/\\* SHADOWFOV:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Shadow map field of view: " + parts[2]);
                    shadowMapFOV = Float.parseFloat(parts[2]);
                    shadowMapIsOrtho = false;
                    continue;
                }
                if (line.matches("/\\* SHADOWHPL:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Shadow map half-plane: " + parts[2]);
                    shadowMapHalfPlane = Float.parseFloat(parts[2]);
                    shadowMapIsOrtho = true;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*float[ \t]*shadowDistance[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    System.out.println("Shadow map distance: " + parts[1]);
                    shadowMapHalfPlane = Float.parseFloat(parts[1]);
                    shadowMapIsOrtho = true;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*float[ \t]*shadowIntervalSize[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    System.out.println("Shadow map interval size: " + parts[1]);
                    shadowIntervalSize = Float.parseFloat(parts[1]);
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*bool[ \t]*generateShadowMipmap[ \t]*=[ \t]*true[ \t]*;.*")) {
                    System.out.println("Generate shadow mipmap");
                    shadowMipmapEnabled = true;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*bool[ \t]*shadowHardwareFiltering[ \t]*=[ \t]*true[ \t]*;.*")) {
                    System.out.println("Hardware shadow filtering enabled.");
                    shadowHardwareFilteringEnabled = true;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*bool[ \t]*gcolorMipmapEnabled[ \t]*=[ \t]*true[ \t]*;.*")) {
                    if (!filename.matches(".*composite[0-9]?.fsh")) continue;
                    System.out.println("gcolor mipmap enabled for " + filename);
                    newCompositeMipmapSetting |= 1;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*bool[ \t]*gdepthMipmapEnabled[ \t]*=[ \t]*true[ \t]*;.*")) {
                    if (!filename.matches(".*composite[0-9]?.fsh")) continue;
                    System.out.println("gdepth mipmap enabled for " + filename);
                    newCompositeMipmapSetting |= 2;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*bool[ \t]*gnormalMipmapEnabled[ \t]*=[ \t]*true[ \t]*;.*")) {
                    if (!filename.matches(".*composite[0-9]?.fsh")) continue;
                    System.out.println("gnormal mipmap enabled for " + filename);
                    newCompositeMipmapSetting |= 4;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*bool[ \t]*compositeMipmapEnabled[ \t]*=[ \t]*true[ \t]*;.*")) {
                    if (!filename.matches(".*composite[0-9]?.fsh")) continue;
                    System.out.println("composite mipmap enabled for " + filename);
                    newCompositeMipmapSetting |= 8;
                    continue;
                }
                if (line.matches("/\\* WETNESSHL:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Wetness halflife: " + parts[2]);
                    wetnessHalfLife = Float.parseFloat(parts[2]);
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*float[ \t]*wetnessHalflife[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    System.out.println("Wetness halflife: " + parts[1]);
                    wetnessHalfLife = Float.parseFloat(parts[1]);
                    continue;
                }
                if (line.matches("/\\* DRYNESSHL:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Dryness halflife: " + parts[2]);
                    drynessHalfLife = Float.parseFloat(parts[2]);
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*float[ \t]*drynessHalflife[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    System.out.println("Dryness halflife: " + parts[1]);
                    drynessHalfLife = Float.parseFloat(parts[1]);
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*float[ \t]*eyeBrightnessHalflife[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    System.out.println("Eye brightness halflife: " + parts[1]);
                    eyeBrightnessHalflife = Float.parseFloat(parts[1]);
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*float[ \t]*centerDepthHalflife[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    System.out.println("Center depth halflife: " + parts[1]);
                    centerDepthSmoothHalflife = Float.parseFloat(parts[1]);
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*float[ \t]*sunPathRotation[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    System.out.println("Sun path rotation: " + parts[1]);
                    sunPathRotation = Float.parseFloat(parts[1]);
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*bool[ \t]*generateShadowMipmap[ \t]*=[ \t]*true[ \t]*;.*")) {
                    System.out.println("Shadow mipmap enabled");
                    shadowMipmapEnabled = true;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*float[ \t]*ambientOcclusionLevel[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    System.out.println("AO Level: " + parts[1]);
                    aoLevel = Float.parseFloat(parts[1]);
                    blockAoLight = 1.0f - aoLevel;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*int[ \t]*superSamplingLevel[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    int ssaa = Integer.parseInt(parts[1]);
                    if (ssaa > 1) {
                        System.out.println("Super sampling level: " + ssaa + "x");
                        superSamplingLevel = ssaa;
                        continue;
                    }
                    superSamplingLevel = 1;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*int[ \t]*noiseTextureResolution[ \t]*=[ \t]*-?[0-9.]+f?;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    System.out.println("Noise texture enabled");
                    System.out.println("Noise texture resolution: " + parts[1]);
                    noiseTextureResolution = Integer.parseInt(parts[1]);
                    noiseTextureEnabled = true;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*int[ \t]*gcolorFormat[ \t]*=[ \t]*[RGB81632F]*[ \t]*;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    format = Shaders.getTextureFormatFromString(parts[1]);
                    if (format == 0) continue;
                    System.out.println("gcolor format: " + parts[1]);
                    gbufferFormat_gcolor = format;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*int[ \t]*gdepthFormat[ \t]*=[ \t]*[RGB81632F]*[ \t]*;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    format = Shaders.getTextureFormatFromString(parts[1]);
                    if (format == 0) continue;
                    System.out.println("gdepth format: " + parts[1]);
                    gbufferFormat_gdepth = format;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*int[ \t]*gnormalFormat[ \t]*=[ \t]*[RGB81632F]*[ \t]*;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    format = Shaders.getTextureFormatFromString(parts[1]);
                    if (format == 0) continue;
                    System.out.println("gnormal format: " + parts[1]);
                    gbufferFormat_gnormal = format;
                    continue;
                }
                if (line.matches("[ \t]*const[ \t]*int[ \t]*compositeFormat[ \t]*=[ \t]*[RGB81632F]*[ \t]*;.*")) {
                    parts = line.split("(=[ \t]*|;)");
                    format = Shaders.getTextureFormatFromString(parts[1]);
                    if (format == 0) continue;
                    System.out.println("composite format: " + parts[1]);
                    gbufferFormat_composite = format;
                    continue;
                }
                if (line.matches("/\\* GAUX4FORMAT:RGBA32F \\*/.*")) {
                    System.out.println("gaux4 format : RGB32AF");
                    gbufferFormat_gaux4 = 34836;
                    continue;
                }
                if (line.matches("/\\* GAUX4FORMAT:RGB32F \\*/.*")) {
                    System.out.println("gaux4 format : RGB32F");
                    gbufferFormat_gaux4 = 34837;
                    continue;
                }
                if (line.matches("/\\* GAUX4FORMAT:RGB16 \\*/.*")) {
                    System.out.println("gaux4 format : RGB16");
                    gbufferFormat_gaux4 = 32852;
                    continue;
                }
                if (!line.matches("/\\* DRAWBUFFERS:[0-7N]* \\*/.*")) continue;
                parts = line.split("(:| )", 4);
                newDrawBufSetting = parts[2];
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't read " + filename + "!");
            ARBShaderObjects.glDeleteObjectARB((int)fragShader);
            return 0;
        }
        try {
            reader.close();
        }
        catch (Exception e) {
            System.out.println("Couldn't close " + filename + "!");
        }
        ARBShaderObjects.glShaderSourceARB((int)fragShader, (CharSequence)fragCode);
        ARBShaderObjects.glCompileShaderARB((int)fragShader);
        Shaders.printLogInfo(fragShader, filename);
        return fragShader;
    }

    private static boolean printLogInfo(int obj, String name) {
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)obj, (int)35716, (IntBuffer)iVal);
        int length = iVal.get();
        if (length > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer((int)length);
            iVal.flip();
            ARBShaderObjects.glGetInfoLogARB((int)obj, (IntBuffer)iVal, (ByteBuffer)infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            if (infoBytes[length - 1] == 0) {
                infoBytes[length - 1] = 10;
            }
            String out = new String(infoBytes);
            System.out.println("Info log: " + name + "\n" + out);
            return false;
        }
        return true;
    }

    public static void setDrawBuffers(IntBuffer drawBuffers) {
        if (activeDrawBuffers != drawBuffers) {
            activeDrawBuffers = drawBuffers;
            GL20.glDrawBuffers((IntBuffer)drawBuffers);
        }
    }

    public static void useProgram(int program) {
        Shaders.checkGLError("pre-useProgram");
        if (activeProgram == program) {
            return;
        }
        if (isShadowPass) {
            activeProgram = 20;
            ARBShaderObjects.glUseProgramObjectARB((int)programsID[20]);
            Shaders.setProgramUniform1i("texture", 0);
            normalMapEnabled = false;
            return;
        }
        activeProgram = program;
        ARBShaderObjects.glUseProgramObjectARB((int)programsID[program]);
        if (programsID[program] == 0) {
            normalMapEnabled = false;
            return;
        }
        if (Shaders.checkGLError("useProgram ", programNames[program]) != 0) {
            Shaders.programsID[program] = 0;
        }
        IntBuffer drawBuffers = programsDrawBuffers[program];
        if (isRenderingDfb) {
            Shaders.setDrawBuffers(drawBuffers);
            Shaders.checkGLError(programNames[program] + " draw buffers = " + programsDrawBufSettings[program]);
        }
        activeCompositeMipmapSetting = programsCompositeMipmapSetting[program];
        uniformEntityHurt = ARBShaderObjects.glGetUniformLocationARB((int)programsID[activeProgram], (CharSequence)"entityHurt");
        uniformEntityFlash = ARBShaderObjects.glGetUniformLocationARB((int)programsID[activeProgram], (CharSequence)"entityFlash");
        switch (program) {
            case 2: {
                normalMapEnabled = false;
                Shaders.setProgramUniform1i("texture", 0);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                normalMapEnabled = true;
                Shaders.setProgramUniform1i("texture", 0);
                Shaders.setProgramUniform1i("lightmap", 1);
                Shaders.setProgramUniform1i("normals", 2);
                Shaders.setProgramUniform1i("specular", 3);
                Shaders.setProgramUniform1i("shadow", 4);
                Shaders.setProgramUniform1i("watershadow", 5);
                Shaders.setProgramUniform1i("depthtex0", 6);
                Shaders.setProgramUniform1i("depthtex1", 12);
                Shaders.setProgramUniform1i("shadowcolor", 13);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                normalMapEnabled = false;
                Shaders.setProgramUniform1i("gcolor", 0);
                Shaders.setProgramUniform1i("gdepth", 1);
                Shaders.setProgramUniform1i("gnormal", 2);
                Shaders.setProgramUniform1i("composite", 3);
                Shaders.setProgramUniform1i("gaux1", 7);
                Shaders.setProgramUniform1i("gaux2", 8);
                Shaders.setProgramUniform1i("gaux3", 9);
                Shaders.setProgramUniform1i("gaux4", 10);
                Shaders.setProgramUniform1i("colortex0", 0);
                Shaders.setProgramUniform1i("colortex1", 1);
                Shaders.setProgramUniform1i("colortex2", 2);
                Shaders.setProgramUniform1i("colortex3", 3);
                Shaders.setProgramUniform1i("colortex4", 7);
                Shaders.setProgramUniform1i("colortex5", 8);
                Shaders.setProgramUniform1i("colortex6", 9);
                Shaders.setProgramUniform1i("colortex7", 10);
                Shaders.setProgramUniform1i("shadow", waterShadowEnabled ? 5 : 4);
                Shaders.setProgramUniform1i("watershadow", 4);
                Shaders.setProgramUniform1i("shadowtex0", 4);
                Shaders.setProgramUniform1i("shadowtex1", 5);
                Shaders.setProgramUniform1i("gdepthtex", 6);
                Shaders.setProgramUniform1i("depthtex0", 6);
                Shaders.setProgramUniform1i("depthtex1", 11);
                Shaders.setProgramUniform1i("depthtex2", 12);
                Shaders.setProgramUniform1i("shadowcolor", 13);
                Shaders.setProgramUniformMatrix4ARB("gbufferPreviousProjection", false, previousProjection);
                Shaders.setProgramUniformMatrix4ARB("gbufferProjection", false, projection);
                Shaders.setProgramUniformMatrix4ARB("gbufferProjectionInverse", false, projectionInverse);
                Shaders.setProgramUniformMatrix4ARB("gbufferPreviousModelView", false, previousModelView);
                if (shadowPassInterval <= 0) break;
                Shaders.setProgramUniformMatrix4ARB("shadowProjection", false, shadowProjection);
                Shaders.setProgramUniformMatrix4ARB("shadowProjectionInverse", false, shadowProjectionInverse);
                Shaders.setProgramUniformMatrix4ARB("shadowModelView", false, shadowModelView);
                Shaders.setProgramUniformMatrix4ARB("shadowModelViewInverse", false, shadowModelViewInverse);
                break;
            }
            default: {
                normalMapEnabled = false;
            }
        }
        yd stack = Shaders.mc.h.bn.h();
        Shaders.setProgramUniform1i("heldItemId", stack == null ? -1 : stack.d);
        Shaders.setProgramUniform1i("heldBlockLightValue", stack == null || stack.d >= 256 ? 0 : aqw.w[stack.d]);
        Shaders.setProgramUniform1i("fogMode", fogEnabled ? GL11.glGetInteger((int)2917) : 0);
        Shaders.setProgramUniform3f("fogColor", fogColor[0], fogColor[1], fogColor[2]);
        Shaders.setProgramUniform1i("worldTime", (int)worldTime % 24000);
        Shaders.setProgramUniform1f("frameTimeCounter", frameTimeCounter);
        Shaders.setProgramUniform1f("sunAngle", sunAngle);
        Shaders.setProgramUniform1f("shadowAngle", shadowAngle);
        Shaders.setProgramUniform1f("rainStrength", rainStrength);
        Shaders.setProgramUniform1f("aspectRatio", (float)renderWidth / (float)renderHeight);
        Shaders.setProgramUniform1f("viewWidth", renderWidth);
        Shaders.setProgramUniform1f("viewHeight", renderHeight);
        Shaders.setProgramUniform1f("near", 0.05f);
        Shaders.setProgramUniform1f("far", 32 << 3 - Shaders.mc.u.e);
        Shaders.setProgramUniform3f("sunPosition", sunPosition[0], sunPosition[1], sunPosition[2]);
        Shaders.setProgramUniform3f("moonPosition", moonPosition[0], moonPosition[1], moonPosition[2]);
        Shaders.setProgramUniform3f("upPosition", upPosition[0], upPosition[1], upPosition[2]);
        Shaders.setProgramUniform3f("previousCameraPosition", (float)previousCameraPosition[0], (float)previousCameraPosition[1], (float)previousCameraPosition[2]);
        Shaders.setProgramUniform3f("cameraPosition", (float)cameraPosition[0], (float)cameraPosition[1], (float)cameraPosition[2]);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelView", false, modelView);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelViewInverse", false, modelViewInverse);
        Shaders.setProgramUniform1f("wetness", wetness);
        Shaders.setProgramUniform1f("eyeAltitude", eyePosY);
        Shaders.setProgramUniform2i("eyeBrightness", eyeBrightness & 0xFFFF, eyeBrightness >> 16);
        Shaders.setProgramUniform2i("eyeBrightnessSmooth", Math.round(eyeBrightnessFadeX), Math.round(eyeBrightnessFadeY));
        Shaders.setProgramUniform2i("terrainTextureSize", terrainTextureSize[0], terrainTextureSize[1]);
        Shaders.setProgramUniform1i("terrainIconSize", terrainIconSize);
        Shaders.setProgramUniform1i("isEyeInWater", isEyeInWater);
        Shaders.setProgramUniform1i("hideGUI", Shaders.mc.u.Z ? 1 : 0);
        if (centerDepthSmoothEnabled) {
            Shaders.setProgramUniform1f("centerDepthSmooth", centerDepthSmooth);
        }
        if (noiseTextureEnabled) {
            Shaders.setProgramUniform1i("noisetex", Shaders.noiseTexture.textureUnit);
        }
        Shaders.setProgramUniform2i("atlasSize", atlasSizeX, atlasSizeY);
        Shaders.checkGLError("useProgram ", programNames[program]);
    }

    public static void setProgramUniform1i(String name, int x2) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform1iARB((int)uniform, (int)x2);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform2i(String name, int x2, int y) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform2iARB((int)uniform, (int)x2, (int)y);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform1f(String name, float x2) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform1fARB((int)uniform, (float)x2);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform3f(String name, float x2, float y, float z) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform3fARB((int)uniform, (float)x2, (float)y, (float)z);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniformMatrix4ARB(String name, boolean transpose, FloatBuffer matrix) {
        int gp = programsID[activeProgram];
        if (gp != 0 && matrix != null) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniformMatrix4ARB((int)uniform, (boolean)transpose, (FloatBuffer)matrix);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    private static int getTextureFormatFromString(String par) {
        if (par.matches("[ \t]*R8[ \t]*")) {
            return 33321;
        }
        if (par.matches("[ \t]*RG8[ \t]*")) {
            return 33323;
        }
        if (par.matches("[ \t]*RGB8[ \t]*")) {
            return 32849;
        }
        if (par.matches("[ \t]*R16[ \t]*")) {
            return 33322;
        }
        if (par.matches("[ \t]*RG16[ \t]*")) {
            return 33324;
        }
        if (par.matches("[ \t]*RGB16[ \t]*")) {
            return 32852;
        }
        if (par.matches("[ \t]*R32F[ \t]*")) {
            return 33326;
        }
        if (par.matches("[ \t]*RG32F[ \t]*")) {
            return 33328;
        }
        if (par.matches("[ \t]*RGB32F[ \t]*")) {
            return 34837;
        }
        return 0;
    }

    public static void setFogColor(float r, float g, float b) {
        Shaders.fogColor[0] = r;
        Shaders.fogColor[1] = g;
        Shaders.fogColor[2] = b;
    }

    static {
        isRenderingWorld = false;
        isRenderingSky = false;
        isCompositeRendered = false;
        isRenderingDfb = false;
        isShadowPass = false;
        sunPosition = new float[4];
        moonPosition = new float[4];
        upPosition = new float[4];
        upPosModelView = new float[]{0.0f, 100.0f, 0.0f, 0.0f};
        sunPosModelView = new float[]{0.0f, 100.0f, 0.0f, 0.0f};
        moonPosModelView = new float[]{0.0f, -100.0f, 0.0f, 0.0f};
        tempMat = new float[16];
        clearColor = new float[3];
        worldTime = 0L;
        lastWorldTime = 0L;
        diffWorldTime = 0L;
        sunAngle = 0.0f;
        shadowAngle = 0.0f;
        systemTime = 0L;
        lastSystemTime = 0L;
        diffSystemTime = 0L;
        frameCounter = 0;
        frameTimeCounter = 0.0f;
        systemTimeInt32 = 0;
        rainStrength = 0.0f;
        wetness = 0.0f;
        wetnessHalfLife = 600.0f;
        drynessHalfLife = 200.0f;
        eyeBrightnessHalflife = 10.0f;
        usewetness = false;
        isEyeInWater = 0;
        eyeBrightness = 0;
        eyeBrightnessFadeX = 0.0f;
        eyeBrightnessFadeY = 0.0f;
        eyePosY = 0.0f;
        centerDepth = 0.0f;
        centerDepthSmooth = 0.0f;
        centerDepthSmoothHalflife = 1.0f;
        centerDepthSmoothEnabled = false;
        superSamplingLevel = 1;
        lightmapEnabled = false;
        fogEnabled = true;
        entityAttrib = 10;
        midTexCoordAttrib = 11;
        useEntityAttrib = false;
        useMidTexCoordAttrib = false;
        useMultiTexCoord3Attrib = false;
        progUseEntityAttrib = false;
        progUseMidTexCoordAttrib = false;
        atlasSizeX = 0;
        atlasSizeY = 0;
        uniformEntityHurt = -1;
        uniformEntityFlash = -1;
        previousProjection = BufferUtils.createFloatBuffer((int)16);
        projection = BufferUtils.createFloatBuffer((int)16);
        projectionInverse = BufferUtils.createFloatBuffer((int)16);
        previousModelView = BufferUtils.createFloatBuffer((int)16);
        modelView = BufferUtils.createFloatBuffer((int)16);
        modelViewInverse = BufferUtils.createFloatBuffer((int)16);
        previousCameraPosition = new double[3];
        cameraPosition = new double[3];
        shadowPassInterval = 0;
        needResizeShadow = false;
        shadowMapWidth = 1024;
        shadowMapHeight = 1024;
        spShadowMapWidth = 1024;
        spShadowMapHeight = 1024;
        shadowMapFOV = 90.0f;
        shadowMapHalfPlane = 160.0f;
        shadowMapIsOrtho = true;
        gbufferFormat_gcolor = 6408;
        gbufferFormat_gaux1 = 6408;
        gbufferFormat_gdepth = 6408;
        gbufferFormat_gaux4 = 6408;
        gbufferFormat_gnormal = 6408;
        gbufferFormat_composite = 6408;
        shadowPassCounter = 0;
        shouldSkipDefaultShadow = false;
        sfb = 0;
        sfbDepthTextures = null;
        sfbColorTextures = null;
        waterShadowEnabled = false;
        colorShadowEnabled = false;
        shadowProjection = BufferUtils.createFloatBuffer((int)16);
        shadowProjectionInverse = BufferUtils.createFloatBuffer((int)16);
        shadowModelView = BufferUtils.createFloatBuffer((int)16);
        shadowModelViewInverse = BufferUtils.createFloatBuffer((int)16);
        usedColorBuffers = 0;
        usedColorAttachs = 0;
        usedDrawBuffers = 0;
        dfbDrawBuffers = null;
        drawBuffersNone = (IntBuffer)ByteBuffer.allocateDirect(32).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().put(0).position(0).limit(1);
        drawBuffersLast = null;
        drawBuffersAll = null;
        drawBuffersClear0 = null;
        drawBuffersClear1 = null;
        drawBuffersClearColor = null;
        drawBuffersColorAtt0 = (IntBuffer)ByteBuffer.allocateDirect(32).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().put(36064).position(0).limit(1);
        dfb = 0;
        dfbDepthTextures = null;
        dfbTextures = null;
        activeProgram = 0;
        programNames = new String[]{"", "gbuffers_basic", "gbuffers_textured", "gbuffers_textured_lit", "gbuffers_skybasic", "gbuffers_skytextured", "gbuffers_terrain", "gbuffers_entities", "gbuffers_hand", "gbuffers_water", "gbuffers_weather", "composite", "composite1", "composite2", "composite3", "composite4", "composite5", "composite6", "composite7", "final", "shadow"};
        programBackups = new int[]{0, 0, 1, 2, 1, 2, 3, 3, 3, 6, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        programsID = new int[21];
        programsRef = new int[21];
        programIDCopyDepth = 0;
        programsDrawBufSettings = new String[21];
        newDrawBufSetting = null;
        programsDrawBuffers = new IntBuffer[21];
        activeDrawBuffers = null;
        programsColorAtmSettings = new String[21];
        newColorAtmSetting = null;
        activeColorAtmSettings = null;
        programsCompositeMipmapSetting = new int[21];
        newCompositeMipmapSetting = 0;
        activeCompositeMipmapSetting = 0;
        loadedShaders = null;
        shadersConfig = null;
        defaultTexture = null;
        normalMapEnabled = false;
        shadowMipmapEnabled = false;
        shadowHardwareFilteringEnabled = false;
        tempDirectByteBuffer = BufferUtils.createByteBuffer((int)64);
        tempDirectIntBuffer = tempDirectByteBuffer.asIntBuffer();
        tempDirectFloatBuffer = tempDirectByteBuffer.asFloatBuffer();
        dtweak = false;
        configCloudShadow = true;
        configHandDepthMul = 0.125f;
        configRenderResMul = 1.0f;
        configShadowResMul = 1.0f;
        configTexMinFilB = 0;
        configTexMinFilN = 0;
        configTexMinFilS = 0;
        configTexMagFilB = 0;
        configTexMagFilN = 0;
        configTexMagFilS = 0;
        configShadowClipFrustum = false;
        texMinFilDesc = new String[]{"Nearest", "Nearest-Nearest", "Nearest-Linear"};
        texMagFilDesc = new String[]{"Nearest", "Linear"};
        texMinFilValue = new int[]{9728, 9984, 9986};
        texMagFilValue = new int[]{9728, 9729};
        shaderPack = null;
        packNameNone = "(none)";
        packNameDefault = "(internal)";
        shaderpacksdirname = "shaderpacks";
        optionsfilename = "optionsshaders.txt";
        shadersdir = new File(ats.w().x, "shaders");
        shaderpacksdir = new File(ats.w().x, shaderpacksdirname);
        configFile = new File(ats.w().x, optionsfilename);
        blockLightLevel05 = 1.0f;
        blockLightLevel06 = 1.0f;
        blockLightLevel08 = 1.0f;
        aoLevel = 0.8f;
        blockAoLight = 1.0f - aoLevel;
        sunPathRotation = 0.0f;
        shadowAngleInterval = 0.0f;
        fogColor = new float[3];
        shadowIntervalSize = 2.0f;
        terrainIconSize = 16;
        terrainTextureSize = new int[2];
        noiseTextureEnabled = false;
        noiseTextureResolution = 256;
        invertMat4x_m = new float[16];
        invertMat4x_inv = new float[16];
        entityData = new int[20];
        entityDataIndex = 0;
    }
}

