/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCRemap;

public class SMCCTEntityRenderer
implements IClassTransformer {
    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVrenderWorld
    extends MethodVisitor {
        private static final int stateEnd = 28;
        int state = 0;
        String section = "";
        Label labelAfterUpdate = null;
        Label labelEndUpdate = null;
        Label labelNoSky = null;

        public MVrenderWorld(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, "net/minecraft/client/renderer/EntityRenderer", "field_78531_r", "Lnet/minecraft/client/Minecraft;");
            this.mv.visitVarInsn(23, 1);
            this.mv.visitVarInsn(22, 2);
            this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginRender", "(Lnet/minecraft/client/Minecraft;FJ)V");
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof String) {
                String scst;
                this.section = scst = (String)cst;
            }
            this.mv.visitLdcInsn(cst);
        }

        public void visitIntInsn(int opcode, int operand) {
            switch (this.state) {
                case 23: 
                case 25: {
                    if (opcode != 17 || operand != 256) break;
                    this.state = 26;
                    this.mv.visitInsn(3);
                    return;
                }
            }
            this.mv.visitIntInsn(opcode, operand);
        }

        public void visitJumpInsn(int opcode, Label label) {
            switch (this.state) {
                case 4: {
                    if (opcode != 162) break;
                    ++this.state;
                    this.mv.visitInsn(88);
                    this.mv.visitFieldInsn(178, "shadersmodcore/client/Shaders", "isShadowPass", "Z");
                    this.mv.visitJumpInsn(154, label);
                    return;
                }
                case 10: {
                    if (opcode != 154) break;
                    ++this.state;
                    this.labelAfterUpdate = label;
                    this.labelEndUpdate = new Label();
                    this.mv.visitJumpInsn(opcode, label);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginUpdateChunks", "()V");
                    return;
                }
                case 11: {
                    if (label != this.labelAfterUpdate) break;
                    this.mv.visitJumpInsn(opcode, this.labelEndUpdate);
                    return;
                }
            }
            this.mv.visitJumpInsn(opcode, label);
        }

        public void visitLabel(Label label) {
            switch (this.state) {
                case 11: {
                    if (label != this.labelAfterUpdate) break;
                    ++this.state;
                    this.mv.visitLabel(this.labelEndUpdate);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endUpdateChunks", "()V");
                    this.mv.visitLabel(label);
                    this.labelEndUpdate = null;
                    this.labelAfterUpdate = null;
                    return;
                }
            }
            this.mv.visitLabel(label);
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            switch (this.state) {
                case 7: {
                    this.state = 8;
                    this.mv.visitLabel(this.labelNoSky);
                    this.labelNoSky = null;
                    this.mv.visitFrame(type, nLocal, local, nStack, stack);
                    return;
                }
                case 27: {
                    ++this.state;
                    this.mv.visitFrame(type, nLocal, local, nStack, stack);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "renderCompositeFinal", "()V");
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(180, "net/minecraft/client/renderer/EntityRenderer", "field_78503_V", "D");
                    this.mv.visitInsn(15);
                    this.mv.visitInsn(151);
                    Label l149 = new Label();
                    this.mv.visitJumpInsn(154, l149);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginFPOverlay", "()V");
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(23, 1);
                    this.mv.visitVarInsn(21, 13);
                    this.mv.visitMethodInsn(183, "net/minecraft/client/renderer/EntityRenderer", "func_78476_b", "(FI)V");
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endFPOverlay", "()V");
                    this.mv.visitLabel(l149);
                    this.mv.visitLineNumber(1371, l149);
                    this.mv.visitFrame(3, 0, null, 0, null);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endRender", "()V");
                    return;
                }
            }
            this.mv.visitFrame(type, nLocal, local, nStack, stack);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapFieldName(owner, name, desc);
            String descM = SMCRemap.remapper.mapType(desc);
            switch (this.state) {
                case 3: {
                    if (!ownerM.equals("net/minecraft/client/settings/GameSettings") || !nameM.equals("field_74339_e")) break;
                    ++this.state;
                }
            }
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            switch (this.state) {
                case 0: {
                    if (!ownerM.equals("org/lwjgl/opengl/GL11") || !nameM.equals("glViewport") || !descM.equals("(IIII)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "setViewport", "(IIII)V");
                    return;
                }
                case 1: {
                    if (!ownerM.equals("org/lwjgl/opengl/GL11") || !nameM.equals("glClear") || !descM.equals("(I)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "clearRenderBuffer", "()V");
                    return;
                }
                case 2: {
                    if (!ownerM.equals("net/minecraft/client/renderer/EntityRenderer") || !nameM.equals("func_78479_a") || !descM.equals("(FI)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitVarInsn(23, 1);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "setCamera", "(F)V");
                    return;
                }
                case 3: {
                    if (!ownerM.equals("Config") || !nameM.equals("isSkyEnabled") || !descM.equals("()Z")) break;
                    this.state = 6;
                    this.mv.visitFieldInsn(178, "shadersmodcore/client/Shaders", "isShadowPass", "Z");
                    this.labelNoSky = new Label();
                    this.mv.visitJumpInsn(154, this.labelNoSky);
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    return;
                }
                case 5: {
                    if (!ownerM.equals("net/minecraft/client/renderer/RenderGlobal") || !nameM.equals("func_72714_a") || !descM.equals("(F)V")) break;
                    this.state = 8;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginSky", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endSky", "()V");
                    return;
                }
                case 6: {
                    if (!ownerM.equals("net/minecraft/client/renderer/RenderGlobal") || !nameM.equals("func_72714_a") || !descM.equals("(F)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginSky", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endSky", "()V");
                    return;
                }
                case 8: {
                    if (!ownerM.equals("net/minecraft/client/renderer/culling/ICamera") && !ownerM.equals("net/minecraft/client/renderer/culling/Frustrum") || !nameM.equals("func_78547_a") || !descM.equals("(DDD)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersRender", "setFrustrumPosition", "(Lnet/minecraft/client/renderer/culling/Frustrum;DDD)V");
                    return;
                }
                case 9: {
                    if (!ownerM.equals("net/minecraft/client/renderer/RenderGlobal") || !nameM.equals("func_72729_a") || !descM.equals("(Lnet/minecraft/client/renderer/culling/ICamera;F)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersRender", "clipRenderersByFrustrum", "(Lnet/minecraft/client/renderer/RenderGlobal;Lnet/minecraft/client/renderer/culling/Frustrum;F)V");
                    return;
                }
                case 12: {
                    if (!ownerM.equals("net/minecraft/client/renderer/RenderGlobal") || !nameM.equals("func_72719_a") || !descM.equals("(Lnet/minecraft/entity/EntityLivingBase;ID)I")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginTerrain", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endTerrain", "()V");
                    return;
                }
                case 13: {
                    if (ownerM.equals("net/minecraft/client/particle/EffectRenderer") && nameM.equals("func_78872_b") && descM.equals("(Lnet/minecraft/entity/Entity;F)V")) {
                        ++this.state;
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginLitParticles", "()V");
                        this.mv.visitMethodInsn(opcode, owner, name, desc);
                        return;
                    }
                    if (!ownerM.equals("org/lwjgl/opengl/GL11") || !nameM.equals("glDisable") || !descM.equals("(I)V")) break;
                    this.state = 16;
                    break;
                }
                case 14: {
                    if (!ownerM.equals("net/minecraft/client/particle/EffectRenderer") || !nameM.equals("func_78874_a") || !descM.equals("(Lnet/minecraft/entity/Entity;F)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginParticles", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endParticles", "()V");
                    return;
                }
                case 15: {
                    if (!ownerM.equals("org/lwjgl/opengl/GL11") || !nameM.equals("glDisable") || !descM.equals("(I)V")) break;
                    this.state = 16;
                    break;
                }
                case 16: {
                    if (ownerM.equals("net/minecraft/client/renderer/RenderGlobal") && nameM.equals("func_72719_a") && descM.equals("(Lnet/minecraft/entity/EntityLivingBase;ID)I")) {
                        ++this.state;
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginWaterFancy", "()V");
                        this.mv.visitMethodInsn(opcode, owner, name, desc);
                        return;
                    }
                    if (!ownerM.equals("net/minecraft/client/renderer/RenderGlobal") || !nameM.equals("renderAllSortedRenderers") || !descM.equals("(ID)I")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginWaterFancy", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    return;
                }
                case 17: {
                    if (ownerM.equals("net/minecraft/client/renderer/RenderGlobal") && nameM.equals("func_72733_a") && descM.equals("(ID)V")) {
                        ++this.state;
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "midWaterFancy", "()V");
                        this.mv.visitMethodInsn(opcode, owner, name, desc);
                        return;
                    }
                    if (!ownerM.equals("net/minecraft/client/renderer/RenderGlobal") || !nameM.equals("renderAllSortedRenderers") || !descM.equals("(ID)I")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "midWaterFancy", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    return;
                }
                case 18: {
                    if (!ownerM.equals("org/lwjgl/opengl/GL11") || !nameM.equals("glShadeModel") || !descM.equals("(I)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endWater", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    return;
                }
                case 19: {
                    if (ownerM.equals("net/minecraft/client/renderer/RenderGlobal") && nameM.equals("func_72719_a") && descM.equals("(Lnet/minecraft/entity/EntityLivingBase;ID)I")) {
                        ++this.state;
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginWater", "()V");
                        this.mv.visitMethodInsn(opcode, owner, name, desc);
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endWater", "()V");
                        return;
                    }
                    if (!ownerM.equals("net/minecraft/client/renderer/RenderGlobal") || !nameM.equals("renderAllSortedRenderers") || !descM.equals("(ID)I")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginWater", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endWater", "()V");
                    return;
                }
                case 20: {
                    if (!ownerM.equals("org/lwjgl/opengl/GL11") || !nameM.equals("glDisable") || !descM.equals("(I)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitFieldInsn(178, "shadersmodcore/client/Shaders", "isShadowPass", "Z");
                    Label l117 = new Label();
                    this.mv.visitJumpInsn(153, l117);
                    this.mv.visitInsn(177);
                    this.mv.visitLabel(l117);
                    this.mv.visitFrame(3, 0, null, 0, null);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "readCenterDepth", "()V");
                    return;
                }
                case 21: {
                    if (!ownerM.equals("net/minecraft/client/renderer/EntityRenderer") || !nameM.equals("func_78474_d") || !descM.equals("(F)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginWeather", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endWeather", "()V");
                    return;
                }
                case 22: {
                    if (!ownerM.equals("org/lwjgl/opengl/GL11") || !nameM.equals("glDisable") || !descM.equals("(I)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "disableFog", "()V");
                    return;
                }
                case 23: {
                    if (!ownerM.equals("net/minecraft/client/particle/EffectRenderer") || !nameM.equals("func_78872_b") || !descM.equals("(Lnet/minecraft/entity/Entity;F)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginLitParticles", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    return;
                }
                case 24: {
                    if (!ownerM.equals("net/minecraft/client/particle/EffectRenderer") || !nameM.equals("func_78874_a") || !descM.equals("(Lnet/minecraft/entity/Entity;F)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginParticles", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endParticles", "()V");
                    return;
                }
                case 26: {
                    if (!ownerM.equals("net/minecraft/client/renderer/EntityRenderer") || !nameM.equals("func_78476_b") || !descM.equals("(FI)V")) break;
                    ++this.state;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginHand", "()V");
                    this.mv.visitMethodInsn(opcode, owner, name, desc);
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endHand", "()V");
                    return;
                }
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitEnd() {
            if (this.state != 28) {
                SMCLog.warning("  state %d expect %d", this.state, 28);
            }
            this.mv.visitEnd();
        }
    }

    private static class MVrenderHand
    extends MethodVisitor {
        Label la1 = new Label();

        public MVrenderHand(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (ownerM.equals("org/lwjgl/util/glu/Project") && nameM.equals("gluPerspective") && descM.equals("(FFFF)V")) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "applyHandDepth", "()V");
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                return;
            }
            if (ownerM.equals("org/lwjgl/opengl/GL11") && nameM.equals("glPushMatrix") && descM.equals("()V")) {
                this.mv.visitFieldInsn(178, "shadersmodcore/client/Shaders", "isCompositeRendered", "Z");
                this.mv.visitJumpInsn(154, this.la1);
                return;
            }
            if (ownerM.equals("org/lwjgl/opengl/GL11") && nameM.equals("glPopMatrix") && descM.equals("()V")) {
                this.mv.visitInsn(177);
                this.mv.visitLabel(this.la1);
                this.mv.visitFrame(3, 0, null, 0, null);
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVrenderCloudsCheck
    extends MethodVisitor {
        public MVrenderCloudsCheck(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (ownerM.equals("net/minecraft/client/settings/GameSettings") && nameM.equals("func_74309_c") && descM.equals("()Z")) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "shouldRenderClouds", "(Lnet/minecraft/client/settings/GameSettings;)Z");
                return;
            }
            if (ownerM.equals("net/minecraft/client/renderer/RenderGlobal") && nameM.equals("func_72718_b") && descM.equals("(F)V")) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginClouds", "()V");
                this.mv.visitMethodInsn(opcode, owner, name, desc);
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endClouds", "()V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVsetupFog
    extends MethodVisitor {
        public MVsetupFog(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (owner.equals("org/lwjgl/opengl/GL11") && name.equals("glFogi") && desc.equals("(II)V")) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "sglFogi", "(II)V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVsetFogColorBuffer
    extends MethodVisitor {
        public MVsetFogColorBuffer(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitVarInsn(23, 1);
            this.mv.visitVarInsn(23, 2);
            this.mv.visitVarInsn(23, 3);
            this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "setFogColor", "(FFF)V");
        }
    }

    private static class MVenableLightmap
    extends MethodVisitor {
        public MVenableLightmap(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "enableLightmap", "()V");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class MVdisableLightmap
    extends MethodVisitor {
        public MVdisableLightmap(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "disableLightmap", "()V");
            }
            this.mv.visitInsn(opcode);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String nameM = SMCRemap.remapper.mapMethodName(this.classname, name, desc);
            if (nameM.equals("func_78483_a")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVdisableLightmap(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals("func_78463_b")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVenableLightmap(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals("func_78469_a")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVsetFogColorBuffer(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals("func_78468_a")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVsetupFog(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals("func_82829_a")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVrenderCloudsCheck(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals("func_78476_b")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVrenderHand(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals("func_78471_a")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVrenderWorld(SMCRemap.getAdaptor(this.cv.visitMethod(access, name, desc, signature, exceptions)));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

