/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCNames;

public class SMCCTRenderGlobal
implements IClassTransformer {
    public byte[] transform(String arg0, String arg1, byte[] arg2) {
        SMCLog.info("transforming %s %s", arg0, arg1);
        ClassReader cr = new ClassReader(arg2);
        ClassWriter cw = new ClassWriter(cr, 3);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVdrawBlockDamageTexture
    extends MethodVisitor {
        public MVdrawBlockDamageTexture(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if (owner.equals("org/lwjgl/opengl/GL11")) {
                if (name.equals("glBlendFunc")) {
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginBlockDestroyProgress", "()V");
                    SMCLog.info("    %s", "beginBlockDestroyProgress");
                } else if (name.equals("glPopMatrix")) {
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endBlockDestroyProgress", "()V");
                    SMCLog.info("    %s", "endBlockDestroyProgress");
                }
            }
        }
    }

    private static class MVrenderSky
    extends MVendisTexFog {
        int state = 0;

        public MVrenderSky(MethodVisitor mv) {
            super(mv);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            String ownerM = SMCNames.remapper.mapType(owner);
            String nameM = SMCNames.remapper.mapMethodName(owner, name, desc);
            String descM = SMCNames.remapper.mapMethodDesc(desc);
            if (ownerM.equals("net/minecraft/client/multiplayer/WorldClient")) {
                if (nameM.equals("func_72867_j") && this.state == 0) {
                    this.state = 1;
                }
            } else if (owner.equals("org/lwjgl/opengl/GL11") && name.equals("glRotatef")) {
                if (this.state == 1) {
                    this.state = 2;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "preCelestialRotate", "()V");
                    SMCLog.info("    %s", "preCelestialRotate");
                } else if (this.state == 2) {
                    this.state = 3;
                    this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "postCelestialRotate", "()V");
                    SMCLog.info("    %s", "postCelestialRotate");
                }
            }
        }
    }

    private static class MVendisTexFog
    extends MethodVisitor {
        int lastInt = 0;

        public MVendisTexFog(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.mv.visitIntInsn(opcode, operand);
            this.lastInt = opcode == 17 && (operand == 3553 || operand == 2912) ? operand : 0;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            if (owner.equals("org/lwjgl/opengl/GL11")) {
                if (name.equals("glEnable")) {
                    if (this.lastInt == 3553) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "enableTexture2D", "()V");
                        SMCLog.info("    %s", "enableTexture2D");
                    } else if (this.lastInt == 2912) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "enableFog", "()V");
                        SMCLog.info("    %s", "enableFog");
                    }
                } else if (name.equals("glDisable")) {
                    if (this.lastInt == 3553) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "disableTexture2D", "()V");
                        SMCLog.info("    %s", "disableTexture2D");
                    } else if (this.lastInt == 2912) {
                        this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "disableFog", "()V");
                        SMCLog.info("    %s", "disableFog");
                    }
                }
            }
            this.lastInt = 0;
        }
    }

    private static class MVrenderEntities
    extends MethodVisitor {
        int state = 0;

        public MVrenderEntities(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof String) {
                String scst = (String)cst;
                if (scst.equals("entities")) {
                    this.state = 1;
                } else if (scst.equals("tileentities")) {
                    this.state = 3;
                }
            }
            this.mv.visitLdcInsn(cst);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String nameM;
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            if (this.state == 1) {
                this.state = 2;
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginEntities", "()V");
                SMCLog.info("    %s", "beginEntities");
            } else if (this.state == 3) {
                this.state = 4;
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endEntities", "()V");
                SMCLog.info("    %s", "endEntities");
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "beginTileEntities", "()V");
                SMCLog.info("    %s", "beginTileEntities");
            } else if (this.state == 4 && (nameM = SMCNames.remapper.mapMethodName(owner, name, desc)).equals("func_78483_a")) {
                this.state = 5;
                this.mv.visitMethodInsn(184, "shadersmodcore/client/Shaders", "endTileEntities", "()V");
                SMCLog.info("    %s", "endTileEntities");
            }
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String remappedName = SMCNames.remapper.mapMethodName(this.classname, name, desc);
            if (remappedName.equals("func_72713_a")) {
                SMCLog.info("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVrenderEntities(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (remappedName.equals("func_72719_a")) {
                SMCLog.info("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVendisTexFog(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (remappedName.equals("func_72714_a")) {
                SMCLog.info("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVrenderSky(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (remappedName.equals("func_72717_a") || remappedName.equals("drawBlockDamageTexture")) {
                SMCLog.info("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVdrawBlockDamageTexture(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (remappedName.equals("func_72731_b")) {
                SMCLog.info("  patching method %s.%s%s = %s", this.classname, name, desc, remappedName);
                return new MVendisTexFog(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

