/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.client;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import shadersmodcore.client.MultiTexID;
import shadersmodcore.client.Shaders;

public class ShadersTex {
    public static final int initialBufferSize = 0x400000;
    public static int buffersize = 0x400000;
    public static ByteBuffer byteBuffer = ByteBuffer.allocateDirect(0x400000).order(ByteOrder.LITTLE_ENDIAN);
    public static IntBuffer intBuffer = byteBuffer.asIntBuffer();
    public static int numTextureLevels = 5;
    public static int[] ainttemp = new int[0x100000];
    public static final int defBaseTexColor = 0;
    public static final int defNormTexColor = -8421377;
    public static final int defSpecTexColor = 0;
    public static MultiTexID updatingTex = null;
    public static MultiTexID boundTex = null;
    public static int updatingPage = 0;

    public static void reallocByteBuffer(int size) {
        byteBuffer = null;
        intBuffer = null;
        byteBuffer = ByteBuffer.allocateDirect(size).order(ByteOrder.LITTLE_ENDIAN);
        intBuffer = byteBuffer.asIntBuffer();
    }

    public static void reallocIntBuffer(int size) {
        ShadersTex.reallocByteBuffer(size * 4);
    }

    public static int[] createAIntImage(int size) {
        int[] aint = new int[size * 3];
        Arrays.fill(aint, 0, size, 0);
        Arrays.fill(aint, size, size * 2, -8421377);
        Arrays.fill(aint, size * 2, size * 3, 0);
        return aint;
    }

    public static int[] createAIntImage(int size, int color) {
        int[] aint = new int[size * 3];
        Arrays.fill(aint, 0, size, color);
        Arrays.fill(aint, size, size * 2, -8421377);
        Arrays.fill(aint, size * 2, size * 3, 0);
        return aint;
    }

    public static IntBuffer fillIntBuffer(int size, int value) {
        if (ainttemp.length < size) {
            ainttemp = new int[size];
        }
        Arrays.fill(ainttemp, 0, size, value);
        intBuffer.put(ainttemp, 0, size);
        return intBuffer;
    }

    public static MultiTexID getMultiTexID(bhx tex) {
        if (tex.multiTex == null) {
            tex.multiTex = MultiTexID.put(tex.b(), bim.a(), bim.a());
        }
        return tex.multiTex;
    }

    public static void bindTextures(int baseTex, int normTex, int specTex) {
        if (Shaders.isRenderingWorld && blx.activeTexUnit == 33984) {
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)normTex);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)specTex);
            GL13.glActiveTexture((int)33984);
        }
        GL11.glBindTexture((int)3553, (int)baseTex);
    }

    public static void bindNSTextures(int normTex, int specTex) {
        if (Shaders.isRenderingWorld && blx.activeTexUnit == 33984) {
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)normTex);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)specTex);
            GL13.glActiveTexture((int)33984);
        }
    }

    public static void bindTextures(MultiTexID multiTex) {
        boundTex = multiTex;
        ShadersTex.bindTextures(multiTex.base, multiTex.norm, multiTex.spec);
    }

    public static void bindAbstractTexture(bhx tex) {
        ShadersTex.bindTextures(tex.getMultiTexID());
        Shaders.atlasSizeX = 0;
        Shaders.atlasSizeY = 0;
    }

    public static void bindTextureMap(bih tex) {
        ShadersTex.bindTextures(tex.getMultiTexID());
        Shaders.atlasSizeX = tex.atlasWidth;
        Shaders.atlasSizeY = tex.atlasHeight;
    }

    public static void bindNSTextures(MultiTexID multiTex) {
        ShadersTex.bindNSTextures(multiTex.norm, multiTex.spec);
    }

    public static void bindTextures(int baseTex) {
        MultiTexID multiTex = MultiTexID.get(baseTex);
        ShadersTex.bindTextures(multiTex);
    }

    public static void allocTexStorage(int width, int height) {
        int level = 0;
        int wt = width;
        int ht = height;
        while (wt > 0 && ht > 0) {
            GL11.glTexImage2D((int)3553, (int)level, (int)6408, (int)wt, (int)ht, (int)0, (int)32993, (int)33639, (IntBuffer)null);
            wt /= 2;
            ht /= 2;
            ++level;
        }
        GL11.glTexParameteri((int)3553, (int)33085, (int)(level - 1));
    }

    public static void setupEmptyTexture(MultiTexID multiTex, int width, int height) {
        GL11.glBindTexture((int)3553, (int)multiTex.base);
        ShadersTex.allocTexStorage(width, height);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        ShadersTex.allocTexStorage(width, height);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glBindTexture((int)3553, (int)multiTex.spec);
        ShadersTex.allocTexStorage(width, height);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glBindTexture((int)3553, (int)multiTex.base);
    }

    public static void setupTextureMap(bih tex, bid stitcher) {
        int height;
        int width;
        MultiTexID multiTex = tex.getMultiTexID();
        tex.atlasWidth = width = stitcher.a();
        tex.atlasHeight = height = stitcher.b();
        List spriteList = stitcher.d();
        GL11.glBindTexture((int)3553, (int)multiTex.base);
        ShadersTex.allocTexStorage(width, height);
        GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilB]);
        GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilB]);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)33085, (int)4);
        GL11.glTexParameteri((int)3553, (int)33083, (int)4);
        for (bii sprite : spriteList) {
            ShadersTex.updateSubImage1(sprite.a(0), sprite.a(), sprite.b(), sprite.h(), sprite.i(), 0, 0);
        }
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        ShadersTex.allocTexStorage(width, height);
        GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilN]);
        GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilN]);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)33085, (int)4);
        GL11.glTexParameteri((int)3553, (int)33083, (int)4);
        for (bii sprite : spriteList) {
            ShadersTex.updateSubImage1(sprite.a(0), sprite.a(), sprite.b(), sprite.h(), sprite.i(), 1, -8421377);
        }
        GL11.glBindTexture((int)3553, (int)multiTex.spec);
        ShadersTex.allocTexStorage(width, height);
        GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilS]);
        GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilS]);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)33085, (int)4);
        GL11.glTexParameteri((int)3553, (int)33083, (int)4);
        for (bii sprite : spriteList) {
            ShadersTex.updateSubImage1(sprite.a(0), sprite.a(), sprite.b(), sprite.h(), sprite.i(), 2, 0);
        }
        GL11.glBindTexture((int)3553, (int)multiTex.base);
    }

    public static int blend4Alpha(int c0, int c1, int c2, int c3) {
        int dv;
        int a0 = c0 >>> 24 & 0xFF;
        int a1 = c1 >>> 24 & 0xFF;
        int a2 = c2 >>> 24 & 0xFF;
        int a3 = c3 >>> 24 & 0xFF;
        int as = a0 + a1 + a2 + a3;
        int an = (as + 2) / 4;
        if (as != 0) {
            dv = as;
        } else {
            dv = 4;
            a0 = 1;
            a1 = 1;
            a2 = 1;
            a3 = 1;
        }
        int frac = (dv + 1) / 2;
        int color = an << 24 | ((c0 >>> 16 & 0xFF) * a0 + (c1 >>> 16 & 0xFF) * a1 + (c2 >>> 16 & 0xFF) * a2 + (c3 >>> 16 & 0xFF) * a3 + frac) / dv << 16 | ((c0 >>> 8 & 0xFF) * a0 + (c1 >>> 8 & 0xFF) * a1 + (c2 >>> 8 & 0xFF) * a2 + (c3 >>> 8 & 0xFF) * a3 + frac) / dv << 8 | ((c0 >>> 0 & 0xFF) * a0 + (c1 >>> 0 & 0xFF) * a1 + (c2 >>> 0 & 0xFF) * a2 + (c3 >>> 0 & 0xFF) * a3 + frac) / dv << 0;
        return color;
    }

    public static int blend4Simple(int c0, int c1, int c2, int c3) {
        int color = ((c0 >>> 24 & 0xFF) + (c1 >>> 24 & 0xFF) + (c2 >>> 24 & 0xFF) + (c3 >>> 24 & 0xFF) + 2) / 4 << 24 | ((c0 >>> 16 & 0xFF) + (c1 >>> 16 & 0xFF) + (c2 >>> 16 & 0xFF) + (c3 >>> 16 & 0xFF) + 2) / 4 << 16 | ((c0 >>> 8 & 0xFF) + (c1 >>> 8 & 0xFF) + (c2 >>> 8 & 0xFF) + (c3 >>> 8 & 0xFF) + 2) / 4 << 8 | ((c0 >>> 0 & 0xFF) + (c1 >>> 0 & 0xFF) + (c2 >>> 0 & 0xFF) + (c3 >>> 0 & 0xFF) + 2) / 4 << 0;
        return color;
    }

    public static void genMipmapAlpha(int[] aint, int offset, int width, int height) {
        int o2;
        int h2;
        int w2;
        int minwh = Math.min(width, height);
        int w1 = w2 = width;
        int h1 = h2 = height;
        int o1 = o2 = offset;
        o2 = offset;
        w2 = width;
        h2 = height;
        o1 = 0;
        w1 = 0;
        h1 = 0;
        int level = 0;
        while (w2 > 1 && h2 > 1) {
            o1 = o2 + w2 * h2;
            w1 = w2 / 2;
            h1 = h2 / 2;
            for (int y = 0; y < h1; ++y) {
                int p1 = o1 + y * w1;
                int p2 = o2 + y * 2 * w2;
                for (int x2 = 0; x2 < w1; ++x2) {
                    aint[p1 + x2] = ShadersTex.blend4Alpha(aint[p2 + x2 * 2], aint[p2 + (x2 * 2 + 1)], aint[p2 + w2 + x2 * 2], aint[p2 + w2 + (x2 * 2 + 1)]);
                }
            }
            ++level;
            w2 = w1;
            h2 = h1;
            o2 = o1;
        }
        while (level > 0) {
            w2 = width >> --level;
            h2 = height >> level;
            int p2 = o2 = o1 - w2 * h2;
            for (int y = 0; y < h2; ++y) {
                for (int x3 = 0; x3 < w2; ++x3) {
                    if (aint[p2] == 0) {
                        aint[p2] = aint[o1 + y / 2 * w1 + x3 / 2] & 0xFFFFFF;
                    }
                    ++p2;
                }
            }
            o1 = o2;
            w1 = w2;
            h1 = h2;
        }
    }

    public static void genMipmapSimple(int[] aint, int offset, int width, int height) {
        int o2;
        int h2;
        int w2;
        int minwh = Math.min(width, height);
        int w1 = w2 = width;
        int h1 = h2 = height;
        int o1 = o2 = offset;
        o2 = offset;
        w2 = width;
        h2 = height;
        o1 = 0;
        w1 = 0;
        h1 = 0;
        int level = 0;
        while (w2 > 1 && h2 > 1) {
            o1 = o2 + w2 * h2;
            w1 = w2 / 2;
            h1 = h2 / 2;
            for (int y = 0; y < h1; ++y) {
                int p1 = o1 + y * w1;
                int p2 = o2 + y * 2 * w2;
                for (int x2 = 0; x2 < w1; ++x2) {
                    aint[p1 + x2] = ShadersTex.blend4Simple(aint[p2 + x2 * 2], aint[p2 + (x2 * 2 + 1)], aint[p2 + w2 + x2 * 2], aint[p2 + w2 + (x2 * 2 + 1)]);
                }
            }
            ++level;
            w2 = w1;
            h2 = h1;
            o2 = o1;
        }
        while (level > 0) {
            w2 = width >> --level;
            h2 = height >> level;
            int p2 = o2 = o1 - w2 * h2;
            for (int y = 0; y < h2; ++y) {
                for (int x3 = 0; x3 < w2; ++x3) {
                    if (aint[p2] == 0) {
                        aint[p2] = aint[o1 + y / 2 * w1 + x3 / 2] & 0xFFFFFF;
                    }
                    ++p2;
                }
            }
            o1 = o2;
            w1 = w2;
            h1 = h2;
        }
    }

    public static boolean isSemiTransparent(int[] aint, int width, int height) {
        int size = width * height;
        if (aint[0] >>> 24 == 255 && aint[size - 1] == 0) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            int alpha = aint[i] >>> 24;
            if (alpha == 0 || alpha == 255) continue;
            return true;
        }
        return false;
    }

    public static void updateSubImage1(int[] src, int width, int height, int posX, int posY, int page, int color) {
        int size = width * height;
        if (intBuffer.capacity() < size) {
            ShadersTex.reallocIntBuffer(size);
        }
        if (ainttemp.length < (size * 4 + 2) / 3) {
            ainttemp = new int[(size * 4 + 2) / 3];
        }
        int[] aint = ainttemp;
        if (src.length >= size * (page + 1)) {
            System.arraycopy(src, size * page, aint, 0, size);
        } else {
            Arrays.fill(aint, color);
        }
        ShadersTex.genMipmapAlpha(aint, 0, width, height);
        int level = 0;
        int offset = 0;
        int lw = width;
        int lh = height;
        int px = posX;
        int py = posY;
        while (lw > 0 && lh > 0) {
            int lsize = lw * lh;
            intBuffer.clear();
            intBuffer.put(aint, offset, lsize).position(0).limit(lsize);
            GL11.glTexSubImage2D((int)3553, (int)level, (int)px, (int)py, (int)lw, (int)lh, (int)32993, (int)33639, (IntBuffer)intBuffer);
            offset += lsize;
            lw /= 2;
            lh /= 2;
            px /= 2;
            py /= 2;
            ++level;
        }
        intBuffer.clear();
    }

    public static void updateSubTex1(int[] src, int width, int height, int posX, int posY) {
        int level = 0;
        int cw = width;
        int ch = height;
        int cx = posX;
        int cy = posY;
        while (cw > 0 && ch > 0) {
            GL11.glCopyTexSubImage2D((int)3553, (int)level, (int)cx, (int)cy, (int)0, (int)0, (int)cw, (int)ch);
            ++level;
            cw /= 2;
            ch /= 2;
            cx /= 2;
            cy /= 2;
        }
    }

    public static void setupTextureMipmap(bih tex) {
    }

    public static void updateImage(MultiTexID multiTex, int[] src, int width, int height) {
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        ShadersTex.updateSubImage1(src, width, height, 0, 0, 1, -8421377);
        GL11.glBindTexture((int)3553, (int)multiTex.spec);
        ShadersTex.updateSubImage1(src, width, height, 0, 0, 2, 0);
        GL11.glBindTexture((int)3553, (int)multiTex.base);
        ShadersTex.updateSubImage1(src, width, height, 0, 0, 0, 0);
    }

    public static void updateSubImageMulti(int[] src, int width, int height, int posX, int posY, boolean linear, boolean clamp) {
        if (updatingTex != null) {
            GL11.glBindTexture((int)3553, (int)ShadersTex.updatingTex.norm);
            ShadersTex.updateSubImage1(src, width, height, posX, posY, 1, -8421377);
            GL11.glBindTexture((int)3553, (int)ShadersTex.updatingTex.spec);
            ShadersTex.updateSubImage1(src, width, height, posX, posY, 2, 0);
            GL11.glBindTexture((int)3553, (int)ShadersTex.updatingTex.base);
        }
        ShadersTex.updateSubImage1(src, width, height, posX, posY, 0, 0);
    }

    public static void updateAnimationTextureMap(bih tex, List tasList) {
        MultiTexID multiTex = tex.getMultiTexID();
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        for (bii tas : tasList) {
            tas.j();
        }
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        for (bii tas : tasList) {
            tas.j();
        }
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        for (bii tas : tasList) {
            tas.j();
        }
    }

    public static void setupTexture(MultiTexID multiTex, int[] src, int width, int height, boolean linear, boolean clamp) {
        int mmfilter = linear ? 9729 : 9728;
        int wraptype = clamp ? 10496 : 10497;
        int size = width * height;
        if (intBuffer.capacity() < size) {
            ShadersTex.reallocIntBuffer(size);
        }
        intBuffer.clear();
        intBuffer.put(src, 0, size).position(0).limit(size);
        GL11.glBindTexture((int)3553, (int)multiTex.base);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)intBuffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10242, (int)wraptype);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wraptype);
        intBuffer.put(src, size, size).position(0).limit(size);
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)intBuffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10242, (int)wraptype);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wraptype);
        intBuffer.put(src, size * 2, size).position(0).limit(size);
        GL11.glBindTexture((int)3553, (int)multiTex.spec);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)intBuffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10242, (int)wraptype);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wraptype);
        GL11.glBindTexture((int)3553, (int)multiTex.base);
    }

    public static void updateSubImage(MultiTexID multiTex, int[] src, int width, int height, int posX, int posY, boolean linear, boolean clamp) {
        int size = width * height;
        if (intBuffer.capacity() < size) {
            ShadersTex.reallocIntBuffer(size);
        }
        intBuffer.clear();
        intBuffer.put(src, 0, size);
        intBuffer.position(0).limit(size);
        GL11.glBindTexture((int)3553, (int)multiTex.base);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuffer);
        if (src.length == size * 3) {
            intBuffer.clear();
            intBuffer.put(src, size, size).position(0);
            intBuffer.position(0).limit(size);
        }
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuffer);
        if (src.length == size * 3) {
            intBuffer.clear();
            intBuffer.put(src, size * 2, size);
            intBuffer.position(0).limit(size);
        }
        GL11.glBindTexture((int)3553, (int)multiTex.spec);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuffer);
        GL13.glActiveTexture((int)33984);
    }

    public static bjl getNSMapLocation(bjl location, String mapName) {
        String basename = location.a();
        String[] basenameParts = basename.split(".png");
        String basenameNoFileType = basenameParts[0];
        return new bjl(location.b(), basenameNoFileType + "_" + mapName + ".png");
    }

    public static void loadNSMap(bjm manager, bjl location, int width, int height, int[] aint) {
        ShadersTex.loadNSMap1(manager, ShadersTex.getNSMapLocation(location, "n"), width, height, aint, width * height, -8421377);
        ShadersTex.loadNSMap1(manager, ShadersTex.getNSMapLocation(location, "s"), width, height, aint, width * height * 2, 0);
    }

    public static void loadNSMap1(bjm manager, bjl location, int width, int height, int[] aint, int offset, int defaultColor) {
        boolean good = false;
        try {
            bjk res = manager.a(location);
            BufferedImage bufferedimage = ImageIO.read(res.b());
            if (bufferedimage.getWidth() == width && bufferedimage.getHeight() == height) {
                bufferedimage.getRGB(0, 0, width, height, aint, offset, width);
                good = true;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (!good) {
            Arrays.fill(aint, offset, offset + width * height, defaultColor);
        }
    }

    public static void loadSimpleTexture(int textureID, BufferedImage bufferedimage, boolean linear, boolean clamp, bjm resourceManager, bjl location, MultiTexID multiTex) {
        int height;
        int width = bufferedimage.getWidth();
        int size = width * (height = bufferedimage.getHeight());
        if (ainttemp.length < size * 3) {
            ainttemp = ShadersTex.createAIntImage(size);
        }
        bufferedimage.getRGB(0, 0, width, height, ainttemp, 0, width);
        ShadersTex.loadNSMap(resourceManager, location, width, height, ainttemp);
        ShadersTex.setupTexture(multiTex, ainttemp, width, height, linear, clamp);
    }

    public static void mergeImage(int[] aint, int dstoff, int srcoff, int size) {
    }

    public static int blendColor(int color1, int color2, int factor1) {
        int factor2 = 255 - factor1;
        return ((color1 >>> 24 & 0xFF) * factor1 + (color2 >>> 24 & 0xFF) * factor2) / 255 << 24 | ((color1 >>> 16 & 0xFF) * factor1 + (color2 >>> 16 & 0xFF) * factor2) / 255 << 16 | ((color1 >>> 8 & 0xFF) * factor1 + (color2 >>> 8 & 0xFF) * factor2) / 255 << 8 | ((color1 >>> 0 & 0xFF) * factor1 + (color2 >>> 0 & 0xFF) * factor2) / 255 << 0;
    }

    public static void loadLayeredTexture(bib tex, bjm manager, List list) {
        int width = 0;
        int height = 0;
        int size = 0;
        int[] image = null;
        for (String s : list) {
            if (s == null) continue;
            try {
                bjl location = new bjl(s);
                InputStream inputstream = manager.a(location).b();
                BufferedImage bufimg = ImageIO.read(inputstream);
                if (size == 0) {
                    width = bufimg.getWidth();
                    size = width * (height = bufimg.getHeight());
                    if (ainttemp.length < size * 3) {
                        ainttemp = new int[size * 3];
                    }
                    image = ShadersTex.createAIntImage(size, 0);
                }
                bufimg.getRGB(0, 0, width, height, ainttemp, 0, width);
                ShadersTex.loadNSMap(manager, location, width, height, ainttemp);
                for (int i = 0; i < size; ++i) {
                    int alpha = ainttemp[i] >>> 24 & 0xFF;
                    image[size * 0 + i] = ShadersTex.blendColor(ainttemp[size * 0 + i], image[size * 0 + i], alpha);
                    image[size * 1 + i] = ShadersTex.blendColor(ainttemp[size * 1 + i], image[size * 1 + i], alpha);
                    image[size * 2 + i] = ShadersTex.blendColor(ainttemp[size * 2 + i], image[size * 2 + i], alpha);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        ShadersTex.setupTexture(tex.getMultiTexID(), image, width, height, false, false);
    }

    static void updateTextureMinMagFilter() {
        bij texman = ats.w().J();
        bil texObj = texman.b(bih.b);
        if (texObj != null) {
            MultiTexID multiTex = texObj.getMultiTexID();
            GL11.glBindTexture((int)3553, (int)multiTex.base);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilB]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilB]);
            GL11.glBindTexture((int)3553, (int)multiTex.norm);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilN]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilN]);
            GL11.glBindTexture((int)3553, (int)multiTex.spec);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilS]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilS]);
            GL11.glBindTexture((int)3553, (int)0);
        }
    }
}

