/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common.networking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.gliby.voicechat.common.VoiceChatServer;
import net.gliby.voicechat.common.networking.DataStream;
import net.gliby.voicechat.common.networking.ServerDatalet;
import net.gliby.voicechat.common.networking.ThreadDataQueue;
import net.gliby.voicechat.common.networking.ThreadKillDataStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class DataManager {
    public ConcurrentLinkedQueue<ServerDatalet> dataQueue;
    public ConcurrentHashMap<Integer, DataStream> streaming;
    private HashMap<Integer, List<Integer>> receivedEntityData;
    Thread threadKill;
    Thread treadQueue;
    VoiceChatServer voiceChat;
    public List<UUID> mutedPlayers;

    public DataManager(VoiceChatServer voiceChat) {
        this.voiceChat = voiceChat;
    }

    public void init() {
        this.mutedPlayers = new ArrayList<UUID>();
        this.dataQueue = new ConcurrentLinkedQueue();
        this.streaming = new ConcurrentHashMap();
        this.receivedEntityData = new HashMap();
        this.treadQueue = new Thread((Runnable)new ThreadDataQueue(this), "Stream Queue");
        this.treadQueue.start();
        this.threadKill = new Thread((Runnable)new ThreadKillDataStream(this), "Stream Kill");
        this.threadKill.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueue(EntityPlayerMP player, byte[] decoded_data, int id, boolean end) {
        if (this.mutedPlayers.contains(player.func_110124_au())) {
            return;
        }
        this.dataQueue.offer(new ServerDatalet(player, id, decoded_data, end));
        Thread thread = this.treadQueue;
        synchronized (thread) {
            this.treadQueue.notify();
        }
    }

    public boolean newDatalet(ServerDatalet let) {
        return this.streaming.get(let.id) == null;
    }

    public void createStream(ServerDatalet data) {
        this.addStreamSafe(new DataStream(data.player, data.id, this.generateSource(data)));
        this.giveEntity(data);
        this.giveStream(data);
    }

    private void giveEntity(ServerDatalet data) {
        EntityPlayerMP[] players = this.voiceChat.getServerNetwork().getPlayers();
        EntityPlayerMP sender = data.player;
        for (int i = 0; i < players.length; ++i) {
            EntityPlayerMP player = players[i];
            if (sender == player) continue;
            this.voiceChat.getVoiceServer().sendEntityData(player, sender.func_145782_y(), sender.getDisplayName(), sender.field_70165_t, sender.field_70163_u, sender.field_70161_v, sender.field_70159_w, sender.field_70181_x, sender.field_70179_y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStreamSafe(DataStream stream) {
        if (this.streaming.get(stream.id) == null) {
            this.streaming.put(stream.id, stream);
            Thread thread = this.threadKill;
            synchronized (thread) {
                this.threadKill.notify();
            }
        }
    }

    public void giveStream(ServerDatalet let) {
        EntityPlayerMP sender = let.player;
        if (sender != null) {
            this.sendVoiceToWorldWithinDistance(let, this.voiceChat.getServerSettings().getSoundDistance());
        }
        if (let.end) {
            this.killStream(let.id);
        }
    }

    public void sendVoiceToWorldWithinDistance(ServerDatalet let, int distance) {
        EntityPlayerMP curPlayer = let.player;
        List players = curPlayer.field_70170_p.field_73010_i;
        int tickRate = MinecraftServer.func_71276_C().func_71259_af();
        if (let.end) {
            for (int i = 0; i < players.size(); ++i) {
                double d6;
                double d5;
                double d4;
                EntityPlayerMP player = (EntityPlayerMP)players.get(i);
                if (player == curPlayer || !((d4 = curPlayer.field_70165_t - player.field_70165_t) * d4 + (d5 = curPlayer.field_70163_u - player.field_70163_u) * d5 + (d6 = curPlayer.field_70161_v - player.field_70161_v) * d6 < (double)(distance * distance))) continue;
                this.voiceChat.getVoiceServer().sendVoiceEnd(player, let.id);
            }
        } else {
            for (int i = 0; i < players.size(); ++i) {
                double d6;
                double d5;
                double d4;
                EntityPlayerMP player = (EntityPlayerMP)players.get(i);
                if (player == curPlayer || !((d4 = curPlayer.field_70165_t - player.field_70165_t) * d4 + (d5 = curPlayer.field_70163_u - player.field_70163_u) * d5 + (d6 = curPlayer.field_70161_v - player.field_70161_v) * d6 < (double)(distance * distance))) continue;
                if (distance > 63) {
                    if (!this.hasEntityData(let.id, player.func_145782_y())) {
                        this.voiceChat.getVoiceServer().sendEntityData(player, let.id, curPlayer.getDisplayName(), curPlayer.field_70165_t, curPlayer.field_70163_u, curPlayer.field_70161_v, curPlayer.field_70159_w, curPlayer.field_70181_x, curPlayer.field_70179_y);
                        this.addReceivedEntityData(let.id, player.func_145782_y());
                    }
                    if (tickRate % 7 == 0) {
                        this.voiceChat.getVoiceServer().sendEntityPosition(player, let.id, curPlayer.field_70165_t, curPlayer.field_70163_u, curPlayer.field_70161_v, curPlayer.field_70159_w, curPlayer.field_70181_x, curPlayer.field_70179_y);
                    }
                }
                this.voiceChat.getVoiceServer().sendVoiceData(player, let.id, 1, let.data);
            }
        }
    }

    private String generateSource(ServerDatalet let) {
        return Integer.toString(let.id);
    }

    public void killStream(int id) {
        this.streaming.remove(id);
    }

    private void addReceivedEntityData(int id, int entityId) {
        List<Integer> list = this.receivedEntityData.get(id);
        if (list != null) {
            list.add(entityId);
        } else {
            list = new ArrayList<Integer>();
            list.add(entityId);
            this.receivedEntityData.put(id, list);
        }
    }

    public boolean hasEntityData(int entityID, int hasEntityID) {
        if (this.receivedEntityData.containsKey(entityID)) {
            return this.receivedEntityData.get(entityID).contains(hasEntityID);
        }
        return false;
    }

    public void playerDisconnect(EntityPlayer player) {
        List<Integer> list = this.receivedEntityData.get(player.func_145782_y());
        if (list != null) {
            this.receivedEntityData.remove(player.func_145782_y());
        }
        for (Map.Entry<Integer, List<Integer>> pairs : this.receivedEntityData.entrySet()) {
            List<Integer> idList = this.receivedEntityData.get(pairs.getKey());
            for (int i = 0; i < idList.size(); ++i) {
                if (idList.get(i).intValue() != player.func_145782_y()) continue;
                idList.remove(i);
            }
        }
    }
}

