/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.common.ServerSettings;

public class ServerConfiguration {
    private static final String MAX_SOUND_DISTANCE = "sound_dist";
    private static final String UDP_PORT = "udp";
    private static final String ADVANCED_NETWORKING = "adv_net";
    private Properties properties = new Properties();
    private final File file;
    private ServerSettings settings;

    public ServerConfiguration(ServerSettings settings, File file) {
        this.settings = settings;
        this.file = file;
    }

    private boolean load() {
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.file);
            this.properties.load(is);
            this.settings.setSoundDistance(Integer.parseInt("" + this.properties.get(MAX_SOUND_DISTANCE)));
            this.settings.setUDP(Integer.parseInt("" + this.properties.get(UDP_PORT)));
            this.settings.setAdvancedNetworking(Boolean.parseBoolean("" + this.properties.get(ADVANCED_NETWORKING)));
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean save() {
        try {
            this.properties.setProperty(MAX_SOUND_DISTANCE, Integer.toString(this.settings.getSoundDistance()));
            this.properties.setProperty(UDP_PORT, Integer.toString(this.settings.getUDPort()));
            this.properties.setProperty(ADVANCED_NETWORKING, Boolean.toString(this.settings.isAdvancedNetworkAllowed()));
            FileOutputStream out = new FileOutputStream(this.file);
            this.properties.store(out, "Properties for Gliby's Voice Chat Mod Server for Forge, VERSION: " + VoiceChat.getServerInstance().getVersion());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void init() {
        if (!this.load()) {
            VoiceChat.getLogger().info("No Configuration file found on server, will create one with default settings.");
            if (this.save()) {
                VoiceChat.getLogger().info("Created Configuration file with default settings on server.");
            }
        }
    }
}

