/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.sound;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.debug.Statistics;
import net.gliby.voicechat.client.sound.SoundManager;
import net.minecraft.client.Minecraft;
import org.xiph.speex.SpeexDecoder;

public class SoundPreProcessor {
    VoiceChatClient voiceChat;
    Statistics stats;
    SpeexDecoder decoder;

    public SoundPreProcessor(VoiceChatClient voiceChat, Minecraft mc) {
        this.voiceChat = voiceChat;
        this.stats = voiceChat.getStatistics();
    }

    public boolean process(int id, byte[] encodedSamples, int chunkSize, int global) {
        if (chunkSize == -1) {
            SoundPreProcessor soundPreProcessor = this;
            soundPreProcessor.voiceChat.getLogger().fatal("Sound Pre-Processor has been given incorrect data from network. " + (Object)((Object)this.voiceChat.getSettings().getVoiceServerType()));
            return false;
        }
        if (this.decoder == null) {
            this.decoder = new SpeexDecoder();
            this.decoder.init(0, (int)SoundManager.getUniversalAudioFormat().getSampleRate(), SoundManager.getUniversalAudioFormat().getChannels(), this.voiceChat.getSettings().isPerceptualEnchantmentAllowed());
        }
        byte[] decodedData = null;
        if (encodedSamples.length <= chunkSize) {
            try {
                this.decoder.processData(encodedSamples, 0, encodedSamples.length);
            }
            catch (StreamCorruptedException e) {
                e.printStackTrace();
                return false;
            }
            decodedData = new byte[this.decoder.getProcessedDataByteSize()];
            this.decoder.getProcessedData(decodedData, 0);
        } else {
            List<byte[]> samplesList = SoundPreProcessor.divideArray(encodedSamples, chunkSize);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int i = 0; i < samplesList.size(); ++i) {
                byte[] sample = samplesList.get(i);
                SpeexDecoder tempDecoder = new SpeexDecoder();
                tempDecoder.init(0, (int)SoundManager.getUniversalAudioFormat().getSampleRate(), SoundManager.getUniversalAudioFormat().getChannels(), this.voiceChat.getSettings().isPerceptualEnchantmentAllowed());
                try {
                    this.decoder.processData(sample, 0, sample.length);
                }
                catch (StreamCorruptedException e) {
                    e.printStackTrace();
                    return false;
                }
                byte[] sampleBuffer = new byte[this.decoder.getProcessedDataByteSize()];
                this.decoder.getProcessedData(sampleBuffer, 0);
                try {
                    baos.write(sampleBuffer);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            decodedData = baos.toByteArray();
            try {
                baos.flush();
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (decodedData != null) {
            SoundPreProcessor soundPreProcessor = this;
            soundPreProcessor.voiceChat.getSoundManager().addQueue(decodedData, global, id);
            if (this.stats != null) {
                this.stats.addEncodedSamples(encodedSamples.length);
                this.stats.addDecodedSamples(decodedData.length);
            }
            return true;
        }
        return false;
    }

    public static List<byte[]> divideArray(byte[] source, int chunksize) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int start = 0; start < source.length; start += chunksize) {
            int end = Math.min(source.length, start + chunksize);
            result.add(Arrays.copyOfRange(source, start, end));
        }
        return result;
    }
}

