/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.networking;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.networking.VoiceClient;
import net.gliby.voicechat.common.EntityVector;
import net.gliby.voicechat.common.networking.PacketDispatcher;
import net.gliby.voicechat.common.networking.packets.PacketServerVoiceEnd;
import net.gliby.voicechat.common.networking.packets.PacketServerVoiceSample;
import net.gliby.voicechat.common.networking.voiceservers.EnumVoiceNetworkType;

public class MinecraftVoiceClient
extends VoiceClient {
    public MinecraftVoiceClient(EnumVoiceNetworkType enumVoiceServer) {
        super(enumVoiceServer);
    }

    @Override
    public void start() {
    }

    @Override
    public void handleEnd(int id) {
        VoiceChat.getSynchronizedProxyInstance();
        VoiceChatClient.getSoundManager().alertEnd(id);
    }

    @Override
    public void handlePacket(int entityID, byte[] data, int chunkSize, int global) {
        VoiceChat.getSynchronizedProxyInstance();
        VoiceChatClient.getSoundManager().getSoundPreProcessor().process(entityID, data, chunkSize, global);
    }

    @Override
    public void sendVoiceData(byte[] samples, boolean end) {
        if (end) {
            PacketDispatcher.sendPacketToServer(new PacketServerVoiceEnd(new byte[0]));
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        if (samples != null) {
            try {
                if (!end) {
                    outputStream.writeInt(samples.length);
                    for (int i = 0; i < samples.length; ++i) {
                        outputStream.writeByte(samples[i]);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        PacketDispatcher.sendPacketToServer(new PacketServerVoiceSample(bos.toByteArray()));
    }

    @Override
    public void stop() {
    }

    @Override
    public void handleEntityData(int entityID, String name, double x, double y, double z, double motX, double motY, double motZ) {
        EntityVector entityVector = new EntityVector(entityID, name, x, y, z, motX, motY, motZ);
        VoiceChat.getSynchronizedProxyInstance();
        VoiceChatClient.getSoundManager().entityData.put(entityID, entityVector);
    }

    @Override
    public void handleEntityPosition(int entityID, double x, double y, double z, double motX, double motY, double motZ) {
        VoiceChat.getSynchronizedProxyInstance();
        EntityVector entityVector = VoiceChatClient.getSoundManager().entityData.get(entityID);
        entityVector.setPosition(x, y, z);
        entityVector.setVelocity(motX, motY, motZ);
    }
}

