/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.debug.Statistics;
import net.gliby.voicechat.client.gui.UIPosition;
import net.gliby.voicechat.client.gui.ValueFormat;
import net.gliby.voicechat.client.gui.options.GuiOptionsWizard;
import net.gliby.voicechat.client.sound.PlayableStream;
import net.gliby.voicechat.client.textures.IndependentTexture;
import net.gliby.voicechat.common.MathUtility;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class GuiInGameHandler
extends Gui {
    private long lastFrame;
    private long lastFPS;
    private float fade = 0.0f;
    Minecraft mc;
    VoiceChatClient voiceChat;
    ScaledResolution res;
    Vector2f position;

    public GuiInGameHandler(VoiceChatClient voiceChat) {
        this.voiceChat = voiceChat;
        this.mc = Minecraft.func_71410_x();
    }

    @SubscribeEvent
    public void renderInGameGui(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            if (this.res == null) {
                this.getDelta();
                this.lastFPS = this.getTime();
                if (this.voiceChat.getSettings().isSetupNeeded()) {
                    this.mc.func_147108_a((GuiScreen)new GuiOptionsWizard(this.voiceChat, null));
                }
            }
            this.res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
            int delta = this.getDelta();
            this.updateFPS();
            int width = this.res.func_78326_a();
            int height = this.res.func_78328_b();
            UIPosition positionUI = this.voiceChat.getSettings().getUIPositionSpeak();
            this.position = this.getPosition(width, height, positionUI);
            this.fade = !VoiceChat.getProxyInstance().isRecorderActive() ? (this.fade > 0.0f ? (this.fade -= 0.01f * (float)delta) : 0.0f) : (this.fade < 1.0f && VoiceChat.getProxyInstance().isRecorderActive() ? (this.fade += 0.01f * (float)delta) : 1.0f);
            if (this.fade != 0.0f && positionUI.scale != 0.0f) {
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.fade * this.voiceChat.getSettings().getUIOpacity()));
                IndependentTexture.TEXTURES.bindTexture(this.mc);
                GL11.glTranslatef((float)(this.position.x + (float)positionUI.info.offsetX), (float)(this.position.y + (float)positionUI.info.offsetY), (float)0.0f);
                GL11.glScalef((float)positionUI.scale, (float)positionUI.scale, (float)1.0f);
                this.func_73729_b(0, 0, 0, 0, 54, 46);
                switch ((int)((float)(Minecraft.func_71386_F() % 1000L) / 350.0f)) {
                    case 0: {
                        this.func_73729_b(12, -3, 0, 47, 22, 49);
                        break;
                    }
                    case 1: {
                        this.func_73729_b(31, -3, 23, 47, 14, 49);
                        break;
                    }
                    case 2: {
                        this.func_73729_b(40, -3, 38, 47, 16, 49);
                    }
                }
                this.mc.func_110434_K().func_110577_a(this.mc.field_71439_g.func_110306_p());
                GL11.glScalef((float)0.6f, (float)0.3f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)47.0f, (float)0.0f);
                this.func_73729_b(0, 0, 32, 64, 32, 64);
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
            float scale = 0.0f;
            if (!this.voiceChat.activeStreams.isEmpty()) {
                positionUI = this.voiceChat.getSettings().getUIPositionPlate();
                this.position = this.getPosition(width, height, positionUI);
                for (int i = 0; i < this.voiceChat.activeStreams.size(); ++i) {
                    PlayableStream stream = this.voiceChat.activeStreams.get(i);
                    if (stream == null) continue;
                    GL11.glPushMatrix();
                    scale = 0.75f * positionUI.scale;
                    GL11.glTranslatef((float)(this.position.x + (float)positionUI.info.offsetX), (float)(this.position.y + (float)positionUI.info.offsetY + (float)(i * 23) * scale), (float)0.0f);
                    GL11.glScalef((float)scale, (float)scale, (float)0.0f);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.voiceChat.getSettings().getUIOpacity());
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
                    IndependentTexture.TEXTURES.bindTexture(this.mc);
                    this.func_73729_b(0, 0, 56, stream.special * 22, 109, 21);
                    String s = stream.getEntityName();
                    GL11.glPushMatrix();
                    int length = this.mc.field_71466_p.func_78256_a(s);
                    scale = MathUtility.clamp(50.5f / (float)length, 0.0f, 1.25f);
                    GL11.glTranslatef((float)(25.0f + scale / 2.0f), (float)(11.0f - (float)(this.mc.field_71466_p.field_78288_b - 1) * scale / 2.0f), (float)0.0f);
                    GL11.glScalef((float)scale, (float)scale, (float)0.0f);
                    this.func_73731_b(this.mc.field_71466_p, s, 0, 0, -1);
                    GL11.glPopMatrix();
                    if (stream.getEntityName() != null) {
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)3.0f, (float)3.0f, (float)0.0f);
                        GL11.glScalef((float)0.48f, (float)0.24f, (float)0.0f);
                        if (stream.isEntityPlayer()) {
                            IndependentTexture.bindPlayer(this.mc, (Entity)stream.entity);
                        } else {
                            IndependentTexture.bindDefaultPlayer(this.mc);
                        }
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.voiceChat.getSettings().getUIOpacity());
                        this.func_73729_b(0, 0, 32, 64, 32, 64);
                        this.func_73729_b(0, 0, 160, 64, 32, 64);
                        GL11.glPopMatrix();
                    }
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    private Vector2f getPosition(int width, int height, UIPosition uiPositionSpeak) {
        return uiPositionSpeak.type == 0 ? new Vector2f(uiPositionSpeak.x * (float)width, uiPositionSpeak.y * (float)height) : new Vector2f(uiPositionSpeak.x, uiPositionSpeak.y);
    }

    @SubscribeEvent
    public void render(RenderGameOverlayEvent.Text text) {
        if (VoiceChat.getProxyInstance().getSettings().getDebugMode() && Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            VoiceChat.getProxyInstance();
            Statistics stats = VoiceChatClient.getStatistics();
            if (stats != null) {
                int settings = 1 | ValueFormat.PRECISION(2) | 0xC0;
                String encodedAvg = ValueFormat.format(stats.getEncodedAverageDataReceived(), settings);
                String decodedAvg = ValueFormat.format(stats.getDecodedAverageDataReceived(), settings);
                String encodedData = ValueFormat.format(stats.getEncodedDataReceived(), settings);
                String decodedData = ValueFormat.format(stats.getDecodedDataReceived(), settings);
                text.right.add("Voice Chat Debug Info");
                text.right.add("VC Data [ENC AVG]: " + encodedAvg + "");
                text.right.add("VC Data [DEC AVG]: " + decodedAvg + "");
                text.right.add("VC Data [ENC REC]: " + encodedData + "");
                text.right.add("VC Data [DEC REC]: " + decodedData + "");
            }
        }
    }

    public int getDelta() {
        long time = this.getTime();
        int delta = (int)(time - this.lastFrame);
        this.lastFrame = time;
        return delta;
    }

    public long getTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public void updateFPS() {
        if (this.getTime() - this.lastFPS > 1000L) {
            this.lastFPS += 1000L;
        }
    }
}

