/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common.networking.voiceservers;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import net.gliby.voicechat.common.VoiceChatServer;
import net.gliby.voicechat.common.networking.PacketDispatcher;
import net.gliby.voicechat.common.networking.packets.PacketClientChunkVoiceSample;
import net.gliby.voicechat.common.networking.packets.PacketClientEntityData;
import net.gliby.voicechat.common.networking.packets.PacketClientEntityPosition;
import net.gliby.voicechat.common.networking.packets.PacketClientVoiceEnd;
import net.gliby.voicechat.common.networking.packets.PacketClientVoiceSample;
import net.gliby.voicechat.common.networking.voiceservers.EnumVoiceNetworkType;
import net.gliby.voicechat.common.networking.voiceservers.VoiceServer;
import net.minecraft.entity.player.EntityPlayerMP;

public class MinecraftVoiceServer
extends VoiceServer {
    private VoiceChatServer voiceChat;

    public MinecraftVoiceServer(VoiceChatServer voiceChat, EnumVoiceNetworkType enumVoiceServer) {
        super(enumVoiceServer);
        this.voiceChat = voiceChat;
    }

    @Override
    public boolean start() {
        return false;
    }

    @Override
    public void handleVoiceData(EntityPlayerMP player, byte[] data, int id, boolean end) {
        this.voiceChat.getServerNetwork().getDataManager().addQueue(player, data, id, end);
    }

    @Override
    public void sendVoiceData(EntityPlayerMP player, int entityID, int global, byte[] samples) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        if (samples != null) {
            try {
                outputStream.writeInt(samples.length);
                for (int i = 0; i < samples.length; ++i) {
                    outputStream.writeByte(samples[i]);
                }
                outputStream.writeInt(entityID);
                outputStream.writeInt(global);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            PacketDispatcher.sendPacketToPlayer(new PacketClientVoiceSample(bos.toByteArray()), player);
        }
    }

    @Override
    public void sendChunkVoiceData(EntityPlayerMP player, int entityID, int global, byte[] samples, int chunkSize) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        if (samples != null) {
            try {
                outputStream.writeInt(samples.length);
                for (int i = 0; i < samples.length; ++i) {
                    outputStream.writeByte(samples[i]);
                }
                outputStream.writeInt(chunkSize);
                outputStream.writeInt(entityID);
                outputStream.writeInt(global);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            PacketDispatcher.sendPacketToPlayer(new PacketClientChunkVoiceSample(bos.toByteArray()), player);
        }
    }

    @Override
    public void sendVoiceEnd(EntityPlayerMP player, int id) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToPlayer(new PacketClientVoiceEnd(bos.toByteArray()), player);
    }

    @Override
    public void sendEntityData(EntityPlayerMP player, int entityID, String name, double x, double y, double z, double motX, double motY, double motZ) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(entityID);
            outputStream.writeUTF(name);
            outputStream.writeDouble(x);
            outputStream.writeDouble(y);
            outputStream.writeDouble(z);
            outputStream.writeDouble(motX);
            outputStream.writeDouble(motY);
            outputStream.writeDouble(motZ);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToPlayer(new PacketClientEntityData(bos.toByteArray()), player);
    }

    @Override
    public void sendEntityPosition(EntityPlayerMP player, int entityID, double x, double y, double z, double motX, double motY, double motZ) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(entityID);
            outputStream.writeDouble(x);
            outputStream.writeDouble(y);
            outputStream.writeDouble(z);
            outputStream.writeDouble(motX);
            outputStream.writeDouble(motY);
            outputStream.writeDouble(motZ);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToPlayer(new PacketClientEntityPosition(bos.toByteArray()), player);
    }
}

