/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import java.io.File;
import java.lang.reflect.Field;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.common.ServerSettings;
import net.gliby.voicechat.common.commands.CommandVoiceMute;
import net.gliby.voicechat.common.networking.CommonPlayerTracker;
import net.gliby.voicechat.common.networking.ServerNetwork;
import net.gliby.voicechat.common.networking.voiceservers.ConnectionHandler;
import net.gliby.voicechat.common.networking.voiceservers.EnumVoiceNetworkType;
import net.gliby.voicechat.common.networking.voiceservers.MinecraftVoiceServer;
import net.gliby.voicechat.common.networking.voiceservers.VoiceServer;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VoiceChatServer {
    private static final String VERSION = "0.4.0";
    private static final String MC_VERSION = "1.7.10";
    public static final int VOICESERVER_UDP = 5447;
    private VoiceServer voiceServer;
    private Thread voiceServerThread;
    private ServerNetwork serverNetwork;
    private ServerSettings settings;
    private File configurationDirectory;
    protected static final Logger LOGGER = LogManager.getLogger((String)"Gliby's Voice Chat Mod");

    public void initServer(FMLServerStartingEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new CommonPlayerTracker(this));
        FMLCommonHandler.instance().bus().register((Object)new ConnectionHandler(this));
        this.voiceServerThread = this.startVoiceServer();
        VoiceChatServer.getLogger().info("Gliby's Voice Chat Mod for Forge Server has started.");
        this.settings = new ServerSettings(this);
        if (MinecraftServer.func_71276_C().func_71262_S()) {
            try {
                Field fileField = MinecraftServer.class.getDeclaredFields()[4];
                fileField.setAccessible(true);
                File file = (File)fileField.get(MinecraftServer.func_71276_C());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configurationDirectory = new File(MinecraftServer.func_71276_C().func_71270_I(), "gliby_vc");
            if (!this.configurationDirectory.exists()) {
                this.configurationDirectory.mkdir();
            }
            this.settings.init(new File(this.configurationDirectory, "server-config.properties"));
        }
        event.registerServerCommand((ICommand)new CommandVoiceMute());
    }

    private Thread startVoiceServer() {
        this.serverNetwork = new ServerNetwork(this);
        this.serverNetwork.init();
        this.voiceServer = new MinecraftVoiceServer(this, EnumVoiceNetworkType.MINECRAFT);
        Thread thread = new Thread((Runnable)this.voiceServer, "Voice Server");
        thread.start();
        VoiceChat.getLogger().info("Started [" + this.voiceServer.getType().name + "] Server.");
        return thread;
    }

    public synchronized VoiceServer getVoiceServer() {
        return this.voiceServer;
    }

    public synchronized ServerNetwork getServerNetwork() {
        return this.serverNetwork;
    }

    public static synchronized Logger getLogger() {
        return LOGGER;
    }

    public void initClient(VoiceChat voiceChat, FMLStateEvent event) {
    }

    public void postInit(VoiceChat voiceChat, FMLPostInitializationEvent event) {
    }

    public void preInitServer(FMLServerAboutToStartEvent event) {
    }

    public String getVersion() {
        return VERSION;
    }

    public void preInitClient(FMLPreInitializationEvent event) {
    }

    public static String getMinecraftVersion() {
        return MC_VERSION;
    }

    public ServerSettings getServerSettings() {
        return this.settings;
    }
}

