/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.sound;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;

public class SoundSystemWrapper {
    SoundHandler soundHandler;
    SoundManager soundManager;
    Object sndSystem;
    Field soundSystem;
    public String[] names = new String[11];

    public SoundSystemWrapper(SoundHandler soundHandler) throws Exception {
        this.names[0] = "rawDataStream";
        this.names[1] = "playing";
        this.names[2] = "setVelocity";
        this.names[3] = "setPosition";
        this.names[4] = "setDistOrRoll";
        this.names[5] = "feedRawAudioData";
        this.names[6] = "flush";
        this.names[7] = "setPitch";
        this.names[8] = "setVolume";
        this.soundHandler = soundHandler;
        Field field = SoundHandler.class.getDeclaredFields()[5];
        field.setAccessible(true);
        this.soundManager = (SoundManager)field.get(soundHandler);
        this.soundSystem = SoundManager.class.getDeclaredFields()[4];
        this.soundSystem.setAccessible(true);
    }

    public void rawDataStream(AudioFormat format, boolean priority, String identifier, float x, float y, float z, int attModel, float distOrRoll) {
        try {
            this.sndSystem = this.soundSystem.get(this.soundManager);
            Method method = this.sndSystem.getClass().getMethod(this.names[0], AudioFormat.class, Boolean.TYPE, String.class, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Float.TYPE);
            method.invoke(this.sndSystem, format, priority, identifier, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), attModel, Float.valueOf(distOrRoll));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean playing(String string) {
        try {
            this.sndSystem = this.soundSystem.get(this.soundManager);
            Method method = this.sndSystem.getClass().getMethod(this.names[1], String.class);
            method.setAccessible(true);
            return (Boolean)method.invoke(this.sndSystem, string);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setVelocity(String string, float motX, float motY, float motZ) {
        try {
            this.sndSystem = this.soundSystem.get(this.soundManager);
            Method method = this.sndSystem.getClass().getMethod(this.names[2], String.class, Float.TYPE, Float.TYPE, Float.TYPE);
            method.setAccessible(true);
            method.invoke(this.sndSystem, string, Float.valueOf(motX), Float.valueOf(motY), Float.valueOf(motZ));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPosition(String string, float x, float y, float z) {
        try {
            this.sndSystem = this.soundSystem.get(this.soundManager);
            Method method = this.sndSystem.getClass().getMethod(this.names[3], String.class, Float.TYPE, Float.TYPE, Float.TYPE);
            method.setAccessible(true);
            method.invoke(this.sndSystem, string, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDistOrRoll(String generateSource, int soundDistance) {
        try {
            this.sndSystem = this.soundSystem.get(this.soundManager);
            Method method = this.sndSystem.getClass().getMethod(this.names[4], String.class, Integer.TYPE);
            method.invoke(this.sndSystem, generateSource, soundDistance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void feedRawAudioData(String identifier, byte[] bs) {
        try {
            this.sndSystem = this.soundSystem.get(this.soundManager);
            Method method = this.sndSystem.getClass().getMethod(this.names[5], String.class, byte[].class);
            method.invoke(this.sndSystem, identifier, bs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void flush(String identifier) {
        try {
            this.sndSystem = this.soundSystem.get(this.soundManager);
            Method method = this.sndSystem.getClass().getMethod(this.names[6], String.class);
            method.setAccessible(true);
            method.invoke(this.sndSystem, identifier);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPitch(String identifier, float f) {
        try {
            this.sndSystem = this.soundSystem.get(this.soundManager);
            Method method = this.sndSystem.getClass().getMethod(this.names[7], String.class, Float.TYPE);
            method.setAccessible(true);
            method.invoke(this.sndSystem, identifier, Float.valueOf(f));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVolume(String identifier, float worldVolume) {
        try {
            this.sndSystem = this.soundSystem.get(this.soundManager);
            Method method = this.sndSystem.getClass().getMethod(this.names[8], String.class, Float.TYPE);
            method.setAccessible(true);
            method.invoke(this.sndSystem, identifier, Float.valueOf(worldVolume));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

