/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.networking;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.common.networking.voiceservers.EnumVoiceNetworkType;

public class ClientPacketHandler {
    public static void handleForceBandwidth(byte[] payload) {
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        DataInputStream dis = new DataInputStream(bais);
        int x = -1;
        int x1 = -1;
        try {
            x = dis.readInt();
            x1 = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().setQuality(x, x1);
    }

    public static void handleEntityData(byte[] payload) {
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        DataInputStream dis = new DataInputStream(bais);
        int entityID = -1;
        double x = -1.0;
        double y = -1.0;
        double z = -1.0;
        double motX = -1.0;
        double motY = -1.0;
        double motZ = -1.0;
        String name = null;
        try {
            entityID = dis.readInt();
            name = dis.readUTF();
            x = dis.readDouble();
            y = dis.readDouble();
            z = dis.readDouble();
            motX = dis.readDouble();
            motY = dis.readDouble();
            motZ = dis.readDouble();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (name != null) {
            VoiceChat.getProxyInstance().getClientNetwork().getVoiceClient().handleEntityData(entityID, name, x, y, z, motX, motY, motZ);
        }
    }

    public static void handleEntityPosition(byte[] payload) {
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        DataInputStream dis = new DataInputStream(bais);
        int entityID = -1;
        double x = -1.0;
        double y = -1.0;
        double z = -1.0;
        double motX = -1.0;
        double motY = -1.0;
        double motZ = -1.0;
        try {
            entityID = dis.readInt();
            x = dis.readDouble();
            y = dis.readDouble();
            z = dis.readDouble();
            motX = dis.readDouble();
            motY = dis.readDouble();
            motZ = dis.readDouble();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().getVoiceClient().handleEntityPosition(entityID, x, y, z, motX, motY, motZ);
    }

    public static void handleVoiceData(byte[] payload) {
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        DataInputStream dis = new DataInputStream(bais);
        int entityID = -1;
        int global = 0;
        byte[] data = null;
        try {
            int size = dis.readInt();
            data = new byte[size];
            for (int i = 0; i < size; ++i) {
                data[i] = dis.readByte();
            }
            entityID = dis.readInt();
            global = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().getVoiceClient().handlePacket(entityID, data, data.length, global);
    }

    public static void handleChunkVoiceData(byte[] payload) {
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        DataInputStream dis = new DataInputStream(bais);
        int entityID = -1;
        int chunkSize = -1;
        int global = 0;
        byte[] data = null;
        try {
            int size = dis.readInt();
            data = new byte[size];
            for (int i = 0; i < size; ++i) {
                data[i] = dis.readByte();
            }
            chunkSize = dis.readInt();
            entityID = dis.readInt();
            global = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().getVoiceClient().handlePacket(entityID, data, chunkSize, global);
    }

    public static void handleVoiceServerAuthentication(byte[] payload) {
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        DataInputStream dis = new DataInputStream(bais);
        int type = 0;
        String hash = null;
        int udp = 0;
        int maxSoundDistance = 63;
        try {
            maxSoundDistance = dis.readInt();
            type = dis.readInt();
            hash = dis.readUTF();
            udp = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().startClientNetwork(EnumVoiceNetworkType.values()[type], hash, null, udp, maxSoundDistance);
    }

    public static void handleVoiceServer(byte[] payload) {
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        DataInputStream dis = new DataInputStream(bais);
        int type = 0;
        int maxSoundDistance = 63;
        try {
            maxSoundDistance = dis.readInt();
            type = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().startClientNetwork(EnumVoiceNetworkType.values()[type], null, null, 0, maxSoundDistance);
    }

    public static void handleVoiceEnd(byte[] payload) {
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        DataInputStream dis = new DataInputStream(bais);
        int entityID = -1;
        try {
            entityID = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().getVoiceClient().handleEnd(entityID);
    }
}

