/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.networking;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.networking.MinecraftVoiceClient;
import net.gliby.voicechat.client.networking.VoiceClient;
import net.gliby.voicechat.common.networking.PacketDispatcher;
import net.gliby.voicechat.common.networking.packets.PacketServerVoiceVersion;
import net.gliby.voicechat.common.networking.voiceservers.EnumVoiceNetworkType;

public class ClientNetwork {
    VoiceChatClient voiceChat;
    VoiceClient voiceClient;
    Thread voiceClientThread;

    public ClientNetwork(VoiceChatClient voiceChatClient) {
        this.voiceChat = voiceChatClient;
    }

    public VoiceClient startClientNetwork(EnumVoiceNetworkType type, String hash, String serverAddress, int udpPort, int soundDist) {
        this.voiceChat.getSettings().resetQuality();
        ClientNetwork clientNetwork = this;
        clientNetwork.voiceChat.getSoundManager().reset();
        switch (type) {
            case MINECRAFT: {
                this.voiceClient = new MinecraftVoiceClient(type);
                this.sendClientInfo();
                break;
            }
            default: {
                this.voiceClient = new MinecraftVoiceClient(type);
                this.sendClientInfo();
            }
        }
        this.voiceChat.getSettings().setSoundDistance(soundDist);
        this.voiceClientThread = new Thread((Runnable)this.voiceClient, "Voice Client");
        this.voiceClientThread.start();
        ClientNetwork clientNetwork2 = this;
        clientNetwork2.voiceChat.getLogger().info("Connected to [" + type.name + "] Server.");
        return this.voiceClient;
    }

    public void stopClientNetwork() {
        ClientNetwork clientNetwork = this;
        clientNetwork.voiceChat.getLogger().info("Stopped Voice Client.");
        this.getVoiceClient().stop();
        this.voiceClient = null;
        this.voiceClientThread.stop();
        this.voiceClientThread = null;
    }

    private void sendClientInfo() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeUTF(this.voiceChat.getShortVersion());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PacketDispatcher.sendPacketToServer(new PacketServerVoiceVersion(bos.toByteArray()));
    }

    public synchronized VoiceClient getVoiceClient() {
        return this.voiceClient;
    }

    public boolean voiceClientExists() {
        return this.voiceClient != null;
    }

    public void sendSamples(byte[] samples, boolean end) {
        if (this.voiceClient != null) {
            this.voiceClient.sendVoiceData(samples, end);
        }
    }

    public void setQuality(int x, int x1) {
        this.voiceChat.getSettings().setBandwidthLimit(x, x1);
    }
}

