/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.gui.options;

import java.util.HashMap;
import java.util.Map;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.device.Device;
import net.gliby.voicechat.client.gui.GuiBoostSlider;
import net.gliby.voicechat.client.gui.GuiCustomButton;
import net.gliby.voicechat.client.gui.GuiDropDownMenu;
import net.gliby.voicechat.client.keybindings.EnumBinding;
import net.gliby.voicechat.client.sound.MicrophoneTester;
import net.gliby.voicechat.client.textures.IndependentTexture;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiOptionsWizard
extends GuiScreen {
    GuiScreen parent;
    VoiceChatClient voiceChat;
    GuiCustomButton nextButton;
    GuiCustomButton previousButton;
    GuiCustomButton doneButton;
    GuiCustomButton backButton;
    GuiBoostSlider boostSlider;
    Map<GuiButton, Integer> buttonMap = new HashMap<GuiButton, Integer>();
    int currentPage = 1;
    int lastPage = -1;
    int maxPages = 4;
    String title = "Voice Chat Setup Wizard.";
    String text = "";
    GuiDropDownMenu dropDown;
    MicrophoneTester tester;
    String boostSliderId;
    boolean dirty;

    public GuiOptionsWizard(VoiceChatClient voiceChat, GuiScreen parent) {
        this.voiceChat = voiceChat;
        this.parent = parent;
        this.tester = new MicrophoneTester(voiceChat);
    }

    public void func_73866_w_() {
        String[] array = new String[this.voiceChat.getSettings().getDeviceHandler().getDevices().size()];
        for (int i = 0; i < this.voiceChat.getSettings().getDeviceHandler().getDevices().size(); ++i) {
            array[i] = this.voiceChat.getSettings().getDeviceHandler().getDevices().get(i).getName();
        }
        this.dropDown = new GuiDropDownMenu(-1, this.field_146294_l / 2 - 75, this.field_146295_m / 2 - 55, 150, 20, this.voiceChat.getSettings().getInputDevice() != null ? this.voiceChat.getSettings().getInputDevice().getName() : "None", array);
        this.nextButton = new GuiCustomButton(0, this.field_146294_l / 2 - 90, this.field_146295_m / 2 + 60, 180, 20, "Next ->");
        this.field_146292_n.add(this.nextButton);
        this.previousButton = new GuiCustomButton(1, this.field_146294_l / 2 - 90, this.field_146295_m / 2, 180, 20, "<- Previous");
        this.field_146292_n.add(this.previousButton);
        this.doneButton = new GuiCustomButton(2, this.field_146294_l / 2 - 90, this.field_146295_m / 2, 180, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.doneButton);
        this.backButton = new GuiCustomButton(3, this.field_146294_l / 2 - 90, this.field_146295_m / 2 + 15, 180, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]));
        this.field_146292_n.add(this.backButton);
        this.boostSlider = new GuiBoostSlider(900, this.field_146294_l / 2 - 75, this.field_146295_m / 2 - 15, "VALUE", "Boost:" + ((int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) <= 0 ? " OFF" : " " + (int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) + "db"), 0.0f);
        this.field_146292_n.add(this.boostSlider);
        this.boostSlider.sliderValue = this.voiceChat.getSettings().getInputBoost();
        this.doneButton.field_146125_m = false;
        this.dirty = true;
        this.buttonMap.put(this.backButton, 1);
        this.buttonMap.put(this.boostSlider, 3);
    }

    public void func_73863_a(int x, int y, float tick) {
        this.func_146276_q_();
        IndependentTexture.GUI_WIZARD.bindTexture(this.field_146297_k);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(this.field_146294_l / 2) - 142.5f), (float)((float)(this.field_146295_m / 2) - 94.5f), (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)0.0f);
        this.func_73729_b(0, 0, 0, 0, 190, 127);
        GL11.glPopMatrix();
        this.func_73731_b(this.field_146297_k.field_71466_p, this.currentPage + "/" + this.maxPages, this.field_146294_l / 2 + 108, this.field_146295_m / 2 + 67, -1);
        if (this.title != null) {
            this.func_73731_b(this.field_146297_k.field_71466_p, EnumChatFormatting.BOLD + this.title, this.field_146294_l / 2 - this.field_146297_k.field_71466_p.func_78256_a(this.title) / 2 - 12, this.field_146295_m / 2 - 80, -1);
        }
        if (this.text != null) {
            this.field_146289_q.func_78279_b(EnumChatFormatting.func_110646_a((String)this.text), this.field_146294_l / 2 - 107 - 1 + 1, this.field_146295_m / 2 - 65 + 1, 230, 0);
            this.field_146289_q.func_78279_b(this.text, this.field_146294_l / 2 - 107 - 1, this.field_146295_m / 2 - 65, 230, -1);
        }
        this.drawPage(x, y, tick);
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
            if (guibutton != this.nextButton && guibutton != this.previousButton && guibutton != this.doneButton && (this.buttonMap.get(guibutton) == null || this.buttonMap.get(guibutton) != this.currentPage)) continue;
            guibutton.func_146112_a(this.field_146297_k, x, y);
        }
    }

    public void func_146284_a(GuiButton button) {
        if ((button == this.nextButton || button == this.previousButton || this.doneButton == button || this.buttonMap.get(button) != null && this.buttonMap.get(button) == this.currentPage) && !this.dropDown.dropDownMenu) {
            switch (button.field_146127_k) {
                case 0: {
                    if (this.currentPage >= this.maxPages) break;
                    ++this.currentPage;
                    break;
                }
                case 1: {
                    if (this.currentPage < 2) break;
                    --this.currentPage;
                    break;
                }
                case 2: {
                    if (this.currentPage != this.maxPages) break;
                    this.voiceChat.getSettings().setSetupNeeded(false);
                    this.field_146297_k.func_147108_a(null);
                    break;
                }
                case 3: {
                    this.voiceChat.getSettings().setSetupNeeded(false);
                    this.field_146297_k.func_147108_a(this.parent);
                }
            }
        }
    }

    public void drawPage(int x, int y, float tick) {
        if (this.tester.recording && this.currentPage != 3) {
            this.tester.stop();
        }
        if (this.currentPage != 2 && this.dropDown.dropDownMenu) {
            this.dropDown.dropDownMenu = false;
        }
        switch (this.currentPage) {
            case 1: {
                this.title = "Gliby's Voice Chat Setup Wizard";
                this.text = "This setup wizard can help you configure voice chat, or you can manually adjust with " + EnumChatFormatting.GREEN + "Gliby's" + EnumChatFormatting.GRAY + " Voice Chat Options" + EnumChatFormatting.WHITE + " by pressing " + EnumChatFormatting.UNDERLINE + this.voiceChat.keyManager.getKeyName(EnumBinding.OPEN_GUI_OPTIONS) + EnumChatFormatting.RESET + " at any given time, the setup wizard is accesible in options. \n\nYou can continue the setup by pressing Next, or exit this setup wizard by pressing " + EnumChatFormatting.UNDERLINE + "ESC.";
                break;
            }
            case 2: {
                this.title = "Select Input Device";
                this.text = "\n\n\n\n\nSelect your input device, if you don't know which is your default input device select " + EnumChatFormatting.UNDERLINE + "'Primary Sound Capture Driver.'";
                this.dropDown.func_146112_a(this.field_146297_k, x, y);
                break;
            }
            case 3: {
                if (this.lastPage != this.currentPage) {
                    this.tester.start();
                }
                this.title = "Adjust Microphone Levels";
                this.text = "\n\n\n\n\n\n\n\nAdjust your boost level, this is required if your input device is too quiet. It is recommended staying at the " + EnumChatFormatting.GREEN + "Green" + EnumChatFormatting.WHITE + " to " + EnumChatFormatting.YELLOW + "Yellow" + EnumChatFormatting.WHITE + " zone, or voice quality could be bad.";
                IndependentTexture.GUI_WIZARD.bindTexture(this.field_146297_k);
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDisable((int)3008);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)((float)(this.field_146294_l / 2) - 39.75f), (float)((float)(this.field_146295_m / 2) - 67.5f), (float)0.0f);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)0.0f);
                IndependentTexture.GUI_WIZARD.bindTexture(this.field_146297_k);
                this.func_73729_b(0, 0, 0, 127, 35, 20);
                float progress = this.tester.currentAmplitude;
                float procent = progress / 3.164557f;
                this.drawTexturedModalRect(3.35f, 0.0f, 35.0f, 127.0f, procent, 20.0f);
                GL11.glEnable((int)3008);
                GL11.glPopMatrix();
                String ratingText = "Boost Voice Volume.";
                this.func_73731_b(this.field_146289_q, ratingText, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(ratingText) / 2, this.field_146295_m / 2 - 26, -1);
                break;
            }
            case 4: {
                this.title = "Finished Setup Wizard";
                this.text = "You have finished setting up the essentials for " + EnumChatFormatting.GREEN + "Gliby's" + EnumChatFormatting.GRAY + " Voice Chat" + EnumChatFormatting.WHITE + ", if you want to change more settings, go to options by pressing " + this.voiceChat.keyManager.getKeyName(EnumBinding.OPEN_GUI_OPTIONS) + ".\n\nVoice Chat can be activated with " + EnumChatFormatting.UNDERLINE + this.voiceChat.keyManager.getKeyName(EnumBinding.SPEAK) + EnumChatFormatting.WHITE + "\n\nThe setup wizard can be opened in options once again if required, you can go back now and change settings by pressing the 'Previous' button.";
            }
        }
        this.lastPage = this.currentPage;
    }

    public void func_73864_a(int x, int y, int b) {
        if (this.currentPage == 2) {
            Device device;
            if (this.dropDown.getMouseOverInteger() != -1 && this.dropDown.dropDownMenu && !this.voiceChat.getSettings().getDeviceHandler().isEmpty() && (device = this.voiceChat.getSettings().getDeviceHandler().getDevices().get(this.dropDown.getMouseOverInteger())) != null) {
                this.voiceChat.getSettings().setInputDevice(device);
                this.dropDown.setDisplayString(device.getName());
            }
            if (this.dropDown.func_146116_c(this.field_146297_k, x, y) && b == 0) {
                this.dropDown.func_146113_a(this.field_146297_k.func_147118_V());
                boolean bl = this.dropDown.dropDownMenu = !this.dropDown.dropDownMenu;
            }
        }
        if (b == 0) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (guibutton != this.nextButton && guibutton != this.previousButton && this.doneButton != guibutton && (this.buttonMap.get(guibutton) == null || this.buttonMap.get(guibutton) != this.currentPage) || !guibutton.func_146116_c(this.field_146297_k, x, y)) continue;
                super.func_73864_a(x, y, b);
            }
        }
    }

    public void func_73876_c() {
        this.boostSlider.setDisplayString("Boost:" + ((int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) <= 0 ? " OFF" : " " + (int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) + "db"));
        this.voiceChat.getSettings().setInputBoost(this.boostSlider.sliderValue);
        if (this.lastPage != this.currentPage || this.dirty) {
            if (this.currentPage == 1) {
                this.previousButton.field_146125_m = false;
                this.doneButton.field_146125_m = false;
                this.nextButton.field_146128_h = this.field_146294_l / 2 - 90;
                this.nextButton.field_146129_i = this.field_146295_m / 2 + 60;
                this.nextButton.setWidth(180);
                this.nextButton.setHeight(20);
            } else if (this.currentPage == this.maxPages) {
                this.nextButton.field_146125_m = false;
                this.doneButton.field_146125_m = true;
                this.doneButton.field_146128_h = this.field_146294_l / 2;
                this.doneButton.field_146129_i = this.field_146295_m / 2 + 60;
                this.doneButton.setWidth(95);
                this.doneButton.setHeight(20);
                this.previousButton.field_146128_h = this.field_146294_l / 2 - 95;
                this.previousButton.field_146129_i = this.field_146295_m / 2 + 60;
                this.previousButton.setWidth(95);
                this.previousButton.setHeight(20);
            } else {
                this.previousButton.field_146125_m = true;
                this.nextButton.field_146125_m = true;
                this.doneButton.field_146125_m = false;
                this.nextButton.field_146128_h = this.field_146294_l / 2;
                this.nextButton.field_146129_i = this.field_146295_m / 2 + 60;
                this.nextButton.setWidth(95);
                this.nextButton.setHeight(20);
                this.previousButton.field_146128_h = this.field_146294_l / 2 - 95;
                this.previousButton.field_146129_i = this.field_146295_m / 2 + 60;
                this.previousButton.setWidth(95);
                this.previousButton.setHeight(20);
            }
            this.dirty = false;
        }
    }

    public void drawTexturedModalRect(float par1, float par2, float par3, float par4, float par5, float par6) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0.0f), (double)(par2 + par6), (double)this.field_73735_i, (double)((par3 + 0.0f) * f), (double)((par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), (double)this.field_73735_i, (double)((par3 + par5) * f), (double)((par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0.0f), (double)this.field_73735_i, (double)((par3 + par5) * f), (double)((par4 + 0.0f) * f1));
        tessellator.func_78374_a((double)(par1 + 0.0f), (double)(par2 + 0.0f), (double)this.field_73735_i, (double)((par3 + 0.0f) * f), (double)((par4 + 0.0f) * f1));
        tessellator.func_78381_a();
    }

    public void func_146281_b() {
        if (this.tester.recording) {
            this.tester.stop();
        }
    }
}

