/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.common.VoiceChatServer;
import net.gliby.voicechat.common.networking.packets.PacketClientBandwidth;
import net.gliby.voicechat.common.networking.packets.PacketClientChunkVoiceSample;
import net.gliby.voicechat.common.networking.packets.PacketClientEntityData;
import net.gliby.voicechat.common.networking.packets.PacketClientEntityPosition;
import net.gliby.voicechat.common.networking.packets.PacketClientVoiceEnd;
import net.gliby.voicechat.common.networking.packets.PacketClientVoiceSample;
import net.gliby.voicechat.common.networking.packets.PacketClientVoiceServer;
import net.gliby.voicechat.common.networking.packets.PacketClientVoiceServerAuth;
import net.gliby.voicechat.common.networking.packets.PacketServerVoiceEnd;
import net.gliby.voicechat.common.networking.packets.PacketServerVoiceSample;
import net.gliby.voicechat.common.networking.packets.PacketServerVoiceVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="gvc", name="Gliby's Voice Chat Mod", version="0.4.0")
public class VoiceChat {
    String[] clientPacketHandlerSpec = new String[]{"GVC-SMPL", "GVC-FORCEB", "GVC-SMPLE", "GVC-ED", "GVC-E", "GVC-VSA", "GVC-VS", "GVC-CHSMPL"};
    String[] serverPacketHandlerSpec = new String[]{"GVC-SMPL", "GVC-SMPLE", "GVC-VS"};
    @Mod.Instance
    public static VoiceChat instance;
    @SidedProxy(modId="gvc", clientSide="net.gliby.voicechat.client.VoiceChatClient", serverSide="net.gliby.voicechat.common.VoiceChatServer")
    public static VoiceChatServer proxy;
    public static SimpleNetworkWrapper DISPATCH;
    protected static final Logger LOGGER;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            proxy.initClient(this, (FMLStateEvent)event);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(this, event);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.networkClient();
        proxy.preInitClient(event);
    }

    private void networkClient() {
        DISPATCH = NetworkRegistry.INSTANCE.newSimpleChannel("GVC");
        DISPATCH.registerMessage(PacketClientBandwidth.class, PacketClientBandwidth.class, 0, Side.CLIENT);
        DISPATCH.registerMessage(PacketClientChunkVoiceSample.class, PacketClientChunkVoiceSample.class, 1, Side.CLIENT);
        DISPATCH.registerMessage(PacketClientEntityData.class, PacketClientEntityData.class, 2, Side.CLIENT);
        DISPATCH.registerMessage(PacketClientEntityPosition.class, PacketClientEntityPosition.class, 3, Side.CLIENT);
        DISPATCH.registerMessage(PacketClientVoiceEnd.class, PacketClientVoiceEnd.class, 4, Side.CLIENT);
        DISPATCH.registerMessage(PacketClientVoiceSample.class, PacketClientVoiceSample.class, 5, Side.CLIENT);
        DISPATCH.registerMessage(PacketClientVoiceServer.class, PacketClientVoiceServer.class, 6, Side.CLIENT);
        DISPATCH.registerMessage(PacketClientVoiceServerAuth.class, PacketClientVoiceServerAuth.class, 7, Side.CLIENT);
        DISPATCH.registerMessage(PacketServerVoiceSample.class, PacketServerVoiceSample.class, 8, Side.SERVER);
        DISPATCH.registerMessage(PacketServerVoiceEnd.class, PacketServerVoiceEnd.class, 9, Side.SERVER);
        DISPATCH.registerMessage(PacketServerVoiceVersion.class, PacketServerVoiceVersion.class, 10, Side.SERVER);
    }

    @Mod.EventHandler
    public void initServer(FMLServerStartingEvent event) {
        proxy.initServer(event);
    }

    @Mod.EventHandler
    public void preInitServer(FMLServerAboutToStartEvent event) {
        proxy.preInitServer(event);
    }

    public static synchronized Logger getLogger() {
        return proxy.getLogger();
    }

    public static VoiceChat getInstance() {
        return instance;
    }

    public static synchronized VoiceChat getSynchronizedInstance() {
        return instance;
    }

    public static VoiceChatClient getProxyInstance() {
        return (VoiceChatClient)(proxy instanceof VoiceChatClient ? (VoiceChatClient)proxy : proxy);
    }

    public static VoiceChatServer getServerInstance() {
        return proxy;
    }

    public static synchronized VoiceChatClient getSynchronizedProxyInstance() {
        return (VoiceChatClient)proxy;
    }

    public static SimpleNetworkWrapper getDispatcher() {
        return DISPATCH;
    }

    static {
        LOGGER = LogManager.getLogger((String)"Gliby's Voice Chat Mod");
    }
}

