/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.tileentity;

import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.block.BlockGasPump;
import glenn.gasesframework.block.IGasReceptor;
import glenn.gasesframework.block.IGasSource;
import glenn.gasesframework.util.DVec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityPump
extends TileEntity {
    protected static final int[] xDirection = new int[]{0, 0, 1, -1, 0, 0};
    protected static final int[] yDirection = new int[]{1, -1, 0, 0, 0, 0};
    protected static final int[] zDirection = new int[]{0, 0, 0, 0, 1, -1};
    public int pumpTime = 25;
    private int overload = 0;
    private int failedPumpings;
    public boolean excludes = false;
    public GasType containedType;
    public GasType filterType;

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.pumpTime = par1NBTTagCompound.func_74762_e("pumpTime");
        this.failedPumpings = par1NBTTagCompound.func_74762_e("failedPumpings");
        this.excludes = par1NBTTagCompound.func_74767_n("excludes");
        int i = par1NBTTagCompound.func_74762_e("containedType");
        this.containedType = i == -1 ? null : GasType.gasTypes[i];
        i = par1NBTTagCompound.func_74762_e("filterType");
        this.filterType = i == -1 ? null : GasType.gasTypes[i];
        if (par1NBTTagCompound.func_74764_b("overload")) {
            this.overload = par1NBTTagCompound.func_74762_e("overload");
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("pumpTime", this.pumpTime);
        par1NBTTagCompound.func_74768_a("overload", this.overload);
        par1NBTTagCompound.func_74768_a("failedPumpings", this.failedPumpings);
        par1NBTTagCompound.func_74757_a("excludes", this.excludes);
        par1NBTTagCompound.func_74768_a("containedType", this.containedType != null ? this.containedType.gasIndex : -1);
        par1NBTTagCompound.func_74768_a("filterType", this.filterType != null ? this.filterType.gasIndex : -1);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean acceptsType(GasType gasType) {
        if (this.filterType == null) {
            return true;
        }
        return this.filterType == gasType ^ this.excludes | gasType == GasesFramework.gasTypeAir;
    }

    protected boolean extractFromSides() {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int[] indices = this.randomIndexArray(this.field_145850_b.field_73012_v);
        int i = 0;
        while (i < 6 & this.containedType == null) {
            int z1;
            int y1;
            int x1;
            Block directionBlock;
            int index = indices[i];
            if (index != metadata && (directionBlock = this.field_145850_b.func_147439_a(x1 = this.field_145851_c + xDirection[index], y1 = this.field_145848_d + yDirection[index], z1 = this.field_145849_e + zDirection[index])) != Blocks.field_150350_a && IGasSource.class.isAssignableFrom(directionBlock.getClass())) {
                IGasSource gasSource = (IGasSource)directionBlock;
                if (this.acceptsType(gasSource.getGasTypeFromSide(this.field_145850_b, x1, y1, z1, index))) {
                    this.containedType = gasSource.takeGasTypeFromSide(this.field_145850_b, x1, y1, z1, index);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void handleFailedPumpings() {
        DVec velocity;
        if (this.field_145850_b.field_72995_K && this.failedPumpings > 20 && this.field_145850_b.field_73012_v.nextInt(1000 / ((this.failedPumpings - 20) * (this.failedPumpings - 20)) + 1) == 0) {
            velocity = DVec.randomNormalizedVec(this.field_145850_b.field_73012_v).scale(0.25);
            this.field_145850_b.func_72869_a("largesmoke", (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, velocity.x, velocity.y, velocity.z);
        }
        if (this.field_145850_b.field_72995_K && this.overload > 20 && this.field_145850_b.field_73012_v.nextInt(2000 / ((this.overload - 20) * (this.overload - 20)) + 1) == 0) {
            velocity = DVec.randomNormalizedVec(this.field_145850_b.field_73012_v).scale(0.25);
            this.field_145850_b.func_72869_a("largesmoke", (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, velocity.x, velocity.y, velocity.z);
        }
        if (!this.field_145850_b.field_72995_K && this.failedPumpings > 60 || this.overload > 200) {
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 3.0f, true);
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.pumpTime-- <= 0) {
            if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                boolean canPumpAir;
                BlockGasPump block = (BlockGasPump)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (this.containedType == null & (canPumpAir = this.extractFromSides())) {
                    this.containedType = GasesFramework.gasTypeAir;
                }
                if (this.containedType != null) {
                    int x1 = this.field_145851_c + xDirection[metadata];
                    int y1 = this.field_145848_d + yDirection[metadata];
                    int z1 = this.field_145849_e + zDirection[metadata];
                    Block directionBlock = this.field_145850_b.func_147439_a(x1, y1, z1);
                    boolean success = false;
                    if (GasesFramework.fillWithGas(this.field_145850_b, this.field_145850_b.field_73012_v, x1, y1, z1, this.containedType)) {
                        success = true;
                    } else if (IGasReceptor.class.isAssignableFrom(directionBlock.getClass())) {
                        success = ((IGasReceptor)directionBlock).receiveGas(this.field_145850_b, x1, y1, z1, metadata < 2 ? 1 - metadata : metadata, this.containedType);
                    }
                    if (success) {
                        this.containedType = null;
                        this.failedPumpings = 0;
                        this.overload += 10;
                        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 0, 1);
                    } else {
                        ++this.failedPumpings;
                        this.pumpTime += 2;
                        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 0, 0);
                    }
                }
            } else {
                this.failedPumpings = 0;
            }
            this.pumpTime = 25;
        }
        if (this.overload-- < 0) {
            this.overload = 0;
        }
        this.handleFailedPumpings();
    }

    protected int[] randomIndexArray(Random random) {
        int[] array = new int[6];
        int i = 0;
        while (i < 6) {
            int index;
            while (array[index = random.nextInt(6)] != 0) {
            }
            array[index] = i++;
        }
        return array;
    }

    public boolean blockEvent(int eventID, int eventParam) {
        if (!this.field_145850_b.field_72995_K) {
            return true;
        }
        switch (eventID) {
            case 0: {
                if (eventParam == 1) {
                    this.failedPumpings = 0;
                    this.overload += 10;
                    break;
                }
                if (eventParam != 0) break;
                ++this.failedPumpings;
            }
        }
        return true;
    }
}

