/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.block.IGasReceptor;
import glenn.gasesframework.tileentity.TileEntityGasFurnace;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGasFurnace
extends BlockContainer
implements IGasReceptor {
    private final Random furnaceRand = new Random();
    private final boolean isActive;
    private static boolean keepFurnaceInventory;
    @SideOnly(value=Side.CLIENT)
    private IIcon furnaceIconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] furnaceIconFront;

    public BlockGasFurnace(boolean par2) {
        super(Material.field_151573_f);
        this.isActive = par2;
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        super.func_149726_b(par1World, par2, par3, par4);
        this.setDefaultDirection(par1World, par2, par3, par4);
    }

    private void setDefaultDirection(World world, int i, int j, int k) {
        if (!world.field_72995_K) {
            Block localBlock1 = world.func_147439_a(i, j, k - 1);
            Block localBlock2 = world.func_147439_a(i, j, k + 1);
            Block localBlock3 = world.func_147439_a(i - 1, j, k);
            Block localBlock4 = world.func_147439_a(i + 1, j, k);
            int l = 3;
            if (localBlock1.func_149730_j() && !localBlock2.func_149730_j()) {
                l = 3;
            }
            if (localBlock2.func_149730_j() && !localBlock1.func_149730_j()) {
                l = 2;
            }
            if (localBlock3.func_149730_j() && !localBlock4.func_149730_j()) {
                l = 5;
            }
            if (localBlock4.func_149730_j() && !localBlock3.func_149730_j()) {
                l = 4;
            }
            world.func_72921_c(i, j, k, l, 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return par1 == 1 ? this.furnaceIconTop : (par1 == 0 ? this.furnaceIconTop : (par1 == 4 ? this.furnaceIconFront[0] : this.field_149761_L));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int metadata = blockAccess.func_72805_g(x, y, z);
        TileEntityGasFurnace tileEntity = (TileEntityGasFurnace)blockAccess.func_147438_o(x, y, z);
        return side == 1 ? this.furnaceIconTop : (side == 0 ? this.furnaceIconTop : (metadata != side ? this.field_149761_L : this.furnaceIconFront[tileEntity.prevStage]));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.furnaceIconFront = new IIcon[5];
        this.field_149761_L = iconRegister.func_94245_a(this.func_149641_N() + "_side");
        this.furnaceIconTop = iconRegister.func_94245_a(this.func_149641_N() + "_top");
        for (int i = 0; i < 5; ++i) {
            this.furnaceIconFront[i] = iconRegister.func_94245_a(this.func_149641_N() + "_front_" + i);
        }
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par1World.field_72995_K) {
            return true;
        }
        TileEntityGasFurnace tileentityfurnace = (TileEntityGasFurnace)par1World.func_147438_o(par2, par3, par4);
        if (tileentityfurnace != null) {
            par5EntityPlayer.openGui((Object)GasesFramework.instance, 0, par1World, par2, par3, par4);
        }
        return true;
    }

    public static void updateFurnaceBlockState(int stage, World par1World, int par2, int par3, int par4) {
        int l = par1World.func_72805_g(par2, par3, par4);
        TileEntity tileentity = par1World.func_147438_o(par2, par3, par4);
        keepFurnaceInventory = true;
        if (stage == 0) {
            par1World.func_147449_b(par2, par3, par4, GasesFramework.gasFurnaceIdle);
        } else {
            par1World.func_147449_b(par2, par3, par4, GasesFramework.gasFurnaceActive);
        }
        keepFurnaceInventory = false;
        par1World.func_72921_c(par2, par3, par4, l, 2);
        if (tileentity != null) {
            tileentity.func_145829_t();
            par1World.func_147455_a(par2, par3, par4, tileentity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int par2, int par3, int par4, Random par5Random) {
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityGasFurnace();
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            par1World.func_72921_c(par2, par3, par4, 2, 2);
        }
        if (l == 1) {
            par1World.func_72921_c(par2, par3, par4, 5, 2);
        }
        if (l == 2) {
            par1World.func_72921_c(par2, par3, par4, 3, 2);
        }
        if (l == 3) {
            par1World.func_72921_c(par2, par3, par4, 4, 2);
        }
        if (par6ItemStack.func_82837_s()) {
            ((TileEntityGasFurnace)par1World.func_147438_o(par2, par3, par4)).setGuiDisplayName(par6ItemStack.func_82833_r());
        }
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        TileEntityGasFurnace tileentityfurnace;
        if (!keepFurnaceInventory && (tileentityfurnace = (TileEntityGasFurnace)par1World.func_147438_o(par2, par3, par4)) != null) {
            for (int j1 = 0; j1 < tileentityfurnace.func_70302_i_(); ++j1) {
                ItemStack itemstack = tileentityfurnace.func_70301_a(j1);
                if (itemstack == null) continue;
                float f = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int k1 = this.furnaceRand.nextInt(21) + 10;
                    if (k1 > itemstack.field_77994_a) {
                        k1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= k1;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)par2 + f), (double)((float)par3 + f1), (double)((float)par4 + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.furnaceRand.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.furnaceRand.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.furnaceRand.nextGaussian() * f3;
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
            par1World.func_147453_f(par2, par3, par4, par5);
        }
        super.func_149749_a(par1World, par2, par3, par4, par5, par6);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World par1World, int par2, int par3, int par4, int par5) {
        return Container.func_94526_b((IInventory)((IInventory)par1World.func_147438_o(par2, par3, par4)));
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World par1World, int par2, int par3, int par4) {
        return Item.func_150898_a((Block)GasesFramework.gasFurnaceIdle);
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)GasesFramework.gasFurnaceIdle);
    }

    @Override
    public boolean receiveGas(World world, int x, int y, int z, int side, GasType gasType) {
        TileEntityGasFurnace gasFurnace = (TileEntityGasFurnace)world.func_147438_o(x, y, z);
        if (gasType.combustibility.burnRate == 0) {
            return true;
        }
        if (gasFurnace.furnaceBurnTime < 100 * gasType.combustibility.burnRate) {
            gasFurnace.furnaceBurnTime += 100 * gasType.combustibility.burnRate;
            return true;
        }
        return false;
    }

    @Override
    public boolean connectToPipe() {
        return true;
    }
}

