/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import glenn.gasesframework.Combustibility;
import glenn.gasesframework.CommonProxy;
import glenn.gasesframework.DamageSourceAsphyxiation;
import glenn.gasesframework.GasType;
import glenn.gasesframework.GasTypeAir;
import glenn.gasesframework.GasTypeFire;
import glenn.gasesframework.GuiHandler;
import glenn.gasesframework.block.BlockGas;
import glenn.gasesframework.block.BlockGasCollector;
import glenn.gasesframework.block.BlockGasFire;
import glenn.gasesframework.block.BlockGasFurnace;
import glenn.gasesframework.block.BlockGasPipe;
import glenn.gasesframework.block.BlockGasPump;
import glenn.gasesframework.block.BlockGasTank;
import glenn.gasesframework.block.BlockLantern;
import glenn.gasesframework.block.BlockLanternEmpty;
import glenn.gasesframework.block.BlockLanternGas;
import glenn.gasesframework.block.BlockLanternGasEmpty;
import glenn.gasesframework.client.RenderBlockGas;
import glenn.gasesframework.client.RenderBlockGasPipe;
import glenn.gasesframework.client.RenderBlockLantern;
import glenn.gasesframework.client.RenderBlockPump;
import glenn.gasesframework.client.RenderBlockTank;
import glenn.gasesframework.item.ItemGasBottle;
import glenn.gasesframework.item.ItemGasSampler;
import glenn.gasesframework.reaction.Reaction;
import glenn.gasesframework.reaction.ReactionEmpty;
import glenn.gasesframework.reaction.ReactionIgnition;
import glenn.gasesframework.tileentity.TileEntityGasCollector;
import glenn.gasesframework.tileentity.TileEntityGasFurnace;
import glenn.gasesframework.tileentity.TileEntityPump;
import glenn.gasesframework.tileentity.TileEntityTank;
import glenn.gasesframework.util.QueuedLanternRecipe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="gasesFramework", name="Gases Framework", version="1.0.4", dependencies="required-after:gasesFrameworkCore")
public class GasesFramework {
    @Mod.Instance(value="gasesFramework")
    public static GasesFramework instance;
    @SidedProxy(clientSide="glenn.gasesframework.client.ClientProxy", serverSide="glenn.gasesframework.CommonProxy")
    public static CommonProxy proxy;
    public static final GuiHandler guiHandler;
    public static final String version = "1.0.4";
    public static final String targetVersion = "1.7.2";
    public static float gasExplosionFactor;
    public static int gasFurnaceHeatingSpeed;
    public static boolean fancyTank;
    public static boolean enableFireSmoke;
    public static int maxGasHeight;
    public static final DamageSource asphyxiationDamageSource;
    private static ArrayList<QueuedLanternRecipe> queuedLanternRecipes;
    private static Configuration config;
    public static int renderBlockGasID;
    public static int renderBlockLanternID;
    public static int renderBlockGasPipeID;
    public static int renderBlockPumpID;
    public static int renderBlockTankID;
    public static ResourceLocation gasOverlayImage;
    public static ResourceLocation fireOverlayImage;
    public static ResourceLocation emptyOverlayImage;
    private static boolean ENCOURAGE_MECHANICAL_ITEMS_VAR;
    private static boolean ENCOURAGE_LANTERNS_VAR;
    public static final Material gasMaterial;
    private static HashSet<Block> gasReactives;
    private static ArrayList<Reaction> reactions;
    public static BlockGas gasSmoke;
    public static BlockGas gasFire;
    public static BlockGasPipe gasPipeSmoke;
    public static GasType gasTypeSmoke;
    public static GasType gasTypeFire;
    public static Item gasBottle;
    public static Item gasSamplerIncluder;
    public static Item gasSamplerExcluder;
    public static BlockGasPipe gasPipeAir;
    public static Block gasPump;
    public static Block gasTank;
    public static Block gasCollector;
    public static Block gasFurnaceIdle;
    public static Block gasFurnaceActive;
    public static BlockLantern lanternEmpty;
    public static BlockLantern lanternGasEmpty;
    public static BlockLantern lanternGas1;
    public static BlockLantern lanternGas2;
    public static BlockLantern lanternGas3;
    public static BlockLantern lanternGas4;
    public static BlockLantern lanternGas5;
    public static GasType gasTypeAir;
    public static CreativeTabs creativeTab;

    private void initBlocksAndItems() {
        gasBottle = new ItemGasBottle().func_77655_b("gf_gasBottle").func_77637_a(creativeTab).func_111206_d("gasesframework:gas_bottle");
        GameRegistry.registerItem((Item)gasBottle, (String)"gasBottle");
        gasSmoke = (BlockGas)new BlockGas().func_149663_c("gf_gasSmoke").func_149647_a(creativeTab);
        GameRegistry.registerBlock((Block)gasSmoke, (String)"gasSmoke");
        gasFire = (BlockGas)new BlockGasFire().func_149715_a(0.5f).func_149663_c("gf_gasFire").func_149647_a(creativeTab).func_149658_d("gasesframework:gas_fire");
        GameRegistry.registerBlock((Block)gasFire, (String)"gasFire");
        if (GasesFramework.MECHANICAL_ITEMS_ENCOURAGED()) {
            gasSamplerIncluder = new ItemGasSampler(false).func_77655_b("gf_gasSamplerIncluder").func_77637_a(creativeTab).func_111206_d("gasesframework:sampler");
            GameRegistry.registerItem((Item)gasSamplerIncluder, (String)"gasSamplerIncluder");
            gasSamplerExcluder = new ItemGasSampler(true).func_77655_b("gf_gasSamplerExcluder").func_77637_a(creativeTab).func_111206_d("gasesframework:sampler");
            GameRegistry.registerItem((Item)gasSamplerExcluder, (String)"gasSamplerExcluder");
            gasPipeAir = (BlockGasPipe)new BlockGasPipe().func_149647_a(creativeTab).func_149663_c("gf_gasPipeEmpty");
            GameRegistry.registerBlock((Block)gasPipeAir, (String)"gasPipeAir");
            gasPipeSmoke = (BlockGasPipe)new BlockGasPipe().func_149663_c("gf_gasPipeSmoke");
            GameRegistry.registerBlock((Block)gasPipeSmoke, (String)"gasPipeSmoke");
            gasPump = new BlockGasPump().func_149711_c(2.5f).func_149672_a(Block.field_149769_e).func_149647_a(creativeTab).func_149663_c("gf_gasPump").func_149658_d("gasesframework:pump");
            GameRegistry.registerBlock((Block)gasPump, (String)"gasPump");
            gasTank = new BlockGasTank().func_149711_c(3.5f).func_149672_a(Block.field_149769_e).func_149647_a(creativeTab).func_149663_c("gf_gasTank").func_149658_d("gasesframework:tank");
            GameRegistry.registerBlock((Block)gasTank, (String)"gasTank");
            gasCollector = new BlockGasCollector().func_149711_c(2.5f).func_149672_a(Block.field_149769_e).func_149647_a(creativeTab).func_149663_c("gf_gasCollector").func_149658_d("gasesframework:collector");
            GameRegistry.registerBlock((Block)gasCollector, (String)"gasCollector");
            gasFurnaceIdle = new BlockGasFurnace(false).func_149711_c(3.5f).func_149672_a(Block.field_149769_e).func_149663_c("gf_gasFurnace").func_149647_a(creativeTab).func_149658_d("gasesframework:gas_furnace");
            GameRegistry.registerBlock((Block)gasFurnaceIdle, (String)"gasFurnaceIdle");
            gasFurnaceActive = new BlockGasFurnace(true).func_149711_c(3.5f).func_149672_a(Block.field_149769_e).func_149715_a(0.25f).func_149663_c("gf_gasFurnaceWarm").func_149658_d("gasesframework:gas_furnace");
            GameRegistry.registerBlock((Block)gasFurnaceActive, (String)"gasFurnaceActive");
        }
        gasTypeAir = new GasTypeAir();
        gasTypeSmoke = new GasType(gasSmoke, gasPipeSmoke, 1, "smoke", 0x3F3F3F, 2, -16, Combustibility.NONE).setEffectRates(4, 4, 16);
        gasTypeFire = new GasTypeFire(gasFire, 11).setOverlayImage(fireOverlayImage).setEvaporationRate(2);
        lanternEmpty = (BlockLantern)new BlockLanternEmpty().func_149663_c("gf_lanternEmpty").func_149647_a(creativeTab).func_149658_d("gasesframework:lantern_empty");
        GameRegistry.registerBlock((Block)lanternEmpty, (String)"lanternEmpty");
        if (GasesFramework.LANTERNS_ENCOURAGED()) {
            lanternGasEmpty = (BlockLantern)new BlockLanternGasEmpty().func_149663_c("gf_lanternGasEmpty").func_149658_d("gasesframework:lantern_gas0");
            GameRegistry.registerBlock((Block)lanternGasEmpty, (String)"lanternGasEmpty");
            lanternGas1 = (BlockLantern)new BlockLanternGas(Combustibility.CONTROLLABLE).func_149715_a(1.0f).func_149663_c("gf_lanternGas1").func_149658_d("gasesframework:lantern_gas1");
            GameRegistry.registerBlock((Block)lanternGas1, (String)"lanternGas1");
            lanternGas2 = (BlockLantern)new BlockLanternGas(Combustibility.FLAMMABLE).func_149715_a(1.0f).func_149663_c("gf_lanternGas2").func_149658_d("gasesframework:lantern_gas2");
            GameRegistry.registerBlock((Block)lanternGas2, (String)"lanternGas2");
            lanternGas3 = (BlockLantern)new BlockLanternGas(Combustibility.HIGHLY_FLAMMABLE).func_149715_a(1.0f).func_149663_c("gf_lanternGas3").func_149658_d("gasesframework:lantern_gas3");
            GameRegistry.registerBlock((Block)lanternGas3, (String)"lanternGas3");
            lanternGas4 = (BlockLantern)new BlockLanternGas(Combustibility.EXPLOSIVE).func_149715_a(1.0f).func_149663_c("gf_lanternGas4").func_149658_d("gasesframework:lantern_gas4");
            GameRegistry.registerBlock((Block)lanternGas4, (String)"lanternGas4");
            lanternGas5 = (BlockLantern)new BlockLanternGas(Combustibility.HIGHLY_EXPLOSIVE).func_149715_a(1.0f).func_149663_c("gf_lanternGas5").func_149658_d("gasesframework:lantern_gas5");
            GameRegistry.registerBlock((Block)lanternGas5, (String)"lanternGas5");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String[] removedIgnitionBlocks;
        String[] additionalIgnitionBlocks;
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.initBlocksAndItems();
        GasesFramework.registerIgnitionBlock(Blocks.field_150478_aa);
        GasesFramework.registerIgnitionBlock((Block)Blocks.field_150480_ab);
        GasesFramework.registerIgnitionBlock(gasFire);
        gasExplosionFactor = Float.parseFloat(config.get("gases", "gasExplosionFactor", 2.5).getString());
        gasFurnaceHeatingSpeed = config.get("other", "gasFurnaceHeatingSpeed", 2).getInt();
        fancyTank = config.get("other", "fancyTank", true).getBoolean(true);
        enableFireSmoke = config.get("gases", "enableFireSmoke", true).getBoolean(true);
        maxGasHeight = config.get("gases", "maxGasHeight", 256).getInt(256);
        for (String s : additionalIgnitionBlocks = config.get("other", "additionalIgnitionBlocks", new String[0]).getStringList()) {
            Block block = Block.func_149684_b((String)s);
            if (block == null) continue;
            GasesFramework.registerIgnitionBlock(block);
        }
        for (String s : removedIgnitionBlocks = config.get("other", "removedIgnitionBlocks", new String[0]).getStringList()) {
            Block block = Block.func_149684_b((String)s);
            if (block == null) continue;
            GasesFramework.unregisterIgnitionBlock(block);
        }
        config.save();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        renderBlockGasID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockGasID, (ISimpleBlockRenderingHandler)new RenderBlockGas());
        renderBlockLanternID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockLanternID, (ISimpleBlockRenderingHandler)new RenderBlockLantern());
        renderBlockGasPipeID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockGasPipeID, (ISimpleBlockRenderingHandler)new RenderBlockGasPipe());
        renderBlockPumpID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockPumpID, (ISimpleBlockRenderingHandler)new RenderBlockPump());
        renderBlockTankID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockTankID, (ISimpleBlockRenderingHandler)new RenderBlockTank());
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)lanternEmpty, 4), (Object[])new Object[]{"I", "G", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('G'), Blocks.field_150359_w});
        if (GasesFramework.MECHANICAL_ITEMS_ENCOURAGED()) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)gasPipeAir, 24), (Object[])new Object[]{"III", Character.valueOf('I'), Items.field_151042_j});
            GameRegistry.addRecipe((ItemStack)new ItemStack(gasPump), (Object[])new Object[]{" I ", "PRP", " I ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('P'), gasPipeAir, Character.valueOf('R'), Items.field_151137_ax});
            GameRegistry.addRecipe((ItemStack)new ItemStack(gasCollector), (Object[])new Object[]{" P ", "PUP", " P ", Character.valueOf('U'), gasPump, Character.valueOf('P'), gasPipeAir});
            GameRegistry.addRecipe((ItemStack)new ItemStack(gasTank), (Object[])new Object[]{"IPI", "P P", "IPI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('P'), gasPipeAir});
            GameRegistry.addRecipe((ItemStack)new ItemStack(gasFurnaceIdle), (Object[])new Object[]{" I ", "IFI", " I ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('F'), Blocks.field_150460_al});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(gasSamplerExcluder), (Object[])new Object[]{new ItemStack(Items.field_151069_bo), new ItemStack(Items.field_151100_aR, 1, 0)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(gasSamplerIncluder), (Object[])new Object[]{new ItemStack(Items.field_151069_bo), new ItemStack(Items.field_151100_aR, 1, 15)});
            GameRegistry.registerTileEntity(TileEntityPump.class, (String)"gasPump");
            GameRegistry.registerTileEntity(TileEntityGasCollector.class, (String)"gasCollector");
            GameRegistry.registerTileEntity(TileEntityTank.class, (String)"gasTank");
            GameRegistry.registerTileEntity(TileEntityGasFurnace.class, (String)"gasPoweredFurnace");
        }
        GasesFramework.registerReaction(new ReactionIgnition());
        proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)guiHandler);
        for (QueuedLanternRecipe recipe : queuedLanternRecipes) {
            recipe.register();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    public static void registerIgnitionBlock(Block block) {
        gasReactives.add(block);
    }

    public static void unregisterIgnitionBlock(Block block) {
        gasReactives.remove(block);
    }

    public static boolean isIgnitionBlock(Block block) {
        return gasReactives.contains(block);
    }

    public static void registerReaction(Reaction reaction) {
        if (!reaction.isErroneous()) {
            reactions.add(reaction);
        }
    }

    public static Reaction getReactionForBlocks(World world, Block block1, int block1X, int block1Y, int block1Z, Block block2, int block2X, int block2Y, int block2Z) {
        for (Reaction reaction : reactions) {
            if (!reaction.is(world, block1, block1X, block1Y, block1Z, block2, block2X, block2Y, block2Z)) continue;
            return reaction;
        }
        return new ReactionEmpty();
    }

    public static int reverseDirection(int direction) {
        return direction / 2 * 2 + 1 - direction % 2;
    }

    public static void addSpecialFurnaceRecipe(ItemStack ingredient, ItemStack result, int cookTime) {
        if (!GasesFramework.MECHANICAL_ITEMS_ENCOURAGED()) {
            throw new RuntimeException("A furnace recipe was registered while mechanical items were not encouraged. Please put GasesFramework.ENCOURAGE_MECHANICAL_ITEMS() in the mod's static initalizer.");
        }
        TileEntityGasFurnace.specialFurnaceRecipes.add(new TileEntityGasFurnace.SpecialFurnaceRecipe(ingredient, result, cookTime));
    }

    public static void queueLanternRecipe(BlockLantern result, ItemStack ingredient) {
        if (!GasesFramework.LANTERNS_ENCOURAGED()) {
            throw new RuntimeException("A lantern recipe was registered while lanterns were not encouraged. Please put GasesFramework.ENCOURAGE_LANTERNS() in the mod's static initalizer.");
        }
        queuedLanternRecipes.add(new QueuedLanternRecipe(result, ingredient));
    }

    public static void ENCOURAGE_MECHANICAL_ITEMS() {
        ENCOURAGE_MECHANICAL_ITEMS_VAR = true;
    }

    public static void ENCOURAGE_LANTERNS() {
        ENCOURAGE_LANTERNS_VAR = true;
    }

    public static boolean MECHANICAL_ITEMS_ENCOURAGED() {
        return ENCOURAGE_MECHANICAL_ITEMS_VAR;
    }

    public static boolean LANTERNS_ENCOURAGED() {
        return ENCOURAGE_LANTERNS_VAR;
    }

    public static boolean canFillWithGas(World world, int x, int y, int z, GasType type) {
        if (type == gasTypeAir) {
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof BlockGas) {
                return world.func_72805_g(x, y, z) > 0;
            }
            return !block.func_149662_c();
        }
        int firstBlockCapacity = GasesFramework.fillCapacity(world, x, y, z, type);
        if (firstBlockCapacity >= 16) {
            return true;
        }
        if (firstBlockCapacity >= 0) {
            int capacity = 0;
            int[] sideCapacity = new int[6];
            for (int side = 0; side < 6; ++side) {
                int zDirection;
                int yDirection;
                if (side == 0 & type.density > 0 | side == 1 & type.density < 0) {
                    sideCapacity[side] = -1;
                    continue;
                }
                int xDirection = x + (side == 4 ? 1 : (side == 5 ? -1 : 0));
                sideCapacity[side] = GasesFramework.fillCapacity(world, xDirection, yDirection = y + (side == 0 ? 1 : (side == 1 ? -1 : 0)), zDirection = z + (side == 2 ? 1 : (side == 3 ? -1 : 0)), type);
                if (sideCapacity[side] <= 0) continue;
                capacity += sideCapacity[side];
            }
            return capacity + firstBlockCapacity >= 16;
        }
        return false;
    }

    public static boolean fillWithGas(World world, Random random, int x, int y, int z, GasType type) {
        if (type == gasTypeAir) {
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof BlockGas) {
                return world.func_72805_g(x, y, z) > 0;
            }
            return !block.func_149662_c();
        }
        int firstBlockCapacity = GasesFramework.fillCapacity(world, x, y, z, type);
        if (firstBlockCapacity >= 16) {
            GasesFramework.fill(world, x, y, z, type, 16);
            return true;
        }
        if (firstBlockCapacity >= 0) {
            int side;
            int capacity = 0;
            int[] sideCapacity = new int[6];
            for (int side2 = 0; side2 < 6; ++side2) {
                int zDirection;
                int yDirection;
                if (side2 == 0 & type.density > 0 | side2 == 1 & type.density < 0) {
                    sideCapacity[side2] = -1;
                    continue;
                }
                int xDirection = x + (side2 == 4 ? 1 : (side2 == 5 ? -1 : 0));
                sideCapacity[side2] = GasesFramework.fillCapacity(world, xDirection, yDirection = y + (side2 == 0 ? 1 : (side2 == 1 ? -1 : 0)), zDirection = z + (side2 == 2 ? 1 : (side2 == 3 ? -1 : 0)), type);
                if (sideCapacity[side2] <= 0) continue;
                capacity += sideCapacity[side2];
            }
            if (capacity + firstBlockCapacity < 16) {
                return false;
            }
            GasesFramework.fill(world, x, y, z, type, firstBlockCapacity);
            int fill = 0;
            int[] sideFill = new int[6];
            for (side = 0; side < 6; ++side) {
                if (sideCapacity[side] == -1) continue;
                sideFill[side] = sideCapacity[side] * (16 - firstBlockCapacity) / capacity;
                fill += sideFill[side];
            }
            while (fill < 16 - firstBlockCapacity) {
                side = random.nextInt(6);
                if (!(sideFill[side] < sideCapacity[side] & sideCapacity[side] != -1)) continue;
                int n = side;
                sideFill[n] = sideFill[n] + 1;
                ++fill;
            }
            for (side = 0; side < 6; ++side) {
                int xDirection = x + (side == 4 ? 1 : (side == 5 ? -1 : 0));
                int yDirection = y + (side == 0 ? 1 : (side == 1 ? -1 : 0));
                int zDirection = z + (side == 2 ? 1 : (side == 3 ? -1 : 0));
                GasesFramework.fill(world, xDirection, yDirection, zDirection, type, sideFill[side]);
            }
            return true;
        }
        return false;
    }

    private static void fill(World world, int x, int y, int z, GasType type, int amount) {
        if (amount <= 0) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == type.gasBlock) {
            int newMetadata = 16 - world.func_72805_g(x, y, z) + amount;
            world.func_72921_c(x, y, z, 16 - newMetadata, 3);
        } else {
            world.func_147465_d(x, y, z, (Block)type.gasBlock, 16 - amount, 3);
        }
    }

    private static int fillCapacity(World world, int x, int y, int z, GasType type) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockGas) {
            if (block == type.gasBlock) {
                return world.func_72805_g(x, y, z);
            }
            return -1;
        }
        if (block instanceof BlockLiquid) {
            return -1;
        }
        return block.isReplaceable((IBlockAccess)world, x, y, z) ? 16 : -1;
    }

    public static void blindEntity(EntityLivingBase entity, int amount) {
    }

    public static void slowEntity(EntityLivingBase entity, int amount) {
    }

    static {
        guiHandler = new GuiHandler();
        asphyxiationDamageSource = new DamageSourceAsphyxiation("gf_asphyxiation");
        queuedLanternRecipes = new ArrayList();
        gasOverlayImage = new ResourceLocation("gasesframework:textures/misc/gas_overlay.png");
        fireOverlayImage = new ResourceLocation("gasesframework:textures/misc/fire_overlay.png");
        emptyOverlayImage = new ResourceLocation("gasesframework:textures/misc/empty_overlay.png");
        ENCOURAGE_MECHANICAL_ITEMS_VAR = false;
        ENCOURAGE_LANTERNS_VAR = false;
        gasMaterial = new Material(MapColor.field_151660_b){

            public boolean func_76220_a() {
                return false;
            }

            public boolean func_76230_c() {
                return false;
            }

            public boolean func_76228_b() {
                return false;
            }
        }.func_76231_i();
        gasReactives = new HashSet();
        reactions = new ArrayList();
        creativeTab = new CreativeTabs("tabGases"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)lanternEmpty);
            }
        };
    }
}

