/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import glenn.gases.Gases;
import glenn.gases.worldgen.WorldGenPipes;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.worldgen.WorldGenFloatingGas;
import glenn.gasesframework.worldgen.WorldGenGas;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGeneratorGases
implements IWorldGenerator {
    private Random randomGenerator;
    private int chunk_X;
    private int chunk_Z;
    private World currentWorld;
    private WorldGenerator risingFlammableGasGen = new WorldGenGas(Gases.gasRisingFlammable, 0, 3);
    private WorldGenerator fallingExplosiveGasGen = new WorldGenGas(Gases.gasFallingExplosive, 0, 3);
    private WorldGenerator nitrousGasGen = new WorldGenGas(Gases.gasNitrous, 0, 2);
    private WorldGenerator blackDampGasGen = new WorldGenFloatingGas(Gases.gasBlackDamp, 15, 6);
    private WorldGenerator chlorineGasGen = new WorldGenGas(Gases.gasChlorine, 0, 2);
    private WorldGenerator gasPipeGen = new WorldGenPipes(GasesFramework.gasPipeAir);
    private WorldGenerator electricGasGen = new WorldGenFloatingGas(Gases.gasElectric, 4, 6);
    private WorldGenerator corrosiveGasGen = new WorldGenFloatingGas(Gases.gasCorrosive, 4, 6);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.randomGenerator = random;
        this.chunk_X = chunkX * 16;
        this.chunk_Z = chunkZ * 16;
        this.currentWorld = world;
        String s = chunkGenerator.func_73148_d();
        if (s.equals("HellRandomLevelSource")) {
            this.genGas(Gases.generateElectricGas, this.electricGasGen, 40, 128);
            this.genGas(Gases.generateCorrosiveGas, this.corrosiveGasGen, 40, 128);
        } else if (s.equals("RandomLevelSource")) {
            this.genGas(Gases.generateGreenGas, this.risingFlammableGasGen, 16, 48);
            this.genGas(Gases.generateRedGas, this.fallingExplosiveGasGen, 4, 20);
            this.genGas(Gases.generateNitrousGas, this.nitrousGasGen, 4, 20);
            this.genGas(Gases.generateBlackDamp, this.blackDampGasGen, 16, 32);
            this.genGas(Gases.generateChlorineGas, this.chlorineGasGen, 32, 48);
            for (int i = 0; i < Gases.generatePipes; ++i) {
                this.gasPipeGen.func_76484_a(world, random, this.chunk_X + random.nextInt(16), 16 + random.nextInt(32), this.chunk_Z + random.nextInt(16));
            }
        }
    }

    protected void genGas(int amountValue, WorldGenerator generator, int minHeight, int maxHeight) {
        if (amountValue >= 0) {
            this.genStandardGas(amountValue, generator, minHeight, maxHeight);
        } else {
            this.genGasWithChance(-amountValue, generator, minHeight, maxHeight);
        }
    }

    protected void genStandardGas(int par1, WorldGenerator par2WorldGenerator, int par3, int par4) {
        for (int var5 = 0; var5 < par1; ++var5) {
            int var6 = this.chunk_X + this.randomGenerator.nextInt(16);
            int var7 = this.randomGenerator.nextInt(par4 - par3) + par3;
            int var8 = this.chunk_Z + this.randomGenerator.nextInt(16);
            par2WorldGenerator.func_76484_a(this.currentWorld, this.randomGenerator, var6, var7, var8);
        }
    }

    protected void genGasWithChance(int par1, WorldGenerator par2WorldGenerator, int par3, int par4) {
        if (this.randomGenerator.nextInt(par1) == 0) {
            int var6 = this.chunk_X + this.randomGenerator.nextInt(16);
            int var7 = this.randomGenerator.nextInt(par4 - par3) + par3;
            int var8 = this.chunk_Z + this.randomGenerator.nextInt(16);
            par2WorldGenerator.func_76484_a(this.currentWorld, this.randomGenerator, var6, var7, var8);
        }
    }
}

