/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases.worldgen;

import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.block.BlockGasPipe;
import glenn.gasesframework.util.IVec;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenPipes
extends WorldGenerator {
    protected BlockGasPipe pipeBlock;
    protected HashSet<IVec> pipePlacements;

    public WorldGenPipes(BlockGasPipe pipeBlock) {
        this.pipeBlock = pipeBlock;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != Blocks.field_150350_a) {
            return false;
        }
        this.pipePlacements = new HashSet();
        this.branch(world, random, x, y, z);
        if (this.pipePlacements.size() > 6) {
            for (IVec pipe : this.pipePlacements) {
                if (random.nextInt(12) == 0) continue;
                world.func_147449_b(pipe.x, pipe.y, pipe.z, (Block)this.pipeBlock);
            }
        }
        return true;
    }

    protected Block getBlock(World world, int x, int y, int z) {
        if (this.pipePlacements.contains(new IVec(x, y, z))) {
            return this.pipeBlock;
        }
        return world.func_147439_a(x, y, z);
    }

    protected void branch(World world, Random random, int x, int y, int z) {
        boolean[] sides = new boolean[6];
        int generationChance = 1;
        for (int i = 0; i < 6; ++i) {
            int yDirection;
            int xDirection;
            int n = i == 4 ? 1 : (xDirection = i == 5 ? -1 : 0);
            int n2 = i == 0 ? 1 : (yDirection = i == 1 ? -1 : 0);
            int zDirection = i == 2 ? 1 : (i == 3 ? -1 : 0);
            Block block = this.getBlock(world, x + xDirection, y + yDirection, z + zDirection);
            if (block.func_149662_c()) {
                sides[i] = true;
                continue;
            }
            if (block != Blocks.field_150350_a) continue;
            ++generationChance;
        }
        generationChance = generationChance / 2 + 1;
        boolean[] blArray = new boolean[6];
        boolean bl = random.nextInt(generationChance) == 0 && this.getBlock(world, x, y + 1, z) == Blocks.field_150350_a & (sides[2] | sides[3] | sides[4] | sides[5]) ? true : (blArray[0] = false);
        boolean bl2 = random.nextInt(generationChance) == 0 && this.getBlock(world, x, y - 1, z) == Blocks.field_150350_a & (sides[2] | sides[3] | sides[4] | sides[5]) ? true : (blArray[1] = false);
        boolean bl3 = random.nextInt(generationChance) == 0 && this.getBlock(world, x, y, z + 1) == Blocks.field_150350_a & (sides[0] | sides[1] | sides[4] | sides[5]) ? true : (blArray[2] = false);
        boolean bl4 = random.nextInt(generationChance) == 0 && this.getBlock(world, x, y, z - 1) == Blocks.field_150350_a & (sides[0] | sides[1] | sides[4] | sides[5]) ? true : (blArray[3] = false);
        boolean bl5 = random.nextInt(generationChance) == 0 && this.getBlock(world, x + 1, y, z) == Blocks.field_150350_a & (sides[0] | sides[1] | sides[2] | sides[3]) ? true : (blArray[4] = false);
        blArray[5] = random.nextInt(generationChance) == 0 && this.getBlock(world, x - 1, y, z) == Blocks.field_150350_a & (sides[0] | sides[1] | sides[2] | sides[3]);
        boolean[] possibleDirections = blArray;
        int nPossibleDirections = 0;
        for (int i = 0; i < 6; ++i) {
            if (!possibleDirections[i]) continue;
            ++nPossibleDirections;
        }
        if (nPossibleDirections > 0) {
            this.pipePlacements.add(new IVec(x, y, z));
        }
        while (nPossibleDirections > 0) {
            int direction = random.nextInt(6);
            if (!possibleDirections[direction]) continue;
            possibleDirections[direction] = false;
            --nPossibleDirections;
            this.generatePipe(world, random, x, y, z, direction);
        }
    }

    protected void generatePipe(World world, Random random, int x, int y, int z, int startDirection) {
        int yDirection;
        int xDirection;
        int support = 2;
        int n = startDirection == 4 ? 1 : (xDirection = startDirection == 5 ? -1 : 0);
        int n2 = startDirection == 0 ? 1 : (yDirection = startDirection == 1 ? -1 : 0);
        int zDirection = startDirection == 2 ? 1 : (startDirection == 3 ? -1 : 0);
        for (int i = 0; i < 10 && support > 0 && world.func_147437_c(x += xDirection, y += yDirection, z += zDirection); ++i) {
            boolean flag = false;
            boolean flag2 = false;
            for (int j = 0; j < 6; ++j) {
                int yDirection2;
                int xDirection2;
                if (j == GasesFramework.reverseDirection((int)startDirection)) continue;
                int n3 = j == 4 ? 1 : (xDirection2 = j == 5 ? -1 : 0);
                int n4 = j == 0 ? 1 : (yDirection2 = j == 1 ? -1 : 0);
                int zDirection2 = j == 2 ? 1 : (j == 3 ? -1 : 0);
                Block block = this.getBlock(world, x + xDirection2, y + yDirection2, z + zDirection2);
                if (block.func_149662_c()) {
                    flag = true;
                    continue;
                }
                if (!(block instanceof BlockGasPipe)) continue;
                flag2 = true;
            }
            support = flag2 ? -1 : (flag ? 2 : --support);
            Block block = this.getBlock(world, x + xDirection, y + yDirection, z + zDirection);
            if (support == 2 && random.nextInt(10) == 0 || random.nextInt(2) == 0 && block != Blocks.field_150350_a && !(block instanceof BlockGasPipe)) {
                this.branch(world, random, x, y, z);
                break;
            }
            this.pipePlacements.add(new IVec(x, y, z));
        }
    }
}

