/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glenn.gases.entity.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class EntityFlashSparkFX
extends EntityFX {
    private static final ResourceLocation texture = new ResourceLocation("gases:textures/effects/flash_spark.png");
    private double[] prevMotionX = new double[5];
    private double[] prevMotionY = new double[5];
    private double[] prevMotionZ = new double[5];

    public EntityFlashSparkFX(World world) {
        super(world);
    }

    public EntityFlashSparkFX(World world, double x, double y, double z, double xv, double yv, double zv) {
        super(world, x, y, z);
        this.func_70016_h(xv, yv, zv);
        this.maxLifetime = 20 + world.field_73012_v.nextInt(10);
    }

    @Override
    public double getScale(float partialTick) {
        return 0.05;
    }

    @Override
    public ResourceLocation getTexture() {
        return texture;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70181_x == 0.0) {
            this.field_70181_x = -this.prevMotionY[0] * 0.75;
            this.field_70159_w *= 0.9;
            this.field_70179_y *= 0.9;
        } else {
            this.field_70181_x -= 0.1;
        }
        this.push(this.field_70159_w, this.prevMotionX);
        this.push(this.field_70181_x, this.prevMotionY);
        this.push(this.field_70179_y, this.prevMotionZ);
        super.func_70071_h_();
    }

    @Override
    public void render(Tessellator tessellator, RenderManager renderManager, float partialTick, double x, double y, double z) {
        x = this.field_70165_t - renderManager.field_78730_l;
        y = this.field_70163_u - renderManager.field_78731_m;
        z = this.field_70161_v - renderManager.field_78728_n;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        double d = this.getScale(partialTick);
        tessellator.func_78371_b(3);
        tessellator.func_78374_a(x, y, z, 0.0, 0.0);
        for (int i = 0; i < 5; ++i) {
            tessellator.func_78374_a(x -= this.prevMotionX[i], y -= this.prevMotionY[i], z -= this.prevMotionZ[i], (double)(i + 1) / 5.0, 0.0);
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
    }

    private void push(double motion, double[] array) {
        for (int i = 4; i > 0; --i) {
            array[i] = array[i - 1];
        }
        array[0] = motion;
    }
}

