/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import glenn.gases.Gases;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class UpdateChecker {
    private boolean alreadyChecked = !Gases.enableUpdateCheck;
    private ArrayList<MessageCounter> counters;

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K && event.entity instanceof EntityPlayer && !this.alreadyChecked) {
            try {
                String line;
                File messageCounterFile;
                File readMeFile;
                Gson gson = new Gson();
                File metaFolder = new File(Minecraft.func_71410_x().field_71412_D.getPath() + "/config/Glenn's Gases");
                if (!metaFolder.exists()) {
                    metaFolder.mkdirs();
                }
                if (!(readMeFile = new File(metaFolder.getPath() + "/readMe.txt")).exists()) {
                    readMeFile.createNewFile();
                    PrintWriter writer = new PrintWriter(readMeFile);
                    writer.print(String.format("This is a folder used by Glenn's Gases, a Minecraft mod you have installed.%nThis folder, or the contents of this folder, should not be removed or altered as long as Glenn's Gases is installed.%nThe folder is only used as a small local data store to save data between sessions.%nTo disable the use of this folder, disable the update checker in Glenn's Gases' configurations.", new Object[0]));
                    writer.close();
                }
                if ((messageCounterFile = new File(metaFolder.getPath() + "/messageCounter.json")).exists()) {
                    String line2;
                    BufferedReader bf = new BufferedReader(new FileReader(messageCounterFile));
                    String countersJsonString = "";
                    while ((line2 = bf.readLine()) != null) {
                        countersJsonString = countersJsonString + line2 + "\n";
                    }
                    bf.close();
                    this.counters = (ArrayList)gson.fromJson(countersJsonString, new TypeToken<ArrayList<MessageCounter>>(){}.getType());
                    if (this.counters == null) {
                        this.counters = new ArrayList();
                    }
                } else {
                    this.counters = new ArrayList();
                }
                URL url = new URL("http://www.jamieswhiteshirt.com/trackable/gases.json");
                InputStreamReader isr = new InputStreamReader(url.openStream());
                BufferedReader bf = new BufferedReader(isr);
                String versionsJsonString = "";
                while ((line = bf.readLine()) != null) {
                    versionsJsonString = versionsJsonString + line + "\n";
                }
                bf.close();
                VersionMessage[] messages = (VersionMessage[])gson.fromJson(versionsJsonString, VersionMessage[].class);
                if (messages != null && messages.length > 0) {
                    for (int i = 0; i < messages.length; ++i) {
                        VersionMessage version = messages[i];
                        this.processVersionMessage((EntityPlayer)event.entity, version);
                    }
                }
                messageCounterFile.createNewFile();
                PrintWriter writer = new PrintWriter(messageCounterFile);
                writer.print(gson.toJson(this.counters));
                writer.close();
            }
            catch (Exception e) {
                System.out.println("[Gases]Failed to check for update messages (" + e.getClass().getName() + ")");
            }
            this.alreadyChecked = true;
        }
    }

    private void processVersionMessage(EntityPlayer player, VersionMessage msg) {
        if (msg == null) {
            return;
        }
        if (msg.id == -1) {
            return;
        }
        if (msg.timesToShow == 0) {
            return;
        }
        if (!this.versionInRanges("1.7.2", msg.minecraftVersions) || !this.versionInRanges("1.5.0", msg.modVersions)) {
            return;
        }
        MessageCounter counter = null;
        for (int i = 0; i < this.counters.size(); ++i) {
            MessageCounter c = this.counters.get(i);
            if (c == null || c.id != msg.id) continue;
            counter = c;
            break;
        }
        if (counter == null) {
            counter = new MessageCounter();
            counter.id = msg.id;
            counter.timesShown = 0;
            counter.timesToShow = msg.timesToShow;
            this.counters.add(counter);
        } else if (counter.timesToShow != msg.timesToShow) {
            counter.timesToShow = msg.timesToShow;
            counter.timesShown = 0;
        }
        if (counter.timesShown >= msg.timesToShow & counter.timesToShow != -1) {
            return;
        }
        boolean anythingPrinted = false;
        if (msg.displayName != null && msg.displayName.length() > 0) {
            anythingPrinted = true;
            player.func_145747_a(new ChatComponentText(msg.displayName).func_150255_a(this.getImportanceStyle(msg.importance).func_150227_a(Boolean.valueOf(true))));
        }
        if (msg.description != null) {
            for (int i = 0; i < msg.description.length; ++i) {
                String s = msg.description[i];
                if (s == null) continue;
                anythingPrinted = true;
                player.func_145747_a(new ChatComponentText(s).func_150255_a(this.getImportanceStyle(msg.importance)));
            }
        }
        if (msg.URL != null && msg.URL.length() > 0) {
            anythingPrinted = true;
            player.func_145747_a((IChatComponent)new ChatComponentText(msg.URL));
        }
        if (anythingPrinted) {
            ChatStyle style = new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW);
            ++counter.timesShown;
            if (counter.timesToShow != -1) {
                int timesLeft = counter.timesToShow - counter.timesShown;
                if (timesLeft == 0) {
                    player.func_145747_a(new ChatComponentText("This message will not be shown again.").func_150255_a(style));
                } else if (timesLeft == 1) {
                    player.func_145747_a(new ChatComponentText("This message will be shown one more time.").func_150255_a(style));
                } else if (timesLeft > 1) {
                    player.func_145747_a(new ChatComponentText("This message will be shown " + timesLeft + " more times.").func_150255_a(style));
                }
            }
            player.func_145747_a(new ChatComponentText("These messages can be disabled in Glenn's Gases' configuration files.").func_150255_a(style));
        }
    }

    private ChatStyle getImportanceStyle(int importance) {
        switch (importance) {
            case 0: {
                return new ChatStyle().func_150238_a(EnumChatFormatting.DARK_GREEN);
            }
            case 1: {
                return new ChatStyle().func_150238_a(EnumChatFormatting.BLUE);
            }
            case 2: {
                return new ChatStyle().func_150238_a(EnumChatFormatting.DARK_RED);
            }
        }
        return new ChatStyle();
    }

    private boolean versionInRanges(String version, String[] ranges) {
        if (ranges == null || ranges.length == 0) {
            return true;
        }
        boolean result = false;
        for (int i = 0; i < ranges.length; ++i) {
            result ^= this.versionInRange(version, ranges[i]);
        }
        return result;
    }

    private boolean versionInRange(String version, String range) {
        if (range == null || range.length() == 0) {
            return true;
        }
        int iVersion = this.versionStringToInt(version);
        if (range.startsWith("<=")) {
            return iVersion <= this.versionStringToInt(range.substring(2));
        }
        if (range.startsWith(">=")) {
            return iVersion >= this.versionStringToInt(range.substring(2));
        }
        if (range.startsWith("<")) {
            return iVersion < this.versionStringToInt(range.substring(1));
        }
        if (range.startsWith(">")) {
            return iVersion > this.versionStringToInt(range.substring(1));
        }
        String[] split = range.split("-");
        if (split.length == 2) {
            int iRange1 = this.versionStringToInt(split[0]);
            int iRange2 = this.versionStringToInt(split[1]);
            return iVersion <= iRange1 & iVersion >= iRange2 | iVersion >= iRange1 & iVersion <= iRange2;
        }
        return iVersion == this.versionStringToInt(range);
    }

    private int versionStringToInt(String version) {
        int versionScore = 0;
        int multiplier = 1000000000;
        String[] splitVersion = version.split("\\.");
        int i = 0;
        while (i < splitVersion.length) {
            versionScore += Integer.parseInt(splitVersion[i]) * multiplier;
            ++i;
            multiplier /= 1000;
        }
        return versionScore;
    }

    private class MessageCounter {
        public int id = -1;
        public int timesToShow = 1;
        public int timesShown = 0;

        private MessageCounter() {
        }
    }

    private class VersionMessage {
        public int id = -1;
        public int timesToShow = 1;
        public int importance = 1;
        public String[] minecraftVersions = new String[0];
        public String[] modVersions = new String[0];
        public String displayName = "";
        public String[] description = new String[0];
        public String modVersion = "";
        public String URL = "";

        private VersionMessage() {
        }
    }
}

