/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.worldgen;

import glenn.gasesframework.block.BlockGas;
import glenn.gasesframework.util.IVec;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenGas
extends WorldGenerator {
    private BlockGas minableBlock;
    private int minableBlockMetadata;
    private int blobs;
    private Block replacedBlock;
    private Map<IVec, Boolean> cache;

    public WorldGenGas(BlockGas block, int blockMetadata, int blobs) {
        this.minableBlock = block;
        this.minableBlockMetadata = blockMetadata;
        this.blobs = blobs;
        this.replacedBlock = Blocks.field_150348_b;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        this.minableBlock.cheapUpdateCalculation = true;
        this.cache = new HashMap<IVec, Boolean>();
        for (int i = 0; i < this.blobs; ++i) {
            int x2 = x + random.nextInt(this.blobs * 2 - 1) - this.blobs - 1;
            int y2 = y + random.nextInt(this.blobs * 2 - 1) - this.blobs - 1;
            int z2 = z + random.nextInt(this.blobs * 2 - 1) - this.blobs - 1;
            this.generatePart(world, random, x2, y2, z2, 16);
        }
        this.minableBlock.cheapUpdateCalculation = false;
        return true;
    }

    protected void generatePart(World world, Random random, int x, int y, int z, int numberOfBlocks) {
        float var6 = random.nextFloat() * (float)Math.PI;
        double var7 = (float)(x + 8) + MathHelper.func_76126_a((float)var6) * (float)numberOfBlocks / 8.0f;
        double var9 = (float)(x + 8) - MathHelper.func_76126_a((float)var6) * (float)numberOfBlocks / 8.0f;
        double var11 = (float)(z + 8) + MathHelper.func_76134_b((float)var6) * (float)numberOfBlocks / 8.0f;
        double var13 = (float)(z + 8) - MathHelper.func_76134_b((float)var6) * (float)numberOfBlocks / 8.0f;
        double var15 = y + random.nextInt(3) - 2;
        double var17 = y + random.nextInt(3) - 2;
        for (int var19 = 0; var19 <= numberOfBlocks; ++var19) {
            double var20 = var7 + (var9 - var7) * (double)var19 / (double)numberOfBlocks;
            double var22 = var15 + (var17 - var15) * (double)var19 / (double)numberOfBlocks;
            double var24 = var11 + (var13 - var11) * (double)var19 / (double)numberOfBlocks;
            double var26 = random.nextDouble() * (double)numberOfBlocks / 16.0;
            double var28 = (double)(MathHelper.func_76126_a((float)((float)var19 * (float)Math.PI / (float)numberOfBlocks)) + 1.0f) * var26 + 1.0;
            double var30 = (double)(MathHelper.func_76126_a((float)((float)var19 * (float)Math.PI / (float)numberOfBlocks)) + 1.0f) * var26 + 1.0;
            int var32 = MathHelper.func_76128_c((double)(var20 - var28 / 2.0));
            int var33 = MathHelper.func_76128_c((double)(var22 - var30 / 2.0));
            int var34 = MathHelper.func_76128_c((double)(var24 - var28 / 2.0));
            int var35 = MathHelper.func_76128_c((double)(var20 + var28 / 2.0));
            int var36 = MathHelper.func_76128_c((double)(var22 + var30 / 2.0));
            int var37 = MathHelper.func_76128_c((double)(var24 + var28 / 2.0));
            for (int var38 = var32; var38 <= var35; ++var38) {
                double var39 = ((double)var38 + 0.5 - var20) / (var28 / 2.0);
                if (!(var39 * var39 < 1.0)) continue;
                for (int var41 = var33; var41 <= var36; ++var41) {
                    double var42 = ((double)var41 + 0.5 - var22) / (var30 / 2.0);
                    if (!(var39 * var39 + var42 * var42 < 1.0)) continue;
                    for (int var44 = var34; var44 <= var37; ++var44) {
                        double var45 = ((double)var44 + 0.5 - var24) / (var28 / 2.0);
                        if (!(var39 * var39 + var42 * var42 + var45 * var45 < 1.0) || !this.isPlacementValid(world, var38, var41, var44)) continue;
                        world.func_147465_d(var38, var41, var44, (Block)this.minableBlock, this.minableBlockMetadata, 2);
                    }
                }
            }
        }
    }

    protected boolean isPlacementValid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null && !block.isReplaceableOreGen(world, x, y, z, this.replacedBlock)) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            int z2;
            int y2;
            int x2 = x + (i == 4 ? -1 : (i == 5 ? 1 : 0));
            if (!this.isInvalidBorderingBlock(world, x2, y2 = y + (i == 0 ? -1 : (i == 1 ? 1 : 0)), z2 = z + (i == 2 ? -1 : (i == 3 ? 1 : 0)))) continue;
            return false;
        }
        return true;
    }

    private boolean isInvalidBorderingBlock(World world, int x, int y, int z) {
        IVec vec = new IVec(x, y, z);
        Boolean b = this.cache.get(vec);
        if (b == null) {
            Block block = world.func_147439_a(x, y, z);
            b = block != this.minableBlock && (block == Blocks.field_150351_n || block == Blocks.field_150354_m || !world.func_147439_a(x, y, z).func_149662_c());
            this.cache.put(vec, b);
        }
        return b;
    }
}

