/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.tileentity;

import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityTank
extends TileEntity {
    public GasType containedType;
    public int amount = 0;
    public double[][] ps;
    public double[][] vs;
    private static Random rand = new Random();

    public TileEntityTank() {
        if (GasesFramework.fancyTank) {
            this.ps = new double[9][9];
            this.vs = new double[9][9];
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.amount = par1NBTTagCompound.func_74762_e("amount");
        int i = par1NBTTagCompound.func_74762_e("containedType");
        this.containedType = i == -1 ? null : GasType.gasTypes[i];
        if (GasesFramework.fancyTank) {
            double gasHeight = this.getGasCap() == 0 ? 0.0 : (double)this.amount / (double)this.getGasCap();
            for (double[] fs : this.ps) {
                Arrays.fill(fs, gasHeight);
            }
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("amount", this.amount);
        par1NBTTagCompound.func_74768_a("containedType", this.containedType != null ? this.containedType.gasIndex : -1);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    private double get(int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x > 8) {
            x = 8;
        }
        if (y < 0) {
            y = 0;
        } else if (y > 8) {
            y = 8;
        }
        return this.ps[x][y];
    }

    private void wobble(boolean up) {
        if (!GasesFramework.fancyTank) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                double[] dArray = this.vs[i];
                int n = j;
                dArray[n] = dArray[n] + (up ? -0.005 : 0.005) * (1.0 - rand.nextDouble() * 3.0);
            }
        }
    }

    public void func_145845_h() {
        int j;
        int i;
        if (!this.field_145850_b.field_72995_K || !GasesFramework.fancyTank) {
            return;
        }
        double gasHeight = this.getGasCap() == 0 ? 0.0 : (double)this.amount / (double)this.getGasCap();
        for (i = 0; i < 9; ++i) {
            j = 0;
            while (j < 9) {
                this.vs[i][j] = this.vs[i][j];
                double[] dArray = this.vs[i];
                int n = j;
                dArray[n] = dArray[n] + (gasHeight - this.ps[i][j]) * 0.4;
                double[] dArray2 = this.vs[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + (this.get(i - 1, j) + this.get(i, j + 1) + this.get(i + 1, j) + this.get(i, j - 1) - this.ps[i][j] * 4.0) * 0.05;
                double[] dArray3 = this.vs[i];
                int n3 = j;
                dArray3[n3] = dArray3[n3] + (this.get(i - 1, j) + this.get(i, j + 1) + this.get(i + 1, j) + this.get(i, j - 1) - this.ps[i][j] * 4.0) * 0.035355;
                double[] dArray4 = this.vs[i];
                int n4 = j++;
                dArray4[n4] = dArray4[n4] * 0.9;
            }
        }
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                double[] dArray = this.ps[i];
                int n = j;
                dArray[n] = dArray[n] + this.vs[i][j];
                if (this.ps[i][j] < 0.0) {
                    this.ps[i][j] = 0.0;
                    this.vs[i][j] = -this.vs[i][j];
                    continue;
                }
                if (!(this.ps[i][j] > 1.0)) continue;
                this.ps[i][j] = 1.0;
                this.vs[i][j] = -this.vs[i][j];
            }
        }
    }

    public int getGasCap() {
        if (this.containedType == null) {
            return 0;
        }
        return (64 - this.containedType.density) * 2 + 16;
    }

    public boolean increment(GasType gasType) {
        if (this.field_145850_b.field_72995_K) {
            return this.containedType == null | this.amount < this.getGasCap();
        }
        GasType prevGasType = this.containedType;
        if (gasType == GasesFramework.gasTypeAir) {
            return true;
        }
        if (this.containedType == null | this.containedType == gasType) {
            this.containedType = gasType;
            if (++this.amount <= this.getGasCap()) {
                this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, GasesFramework.gasTank, 0, this.amount);
                if (prevGasType != this.containedType) {
                    this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.containedType.gasIndex);
                }
                return true;
            }
            this.amount = this.getGasCap();
            return false;
        }
        return false;
    }

    public boolean decrement() {
        if (this.field_145850_b.field_72995_K) {
            return this.amount > 0;
        }
        GasType prevGasType = this.containedType;
        if (this.amount-- > 0) {
            if (this.amount == 0) {
                this.containedType = null;
            }
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, GasesFramework.gasTank, 0, this.amount);
            if (prevGasType != this.containedType) {
                this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.containedType == null ? -1 : this.containedType.gasIndex);
            }
            return true;
        }
        this.amount = 0;
        return false;
    }

    public boolean blockEvent(int eventID, int eventParam) {
        if (!this.field_145850_b.field_72995_K) {
            return true;
        }
        switch (eventID) {
            case 0: {
                if (this.amount < eventParam) {
                    this.wobble(true);
                } else if (this.amount > eventParam) {
                    this.wobble(false);
                }
                this.amount = eventParam;
                break;
            }
            case 1: {
                this.containedType = eventParam == -1 ? null : GasType.gasTypes[eventParam];
            }
        }
        return true;
    }
}

