/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.block;

import glenn.gasesframework.Combustibility;
import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.block.BlockLantern;
import glenn.gasesframework.block.IGasReceptor;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BlockLanternGas
extends BlockLantern
implements IGasReceptor {
    public final Combustibility combustibility;

    public BlockLanternGas(Combustibility combustibility) {
        super(combustibility.burnRate);
        this.combustibility = combustibility;
        combustibility.lanternBlock = this;
    }

    @Override
    public boolean receiveGas(World world, int x, int y, int z, int side, GasType gasType) {
        if (gasType == GasesFramework.gasTypeAir) {
            return true;
        }
        BlockLanternGas lanternBlock = gasType.combustibility.lanternBlock;
        if (lanternBlock != null && world.func_72805_g(x, y, z) == 0) {
            world.func_147449_b(x, y, z, (Block)lanternBlock);
            return true;
        }
        return false;
    }

    @Override
    public boolean connectToPipe() {
        return false;
    }

    @Override
    public ItemStack getContainedItemOut() {
        return new ItemStack(Items.field_151069_bo);
    }

    @Override
    public Block getExpirationBlock() {
        return GasesFramework.lanternGasEmpty;
    }

    @Override
    public ItemStack getContainedItemIn() {
        return null;
    }
}

