/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.block.BlockGasPipe;
import glenn.gasesframework.util.LanternRecipe;
import glenn.gasesframework.util.LanternRecipeGas;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockLantern
extends Block {
    public int tickrate;
    public IIcon topIcon;
    public IIcon sideIcon;
    public IIcon sideConnectedIcon;
    public IIcon connectorsIcon;
    protected static final ArrayList<LanternRecipe> lanternRecipes = new ArrayList();

    protected BlockLantern(int tickrate) {
        super(Material.field_151575_d);
        lanternRecipes.add(new LanternRecipeGas());
        this.tickrate = tickrate;
        this.func_149711_c(0.25f);
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.625f, 0.75f);
        if (tickrate > 0) {
            this.func_149675_a(true);
        }
    }

    protected BlockLantern(int tickrate, ItemStack containedItemIn) {
        this(tickrate);
        lanternRecipes.add(new LanternRecipe(containedItemIn, this));
        GasesFramework.queueLanternRecipe(this, containedItemIn);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.topIcon = iconRegister.func_94245_a("gasesFramework:lantern_top");
        this.sideIcon = iconRegister.func_94245_a("gasesFramework:lantern_side");
        this.sideConnectedIcon = iconRegister.func_94245_a("gasesFramework:lantern_side_connected");
        this.connectorsIcon = iconRegister.func_94245_a("gasesFramework:lantern_connectors");
    }

    public abstract Block getExpirationBlock();

    public abstract ItemStack getContainedItemOut();

    public abstract ItemStack getContainedItemIn();

    public boolean isValidInItem(ItemStack itemStack) {
        for (LanternRecipe lanternRecipe : lanternRecipes) {
            if (!lanternRecipe.equals(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (this.tickrate > 0) {
            int metadata = par1World.func_72805_g(par2, par3, par4);
            if (metadata <= 0) {
                par1World.func_147449_b(par2, par3, par4, this.getExpirationBlock());
            } else {
                par1World.func_72921_c(par2, par3, par4, metadata - 1, 3);
            }
        }
    }

    public int func_149738_a(World par1World) {
        return this.tickrate;
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        boolean isNotEqual;
        ItemStack inUse = par5EntityPlayer.func_71045_bC();
        ItemStack containedItem = this.getContainedItemIn();
        ItemStack ejectedItem = this.getContainedItemOut();
        boolean consumeItem = false;
        boolean blockAlreadyPlaced = false;
        boolean bl = ejectedItem == null | inUse == null || !(ejectedItem.func_77973_b() == inUse.func_77973_b() & ejectedItem.func_77960_j() == inUse.func_77960_j()) ? true : (isNotEqual = false);
        if (inUse != null) {
            BlockLantern lanternBlock = null;
            for (LanternRecipe lanternRecipe : lanternRecipes) {
                if (!lanternRecipe.equals(inUse)) continue;
                lanternBlock = lanternRecipe.getLantern(inUse);
                break;
            }
            if (lanternBlock != null) {
                consumeItem = true;
                par1World.func_147449_b(par2, par3, par4, lanternBlock);
                blockAlreadyPlaced = true;
            }
            if (consumeItem & isNotEqual && --inUse.field_77994_a <= 0) {
                par5EntityPlayer.func_71028_bD();
            }
        }
        if (ejectedItem != null & isNotEqual && !par5EntityPlayer.field_71071_by.func_70441_a(ejectedItem)) {
            this.func_149642_a(par1World, par2, par3, par4, ejectedItem);
        }
        if (!blockAlreadyPlaced) {
            par1World.func_147449_b(par2, par3, par4, (Block)GasesFramework.lanternEmpty);
        }
        return (ejectedItem != null | consumeItem) & isNotEqual;
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        if (this.tickrate != 0) {
            par1World.func_72921_c(par2, par3, par4, 15, 3);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return GasesFramework.renderBlockLanternID;
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        if (!this.func_149718_j(par1World, par2, par3, par4)) {
            this.func_149697_b(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
            par1World.func_147468_f(par2, par3, par4);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.isValidConnection(world, x - 1, y, z) || this.isValidConnection(world, x + 1, y, z) || this.isValidConnection(world, x, y - 1, z) || this.isValidConnection(world, x, y + 1, z) || this.isValidConnection(world, x, y, z - 1) || this.isValidConnection(world, x, y, z + 1);
    }

    public boolean isValidConnection(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.func_149662_c() || block instanceof BlockGasPipe;
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        return this.func_149718_j(par1World, par2, par3, par4);
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)this.getExpirationBlock());
    }

    public Item func_149694_d(World par1World, int par2, int par3, int par4) {
        return Item.func_150898_a((Block)this.getExpirationBlock());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        switch (side) {
            case 2: {
                return blockAccess.func_147439_a(x + 1, y, z) instanceof BlockGasPipe ? this.sideConnectedIcon : this.sideIcon;
            }
            case 3: {
                return blockAccess.func_147439_a(x - 1, y, z) instanceof BlockGasPipe ? this.sideConnectedIcon : this.sideIcon;
            }
            case 4: {
                return blockAccess.func_147439_a(x, y, z + 1) instanceof BlockGasPipe ? this.sideConnectedIcon : this.sideIcon;
            }
            case 5: {
                return blockAccess.func_147439_a(x, y, z - 1) instanceof BlockGasPipe ? this.sideConnectedIcon : this.sideIcon;
            }
        }
        return this.topIcon;
    }
}

