/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.block.IGasReceptor;
import glenn.gasesframework.block.ISample;
import glenn.gasesframework.tileentity.TileEntityPump;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockGasPump
extends Block
implements IGasReceptor,
ITileEntityProvider,
ISample {
    private static final int[] reindex = new int[]{1, 0, 5, 4, 3, 2};
    protected IIcon side;
    protected IIcon top;

    public BlockGasPump() {
        super(Material.field_151573_f);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return reindex[side];
    }

    public int func_149645_b() {
        return GasesFramework.renderBlockPumpID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.side = par1IconRegister.func_94245_a(this.func_149641_N() + "_side");
        this.top = par1IconRegister.func_94245_a(this.func_149641_N() + "_top");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        boolean flag = true;
        switch (par1) {
            case 0: 
            case 1: {
                flag = par2 == 0 | par2 == 1;
                break;
            }
            case 2: 
            case 3: {
                flag = par2 == 5 | par2 == 4;
                break;
            }
            case 4: 
            case 5: {
                flag = par2 == 3 | par2 == 2;
            }
        }
        return flag ? this.top : this.side;
    }

    @Override
    public boolean receiveGas(World world, int x, int y, int z, int side, GasType gasType) {
        if (world.func_72805_g(x, y, z) != GasesFramework.reverseDirection(side)) {
            TileEntityPump tileEntity = (TileEntityPump)world.func_147438_o(x, y, z);
            if (tileEntity == null) {
                return false;
            }
            if (tileEntity.acceptsType(gasType) & tileEntity.containedType == null) {
                tileEntity.containedType = gasType;
                tileEntity.pumpTime = 1;
                return true;
            }
            return false;
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPump();
    }

    @Override
    public GasType sampleInteraction(World world, int x, int y, int z, GasType in, boolean excludes) {
        TileEntityPump tileEntity = (TileEntityPump)world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return in;
        }
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        if (!world.field_72995_K) {
            tileEntity.excludes = excludes;
            tileEntity.filterType = in;
        }
        return in;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventID, int eventParam) {
        TileEntityPump tileEntity = (TileEntityPump)world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return false;
        }
        return tileEntity.blockEvent(eventID, eventParam);
    }

    @Override
    public boolean connectToPipe() {
        return true;
    }
}

