/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases.entity;

import glenn.gases.entity.EntityFX;
import glenn.gasesframework.GasesFramework;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class EntityDust
extends EntityFX {
    private static final ResourceLocation texture = new ResourceLocation("gases:textures/effects/dust.png");
    protected EntityLivingBase thrower;

    public EntityDust(World world) {
        super(world);
    }

    public EntityDust(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityDust(World world, EntityLivingBase thrower) {
        this(world);
        this.thrower = thrower;
        this.func_70107_b(thrower.field_70165_t - (double)(MathHelper.func_76134_b((float)(thrower.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f), thrower.field_70163_u + (double)thrower.func_70047_e(), thrower.field_70161_v - (double)(MathHelper.func_76126_a((float)(thrower.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f));
        double rx = this.field_70146_Z.nextDouble() - 0.5;
        double ry = this.field_70146_Z.nextDouble() - 0.5;
        double rz = this.field_70146_Z.nextDouble() - 0.5;
        double n = Math.sqrt(rx * rx + ry * ry + rz * rz) * 2.0 / this.field_70146_Z.nextDouble();
        double d = 0.8;
        this.field_70159_w = (double)(-MathHelper.func_76126_a((float)(thrower.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(thrower.field_70125_A / 180.0f * (float)Math.PI))) * d + thrower.field_70159_w + rx / n;
        this.field_70179_y = (double)(MathHelper.func_76134_b((float)(thrower.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(thrower.field_70125_A / 180.0f * (float)Math.PI))) * d + thrower.field_70179_y + rz / n;
        this.field_70181_x = (double)(-MathHelper.func_76126_a((float)(thrower.field_70125_A / 180.0f * (float)Math.PI))) * d + thrower.field_70181_x + ry / n;
        this.maxLifetime = 50 + this.field_70146_Z.nextInt(50);
    }

    public abstract Block getReactiveBlock();

    public abstract ItemStack getResult();

    public void onInGas() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)this.field_70163_u), z = MathHelper.func_76128_c((double)this.field_70161_v)) == this.getReactiveBlock()) {
            if (this.field_70146_Z.nextInt(24) < 16 - this.field_70170_p.func_72805_g(x, y, z)) {
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.getResult()));
            }
            this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    @Override
    public double getScale(float partialTick) {
        return 0.1 + (double)((float)this.lifetime + partialTick) / 500.0;
    }

    @Override
    public void func_70071_h_() {
        this.field_70159_w *= 0.9;
        this.field_70181_x = this.field_70181_x * 0.9 + 0.001;
        this.field_70179_y *= 0.9;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70055_a(GasesFramework.gasMaterial)) {
            this.onInGas();
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return texture;
    }

    @Override
    protected boolean isServerSide() {
        return true;
    }
}

