/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.block;

import glenn.gasesframework.Combustibility;
import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.block.ISample;
import glenn.gasesframework.reaction.Reaction;
import glenn.gasesframework.reaction.ReactionEmpty;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGas
extends Block
implements ISample {
    public GasType type;
    private static final int[] ringsX = new int[]{1, 0, -1, 0, 1, -1, -1, 1, 2, 0, -2, 0};
    private static final int[] ringsZ = new int[]{0, 1, 0, -1, 1, 1, -1, -1, 0, 2, 0, -2};
    private static final int[] ringX = new int[]{0, 0, -1, 1, 0, 0};
    private static final int[] ringY = new int[]{-1, 1, 0, 0, 0, 0};
    private static final int[] ringZ = new int[]{0, 0, 0, 0, -1, 1};
    private static final int[] movesX = new int[]{1, 0, -1, 0, 1, -1, -1, 1, 1, 0, -1, 0};
    private static final int[] movesZ = new int[]{0, 1, 0, -1, 1, 1, -1, -1, 0, 1, 0, -1};
    public boolean cheapUpdateCalculation = false;

    public BlockGas() {
        super(GasesFramework.gasMaterial);
        this.func_149675_a(true);
        this.func_149649_H();
        this.func_149711_c(0.0f);
        this.func_149658_d("gasesframework:gas");
    }

    public AxisAlignedBB func_149633_g(World world, int i, int j, int k) {
        int metadata = world.func_72805_g(i, j, k);
        double minY = this.getMinY((IBlockAccess)world, i, j, k, metadata);
        double maxY = this.getMaxY((IBlockAccess)world, i, j, k, metadata);
        return AxisAlignedBB.func_72332_a().func_72299_a((double)i, (double)j + minY, (double)k, (double)i + 1.0, (double)j + maxY, (double)k + 1.0);
    }

    public void func_149670_a(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        this.type.onTouched(par5Entity);
    }

    public int func_149720_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return this.type.color;
    }

    public int func_149741_i(int metadata) {
        return this.type.color;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149678_a(int par1, boolean par2) {
        return par2 && par1 == 0;
    }

    public boolean func_149747_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return false;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int i, int j, int k, int side) {
        int yDirection;
        int xDirection;
        int n = side == 4 ? 1 : (xDirection = side == 5 ? -1 : 0);
        int n2 = side == 0 ? 1 : (yDirection = side == 1 ? -1 : 0);
        int zDirection = side == 2 ? 1 : (side == 3 ? -1 : 0);
        int metadata = blockAccess.func_72805_g(i, j, k);
        Block directionBlock = blockAccess.func_147439_a(i + xDirection, j + yDirection, k + zDirection);
        int directionBlockMetadata = blockAccess.func_72805_g(i + xDirection, j + yDirection, k + zDirection);
        if (side == 1) {
            if (directionBlock instanceof BlockGas) {
                double maxY = ((BlockGas)directionBlock).getMaxY(blockAccess, i, j, k, directionBlockMetadata);
                return maxY - 1.0 != this.getMinY(blockAccess, i, j, k, metadata);
            }
            return true;
        }
        if (side == 0) {
            if (directionBlock instanceof BlockGas) {
                double minY = ((BlockGas)directionBlock).getMinY(blockAccess, i, j, k, directionBlockMetadata);
                return minY != this.getMaxY(blockAccess, i, j, k, metadata) - 1.0;
            }
            return true;
        }
        return true;
    }

    public final double sideIndent(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return par1IBlockAccess.func_147439_a(par2, par3, par4).func_149662_c() ? 0.001 : 0.0;
    }

    public double getMinY(IBlockAccess blockAccess, int i, int j, int k, int metadata) {
        if (this.type.density > 0) {
            return 0.0;
        }
        if (this.type.density < 0) {
            return (double)metadata / 16.0;
        }
        if (blockAccess.func_147439_a(i, j - 1, k) == this) {
            return 0.0;
        }
        boolean b = blockAccess.func_147439_a(i, j + 1, k) == this;
        double d = (0.5 - (double)(16 - metadata) / 8.0) * (b ? 2.0 : 1.0);
        return d < 0.0 ? 0.0 : d;
    }

    public double getMaxY(IBlockAccess blockAccess, int i, int j, int k, int metadata) {
        if (this.type.density > 0) {
            return 1.0 - (double)metadata / 16.0;
        }
        if (this.type.density < 0) {
            return 1.0;
        }
        if (blockAccess.func_147439_a(i, j + 1, k) == this) {
            return 1.0;
        }
        boolean b = blockAccess.func_147439_a(i, j - 1, k) == this;
        double d = 1.0 - (0.5 - (double)(16 - metadata) / 8.0) * (b ? 2.0 : 1.0);
        return d > 1.0 ? 1.0 : d;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public int func_149645_b() {
        return GasesFramework.renderBlockGasID;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public int func_149738_a(World par1World) {
        return 5;
    }

    public int func_149701_w() {
        return 1;
    }

    protected void onEvaporated(World world, int i, int j, int k) {
    }

    public boolean onFire(World world, int i, int j, int k, Random random, int metadata) {
        if (this.type.combustibility.explosionPower > 0.0f) {
            if (!world.field_72995_K) {
                float power = (16.0f - (float)metadata) / 16.0f + 0.25f;
                world.func_147468_f(i, j, k);
                world.func_72876_a(null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, this.type.combustibility.explosionPower * GasesFramework.gasExplosionFactor * power, true);
            }
            return true;
        }
        if (this.type.combustibility.fireSpreadRate >= 0) {
            world.func_147465_d(i, j, k, (Block)GasesFramework.gasFire, metadata, 3);
            return true;
        }
        return false;
    }

    private void mixEqualSortedValues(Random rand, int[] valueList, int[] indexList) {
        int i = 0;
        block0: while (i < valueList.length) {
            int value = valueList[i];
            int j = 1;
            while (j + i <= valueList.length) {
                if (j + i >= valueList.length || valueList[i + j] != value) {
                    int amountOfSwaps = (j - 1) * (j - 1) * 2;
                    for (int k = 0; k < amountOfSwaps; ++k) {
                        int pos2;
                        int pos1 = rand.nextInt(j);
                        if (pos1 == (pos2 = rand.nextInt(j))) continue;
                        int temp = indexList[i + pos1];
                        indexList[i + pos1] = indexList[i + pos2];
                        indexList[i + pos2] = temp;
                    }
                    i += j;
                    continue block0;
                }
                ++j;
            }
        }
    }

    private void fillArrayWithIndices(Random rand, int[] indices, int length, int start, int arrayTranslate) {
        for (int i = 0; i < length; ++i) {
            int index;
            while (indices[index = arrayTranslate + rand.nextInt(length)] != 0) {
            }
            indices[index] = start + i;
        }
    }

    private void reactionsWithSurroundingBlocks(World world, int x, int y, int z, Reaction[] reactions, int[] reactionIndices, Random random) {
        int[] indices = new int[6];
        this.fillArrayWithIndices(random, indices, 6, 0, 0);
        block0: for (int index = 0; index < reactions.length; ++index) {
            int i = indices[index];
            int xDirection = x + (i < 2 ? i * 2 - 1 : 0);
            int yDirection = y + (i < 4 & i >= 2 ? i * 2 - 5 : 0);
            int zDirection = z + (i >= 4 ? i * 2 - 9 : 0);
            Block directionBlock = world.func_147439_a(xDirection, yDirection, zDirection);
            Reaction reaction = GasesFramework.getReactionForBlocks(world, this, x, y, z, directionBlock, xDirection, yDirection, zDirection);
            for (int j = 0; j < reactions.length; ++j) {
                Reaction reaction2 = reactions[j];
                if (reaction2 == null) {
                    reactions[j] = reaction;
                    reactionIndices[j] = i;
                    continue block0;
                }
                if (reaction2.priority >= reaction.priority) continue;
                for (int k = index - 1; k >= j; --k) {
                    reactions[k + 1] = reactions[k];
                    reactionIndices[k + 1] = reactionIndices[k];
                }
                reactions[j] = reaction;
                reactionIndices[j] = i;
                continue block0;
            }
        }
    }

    protected int getDelayForUpdate(World world, int x, int y, int z) {
        Reaction reaction = new ReactionEmpty();
        int delay = -1;
        for (int i = 0; i < 6; ++i) {
            int xDirection = x + (i < 2 ? i * 2 - 1 : 0);
            int yDirection = y + (i < 4 & i >= 2 ? i * 2 - 5 : 0);
            int zDirection = z + (i >= 4 ? i * 2 - 9 : 0);
            Block directionBlock = world.func_147439_a(xDirection, yDirection, zDirection);
            Reaction reaction2 = GasesFramework.getReactionForBlocks(world, this, x, y, z, directionBlock, xDirection, yDirection, zDirection);
            if (!reaction.isErroneous() && reaction2.priority >= reaction.priority) continue;
            reaction = reaction2;
            delay = reaction.getDelay(world, x, y, z, xDirection, yDirection, zDirection);
        }
        if (delay == -1) {
            return this.getDelayForUpdateByDensity();
        }
        return delay;
    }

    protected int getDelayForUpdateByDensity() {
        if (this.type.density > 0) {
            return (int)(128.0f / (float)this.type.density);
        }
        if (this.type.density < 0) {
            return (int)(-128.0f / (float)this.type.density);
        }
        return 8;
    }

    public void func_149674_a(World world, int par2, int par3, int par4, Random random) {
        boolean requiresTick;
        if (!world.field_73011_w.field_76575_d & par3 > GasesFramework.maxGasHeight) {
            world.func_147449_b(par2, par3, par4, Blocks.field_150350_a);
            return;
        }
        Reaction[] reactions = new Reaction[6];
        int[] reactionIndices = new int[6];
        this.reactionsWithSurroundingBlocks(world, par2, par3, par4, reactions, reactionIndices, random);
        for (int i = 0; i < reactions.length; ++i) {
            int zDirection;
            int index = reactionIndices[i];
            int xDirection = index < 2 ? index * 2 - 1 : 0;
            int yDirection = index < 4 & index >= 2 ? index * 2 - 5 : 0;
            int n = zDirection = index >= 4 ? index * 2 - 9 : 0;
            if (!reactions[i].reactIfPossible(world, random, par2, par3, par4, par2 + xDirection, par3 + yDirection, par4 + zDirection)) continue;
            return;
        }
        int metadata = 16 - world.func_72805_g(par2, par3, par4) - this.getGasDecay(world, par2, par3, par4, random);
        boolean bl = requiresTick = this.type.evaporationRate > 0;
        if (metadata <= 0) {
            world.func_147468_f(par2, par3, par4);
            this.onEvaporated(world, par2, par3, par4);
            return;
        }
        if (this.type.density == 0) {
            int i;
            int[] metadataList = new int[6];
            int[] priorityList = new int[6];
            int surroundingAirBlocks = 0;
            int totalFlow = 0;
            int prevMetadata = metadata;
            block1: for (i = 0; i < 6; ++i) {
                int direction2BlockMetadata;
                int xDirection = ringX[i];
                int yDirection = ringY[i];
                int zDirection = ringZ[i];
                Block direction2Block = world.func_147439_a(par2 + xDirection, par3 + yDirection, par4 + zDirection);
                if (this.canForcefullyFlowInto(direction2Block, direction2BlockMetadata = 16 - world.func_72805_g(par2 + xDirection, par3 + yDirection, par4 + zDirection), prevMetadata)) {
                    direction2BlockMetadata = -1;
                    ++surroundingAirBlocks;
                    totalFlow += 8;
                } else if (direction2Block != this) {
                    direction2BlockMetadata = 17;
                } else if (direction2BlockMetadata < metadata - 1) {
                    totalFlow += (metadata - direction2BlockMetadata) / 2;
                }
                for (int j = 0; j < 6; ++j) {
                    if (metadataList[j] <= direction2BlockMetadata & j != i) continue;
                    for (int k = 4; k >= j; --k) {
                        metadataList[k + 1] = metadataList[k];
                        priorityList[k + 1] = priorityList[k];
                    }
                    metadataList[j] = direction2BlockMetadata;
                    priorityList[j] = i;
                    continue block1;
                }
            }
            this.mixEqualSortedValues(random, metadataList, priorityList);
            i = 0;
            while (i < 6 & metadata > 1) {
                int j = priorityList[i];
                int direction2BlockMetadata = metadataList[i];
                int xDirection = ringX[j];
                int yDirection = ringY[j];
                int zDirection = ringZ[j];
                if (direction2BlockMetadata != 17) {
                    int transaction;
                    int flow;
                    if (direction2BlockMetadata == -1) {
                        flow = prevMetadata / 2;
                        transaction = flow * 16 / (totalFlow + 8);
                        if (transaction < 1) {
                            transaction = 1;
                        }
                        world.func_147465_d(par2 + xDirection, par3 + yDirection, par4 + zDirection, (Block)this, 16 - transaction, 3);
                        requiresTick = false;
                        metadata -= transaction;
                    } else if (direction2BlockMetadata < 16 & direction2BlockMetadata + 1 < metadata) {
                        flow = (prevMetadata - direction2BlockMetadata) / 2;
                        transaction = flow * 16 / (totalFlow + 8);
                        if (transaction < 1) {
                            transaction = 1;
                        }
                        world.func_72921_c(par2 + xDirection, par3 + yDirection, par4 + zDirection, 16 - direction2BlockMetadata - transaction, 3);
                        requiresTick = false;
                        metadata -= transaction;
                    }
                }
                ++i;
            }
            if (metadata > 0) {
                world.func_72921_c(par2, par3, par4, 16 - metadata, 3);
            } else {
                world.func_147468_f(par2, par3, par4);
            }
            if (requiresTick) {
                world.func_147464_a(par2, par3, par4, (Block)this, 10);
            }
            return;
        }
        int yDirection = this.type.density > 0 ? -1 : 1;
        Block directionBlock = world.func_147439_a(par2, par3 + yDirection, par4);
        int directionBlockMetadata = 16 - world.func_72805_g(par2, par3 + yDirection, par4);
        Block reverseDirectionBlock = world.func_147439_a(par2, par3 - yDirection, par4);
        int reverseDirectionBlockMetadata = 16 - world.func_72805_g(par2, par3 - yDirection, par4);
        if (this.canForcefullyFlowInto(directionBlock, directionBlockMetadata, metadata)) {
            if (metadata > 0) {
                world.func_147465_d(par2, par3 + yDirection, par4, (Block)this, 16 - metadata, 3);
            }
            world.func_147468_f(par2, par3, par4);
        } else {
            int directionBlockDensity;
            if (directionBlock != this && directionBlock instanceof BlockGas && this.type.density > 0 & this.type.density > (directionBlockDensity = ((BlockGas)directionBlock).type.density) | this.type.density < 0 & this.type.density < directionBlockDensity) {
                world.func_147465_d(par2, par3, par4, directionBlock, 16 - directionBlockMetadata, 3);
                world.func_147465_d(par2, par3 + yDirection, par4, (Block)this, 16 - metadata, 3);
                return;
            }
            if (directionBlock == this && directionBlockMetadata < 16) {
                if (directionBlockMetadata + metadata < 16) {
                    world.func_147468_f(par2, par3, par4);
                    world.func_72921_c(par2, par3 + yDirection, par4, 16 - directionBlockMetadata - metadata, 3);
                    return;
                }
                world.func_72921_c(par2, par3, par4, 32 - directionBlockMetadata - metadata, 3);
                world.func_72921_c(par2, par3 + yDirection, par4, 0, 3);
                metadata -= 16 - directionBlockMetadata;
            }
            if (reverseDirectionBlock == this) {
                metadata += reverseDirectionBlockMetadata;
            }
            int[] metadataList = new int[4];
            int[] priorityList = new int[4];
            int surroundingAirBlocks = 0;
            int totalFlow = 0;
            int prevMetadata = metadata;
            block5: for (int i = 0; i < 4; ++i) {
                int direction2BlockMetadata;
                int xDirection = ringsX[i];
                int zDirection = ringsZ[i];
                Block direction2Block = world.func_147439_a(par2 + xDirection, par3, par4 + zDirection);
                if (this.canForcefullyFlowInto(direction2Block, direction2BlockMetadata = 16 - world.func_72805_g(par2 + xDirection, par3, par4 + zDirection), prevMetadata)) {
                    direction2BlockMetadata = -1;
                    ++surroundingAirBlocks;
                    totalFlow += 8;
                } else if (direction2Block != this) {
                    direction2BlockMetadata = 17;
                } else if (direction2BlockMetadata < metadata - 1) {
                    int flow = (metadata - direction2BlockMetadata) / 2;
                    if (direction2BlockMetadata + flow > 16) {
                        flow = 16 - direction2BlockMetadata;
                    }
                    totalFlow += flow;
                }
                for (int j = 0; j < 4; ++j) {
                    if (metadataList[j] <= direction2BlockMetadata & j != i) continue;
                    for (int k = 2; k >= j; --k) {
                        metadataList[k + 1] = metadataList[k];
                        priorityList[k + 1] = priorityList[k];
                    }
                    metadataList[j] = direction2BlockMetadata;
                    priorityList[j] = i;
                    continue block5;
                }
            }
            this.mixEqualSortedValues(random, metadataList, priorityList);
            if (metadata < surroundingAirBlocks + 2) {
                int[] indices = new int[ringsX.length];
                this.fillArrayWithIndices(random, indices, 4, 0, 0);
                this.fillArrayWithIndices(random, indices, 4, 4, 4);
                this.fillArrayWithIndices(random, indices, 4, 8, 8);
                for (int index = 0; index < indices.length; ++index) {
                    int direction3BlockMetadata;
                    Block direction3Block;
                    int direction2BlockMetadata;
                    int i = indices[index];
                    int x = par2 + ringsX[i];
                    int z = par4 + ringsZ[i];
                    Block direction2Block = world.func_147439_a(x, par3, z);
                    if (!this.canForcefullyFlowInto(direction2Block, direction2BlockMetadata = world.func_72805_g(x, par3, z), prevMetadata) || !this.canForcefullyFlowInto(direction3Block = world.func_147439_a(x, par3 + yDirection, z), direction3BlockMetadata = world.func_72805_g(x, par3 + yDirection, z), prevMetadata) && (direction3Block != this || metadata - world.func_72805_g(x, par3 + yDirection, z) > 0)) continue;
                    if (i >= 8) {
                        Block direction4Block = world.func_147439_a(par2 + movesX[i], par3, par4 + movesZ[i]);
                        int direction4BlockMetadata = world.func_72805_g(par2 + movesX[i], par3, par4 + movesZ[i]);
                        if (!this.canForcefullyFlowInto(world, par2 + movesX[i], par3, par4 + movesZ[i], prevMetadata)) {
                            continue;
                        }
                    } else if (i >= 4 && !this.canForcefullyFlowInto(world, par2 + movesX[i], par3, par4, prevMetadata) && !this.canForcefullyFlowInto(world, par2, par3, par4 + movesZ[i], prevMetadata)) continue;
                    world.func_147468_f(par2, par3, par4);
                    if (metadata > 0) {
                        world.func_147465_d(par2 + movesX[i], par3, par4 + movesZ[i], (Block)this, 16 - metadata, 3);
                    }
                    return;
                }
            }
            int i = 0;
            while (i < 4 & metadata > 1) {
                int j = priorityList[i];
                int direction2BlockMetadata = metadataList[i];
                int xDirection = ringsX[j];
                int zDirection = ringsZ[j];
                if (direction2BlockMetadata != 17) {
                    int transaction;
                    int flow;
                    if (direction2BlockMetadata == -1) {
                        flow = prevMetadata / 2;
                        transaction = flow * 16 / (totalFlow + 8);
                        if (direction2BlockMetadata + transaction > 16) {
                            transaction = 16 - direction2BlockMetadata;
                        } else if (transaction < 1) {
                            transaction = 1;
                        }
                        world.func_147465_d(par2 + xDirection, par3, par4 + zDirection, (Block)this, 16 - transaction, 3);
                        requiresTick = false;
                        metadata -= transaction;
                    } else if (direction2BlockMetadata < 16 & direction2BlockMetadata + 1 < metadata) {
                        flow = (prevMetadata - direction2BlockMetadata) / 2;
                        transaction = flow * 16 / (totalFlow + 8);
                        if (direction2BlockMetadata + transaction > 16) {
                            transaction = 16 - direction2BlockMetadata;
                        } else if (transaction < 1) {
                            transaction = 1;
                        }
                        world.func_72921_c(par2 + xDirection, par3, par4 + zDirection, 16 - direction2BlockMetadata - transaction, 3);
                        requiresTick = false;
                        metadata -= transaction;
                    }
                }
                ++i;
            }
            if (metadata > 16) {
                world.func_72921_c(par2, par3, par4, 0, 3);
                if (reverseDirectionBlock == this) {
                    world.func_72921_c(par2, par3 - yDirection, par4, 32 - metadata, 3);
                }
            } else {
                if (reverseDirectionBlock == this) {
                    world.func_147468_f(par2, par3 - yDirection, par4);
                }
                if (metadata > 0) {
                    world.func_72921_c(par2, par3, par4, 16 - metadata, 3);
                } else {
                    world.func_147468_f(par2, par3, par4);
                }
            }
        }
        if (requiresTick) {
            world.func_147464_a(par2, par3, par4, (Block)this, this.getDelayForUpdate(world, par2, par3, par4));
        }
    }

    public int getGasDecay(World par1World, int par2, int par3, int par4, Random par5Random) {
        return this.type.evaporationRate > 0 && par5Random.nextInt(this.type.evaporationRate) == 0 ? 1 : 0;
    }

    protected boolean canForcefullyFlowInto(World world, int i, int j, int k, int thisMetadata) {
        return this.canForcefullyFlowInto(world.func_147439_a(i, j, k), world.func_72805_g(i, j, k), thisMetadata);
    }

    protected boolean canForcefullyFlowInto(Block block, int otherMetadata, int thisMetadata) {
        return block == Blocks.field_150350_a || block instanceof BlockGas && ((BlockGas)block).type.canBeDestroyedBy(this.type, otherMetadata, thisMetadata);
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        par1World.func_147464_a(par2, par3, par4, (Block)this, this.cheapUpdateCalculation ? this.getDelayForUpdateByDensity() : this.getDelayForUpdate(par1World, par2, par3, par4));
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        this.func_149726_b(par1World, par2, par3, par4);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        this.onFire(world, x, y, z, world.field_73012_v, world.func_72805_g(x, y, z));
    }

    public boolean func_149698_L() {
        return false;
    }

    public boolean canCombustNormally() {
        return this.type.combustibility.burnRate >= Combustibility.FLAMMABLE.burnRate;
    }

    @Override
    public GasType sampleInteraction(World world, int x, int y, int z, GasType in, boolean excludes) {
        return this.type;
    }
}

