/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework;

import cpw.mods.fml.common.registry.GameRegistry;
import glenn.gasesframework.Combustibility;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.block.BlockGas;
import glenn.gasesframework.block.BlockGasPipe;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;

public class GasType {
    public static final GasType[] gasTypes = new GasType[256];
    public final BlockGas gasBlock;
    public final BlockGasPipe gasPipe;
    public final int gasIndex;
    public final String name;
    public final int color;
    public final int opacity;
    public final int density;
    public final Combustibility combustibility;
    public int evaporationRate;
    public float damage;
    public int blindnessRate;
    public int suffocationRate;
    public int slownessRate;
    public ResourceLocation overlayImage;

    public GasType(BlockGas gasBlock, BlockGasPipe gasPipe, int gasIndex, String name, int color, int opacity, int density, Combustibility combustibility) {
        this.gasBlock = gasBlock;
        this.gasPipe = gasPipe;
        this.gasIndex = gasIndex;
        this.name = name;
        this.color = color;
        this.opacity = opacity;
        this.density = density;
        this.combustibility = combustibility;
        this.evaporationRate = 0;
        this.damage = 0.0f;
        this.blindnessRate = -4;
        this.suffocationRate = -16;
        this.slownessRate = -32;
        this.overlayImage = GasesFramework.gasOverlayImage;
        if (gasBlock != null) {
            gasBlock.type = this;
            gasBlock.func_149713_g(opacity);
        }
        if (gasPipe != null) {
            gasPipe.type = this;
        }
        if (gasBlock != null & (combustibility.fireSpreadRate >= 0 | combustibility.explosionPower > 0.0f)) {
            Blocks.field_150480_ab.setFireInfo((Block)gasBlock, 1000, 1000);
        }
        if (combustibility.lanternBlock != null) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)combustibility.lanternBlock), (Object[])new Object[]{new ItemStack((Block)GasesFramework.lanternEmpty), new ItemStack(GasesFramework.gasBottle, 1, gasIndex)});
        }
        if (gasTypes[gasIndex] != null) {
            System.out.println("A gas named " + name + " has overridden a gas at gas index " + gasIndex);
        }
        GasType.gasTypes[gasIndex] = this;
    }

    public GasType(BlockGas gasBlock, int gasIndex, String name, int color, int opacity, int density, Combustibility combustibility) {
        this(gasBlock, null, gasIndex, name, color, opacity, density, combustibility);
    }

    public GasType setEffectRates(int blindness, int suffocation, int slowness) {
        this.blindnessRate = blindness;
        this.suffocationRate = suffocation;
        this.slownessRate = slowness;
        if (this.blindnessRate <= 0) {
            this.blindnessRate = -4;
        }
        if (this.suffocationRate <= 0) {
            this.suffocationRate = -16;
        }
        if (this.slownessRate <= 0) {
            this.slownessRate = -32;
        }
        return this;
    }

    public GasType setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public GasType setEvaporationRate(int evaporation) {
        this.evaporationRate = evaporation;
        return this;
    }

    public ItemStack getBottledItem() {
        return new ItemStack(GasesFramework.gasBottle, 1, this.gasIndex);
    }

    public void onBreathed(EntityLivingBase entity) {
        entity.func_70097_a(GasesFramework.asphyxiationDamageSource, 1.0f);
    }

    public void onTouched(Entity entity) {
        if (this.damage > 0.0f & !(entity instanceof EntityItem)) {
            entity.func_70097_a(DamageSource.field_76377_j, this.damage);
        }
    }

    public boolean isIndustrial() {
        return this.gasPipe != null;
    }

    public boolean canBeDestroyedBy(GasType type, int thisMetadata, int otherMetadata) {
        return false;
    }

    public GasType setOverlayImage(ResourceLocation overlayImage) {
        this.overlayImage = overlayImage;
        return this;
    }

    public ResourceLocation getOverlayImage() {
        return this.overlayImage;
    }

    public String getUnlocalizedName() {
        return "gf_gas." + this.name;
    }
}

