/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.block;

import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.block.IGasInterface;
import glenn.gasesframework.block.IGasReceptor;
import glenn.gasesframework.block.IGasSource;
import glenn.gasesframework.util.PipeBranch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGasPipe
extends Block
implements IGasReceptor {
    private static final int[] xDirection = new int[]{0, 0, 1, -1, 0, 0};
    private static final int[] yDirection = new int[]{-1, 1, 0, 0, 0, 0};
    private static final int[] zDirection = new int[]{0, 0, 0, 0, 1, -1};
    public GasType type;
    public IIcon connectorsIcon;
    public IIcon endIcon;

    public BlockGasPipe() {
        super(Material.field_151575_d);
        if (!GasesFramework.MECHANICAL_ITEMS_ENCOURAGED()) {
            throw new RuntimeException("A gas pipe block was created while mechanical items were not encouraged. Please put GasesFramework.ENCOURAGE_MECHANICAL_ITEMS() in the mod's static initalizer.");
        }
        this.func_149711_c(0.25f);
        this.func_149658_d("gasesframework:pipe_iron");
        this.func_149672_a(Block.field_149769_e);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.connectorsIcon = iconRegister.func_94245_a(this.func_149641_N() + "_connectors");
        this.endIcon = iconRegister.func_94245_a(this.func_149641_N() + "_end");
    }

    public boolean[] getRenderConnectionArray(IBlockAccess blockAccess, int x, int y, int z) {
        boolean[] sidePipe = new boolean[6];
        boolean[] renderConnections = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            int x1 = x + xDirection[i];
            int y1 = y + yDirection[i];
            int z1 = z + zDirection[i];
            Block directionBlock = blockAccess.func_147439_a(x1, y1, z1);
            sidePipe[i] = IGasInterface.class.isAssignableFrom(directionBlock.getClass()) ? ((IGasInterface)directionBlock).connectToPipe() : false;
        }
        boolean collectionAll = sidePipe[0] || sidePipe[1] || sidePipe[2] || sidePipe[3] || sidePipe[4] || sidePipe[5];
        boolean collectionY = sidePipe[2] || sidePipe[3] || sidePipe[4] || sidePipe[5];
        boolean collectionX = sidePipe[0] || sidePipe[1] || sidePipe[4] || sidePipe[5];
        boolean collectionZ = sidePipe[0] || sidePipe[1] || sidePipe[2] || sidePipe[3];
        renderConnections[0] = (sidePipe[3] | !collectionX) & collectionAll;
        renderConnections[1] = (sidePipe[2] | !collectionX) & collectionAll;
        renderConnections[2] = (sidePipe[0] | !collectionY) & collectionAll;
        renderConnections[3] = (sidePipe[1] | !collectionY) & collectionAll;
        renderConnections[4] = (sidePipe[5] | !collectionZ) & collectionAll;
        renderConnections[5] = (sidePipe[4] | !collectionZ) & collectionAll;
        return renderConnections;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        boolean[] renderConnections = this.getRenderConnectionArray((IBlockAccess)world, x, y, z);
        float f1 = 0.375f;
        float f2 = 0.625f;
        float minX = renderConnections[0] ? 0.0f : f1;
        float maxX = renderConnections[1] ? 1.0f : f2;
        float minY = renderConnections[2] ? 0.0f : f1;
        float maxY = renderConnections[3] ? 1.0f : f2;
        float minZ = renderConnections[4] ? 0.0f : f1;
        float maxZ = renderConnections[5] ? 1.0f : f2;
        this.func_149676_a(f1, f1, minZ, f2, f2, maxZ);
        super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
        this.func_149676_a(f1, minY, f1, f2, maxY, f2);
        super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
        this.func_149676_a(minX, f1, f1, maxX, f2, f2);
        super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
        this.func_149719_a((IBlockAccess)world, x, y, z);
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        boolean[] renderConnections = this.getRenderConnectionArray(blockAccess, x, y, z);
        float f1 = 0.375f;
        float f2 = 0.625f;
        float minX = renderConnections[0] ? 0.0f : f1;
        float maxX = renderConnections[1] ? 1.0f : f2;
        float minY = renderConnections[2] ? 0.0f : f1;
        float maxY = renderConnections[3] ? 1.0f : f2;
        float minZ = renderConnections[4] ? 0.0f : f1;
        float maxZ = renderConnections[5] ? 1.0f : f2;
        this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private void fillArrayWithIndices(Random rand, int[] indices, int length, int start, int arrayTranslate) {
        for (int i = 0; i < length; ++i) {
            int index;
            while (indices[index = arrayTranslate + rand.nextInt(length)] != 0) {
            }
            indices[index] = start + i;
        }
    }

    private void shuffleArray(Random random, PipeBranch[] array, int limit) {
        for (int i = limit; i > 0; --i) {
            int otherIndex = random.nextInt(i + 1);
            PipeBranch pipeBranch = array[otherIndex];
            array[otherIndex] = array[i];
            array[i] = pipeBranch;
        }
    }

    @Override
    public boolean receiveGas(World world, int x, int y, int z, int side, GasType gasType) {
        int i;
        ArrayList<PipeBranch> branches = new ArrayList<PipeBranch>();
        ArrayList<PipeBranch> looseEnds = new ArrayList<PipeBranch>();
        ArrayList<PipeBranch> ends = new ArrayList<PipeBranch>();
        branches.add(new PipeBranch(0, 0, 0, side));
        boolean stop = false;
        while (branches.size() > 0 & !stop) {
            int branchAmount = branches.size();
            i = 0;
            while (i < branchAmount & !stop) {
                int z2;
                int y2;
                int x2;
                int j;
                PipeBranch branch = (PipeBranch)branches.get(i);
                PipeBranch[] newBranches = new PipeBranch[6];
                int subBranches = 0;
                int connectedSurroundingBlocks = 0;
                int x1 = x + branch.x;
                int y1 = y + branch.y;
                int z1 = z + branch.z;
                for (j = 0; j < 6; ++j) {
                    if (j == branch.getReverseDirection()) continue;
                    x2 = x1 + xDirection[j];
                    y2 = y1 + yDirection[j];
                    z2 = z1 + zDirection[j];
                    boolean notBranched = true;
                    for (int k = 0; k < branchAmount; ++k) {
                        if (k == i || !((PipeBranch)branches.get(k)).holds(x2 - x, y2 - y, z2 - z)) continue;
                        notBranched = false;
                        break;
                    }
                    Block directionBlock = world.func_147439_a(x2, y2, z2);
                    int directionBlockMetadata = world.func_72805_g(x2, y2, z2);
                    if (directionBlock instanceof BlockGasPipe) {
                        ++connectedSurroundingBlocks;
                        if (!(branch.length < 15 & notBranched)) continue;
                        newBranches[subBranches++] = branch.branch(j);
                        continue;
                    }
                    if (!IGasReceptor.class.isAssignableFrom(directionBlock.getClass())) continue;
                    if (((IGasReceptor)directionBlock).connectToPipe()) {
                        ++connectedSurroundingBlocks;
                    }
                    ends.add(branch.branch(j));
                }
                if (connectedSurroundingBlocks <= 0) {
                    PipeBranch branch2 = branch.branch(branch.getDirection());
                    x2 = x1 + branch2.x;
                    y2 = y1 + branch2.y;
                    z2 = z1 + branch2.z;
                    if (GasesFramework.canFillWithGas(world, x2, y2, z2, ((BlockGasPipe)world.func_147439_a((int)x1, (int)y1, (int)z1)).type)) {
                        looseEnds.add(branch2);
                    }
                }
                if (subBranches > 0) {
                    for (j = 0; j < subBranches; ++j) {
                        PipeBranch newBranch = newBranches[j];
                        if (j < 1) {
                            branches.set(i, newBranch);
                            continue;
                        }
                        branches.add(newBranch);
                    }
                } else {
                    branches.remove(i--);
                    --branchAmount;
                }
                ++i;
            }
        }
        PipeBranch pushedEnd = null;
        if (looseEnds.size() > 0) {
            pushedEnd = (PipeBranch)looseEnds.get(world.field_73012_v.nextInt(looseEnds.size()));
            PipeBranch originPipe = pushedEnd.unBranch();
            BlockGasPipe pipeBlock = (BlockGasPipe)world.func_147439_a(x + originPipe.x, y + originPipe.y, z + originPipe.z);
            GasesFramework.fillWithGas(world, world.field_73012_v, x + pushedEnd.x, y + pushedEnd.y, z + pushedEnd.z, pipeBlock.type);
            pushedEnd = originPipe;
        } else if (ends.size() > 0) {
            Collections.shuffle(ends);
            i = 0;
            while (i < ends.size() & pushedEnd == null) {
                PipeBranch end = (PipeBranch)ends.get(i);
                int x1 = x + end.x;
                int y1 = y + end.y;
                int z1 = z + end.z;
                PipeBranch outPipe = end.unBranch();
                int x2 = x + outPipe.x;
                int y2 = y + outPipe.y;
                int z2 = z + outPipe.z;
                IGasReceptor endBlock = (IGasReceptor)world.func_147439_a(x1, y1, z1);
                GasType outGasType = null;
                Block sourceBlock = world.func_147439_a(x2, y2, z2);
                if (sourceBlock instanceof BlockGasPipe) {
                    outGasType = ((BlockGasPipe)sourceBlock).type;
                } else if (IGasSource.class.isAssignableFrom(sourceBlock.getClass())) {
                    outGasType = ((IGasSource)sourceBlock).takeGasTypeFromSide(world, x2, y2, z2, outPipe.getReverseDirection());
                }
                if (endBlock.receiveGas(world, x1, y1, z1, end.getDirection(), outGasType)) {
                    pushedEnd = end.unBranch();
                }
                ++i;
            }
        }
        if (pushedEnd != null & !world.field_72995_K) {
            while (pushedEnd.length > 1) {
                int x1 = x + pushedEnd.x;
                int y1 = y + pushedEnd.y;
                int z1 = z + pushedEnd.z;
                Block block1 = world.func_147439_a(x1, y1, z1);
                pushedEnd = pushedEnd.unBranch();
                Block block2 = world.func_147439_a(x + pushedEnd.x, y + pushedEnd.y, z + pushedEnd.z);
                if (block1 == block2) continue;
                world.func_147449_b(x1, y1, z1, block2);
            }
            world.func_147449_b(x, y, z, (Block)gasType.gasPipe);
        }
        return pushedEnd != null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return GasesFramework.renderBlockGasPipeID;
    }

    public Item func_149694_d(World par1World, int par2, int par3, int par4) {
        return Item.func_150898_a((Block)GasesFramework.gasPipeAir);
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)GasesFramework.gasPipeAir);
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldBlockMetadata) {
        if (this.type.gasBlock != null && world.func_147437_c(x, y, z)) {
            world.func_147449_b(x, y, z, (Block)this.type.gasBlock);
        }
    }

    @Override
    public boolean connectToPipe() {
        return true;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (this.type.gasBlock != null) {
            this.type.gasBlock.onFire(world, x, y, z, world.field_73012_v, 0);
        }
    }
}

