/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import glenn.gases.CommonProxy;
import glenn.gases.DamageSourceLightning;
import glenn.gases.GasTypeBlackDamp;
import glenn.gases.GasTypeChlorine;
import glenn.gases.GasTypePoisonous;
import glenn.gases.UpdateChecker;
import glenn.gases.block.BlockGasBlackDamp;
import glenn.gases.block.BlockGasElectric;
import glenn.gases.block.BlockGasVoid;
import glenn.gases.block.BlockRustedIronOre;
import glenn.gases.entity.EntityBlueDust;
import glenn.gases.entity.EntityFlashFX;
import glenn.gases.entity.EntityFlashSparkFX;
import glenn.gases.entity.EntityGlowstoneShard;
import glenn.gases.entity.EntitySmallLightning;
import glenn.gases.entity.EntitySnapdragon;
import glenn.gases.entity.EntityTurquoiseDust;
import glenn.gases.item.ItemDust;
import glenn.gases.item.ItemGasDetector;
import glenn.gases.item.ItemGlowstoneShard;
import glenn.gases.item.ItemRespirator;
import glenn.gases.item.ItemSnapdragon;
import glenn.gases.reaction.ReactionAcidVapour;
import glenn.gases.reaction.ReactionCorrosion;
import glenn.gases.reaction.ReactionDustDrop;
import glenn.gases.reaction.ReactionExtinguish;
import glenn.gases.reaction.ReactionRust;
import glenn.gases.worldgen.WorldGeneratorGases;
import glenn.gasesframework.Combustibility;
import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.block.BlockGas;
import glenn.gasesframework.block.BlockGasPipe;
import glenn.gasesframework.block.BlockLantern;
import glenn.gasesframework.block.BlockLanternSpecial;
import glenn.gasesframework.reaction.Reaction;
import glenn.gasesframework.reaction.ReactionIgnition;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCompressed;
import net.minecraft.block.material.MapColor;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;

@Mod(modid="gases", name="Glenn's Gases", version="1.5.0", dependencies="required-after:gasesFramework; required-after:gasesCore")
public class Gases {
    @Mod.Instance(value="gases")
    public static Gases instance;
    @SidedProxy(clientSide="glenn.gases.client.ClientProxy", serverSide="glenn.gases.CommonProxy")
    public static CommonProxy proxy;
    public static final String version = "1.5.0";
    public static final String targetVersion = "1.7.2";
    private static Configuration config;
    public static int generateGreenGas;
    public static int generateRedGas;
    public static int generateNitrousGas;
    public static int generateBlackDamp;
    public static int generateChlorineGas;
    public static int generatePipes;
    public static int generateElectricGas;
    public static int generateCorrosiveGas;
    public static int voidGasMaxHeight;
    public static float maxHardnessForCorrosion;
    public static boolean enableUpdateCheck;
    public static int coalDustOnMine;
    public static final DamageSource lightningDamageSource;
    public static Item glowstoneShard;
    public static Item gasDetector;
    public static Item gasSensitiveChip;
    public static Item turquoiseDust;
    public static Item blueDust;
    public static Item snapdragon;
    public static Item primitiveRespirator;
    public static Block rustedIronOre;
    public static Block rustedIronBlock;
    public static BlockGas gasSteam;
    public static BlockGas gasRisingFlammable;
    public static BlockGas gasFallingExplosive;
    public static BlockGas gasVoid;
    public static BlockGas gasElectric;
    public static BlockGas gasCorrosive;
    public static BlockGas gasNitrous;
    public static BlockGas gasAcidVapour;
    public static BlockGas gasCoalDust;
    public static BlockGas gasBlackDamp;
    public static BlockGas gasChlorine;
    public static BlockGasPipe gasPipeSteam;
    public static BlockGasPipe gasPipeRisingFlammable;
    public static BlockGasPipe gasPipeFallingExplosive;
    public static BlockGasPipe gasPipeVoid;
    public static BlockGasPipe gasPipeElectric;
    public static BlockGasPipe gasPipeCorrosive;
    public static BlockGasPipe gasPipeNitrous;
    public static BlockGasPipe gasPipeChlorine;
    public static BlockLantern lanternTorch;
    public static BlockLantern lanternGlowstone;
    public static GasType gasTypeSteam;
    public static GasType gasTypeRisingFlammable;
    public static GasType gasTypeFallingExplosive;
    public static GasType gasTypeVoid;
    public static GasType gasTypeElectric;
    public static GasType gasTypeCorrosive;
    public static GasType gasTypeNitrous;
    public static GasType gasTypeAcidVapour;
    public static GasType gasTypeCoalDust;
    public static GasType gasTypeBlackDamp;
    public static GasType gasTypeChlorine;
    public static ItemArmor.ArmorMaterial RESPIRATOR;

    private void initBlocksAndItems() {
        glowstoneShard = new ItemGlowstoneShard().func_77655_b("gg_glowstoneShard").func_111206_d("gases:glowstone_shard");
        GameRegistry.registerItem((Item)glowstoneShard, (String)"glowstoneShard");
        gasDetector = new ItemGasDetector().func_77655_b("gg_gasDetector").func_77637_a(GasesFramework.creativeTab).func_111206_d("gases:detector");
        GameRegistry.registerItem((Item)gasDetector, (String)"gasDetector");
        gasSensitiveChip = new Item().func_77655_b("gg_gasSensitiveChip").func_77637_a(GasesFramework.creativeTab).func_111206_d("gases:chip");
        GameRegistry.registerItem((Item)gasSensitiveChip, (String)"gasSensitiveChip");
        turquoiseDust = new ItemDust(EntityTurquoiseDust.class).func_77655_b("gg_turquoiseDust").func_77637_a(GasesFramework.creativeTab).func_111206_d("gases:dust_turquoise");
        GameRegistry.registerItem((Item)turquoiseDust, (String)"turquoiseDust");
        blueDust = new ItemDust(EntityBlueDust.class).func_77655_b("gg_blueDust").func_77637_a(GasesFramework.creativeTab).func_111206_d("gases:dust_blue");
        GameRegistry.registerItem((Item)blueDust, (String)"blueDust");
        snapdragon = new ItemSnapdragon().func_77655_b("gg_snapdragon").func_77637_a(GasesFramework.creativeTab).func_111206_d("gases:snapdragon");
        GameRegistry.registerItem((Item)snapdragon, (String)"snapdragon");
        primitiveRespirator = new ItemRespirator().func_77655_b("gg_primitiveRespirator").func_77637_a(GasesFramework.creativeTab).func_111206_d("gases:respirator");
        GameRegistry.registerItem((Item)primitiveRespirator, (String)"primitiveRespirator");
        rustedIronOre = new BlockRustedIronOre().func_149711_c(3.0f).func_149752_b(5.0f).func_149672_a(Block.field_149780_i).func_149663_c("gg_rustedIronOre").func_149647_a(GasesFramework.creativeTab).func_149658_d("gases:iron_ore_rusted");
        GameRegistry.registerBlock((Block)rustedIronOre, (String)"rustedIronOre");
        rustedIronBlock = new BlockCompressed(MapColor.field_151650_B).func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(Block.field_149777_j).func_149663_c("gg_rustedIronBlock").func_149647_a(GasesFramework.creativeTab).func_149658_d("gases:iron_block_rusted");
        GameRegistry.registerBlock((Block)rustedIronBlock, (String)"rustedIronBlock");
        gasSteam = (BlockGas)new BlockGas().func_149663_c("gg_gasSteam").func_149647_a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((Block)gasSteam, (String)"gasSteam");
        gasRisingFlammable = (BlockGas)new BlockGas().func_149663_c("gg_gasRisingFlammable").func_149647_a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((Block)gasRisingFlammable, (String)"gasRisingFlammable");
        gasFallingExplosive = (BlockGas)new BlockGas().func_149663_c("gg_gasFallingExplosive").func_149647_a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((Block)gasFallingExplosive, (String)"gasFallingExplosive");
        gasVoid = (BlockGas)new BlockGasVoid().func_149663_c("gg_gasVoid").func_149647_a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((Block)gasVoid, (String)"gasVoid");
        gasElectric = (BlockGas)new BlockGasElectric().func_149663_c("gg_gasElectric").func_149647_a(GasesFramework.creativeTab).func_149658_d("gases:gas_special");
        GameRegistry.registerBlock((Block)gasElectric, (String)"gasElectric");
        gasCorrosive = (BlockGas)new BlockGas().func_149663_c("gg_gasCorrosive").func_149647_a(GasesFramework.creativeTab).func_149658_d("gases:gas_special");
        GameRegistry.registerBlock((Block)gasCorrosive, (String)"gasCorrosive");
        gasNitrous = (BlockGas)new BlockGas().func_149663_c("gg_gasNitrous").func_149647_a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((Block)gasNitrous, (String)"gasNitrous");
        gasAcidVapour = (BlockGas)new BlockGas().func_149663_c("gg_gasAcidVapour").func_149658_d("gases:gas_special");
        GameRegistry.registerBlock((Block)gasAcidVapour, (String)"gasAcidVapour");
        gasCoalDust = (BlockGas)new BlockGas().func_149663_c("gg_gasCoalDust").func_149647_a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((Block)gasCoalDust, (String)"gasCoalDust");
        gasBlackDamp = (BlockGas)new BlockGasBlackDamp().func_149663_c("gg_gasBlackDamp");
        GameRegistry.registerBlock((Block)gasBlackDamp, (String)"gasBlackDamp");
        gasChlorine = (BlockGas)new BlockGas().func_149663_c("gg_gasChlorine").func_149647_a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((Block)gasChlorine, (String)"gasChlorine");
        gasPipeSteam = (BlockGasPipe)new BlockGasPipe().func_149663_c("gg_gasPipeSteam");
        GameRegistry.registerBlock((Block)gasPipeSteam, (String)"gasPipeSteam");
        gasPipeRisingFlammable = (BlockGasPipe)new BlockGasPipe().func_149663_c("gg_gasPipeRisingFlammable");
        GameRegistry.registerBlock((Block)gasPipeRisingFlammable, (String)"gasPipeRisingFlammable");
        gasPipeFallingExplosive = (BlockGasPipe)new BlockGasPipe().func_149663_c("gg_gasPipeFallingExplosive");
        GameRegistry.registerBlock((Block)gasPipeFallingExplosive, (String)"gasPipeFallingExplosive");
        gasPipeVoid = (BlockGasPipe)new BlockGasPipe().func_149663_c("gg_gasPipeVoid");
        GameRegistry.registerBlock((Block)gasPipeVoid, (String)"gasPipeVoid");
        gasPipeElectric = (BlockGasPipe)new BlockGasPipe().func_149663_c("gg_gasPipeElectric");
        GameRegistry.registerBlock((Block)gasPipeElectric, (String)"gasPipeElectric");
        gasPipeCorrosive = (BlockGasPipe)new BlockGasPipe().func_149663_c("gg_gasPipeCorrosive");
        GameRegistry.registerBlock((Block)gasPipeCorrosive, (String)"gasPipeCorrosive");
        gasPipeNitrous = (BlockGasPipe)new BlockGasPipe().func_149663_c("gg_gasPipeNitrous");
        GameRegistry.registerBlock((Block)gasPipeNitrous, (String)"gasPipeNitrous");
        gasPipeChlorine = (BlockGasPipe)new BlockGasPipe().func_149663_c("gg_gasChlorine");
        GameRegistry.registerBlock((Block)gasPipeChlorine, (String)"gasPipeChlorine");
        lanternTorch = (BlockLantern)new BlockLanternSpecial(0, new ItemStack(Blocks.field_150478_aa), new ItemStack(Blocks.field_150478_aa), null).func_149715_a(0.75f).func_149663_c("gg_lanternTorch").func_149658_d("gases:lantern_torch");
        GameRegistry.registerBlock((Block)lanternTorch, (String)"lanternTorch");
        lanternGlowstone = (BlockLantern)new BlockLanternSpecial(0, new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151114_aO), null).func_149715_a(1.0f).func_149663_c("gg_lanternGlowstone").func_149658_d("gases:lantern_glowstone");
        GameRegistry.registerBlock((Block)lanternGlowstone, (String)"lanternGlowstone");
        gasTypeSteam = new GasType(gasSteam, gasPipeSteam, 2, "steam", 0xFFFFFF, 0, -32, Combustibility.NONE).setDamage(2.0f).setEvaporationRate(8);
        gasTypeRisingFlammable = new GasType(gasRisingFlammable, gasPipeRisingFlammable, 3, "greenGas", 0x6F7F6F, 1, -12, Combustibility.FLAMMABLE).setEffectRates(2, 2, 8);
        gasTypeFallingExplosive = new GasType(gasFallingExplosive, gasPipeFallingExplosive, 4, "redGas", 0x7F4F4F, 3, 4, Combustibility.EXPLOSIVE).setEffectRates(1, 2, 8);
        gasTypeVoid = new GasType(gasVoid, gasPipeVoid, 5, "voidGas", 0x1F1F1F, 4, 8, Combustibility.NONE).setEffectRates(20, 4, 0).setDamage(1.0f);
        gasTypeElectric = new GasType(gasElectric, gasPipeElectric, 6, "electricGas", 0x1F7F7F, 0, 0, Combustibility.NONE).setEffectRates(4, 2, 0);
        gasTypeCorrosive = new GasType(gasCorrosive, gasPipeCorrosive, 7, "corrosiveGas", 0x1F1FDF, 0, 0, Combustibility.NONE).setEffectRates(4, 2, 0).setDamage(0.5f);
        gasTypeNitrous = new GasTypePoisonous(gasNitrous, gasPipeNitrous, 8, "nitrousGas", 7290671, 3, 4, Combustibility.NONE).setEffectRates(1, 4, 16);
        gasTypeAcidVapour = new GasType(gasAcidVapour, 9, "acidicVapour", 5210047, 0, -20, Combustibility.NONE).setEffectRates(20, 1, 0).setDamage(2.0f).setEvaporationRate(2);
        gasTypeCoalDust = new GasType(gasCoalDust, 10, "coalDust", 0x2F2F2F, 0, 0, Combustibility.HIGHLY_EXPLOSIVE).setEffectRates(0, 6, 16).setEvaporationRate(5);
        gasTypeBlackDamp = new GasTypeBlackDamp(gasBlackDamp, 11, "blackDamp").setOverlayImage(GasesFramework.emptyOverlayImage).setEffectRates(0, 6, 24);
        gasTypeChlorine = new GasTypeChlorine(gasChlorine, gasPipeChlorine, 12, "chlorineGas", 12776092, 1, 8, Combustibility.NONE).setEffectRates(4, 6, 0);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String[] destroyableByChlorine;
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        RESPIRATOR = EnumHelper.addArmorMaterial((String)"RESPIRATOR", (int)125, (int[])new int[]{0, 0, 0, 0}, (int)0);
        this.initBlocksAndItems();
        generateGreenGas = config.get("world", "generateGreenGas", 4).getInt(4);
        generateRedGas = config.get("world", "generateRedGas", 2).getInt(2);
        generateBlackDamp = config.get("world", "generateBlackDamp", 1).getInt(1);
        generateNitrousGas = config.get("world", "generateNitrousGas", 2).getInt(2);
        generateChlorineGas = config.get("world", "generateChlorineGas", 1).getInt(1);
        generatePipes = config.get("world", "generatePipes", 32).getInt(32);
        generateElectricGas = config.get("world", "generateElectricGas", -2).getInt(-2);
        generateCorrosiveGas = config.get("world", "generateCorrosiveGas", -2).getInt(-2);
        voidGasMaxHeight = config.get("gases", "voidGasMaxHeight", 64).getInt(64);
        maxHardnessForCorrosion = Float.parseFloat(config.get("gases", "maxHardnessForCorrosion", 2.0).getString());
        enableUpdateCheck = config.get("other", "enableUpdateCheck", true).getBoolean(true);
        for (String s : destroyableByChlorine = config.get("gases", "destroyableByChlorine", new String[]{"IRON", "CHAIN"}).getStringList()) {
            GasTypeChlorine.armorToDamage.add(s);
        }
        coalDustOnMine = config.get("gases", "coalDustOnMine", 16).getInt(16);
        config.save();
        MinecraftForge.EVENT_BUS.register((Object)new UpdateChecker());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorGases(), (int)10);
        GameRegistry.addRecipe((ItemStack)new ItemStack(primitiveRespirator), (Object[])new Object[]{" W ", "SCS", " L ", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('S'), Items.field_151007_F, Character.valueOf('C'), Items.field_151044_h, Character.valueOf('L'), Items.field_151116_aA});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(snapdragon, 4), (Object[])new Object[]{Items.field_151121_aF, Items.field_151016_H, turquoiseDust, blueDust});
        GameRegistry.addRecipe((ItemStack)new ItemStack(gasSensitiveChip), (Object[])new Object[]{"GRG", "RDR", "GRG", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), Items.field_151045_i});
        for (int i = 0; i < GasType.gasTypes.length; ++i) {
            GasType type;
            if (!(i == 0 | ((type = GasType.gasTypes[i]) != null && type.isIndustrial()))) continue;
            GameRegistry.addRecipe((ItemStack)new ItemStack(gasDetector, 1, i), (Object[])new Object[]{" I ", "ICS", " I ", Character.valueOf('S'), new ItemStack(GasesFramework.gasSamplerIncluder, 1, i), Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('C'), new ItemStack(gasSensitiveChip)});
        }
        GasesFramework.addSpecialFurnaceRecipe((ItemStack)new ItemStack(Items.field_151044_h, 64), (ItemStack)new ItemStack(Items.field_151045_i), (int)25600);
        GasesFramework.registerReaction((Reaction)new ReactionIgnition());
        GasesFramework.registerReaction((Reaction)new ReactionDustDrop((Block)gasElectric, (Block)gasCorrosive));
        GasesFramework.registerReaction((Reaction)new ReactionCorrosion(gasCorrosive));
        GasesFramework.registerReaction((Reaction)new ReactionAcidVapour(11, (Block)gasNitrous, Blocks.field_150355_j));
        GasesFramework.registerReaction((Reaction)new ReactionAcidVapour(12, (Block)gasNitrous, (Block)Blocks.field_150358_i));
        GasesFramework.registerReaction((Reaction)new ReactionExtinguish(0, gasBlackDamp, Blocks.field_150478_aa));
        GasesFramework.registerReaction((Reaction)new ReactionExtinguish(0, gasBlackDamp, (Block)Blocks.field_150480_ab));
        GasesFramework.registerReaction((Reaction)new ReactionRust(Blocks.field_150366_p, rustedIronOre, gasChlorine));
        GasesFramework.registerReaction((Reaction)new ReactionRust(Blocks.field_150339_S, rustedIronBlock, gasChlorine));
        EntityRegistry.registerModEntity(EntitySmallLightning.class, (String)"smallLightning", (int)127, (Object)this, (int)20, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityGlowstoneShard.class, (String)"glowstoneShard", (int)126, (Object)this, (int)20, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityTurquoiseDust.class, (String)"dustParticleGreen", (int)125, (Object)this, (int)20, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityBlueDust.class, (String)"dustParticleBlue", (int)124, (Object)this, (int)20, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntitySnapdragon.class, (String)"snapdragon", (int)123, (Object)this, (int)20, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityFlashFX.class, (String)"flashFX", (int)122, (Object)this, (int)20, (int)1, (boolean)false);
        EntityRegistry.registerModEntity(EntityFlashSparkFX.class, (String)"flashSparkFX", (int)121, (Object)this, (int)20, (int)1, (boolean)false);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        GasesFramework.ENCOURAGE_MECHANICAL_ITEMS();
        GasesFramework.ENCOURAGE_LANTERNS();
        lightningDamageSource = new DamageSourceLightning("gg_lightning");
    }
}

