/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.gels.core;

import java.util.ArrayList;
import java.util.List;
import net.lomeli.gels.api.GelAbility;
import net.lomeli.gels.api.IGelRegistry;

public class GelRegistry
implements IGelRegistry {
    private List<GelAbility> gels = new ArrayList<GelAbility>();
    private static GelRegistry instance;

    public static GelRegistry getInstance() {
        if (instance == null) {
            instance = new GelRegistry();
        }
        return instance;
    }

    @Override
    public int getUniqueID() {
        for (int i = 0; i < this.gels.size(); ++i) {
            if (this.gels.get(i) != null) continue;
            return i;
        }
        return this.gels.size();
    }

    @Override
    public void addGel(GelAbility gel) {
        if (!this.gels.contains(gel)) {
            this.gels.add(gel);
        }
    }

    @Override
    public void addGelToSlot(GelAbility gel, int slot) {
        if (!this.gels.contains(gel)) {
            if (slot < 4) {
                this.gels.add(slot, gel);
            } else {
                this.gels.add(this.getUniqueID(), gel);
            }
        }
    }

    @Override
    public GelAbility getGel(int i) {
        return i < this.gels.size() ? this.gels.get(i) : null;
    }

    @Override
    public List<GelAbility> getRegistry() {
        return this.gels;
    }
}

