/*
 * Decompiled with CFR 0.152.
 */
package xelitez.frostcraft.tileentity;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import xelitez.frostcraft.registry.RecipeRegistry;
import xelitez.frostcraft.tileentity.TileEntityThermalMachines;

public class TileEntityFrostEnforcer
extends TileEntityThermalMachines
implements ISidedInventory {
    public ItemStack[] items = new ItemStack[2];
    public int enforceTime = 0;

    public TileEntityFrostEnforcer() {
        this.capacity = 1200;
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.items.length) continue;
            this.items[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.enforceTime = par1NBTTagCompound.func_74765_d("EnforceTime");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("FreezeTime", (short)this.enforceTime);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.items.length; ++var3) {
            if (this.items[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.items[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int getEnforcingProgressScaled(int par1) {
        return this.enforceTime * par1 / 1200;
    }

    public int getStorageRemainingScaled(int par1) {
        return this.storage * par1 / this.capacity;
    }

    public boolean isEnforcing() {
        return this.storage > 0;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        int var1 = this.enforceTime++;
        this.requestEnergy(5);
        boolean var2 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.canEnforce() && this.isEnforcing()) {
                --this.storage;
                if (this.enforceTime == 1200) {
                    this.enforceTime = 0;
                    this.enforceItem();
                    var2 = true;
                }
            } else if (!this.canEnforce()) {
                this.enforceTime = 0;
            }
            if (this.enforceTime != var1 && this.isEnforcing()) {
                if (!this.isActive) {
                    var2 = true;
                    this.setActive(true);
                }
            } else if (this.isActive) {
                var2 = true;
                this.setActive(false);
            }
        }
        if (var2) {
            this.func_70296_d();
        }
    }

    public void enforceItem() {
        if (this.canEnforce()) {
            ItemStack var1 = RecipeRegistry.registry().getEnforcingResult(this.items[0]);
            NBTTagList enchantments = this.items[0].func_77986_q();
            if (this.items[1] == null) {
                this.items[1] = var1.func_77946_l();
                if (enchantments != null) {
                    for (int i = 0; i < enchantments.func_74745_c(); ++i) {
                        NBTTagCompound tag = enchantments.func_150305_b(i);
                        this.items[1].func_77966_a(Enchantment.field_77331_b[tag.func_74765_d("id")], (int)tag.func_74765_d("lvl"));
                    }
                }
            } else if (this.items[1].func_77969_a(var1)) {
                this.items[1].field_77994_a += var1.field_77994_a;
            }
            --this.items[0].field_77994_a;
            if (this.items[0].field_77994_a <= 0) {
                this.items[0] = null;
            }
        }
    }

    private boolean canEnforce() {
        if (this.items[0] == null) {
            return false;
        }
        ItemStack var1 = RecipeRegistry.registry().getEnforcingResult(this.items[0]);
        if (var1 == null) {
            return false;
        }
        if (this.items[1] == null) {
            return true;
        }
        if (!this.items[1].func_77969_a(var1)) {
            return false;
        }
        int result = this.items[1].field_77994_a + var1.field_77994_a;
        return result <= this.func_70297_j_() && result <= var1.func_77976_d();
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.items[var1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.items[par1] != null) {
            if (this.items[par1].field_77994_a <= par2) {
                ItemStack var3 = this.items[par1];
                this.items[par1] = null;
                return var3;
            }
            ItemStack var3 = this.items[par1].func_77979_a(par2);
            if (this.items[par1].field_77994_a == 0) {
                this.items[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        if (this.items[var1] != null) {
            ItemStack var2 = this.items[var1];
            this.items[var1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.items[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "frostcraft.enforcer";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : var1.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_94128_d(int i) {
        int[] nArray;
        if (i != 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        return nArray;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i == 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1 || i == 0 && RecipeRegistry.registry().getEnforcingResult(itemstack) == null;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i != 1;
    }
}

