/*
 * Decompiled with CFR 0.152.
 */
package xelitez.frostcraft.effect;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import xelitez.frostcraft.damage.EntityDamageSourceFrost;
import xelitez.frostcraft.damage.EntityDamageSourceIndirectFrost;
import xelitez.frostcraft.effect.FCPotion;

public class EffectTicker {
    private static List<Effect> entities = new ArrayList<Effect>();
    private static EffectTicker instance = new EffectTicker();

    public static EffectTicker instance() {
        return instance;
    }

    public static void addEffect(Entity entityHit, PotionEffect potionEffect, Object ... obj) {
        if (entityHit instanceof EntityLivingBase) {
            EffectTicker.addEffect((EntityLivingBase)entityHit, potionEffect, obj);
        } else if (entityHit instanceof EntityDragonPart) {
            EffectTicker.addEffect((EntityLivingBase)((EntityDragonPart)entityHit).field_70259_a, potionEffect, obj);
        }
    }

    public boolean hasEntityEffect(EntityLivingBase entity, Potion potion) {
        for (int i = 0; i < entities.size(); ++i) {
            Effect effect = entities.get(i);
            if (effect.entity.func_145782_y() != entity.func_145782_y() || potion.field_76415_H != effect.potionId) continue;
            return true;
        }
        return false;
    }

    public static void addEffect(EntityLivingBase entity, PotionEffect effect, Object ... firingEntity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        entity.func_70690_d(effect);
        Entity fireentity = null;
        if (firingEntity != null && firingEntity.length >= 2 && firingEntity[1] instanceof Entity) {
            fireentity = (Entity)firingEntity[1];
        }
        Entity source = null;
        if (firingEntity != null && firingEntity.length >= 1 && firingEntity[0] instanceof Entity) {
            source = (Entity)firingEntity[0];
        }
        for (int i = 0; i < entities.size(); ++i) {
            Effect ff = entities.get(i);
            if (ff.entity.func_145782_y() != entity.func_145782_y() || ff.potionId != effect.func_76456_a()) continue;
            if (fireentity != null && ff.firingentity != fireentity) {
                ff.firingentity = fireentity;
            }
            if (source != null && ff.source != source) {
                ff.source = source;
            }
            if (ff.level < effect.func_76458_c()) {
                ff.level = effect.func_76458_c();
                ff.duration = effect.func_76459_b();
                return;
            }
            if (ff.duration < effect.func_76459_b()) {
                ff.duration = effect.func_76459_b();
            }
            return;
        }
        Effect peffect = new Effect(entity, effect);
        if (fireentity != null) {
            peffect = peffect.setEntity(fireentity);
        }
        if (source != null) {
            peffect = peffect.setSource(source);
        }
        entities.add(peffect);
    }

    public void removeEffects(int dim) {
        for (int i = 0; i < entities.size(); ++i) {
            Effect effect = entities.get(i);
            if ((effect.dimension != dim || effect.duration > 0) && !effect.entity.field_70128_L) continue;
            entities.remove(effect);
            this.removeEffects(dim);
            return;
        }
    }

    @SubscribeEvent
    public void onTickStart(TickEvent.WorldTickEvent evt) {
        World world = evt.world;
        if (evt.side.isServer() && evt.phase == TickEvent.Phase.START) {
            for (int i = 0; i < entities.size(); ++i) {
                Effect effect = entities.get(i);
                if (world.field_73011_w.field_76574_g != effect.dimension) continue;
                effect.doTick(world);
            }
            this.removeEffects(world.field_73011_w.field_76574_g);
        }
    }

    private static class Effect {
        public EntityLivingBase entity;
        public Entity firingentity;
        public Entity source;
        public int potionId = -1;
        public int duration = 0;
        public int level = 0;
        public double posX = 0.0;
        public double posY = 0.0;
        public double posZ = 0.0;
        public int dimension;
        public int counter = 0;

        public Effect(EntityLivingBase entity, PotionEffect effect) {
            this.entity = entity;
            this.potionId = effect.func_76456_a();
            this.duration = effect.func_76459_b();
            this.level = effect.func_76458_c();
            this.dimension = entity.field_70170_p.field_73011_w.field_76574_g;
            if (effect.func_76456_a() == FCPotion.freeze.field_76415_H) {
                this.posX = entity.field_70165_t;
                this.posY = entity.field_70163_u;
                this.posZ = entity.field_70161_v;
            }
        }

        public Effect setEntity(Entity entity) {
            this.firingentity = entity;
            return this;
        }

        public Effect setSource(Entity entity) {
            this.source = entity;
            return this;
        }

        public void doTick(World world) {
            if (this.potionId == FCPotion.freeze.field_76415_H) {
                if (this.entity == null || this.entity.field_70128_L || this.entity.func_70660_b((Potion)FCPotion.freeze) != null) {
                    // empty if block
                }
                if (this.entity == null) {
                    --this.duration;
                    ++this.counter;
                    return;
                }
                this.entity.func_70634_a(this.posX, this.posY, this.posZ);
                this.entity.field_70159_w = 0.0;
                this.entity.field_70181_x = 0.0;
                this.entity.field_70179_y = 0.0;
            }
            if (this.potionId == FCPotion.frostburn.field_76415_H) {
                if (this.entity == null || this.entity.field_70128_L || this.entity.func_70660_b((Potion)FCPotion.frostburn) != null) {
                    // empty if block
                }
                if (this.entity == null) {
                    --this.duration;
                    ++this.counter;
                    return;
                }
                if (this.counter == 10) {
                    int damage = this.level + 1;
                    EntityDamageSource var1 = null;
                    var1 = this.firingentity != null ? new EntityDamageSourceIndirectFrost(this.source, this.firingentity) : (this.source != null ? new EntityDamageSourceFrost(this.source) : new EntityDamageSourceFrost((Entity)this.entity));
                    this.entity.func_70097_a((DamageSource)(var1 != null ? var1 : DamageSource.field_76367_g), (float)damage);
                    if (this.entity instanceof EntityDragon) {
                        ((EntityDragon)this.entity).func_70965_a(((EntityDragon)this.entity).field_70987_i, (DamageSource)(var1 != null ? var1 : DamageSource.field_76367_g), (float)damage);
                    }
                }
                if (this.counter >= 20) {
                    this.counter = 0;
                }
            }
            --this.duration;
            ++this.counter;
        }
    }
}

