/*
 * Decompiled with CFR 0.152.
 */
package xelitez.frostcraft.world;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;
import xelitez.frostcraft.SaveHandler;
import xelitez.frostcraft.registry.IdMap;

public class WorldGenFrostWingTower
implements IWorldGenerator {
    public List<BiomeGenBase> biomeList = new ArrayList<BiomeGenBase>();
    private static WorldGenFrostWingTower instance = new WorldGenFrostWingTower();

    public static WorldGenFrostWingTower getInstance() {
        return instance;
    }

    public WorldGenFrostWingTower() {
        this.biomeList.add(BiomeGenBase.field_76775_o);
        this.biomeList.add(BiomeGenBase.field_76774_n);
        this.biomeList.add(BiomeGenBase.field_150584_S);
        this.biomeList.add(BiomeGenBase.field_150579_T);
    }

    public static List<Integer> getPossibleYPos(World world, int x, int z) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 50; i < world.func_72940_L() - 50; ++i) {
            if (world.func_147439_a(x, i - 1, z) == null || !world.func_147439_a(x, i - 1, z).isSideSolid((IBlockAccess)world, x, i - 1, z, ForgeDirection.UP) || world.func_147439_a(x, i, z).func_149688_o() != Material.field_151579_a) continue;
            list.add(i);
        }
        return list;
    }

    private static void sendChatMsg(String Msg) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText("<Frostcraft Generator> " + Msg));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int centerZ;
        int centerX = chunkX * 16 + random.nextInt(16);
        if (!this.biomeList.contains(world.func_72807_a(centerX, centerZ = chunkZ * 16 + random.nextInt(16)))) {
            return;
        }
        NBTTagCompound nbt = SaveHandler.getTagCompound(world, false);
        NBTTagList list = null;
        if (nbt.func_74764_b("Castles")) {
            list = nbt.func_150295_c("Castles", 10);
        }
        if (list == null) {
            list = new NBTTagList();
        }
        ArrayList<Integer[]> intlist = new ArrayList<Integer[]>();
        if (list != null) {
            for (int var0 = 0; var0 < list.func_74745_c(); ++var0) {
                NBTTagCompound nbt1 = list.func_150305_b(var0);
                Integer[] coords = new Integer[]{nbt1.func_74762_e("xCoord"), nbt1.func_74762_e("yCoord"), nbt1.func_74762_e("zCoord")};
                intlist.add(coords);
            }
        }
        int centerY = 0;
        for (Integer int1 : WorldGenFrostWingTower.getPossibleYPos(world, centerX, centerZ)) {
            if (int1 <= 50 || random.nextInt(6) != 2) continue;
            centerY = int1;
        }
        if (centerY != 0) {
            boolean canGenerate = true;
            for (Integer[] ints : intlist) {
                int dz;
                int dy;
                int dx = ints[0] - centerX;
                if (!(Math.sqrt(dx * dx + (dy = ints[1] - centerY) * dy + (dz = ints[2] - centerZ) * dz) < 750.0)) continue;
                canGenerate = false;
            }
            if (canGenerate) {
                this.generateSimple(random, centerX, centerY, centerZ, world);
                NBTTagCompound nbt2 = new NBTTagCompound();
                nbt2.func_74768_a("xCoord", centerX);
                nbt2.func_74768_a("yCoord", centerY);
                nbt2.func_74768_a("zCoord", centerZ);
                list.func_74742_a((NBTBase)nbt2);
                nbt.func_74782_a("Castles", (NBTBase)list);
            }
        }
    }

    private void generateSimple(Random random, int xCoord, int yCoord, int zCoord, World world) {
        for (int x = -7; x < 8; ++x) {
            for (int z = -7; z < 8; ++z) {
                for (int y = -1; y <= 20; ++y) {
                    if (Math.floor(Math.sqrt(x * x + z * z)) <= 7.0) {
                        world.func_147468_f(xCoord + x, yCoord + y, zCoord + z);
                        if (y == -1) {
                            this.generateFloor(world, xCoord + x, yCoord + y - 1, zCoord + z);
                        }
                    }
                    if (Math.floor(Math.sqrt(x * x + z * z)) == 7.0) {
                        if (!(Math.abs(x) < 2 && z < 0 && y < 3 && y >= 0 || x == 0 && y == 3 && z < 0 || y > 18)) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                        }
                        if (y == 18) {
                            if (Math.abs(x) == 1 || Math.abs(z) == 1 || Math.abs(x) == 3 || Math.abs(z) == 3) {
                                world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, (Block)IdMap.blockBlackFrostSingleSlabSet, 2, 2);
                            }
                            if (Math.abs(x) == 5 && Math.abs(z) == 5) {
                                world.func_147468_f(xCoord + x, yCoord + y, zCoord + z);
                            }
                        }
                    }
                    if (y == -1 && Math.floor(Math.sqrt(x * x + z * z)) <= 6.0) {
                        world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                        if (Math.floor(Math.sqrt(x * x + z * z)) == 6.0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                        }
                        if (Math.floor(Math.sqrt(x * x + z * z)) == 2.0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                        }
                        if (Math.abs(x) > 1 && z == 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                        }
                        if (Math.abs(z) > 1 && x == 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                        }
                    }
                    if (y == 17 && Math.floor(Math.sqrt(x * x + z * z)) > 2.0 && Math.floor(Math.sqrt(x * x + z * z)) <= 6.0) {
                        world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                        if (Math.floor(Math.sqrt(x * x + z * z)) == 6.0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                        }
                        if (Math.abs(x) > 1 && z == 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                        }
                        if (Math.abs(z) > 1 && x == 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                        }
                    }
                    if (x == 0 && z == 0 && y <= 17) {
                        world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                    }
                    if (!(Math.floor(Math.sqrt(x * x + z * z)) <= 2.0) || y < 0 || y > 17) continue;
                    if (y % 4 == 0) {
                        if (x < 0 && z > 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                        }
                        if (z == 0 && x < 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 2, 2);
                        }
                        if (z > 0 && x == 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 5, 2);
                        }
                    }
                    if (y % 4 == 1) {
                        if (x > 0 && z > 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                        }
                        if (z > 0 && x == 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 0, 2);
                        }
                        if (z == 0 && x > 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 6, 2);
                        }
                        if (y == 17 && Math.floor(Math.sqrt(x * x + z * z)) == 2.0) {
                            if (z > 0 && x > 0) {
                                world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                            }
                            if (z == 0 && x > 0) {
                                world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 6, 2);
                            }
                        }
                    }
                    if (y % 4 == 2) {
                        if (x > 0 && z < 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                        }
                        if (z == 0 && x > 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 3, 2);
                        }
                        if (z < 0 && x == 0) {
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 4, 2);
                        }
                    }
                    if (y % 4 != 3) continue;
                    if (x < 0 && z < 0) {
                        world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                    }
                    if (z < 0 && x == 0) {
                        world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 1, 2);
                    }
                    if (z != 0 || x >= 0) continue;
                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 7, 2);
                }
            }
        }
        this.generateCandle(world, xCoord + 6, yCoord, zCoord, 2);
        this.generateCandle(world, xCoord, yCoord, zCoord + 6, 1);
        this.generateCandle(world, xCoord - 6, yCoord, zCoord, 2);
        this.generateCandle(world, xCoord - 2, yCoord, zCoord - 6, 0);
        this.generateCandle(world, xCoord + 2, yCoord, zCoord - 6, 0);
        this.generateCandle(world, xCoord, yCoord + 18, zCoord, 0);
        this.generateCandle(world, xCoord + 6, yCoord + 18, zCoord, 0);
        this.generateCandle(world, xCoord, yCoord + 18, zCoord + 6, 0);
        this.generateCandle(world, xCoord - 6, yCoord + 18, zCoord, 0);
        world.func_147465_d(xCoord, yCoord + 18, zCoord - 6, IdMap.blockStatue, 2, 2);
        world.func_147465_d(xCoord, yCoord + 19, zCoord - 6, IdMap.blockStatue, 4, 2);
        world.func_147465_d(xCoord, yCoord + 20, zCoord - 6, IdMap.blockStatue, 5, 2);
        world.func_147465_d(xCoord, yCoord - 1, zCoord, Blocks.field_150474_ac, 0, 2);
        ((TileEntityMobSpawner)world.func_147438_o(xCoord, yCoord - 1, zCoord)).func_145881_a().func_98272_a("FrostGuard");
        world.func_147465_d(xCoord, yCoord + 17, zCoord, Blocks.field_150474_ac, 0, 2);
        ((TileEntityMobSpawner)world.func_147438_o(xCoord, yCoord + 17, zCoord)).func_145881_a().func_98272_a("FrostGuard");
    }

    private void generateFloor(World world, int x, int yStart, int z) {
        for (int y = yStart; y > 0 && (world.func_147439_a(x, y, z).func_149688_o() == Material.field_151579_a || world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z)); --y) {
            world.func_147465_d(x, y, z, Blocks.field_150346_d, 0, 2);
        }
    }

    private void generateCandle(World world, int x, int y, int z, int type) {
        switch (type) {
            case 0: {
                world.func_147465_d(x, y, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                world.func_147465_d(x, y + 1, z, Blocks.field_150478_aa, 5, 2);
                break;
            }
            case 1: {
                world.func_147465_d(x, y, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                world.func_147465_d(x, y + 1, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                world.func_147465_d(x + 1, y + 1, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                world.func_147465_d(x - 1, y + 1, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                world.func_147465_d(x + 1, y + 2, z, Blocks.field_150478_aa, 5, 2);
                world.func_147465_d(x - 1, y + 2, z, Blocks.field_150478_aa, 5, 2);
                break;
            }
            case 2: {
                world.func_147465_d(x, y, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                world.func_147465_d(x, y + 1, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                world.func_147465_d(x, y + 1, z + 1, IdMap.blockBlackFrostFenceSet, 1, 2);
                world.func_147465_d(x, y + 1, z - 1, IdMap.blockBlackFrostFenceSet, 1, 2);
                world.func_147465_d(x, y + 2, z + 1, Blocks.field_150478_aa, 5, 2);
                world.func_147465_d(x, y + 2, z - 1, Blocks.field_150478_aa, 5, 2);
            }
        }
    }

    public static void generateAt(Random random, int i, int j, int k, World world1) {
        final World world = world1;
        final int xCoord = i;
        final int yCoord = j;
        final int zCoord = k;
        new Thread(){

            @Override
            public void run() {
                for (int x = -7; x < 8; ++x) {
                    for (int z = -7; z < 8; ++z) {
                        for (int y = -1; y <= 20; ++y) {
                            if (Math.floor(Math.sqrt(x * x + z * z)) <= 7.0) {
                                world.func_147468_f(xCoord + x, yCoord + y, zCoord + z);
                                if (y == -1) {
                                    this.generateFloor(world, xCoord + x, yCoord + y - 1, zCoord + z);
                                }
                            }
                            if (Math.floor(Math.sqrt(x * x + z * z)) == 7.0) {
                                if (!(Math.abs(x) < 2 && z < 0 && y < 3 && y >= 0 || x == 0 && y == 3 && z < 0 || y > 18)) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                                }
                                if (y == 18) {
                                    if (Math.abs(x) == 1 || Math.abs(z) == 1 || Math.abs(x) == 3 || Math.abs(z) == 3) {
                                        world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, (Block)IdMap.blockBlackFrostSingleSlabSet, 2, 2);
                                    }
                                    if (Math.abs(x) == 5 && Math.abs(z) == 5) {
                                        world.func_147468_f(xCoord + x, yCoord + y, zCoord + z);
                                    }
                                }
                            }
                            if (y == -1 && Math.floor(Math.sqrt(x * x + z * z)) <= 6.0) {
                                world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                                if (Math.floor(Math.sqrt(x * x + z * z)) == 6.0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                                }
                                if (Math.floor(Math.sqrt(x * x + z * z)) == 2.0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                                }
                                if (Math.abs(x) > 1 && z == 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                                }
                                if (Math.abs(z) > 1 && x == 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                                }
                            }
                            if (y == 17 && Math.floor(Math.sqrt(x * x + z * z)) > 2.0 && Math.floor(Math.sqrt(x * x + z * z)) <= 6.0) {
                                world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                                if (Math.floor(Math.sqrt(x * x + z * z)) == 6.0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                                }
                                if (Math.abs(x) > 1 && z == 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                                }
                                if (Math.abs(z) > 1 && x == 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                                }
                            }
                            if (x == 0 && z == 0 && y <= 17) {
                                world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                            }
                            if (!(Math.floor(Math.sqrt(x * x + z * z)) <= 2.0) || y < 0 || y > 17) continue;
                            if (y % 4 == 0) {
                                if (x < 0 && z > 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                                }
                                if (z == 0 && x < 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 2, 2);
                                }
                                if (z > 0 && x == 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 5, 2);
                                }
                            }
                            if (y % 4 == 1) {
                                if (x > 0 && z > 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                                }
                                if (z > 0 && x == 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 0, 2);
                                }
                                if (z == 0 && x > 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 6, 2);
                                }
                                if (y == 17 && Math.floor(Math.sqrt(x * x + z * z)) == 2.0) {
                                    if (z > 0 && x > 0) {
                                        world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                                    }
                                    if (z == 0 && x > 0) {
                                        world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 6, 2);
                                    }
                                }
                            }
                            if (y % 4 == 2) {
                                if (x > 0 && z < 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                                }
                                if (z == 0 && x > 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 3, 2);
                                }
                                if (z < 0 && x == 0) {
                                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 4, 2);
                                }
                            }
                            if (y % 4 != 3) continue;
                            if (x < 0 && z < 0) {
                                world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 2, 2);
                            }
                            if (z < 0 && x == 0) {
                                world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 1, 2);
                            }
                            if (z != 0 || x >= 0) continue;
                            world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrostStairBrick, 7, 2);
                        }
                    }
                }
                this.generateCandle(world, xCoord + 6, yCoord, zCoord, 2);
                this.generateCandle(world, xCoord, yCoord, zCoord + 6, 1);
                this.generateCandle(world, xCoord - 6, yCoord, zCoord, 2);
                this.generateCandle(world, xCoord - 2, yCoord, zCoord - 6, 0);
                this.generateCandle(world, xCoord + 2, yCoord, zCoord - 6, 0);
                this.generateCandle(world, xCoord, yCoord + 18, zCoord, 0);
                this.generateCandle(world, xCoord + 6, yCoord + 18, zCoord, 0);
                this.generateCandle(world, xCoord, yCoord + 18, zCoord + 6, 0);
                this.generateCandle(world, xCoord - 6, yCoord + 18, zCoord, 0);
                world.func_147465_d(xCoord, yCoord + 18, zCoord - 6, IdMap.blockStatue, 2, 2);
                world.func_147465_d(xCoord, yCoord + 19, zCoord - 6, IdMap.blockStatue, 4, 2);
                world.func_147465_d(xCoord, yCoord + 20, zCoord - 6, IdMap.blockStatue, 5, 2);
                world.func_147465_d(xCoord, yCoord - 1, zCoord, Blocks.field_150474_ac, 0, 2);
                ((TileEntityMobSpawner)world.func_147438_o(xCoord, yCoord - 1, zCoord)).func_145881_a().func_98272_a("FrostGuard");
                world.func_147465_d(xCoord, yCoord + 17, zCoord, Blocks.field_150474_ac, 0, 2);
                ((TileEntityMobSpawner)world.func_147438_o(xCoord, yCoord + 17, zCoord)).func_145881_a().func_98272_a("FrostGuard");
            }

            private void generateFloor(World world2, int x, int yStart, int z) {
                for (int y = yStart; y > 0 && (world2.func_147439_a(x, y, z).func_149688_o() == Material.field_151579_a || world2.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world2, x, y, z)); --y) {
                    world2.func_147465_d(x, y, z, Blocks.field_150346_d, 0, 2);
                }
            }

            private void generateCandle(World world2, int x, int y, int z, int type) {
                switch (type) {
                    case 0: {
                        world2.func_147465_d(x, y, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                        world2.func_147465_d(x, y + 1, z, Blocks.field_150478_aa, 5, 2);
                        break;
                    }
                    case 1: {
                        world2.func_147465_d(x, y, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                        world2.func_147465_d(x, y + 1, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                        world2.func_147465_d(x + 1, y + 1, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                        world2.func_147465_d(x - 1, y + 1, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                        world2.func_147465_d(x + 1, y + 2, z, Blocks.field_150478_aa, 5, 2);
                        world2.func_147465_d(x - 1, y + 2, z, Blocks.field_150478_aa, 5, 2);
                        break;
                    }
                    case 2: {
                        world2.func_147465_d(x, y, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                        world2.func_147465_d(x, y + 1, z, IdMap.blockBlackFrostFenceSet, 1, 2);
                        world2.func_147465_d(x, y + 1, z + 1, IdMap.blockBlackFrostFenceSet, 1, 2);
                        world2.func_147465_d(x, y + 1, z - 1, IdMap.blockBlackFrostFenceSet, 1, 2);
                        world2.func_147465_d(x, y + 2, z + 1, Blocks.field_150478_aa, 5, 2);
                        world2.func_147465_d(x, y + 2, z - 1, Blocks.field_150478_aa, 5, 2);
                    }
                }
            }
        }.start();
    }

    public static void generateFrostWingCylinder(World world, int xCoord, int zCoord) {
        WorldGenFrostWingTower.sendChatMsg("Generating Arena... 0%");
        int yCoord = world.func_72940_L() - 27;
        for (int x = -25; x <= 25; ++x) {
            for (int z = -25; z <= 25; ++z) {
                for (int y = 0; y <= 25; ++y) {
                    if (x == -15 && y == 5 && z == -15) {
                        WorldGenFrostWingTower.sendChatMsg("Generating Arena... 20%");
                    }
                    if (x == -5 && y == 10 && z == -5) {
                        WorldGenFrostWingTower.sendChatMsg("Generating Arena... 40%");
                    }
                    if (x == 5 && y == 15 && z == 5) {
                        WorldGenFrostWingTower.sendChatMsg("Generating Arena... 60%");
                    }
                    if (x == 15 && y == 20 && z == 15) {
                        WorldGenFrostWingTower.sendChatMsg("Generating Arena... 80%");
                    }
                    if (x == 25 && y == 25 && z == 25) {
                        WorldGenFrostWingTower.sendChatMsg("Generating Arena... 100%");
                    }
                    if (y == 0 && Math.floor(Math.sqrt(x * x + z * z)) < 25.0) {
                        world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, Blocks.field_150433_aE, 0, 2);
                    }
                    if (Math.floor(Math.sqrt(x * x + z * z)) != 25.0) continue;
                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, IdMap.blockBlackFrost, 0, 2);
                }
            }
        }
        WorldGenFrostWingTower.sendChatMsg("Generation complete!");
    }

    public static void removeCylinder(World world, int xCoord, int zCoord) {
        if (!world.field_72995_K) {
            WorldGenFrostWingTower.sendChatMsg("Removing Arena... 0%");
            int yCoord = world.func_72940_L() - 27;
            for (int x = -25; x <= 25; ++x) {
                for (int z = -25; z <= 25; ++z) {
                    for (int y = 0; y <= 25; ++y) {
                        if (x == -15 && y == 5 && z == -15) {
                            WorldGenFrostWingTower.sendChatMsg("Removing Arena... 20%");
                        }
                        if (x == -5 && y == 10 && z == -5) {
                            WorldGenFrostWingTower.sendChatMsg("Removing Arena... 40%");
                        }
                        if (x == 5 && y == 15 && z == 5) {
                            WorldGenFrostWingTower.sendChatMsg("Removing Arena... 60%");
                        }
                        if (x == 15 && y == 20 && z == 15) {
                            WorldGenFrostWingTower.sendChatMsg("Removing Arena... 80%");
                        }
                        if (x == 25 && y == 25 && z == 25) {
                            WorldGenFrostWingTower.sendChatMsg("Removing Arena... 100%");
                        }
                        if (y == 0 && Math.floor(Math.sqrt(x * x + z * z)) < 25.0) {
                            world.func_147468_f(xCoord + x, yCoord + y, zCoord + z);
                        }
                        if (Math.floor(Math.sqrt(x * x + z * z)) != 25.0) continue;
                        world.func_147468_f(xCoord + x, yCoord + y, zCoord + z);
                    }
                }
            }
            WorldGenFrostWingTower.sendChatMsg("Removal complete!");
        }
    }
}

