/*
 * Decompiled with CFR 0.152.
 */
package xelitez.frostcraft.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import xelitez.frostcraft.block.BlockThermalMachines;
import xelitez.frostcraft.energy.EnergyRequestRegistry;
import xelitez.frostcraft.energy.IIsSource;
import xelitez.frostcraft.interfaces.IChargeable;
import xelitez.frostcraft.registry.RecipeRegistry;
import xelitez.frostcraft.tileentity.TileEntityThermalMachines;

public class TileEntityFrostGenerator
extends TileEntityThermalMachines
implements IIsSource,
ISidedInventory {
    private ItemStack[] items = new ItemStack[2];
    public int generatorBurnTime = 0;
    public int currentItemBurnTime = 0;

    public TileEntityFrostGenerator() {
        this.capacity = 2500;
    }

    @Override
    public boolean handleRequest(int id) {
        int[] dat = EnergyRequestRegistry.getInstance().getRequestData(id);
        if (dat != null && dat[1] <= this.storage && !this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_147439_a(dat[2], dat[3], dat[4]) instanceof BlockThermalMachines && this.field_145850_b.func_147438_o(dat[2], dat[3], dat[4]) instanceof TileEntityThermalMachines) {
                TileEntityThermalMachines te = (TileEntityThermalMachines)this.field_145850_b.func_147438_o(dat[2], dat[3], dat[4]);
                int value = te.recieveEnergy(dat[1]);
                this.storage -= value;
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.items.length) continue;
            this.items[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.generatorBurnTime = par1NBTTagCompound.func_74765_d("BurnTime");
        this.currentItemBurnTime = RecipeRegistry.registry().getFrostTime(this.items[1]);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("BurnTime", (short)this.generatorBurnTime);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.items.length; ++var3) {
            if (this.items[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.items[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.generatorBurnTime * par1 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.generatorBurnTime > 0;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        int var1 = this.generatorBurnTime;
        boolean var2 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.generatorBurnTime == 0) {
                this.currentItemBurnTime = this.generatorBurnTime = RecipeRegistry.registry().getFrostTime(this.items[1]);
                if (this.generatorBurnTime > 0) {
                    var2 = true;
                    if (this.items[1] != null) {
                        --this.items[1].field_77994_a;
                        if (this.items[1].field_77994_a == 0) {
                            this.items[1] = this.items[1].func_77973_b().getContainerItem(this.items[1]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.storage < this.capacity - 3) {
                if (this.generatorBurnTime > 0) {
                    --this.generatorBurnTime;
                }
                this.storage += 4;
                if (this.storage >= this.capacity) {
                    this.storage = this.capacity;
                }
            }
            if (var1 != this.generatorBurnTime) {
                if (!this.isActive) {
                    var2 = true;
                    this.setActive(true);
                }
            } else if (this.isActive) {
                this.setActive(false);
            }
            if (this.items[0] != null && this.items[0].func_77973_b() instanceof IChargeable) {
                IChargeable item = (IChargeable)this.items[0].func_77973_b();
                this.storage = this.storage >= item.getChargeRate() ? (this.storage -= item.charge(item.getChargeRate(), this.items[0])) : (this.storage -= item.charge(this.storage, this.items[0]));
            }
        }
        if (var2) {
            this.func_70296_d();
        }
    }

    public int getCurrentStorgaeScaled(int index) {
        return this.storage * index / this.capacity;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.items[var1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.items[par1] != null) {
            if (this.items[par1].field_77994_a <= par2) {
                ItemStack var3 = this.items[par1];
                this.items[par1] = null;
                return var3;
            }
            ItemStack var3 = this.items[par1].func_77979_a(par2);
            if (this.items[par1].field_77994_a == 0) {
                this.items[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.items[par1] != null) {
            ItemStack var2 = this.items[par1];
            this.items[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.items[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "frostcraft.frostgenerator";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : var1.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 && itemstack.func_77973_b() instanceof IChargeable || i == 1 && RecipeRegistry.registry().getFrostTime(itemstack) != 0;
    }

    public int[] func_94128_d(int i) {
        int[] nArray;
        if (i == 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else if (i == 1) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        } else {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = 1;
        }
        return nArray;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i != 0 || !(itemstack.func_77973_b() instanceof IChargeable) || ((IChargeable)itemstack.func_77973_b()).getMaxCharge() == itemstack.func_77960_j() + ((IChargeable)itemstack.func_77973_b()).getMaxCharge() || i == 1 && RecipeRegistry.registry().getFrostTime(itemstack) == 0;
    }
}

